/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.tls.CertificateStatusRequest;
import org.bouncycastle.tls.HeartbeatExtension;
import org.bouncycastle.tls.ServerNameList;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsProtocol;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.TrustedAuthority;
import org.bouncycastle.util.Integers;

public class TlsExtensionsUtils {
    public static final Integer EXT_client_certificate_type = Integers.valueOf((int)19);
    public static final Integer EXT_client_certificate_url = Integers.valueOf((int)2);
    public static final Integer EXT_encrypt_then_mac = Integers.valueOf((int)22);
    public static final Integer EXT_extended_master_secret = Integers.valueOf((int)23);
    public static final Integer EXT_heartbeat = Integers.valueOf((int)15);
    public static final Integer EXT_max_fragment_length = Integers.valueOf((int)1);
    public static final Integer EXT_padding = Integers.valueOf((int)21);
    public static final Integer EXT_server_certificate_type = Integers.valueOf((int)20);
    public static final Integer EXT_server_name = Integers.valueOf((int)0);
    public static final Integer EXT_status_request = Integers.valueOf((int)5);
    public static final Integer EXT_supported_groups = Integers.valueOf((int)10);
    public static final Integer EXT_truncated_hmac = Integers.valueOf((int)4);
    public static final Integer EXT_trusted_ca_keys = Integers.valueOf((int)3);

    public static Hashtable ensureExtensionsInitialised(Hashtable hashtable) {
        return hashtable == null ? new Hashtable() : hashtable;
    }

    public static void addClientCertificateTypeExtensionClient(Hashtable hashtable, short[] sArray) throws IOException {
        hashtable.put(EXT_client_certificate_type, TlsExtensionsUtils.createCertificateTypeExtensionClient(sArray));
    }

    public static void addClientCertificateTypeExtensionServer(Hashtable hashtable, short s) throws IOException {
        hashtable.put(EXT_client_certificate_type, TlsExtensionsUtils.createCertificateTypeExtensionServer(s));
    }

    public static void addClientCertificateURLExtension(Hashtable hashtable) {
        hashtable.put(EXT_client_certificate_url, TlsExtensionsUtils.createClientCertificateURLExtension());
    }

    public static void addEncryptThenMACExtension(Hashtable hashtable) {
        hashtable.put(EXT_encrypt_then_mac, TlsExtensionsUtils.createEncryptThenMACExtension());
    }

    public static void addExtendedMasterSecretExtension(Hashtable hashtable) {
        hashtable.put(EXT_extended_master_secret, TlsExtensionsUtils.createExtendedMasterSecretExtension());
    }

    public static void addHeartbeatExtension(Hashtable hashtable, HeartbeatExtension heartbeatExtension) throws IOException {
        hashtable.put(EXT_heartbeat, TlsExtensionsUtils.createHeartbeatExtension(heartbeatExtension));
    }

    public static void addMaxFragmentLengthExtension(Hashtable hashtable, short s) throws IOException {
        hashtable.put(EXT_max_fragment_length, TlsExtensionsUtils.createMaxFragmentLengthExtension(s));
    }

    public static void addPaddingExtension(Hashtable hashtable, int n) throws IOException {
        hashtable.put(EXT_padding, TlsExtensionsUtils.createPaddingExtension(n));
    }

    public static void addServerCertificateTypeExtensionClient(Hashtable hashtable, short[] sArray) throws IOException {
        hashtable.put(EXT_server_certificate_type, TlsExtensionsUtils.createCertificateTypeExtensionClient(sArray));
    }

    public static void addServerCertificateTypeExtensionServer(Hashtable hashtable, short s) throws IOException {
        hashtable.put(EXT_server_certificate_type, TlsExtensionsUtils.createCertificateTypeExtensionServer(s));
    }

    public static void addServerNameExtension(Hashtable hashtable, ServerNameList serverNameList) throws IOException {
        hashtable.put(EXT_server_name, TlsExtensionsUtils.createServerNameExtension(serverNameList));
    }

    public static void addStatusRequestExtension(Hashtable hashtable, CertificateStatusRequest certificateStatusRequest) throws IOException {
        hashtable.put(EXT_status_request, TlsExtensionsUtils.createStatusRequestExtension(certificateStatusRequest));
    }

    public static void addSupportedGroupsExtension(Hashtable hashtable, Vector vector) throws IOException {
        hashtable.put(EXT_supported_groups, TlsExtensionsUtils.createSupportedGroupsExtension(vector));
    }

    public static void addTruncatedHMacExtension(Hashtable hashtable) {
        hashtable.put(EXT_truncated_hmac, TlsExtensionsUtils.createTruncatedHMacExtension());
    }

    public static void addTrustedCAKeysExtensionClient(Hashtable hashtable, Vector vector) throws IOException {
        hashtable.put(EXT_trusted_ca_keys, TlsExtensionsUtils.createTrustedCAKeysExtensionClient(vector));
    }

    public static void addTrustedCAKeysExtensionServer(Hashtable hashtable) {
        hashtable.put(EXT_trusted_ca_keys, TlsExtensionsUtils.createTrustedCAKeysExtensionServer());
    }

    public static short[] getClientCertificateTypeExtensionClient(Hashtable hashtable) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(hashtable, EXT_client_certificate_type);
        return byArray == null ? null : TlsExtensionsUtils.readCertificateTypeExtensionClient(byArray);
    }

    public static short getClientCertificateTypeExtensionServer(Hashtable hashtable) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(hashtable, EXT_client_certificate_type);
        return byArray == null ? (short)-1 : (short)TlsExtensionsUtils.readCertificateTypeExtensionServer(byArray);
    }

    public static HeartbeatExtension getHeartbeatExtension(Hashtable hashtable) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(hashtable, EXT_heartbeat);
        return byArray == null ? null : TlsExtensionsUtils.readHeartbeatExtension(byArray);
    }

    public static short getMaxFragmentLengthExtension(Hashtable hashtable) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(hashtable, EXT_max_fragment_length);
        return byArray == null ? (short)-1 : (short)TlsExtensionsUtils.readMaxFragmentLengthExtension(byArray);
    }

    public static int getPaddingExtension(Hashtable hashtable) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(hashtable, EXT_padding);
        return byArray == null ? -1 : TlsExtensionsUtils.readPaddingExtension(byArray);
    }

    public static short[] getServerCertificateTypeExtensionClient(Hashtable hashtable) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(hashtable, EXT_server_certificate_type);
        return byArray == null ? null : TlsExtensionsUtils.readCertificateTypeExtensionClient(byArray);
    }

    public static short getServerCertificateTypeExtensionServer(Hashtable hashtable) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(hashtable, EXT_server_certificate_type);
        return byArray == null ? (short)-1 : (short)TlsExtensionsUtils.readCertificateTypeExtensionServer(byArray);
    }

    public static ServerNameList getServerNameExtension(Hashtable hashtable) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(hashtable, EXT_server_name);
        return byArray == null ? null : TlsExtensionsUtils.readServerNameExtension(byArray);
    }

    public static CertificateStatusRequest getStatusRequestExtension(Hashtable hashtable) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(hashtable, EXT_status_request);
        return byArray == null ? null : TlsExtensionsUtils.readStatusRequestExtension(byArray);
    }

    public static int[] getSupportedGroupsExtension(Hashtable hashtable) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(hashtable, EXT_supported_groups);
        return byArray == null ? null : TlsExtensionsUtils.readSupportedGroupsExtension(byArray);
    }

    public static Vector getTrustedCAKeysExtensionClient(Hashtable hashtable) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(hashtable, EXT_trusted_ca_keys);
        return byArray == null ? null : TlsExtensionsUtils.readTrustedCAKeysExtensionClient(byArray);
    }

    public static boolean hasClientCertificateURLExtension(Hashtable hashtable) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(hashtable, EXT_client_certificate_url);
        return byArray == null ? false : TlsExtensionsUtils.readClientCertificateURLExtension(byArray);
    }

    public static boolean hasEncryptThenMACExtension(Hashtable hashtable) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(hashtable, EXT_encrypt_then_mac);
        return byArray == null ? false : TlsExtensionsUtils.readEncryptThenMACExtension(byArray);
    }

    public static boolean hasExtendedMasterSecretExtension(Hashtable hashtable) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(hashtable, EXT_extended_master_secret);
        return byArray == null ? false : TlsExtensionsUtils.readExtendedMasterSecretExtension(byArray);
    }

    public static boolean hasTruncatedHMacExtension(Hashtable hashtable) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(hashtable, EXT_truncated_hmac);
        return byArray == null ? false : TlsExtensionsUtils.readTruncatedHMacExtension(byArray);
    }

    public static boolean hasTrustedCAKeysExtensionServer(Hashtable hashtable) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(hashtable, EXT_trusted_ca_keys);
        return byArray == null ? false : TlsExtensionsUtils.readTrustedCAKeysExtensionServer(byArray);
    }

    public static byte[] createCertificateTypeExtensionClient(short[] sArray) throws IOException {
        if (sArray == null || sArray.length < 1 || sArray.length > 255) {
            throw new TlsFatalAlert(80);
        }
        return TlsUtils.encodeUint8ArrayWithUint8Length(sArray);
    }

    public static byte[] createCertificateTypeExtensionServer(short s) throws IOException {
        return TlsUtils.encodeUint8(s);
    }

    public static byte[] createClientCertificateURLExtension() {
        return TlsExtensionsUtils.createEmptyExtensionData();
    }

    public static byte[] createEmptyExtensionData() {
        return TlsUtils.EMPTY_BYTES;
    }

    public static byte[] createEncryptThenMACExtension() {
        return TlsExtensionsUtils.createEmptyExtensionData();
    }

    public static byte[] createExtendedMasterSecretExtension() {
        return TlsExtensionsUtils.createEmptyExtensionData();
    }

    public static byte[] createHeartbeatExtension(HeartbeatExtension heartbeatExtension) throws IOException {
        if (heartbeatExtension == null) {
            throw new TlsFatalAlert(80);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        heartbeatExtension.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] createMaxFragmentLengthExtension(short s) throws IOException {
        return TlsUtils.encodeUint8(s);
    }

    public static byte[] createPaddingExtension(int n) throws IOException {
        TlsUtils.checkUint16(n);
        return new byte[n];
    }

    public static byte[] createServerNameExtension(ServerNameList serverNameList) throws IOException {
        if (serverNameList == null) {
            throw new TlsFatalAlert(80);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        serverNameList.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] createStatusRequestExtension(CertificateStatusRequest certificateStatusRequest) throws IOException {
        if (certificateStatusRequest == null) {
            throw new TlsFatalAlert(80);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        certificateStatusRequest.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] createSupportedGroupsExtension(Vector vector) throws IOException {
        if (vector == null || vector.isEmpty()) {
            throw new TlsFatalAlert(80);
        }
        int n = vector.size();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = (Integer)vector.elementAt(i);
        }
        return TlsUtils.encodeUint16ArrayWithUint16Length(nArray);
    }

    public static byte[] createTruncatedHMacExtension() {
        return TlsExtensionsUtils.createEmptyExtensionData();
    }

    public static byte[] createTrustedCAKeysExtensionClient(Vector vector) throws IOException {
        Object object;
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        TlsUtils.writeUint16(0, byteArrayOutputStream);
        for (n = 0; n < vector.size(); ++n) {
            object = (TrustedAuthority)vector.elementAt(n);
            ((TrustedAuthority)object).encode(byteArrayOutputStream);
        }
        n = byteArrayOutputStream.size() - 2;
        TlsUtils.checkUint16(n);
        object = byteArrayOutputStream.toByteArray();
        TlsUtils.writeUint16(n, (byte[])object, 0);
        return object;
    }

    public static byte[] createTrustedCAKeysExtensionServer() {
        return TlsExtensionsUtils.createEmptyExtensionData();
    }

    private static boolean readEmptyExtensionData(byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new IllegalArgumentException("'extensionData' cannot be null");
        }
        if (byArray.length != 0) {
            throw new TlsFatalAlert(47);
        }
        return true;
    }

    public static short[] readCertificateTypeExtensionClient(byte[] byArray) throws IOException {
        short[] sArray = TlsUtils.decodeUint8ArrayWithUint8Length(byArray);
        if (sArray.length < 1) {
            throw new TlsFatalAlert(50);
        }
        return sArray;
    }

    public static short readCertificateTypeExtensionServer(byte[] byArray) throws IOException {
        return TlsUtils.decodeUint8(byArray);
    }

    public static boolean readClientCertificateURLExtension(byte[] byArray) throws IOException {
        return TlsExtensionsUtils.readEmptyExtensionData(byArray);
    }

    public static boolean readEncryptThenMACExtension(byte[] byArray) throws IOException {
        return TlsExtensionsUtils.readEmptyExtensionData(byArray);
    }

    public static boolean readExtendedMasterSecretExtension(byte[] byArray) throws IOException {
        return TlsExtensionsUtils.readEmptyExtensionData(byArray);
    }

    public static HeartbeatExtension readHeartbeatExtension(byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new IllegalArgumentException("'extensionData' cannot be null");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        HeartbeatExtension heartbeatExtension = HeartbeatExtension.parse(byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        return heartbeatExtension;
    }

    public static short readMaxFragmentLengthExtension(byte[] byArray) throws IOException {
        return TlsUtils.decodeUint8(byArray);
    }

    public static int readPaddingExtension(byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new IllegalArgumentException("'extensionData' cannot be null");
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == 0) continue;
            throw new TlsFatalAlert(47);
        }
        return byArray.length;
    }

    public static ServerNameList readServerNameExtension(byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new IllegalArgumentException("'extensionData' cannot be null");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ServerNameList serverNameList = ServerNameList.parse(byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        return serverNameList;
    }

    public static CertificateStatusRequest readStatusRequestExtension(byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new IllegalArgumentException("'extensionData' cannot be null");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        CertificateStatusRequest certificateStatusRequest = CertificateStatusRequest.parse(byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        return certificateStatusRequest;
    }

    public static int[] readSupportedGroupsExtension(byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new IllegalArgumentException("'extensionData' cannot be null");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        int n = TlsUtils.readUint16(byteArrayInputStream);
        if (n < 2 || (n & 1) != 0) {
            throw new TlsFatalAlert(50);
        }
        int[] nArray = TlsUtils.readUint16Array(n / 2, byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        return nArray;
    }

    public static boolean readTruncatedHMacExtension(byte[] byArray) throws IOException {
        return TlsExtensionsUtils.readEmptyExtensionData(byArray);
    }

    public static Vector readTrustedCAKeysExtensionClient(byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new IllegalArgumentException("'extensionData' cannot be null");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        int n = TlsUtils.readUint16(byteArrayInputStream);
        if (n != byArray.length - 2) {
            throw new TlsFatalAlert(50);
        }
        Vector<TrustedAuthority> vector = new Vector<TrustedAuthority>();
        while (byteArrayInputStream.available() > 0) {
            TrustedAuthority trustedAuthority = TrustedAuthority.parse(byteArrayInputStream);
            vector.addElement(trustedAuthority);
        }
        return vector;
    }

    public static boolean readTrustedCAKeysExtensionServer(byte[] byArray) throws IOException {
        return TlsExtensionsUtils.readEmptyExtensionData(byArray);
    }
}

