/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AudioFloatConverter;
import com.sun.media.sound.FFT;
import com.sun.media.sound.ModelPatch;
import com.sun.media.sound.SF2GlobalRegion;
import com.sun.media.sound.SF2Instrument;
import com.sun.media.sound.SF2InstrumentRegion;
import com.sun.media.sound.SF2Layer;
import com.sun.media.sound.SF2LayerRegion;
import com.sun.media.sound.SF2Region;
import com.sun.media.sound.SF2Sample;
import com.sun.media.sound.SF2Soundbank;
import java.util.Random;
import javax.sound.midi.Patch;
import javax.sound.midi.SoundbankResource;
import javax.sound.sampled.AudioFormat;

public final class EmergencySoundbank {
    private static final String[] general_midi_instruments = new String[]{"Acoustic Grand Piano", "Bright Acoustic Piano", "Electric Grand Piano", "Honky-tonk Piano", "Electric Piano 1", "Electric Piano 2", "Harpsichord", "Clavi", "Celesta", "Glockenspiel", "Music Box", "Vibraphone", "Marimba", "Xylophone", "Tubular Bells", "Dulcimer", "Drawbar Organ", "Percussive Organ", "Rock Organ", "Church Organ", "Reed Organ", "Accordion", "Harmonica", "Tango Accordion", "Acoustic Guitar (nylon)", "Acoustic Guitar (steel)", "Electric Guitar (jazz)", "Electric Guitar (clean)", "Electric Guitar (muted)", "Overdriven Guitar", "Distortion Guitar", "Guitar harmonics", "Acoustic Bass", "Electric Bass (finger)", "Electric Bass (pick)", "Fretless Bass", "Slap Bass 1", "Slap Bass 2", "Synth Bass 1", "Synth Bass 2", "Violin", "Viola", "Cello", "Contrabass", "Tremolo Strings", "Pizzicato Strings", "Orchestral Harp", "Timpani", "String Ensemble 1", "String Ensemble 2", "SynthStrings 1", "SynthStrings 2", "Choir Aahs", "Voice Oohs", "Synth Voice", "Orchestra Hit", "Trumpet", "Trombone", "Tuba", "Muted Trumpet", "French Horn", "Brass Section", "SynthBrass 1", "SynthBrass 2", "Soprano Sax", "Alto Sax", "Tenor Sax", "Baritone Sax", "Oboe", "English Horn", "Bassoon", "Clarinet", "Piccolo", "Flute", "Recorder", "Pan Flute", "Blown Bottle", "Shakuhachi", "Whistle", "Ocarina", "Lead 1 (square)", "Lead 2 (sawtooth)", "Lead 3 (calliope)", "Lead 4 (chiff)", "Lead 5 (charang)", "Lead 6 (voice)", "Lead 7 (fifths)", "Lead 8 (bass + lead)", "Pad 1 (new age)", "Pad 2 (warm)", "Pad 3 (polysynth)", "Pad 4 (choir)", "Pad 5 (bowed)", "Pad 6 (metallic)", "Pad 7 (halo)", "Pad 8 (sweep)", "FX 1 (rain)", "FX 2 (soundtrack)", "FX 3 (crystal)", "FX 4 (atmosphere)", "FX 5 (brightness)", "FX 6 (goblins)", "FX 7 (echoes)", "FX 8 (sci-fi)", "Sitar", "Banjo", "Shamisen", "Koto", "Kalimba", "Bag pipe", "Fiddle", "Shanai", "Tinkle Bell", "Agogo", "Steel Drums", "Woodblock", "Taiko Drum", "Melodic Tom", "Synth Drum", "Reverse Cymbal", "Guitar Fret Noise", "Breath Noise", "Seashore", "Bird Tweet", "Telephone Ring", "Helicopter", "Applause", "Gunshot"};

    public static SF2Soundbank createSoundbank() throws Exception {
        Object object;
        SF2Soundbank sF2Soundbank = new SF2Soundbank();
        sF2Soundbank.setName("Emergency GM sound set");
        sF2Soundbank.setVendor("Generated");
        sF2Soundbank.setDescription("Emergency generated soundbank");
        SF2Layer sF2Layer = EmergencySoundbank.new_bass_drum(sF2Soundbank);
        SF2Layer sF2Layer2 = EmergencySoundbank.new_snare_drum(sF2Soundbank);
        SF2Layer sF2Layer3 = EmergencySoundbank.new_tom(sF2Soundbank);
        SF2Layer sF2Layer4 = EmergencySoundbank.new_open_hihat(sF2Soundbank);
        SF2Layer sF2Layer5 = EmergencySoundbank.new_closed_hihat(sF2Soundbank);
        SF2Layer sF2Layer6 = EmergencySoundbank.new_crash_cymbal(sF2Soundbank);
        SF2Layer sF2Layer7 = EmergencySoundbank.new_side_stick(sF2Soundbank);
        SF2Layer[] sF2LayerArray = new SF2Layer[128];
        sF2LayerArray[35] = sF2Layer;
        sF2LayerArray[36] = sF2Layer;
        sF2LayerArray[38] = sF2Layer2;
        sF2LayerArray[40] = sF2Layer2;
        sF2LayerArray[41] = sF2Layer3;
        sF2LayerArray[43] = sF2Layer3;
        sF2LayerArray[45] = sF2Layer3;
        sF2LayerArray[47] = sF2Layer3;
        sF2LayerArray[48] = sF2Layer3;
        sF2LayerArray[50] = sF2Layer3;
        sF2LayerArray[42] = sF2Layer5;
        sF2LayerArray[44] = sF2Layer5;
        sF2LayerArray[46] = sF2Layer4;
        sF2LayerArray[49] = sF2Layer6;
        sF2LayerArray[51] = sF2Layer6;
        sF2LayerArray[52] = sF2Layer6;
        sF2LayerArray[55] = sF2Layer6;
        sF2LayerArray[57] = sF2Layer6;
        sF2LayerArray[59] = sF2Layer6;
        sF2LayerArray[37] = sF2Layer7;
        sF2LayerArray[39] = sF2Layer7;
        sF2LayerArray[53] = sF2Layer7;
        sF2LayerArray[54] = sF2Layer7;
        sF2LayerArray[56] = sF2Layer7;
        sF2LayerArray[58] = sF2Layer7;
        sF2LayerArray[69] = sF2Layer7;
        sF2LayerArray[70] = sF2Layer7;
        sF2LayerArray[75] = sF2Layer7;
        sF2LayerArray[60] = sF2Layer7;
        sF2LayerArray[61] = sF2Layer7;
        sF2LayerArray[62] = sF2Layer7;
        sF2LayerArray[63] = sF2Layer7;
        sF2LayerArray[64] = sF2Layer7;
        sF2LayerArray[65] = sF2Layer7;
        sF2LayerArray[66] = sF2Layer7;
        sF2LayerArray[67] = sF2Layer7;
        sF2LayerArray[68] = sF2Layer7;
        sF2LayerArray[71] = sF2Layer7;
        sF2LayerArray[72] = sF2Layer7;
        sF2LayerArray[73] = sF2Layer7;
        sF2LayerArray[74] = sF2Layer7;
        sF2LayerArray[76] = sF2Layer7;
        sF2LayerArray[77] = sF2Layer7;
        sF2LayerArray[78] = sF2Layer7;
        sF2LayerArray[79] = sF2Layer7;
        sF2LayerArray[80] = sF2Layer7;
        sF2LayerArray[81] = sF2Layer7;
        SF2Instrument sF2Instrument = new SF2Instrument(sF2Soundbank);
        sF2Instrument.setName("Standard Kit");
        sF2Instrument.setPatch(new ModelPatch(0, 0, true));
        sF2Soundbank.addInstrument(sF2Instrument);
        for (int i = 0; i < sF2LayerArray.length; ++i) {
            if (sF2LayerArray[i] == null) continue;
            object = new SF2InstrumentRegion();
            ((SF2InstrumentRegion)object).setLayer(sF2LayerArray[i]);
            ((SF2Region)object).putBytes(43, new byte[]{(byte)i, (byte)i});
            sF2Instrument.getRegions().add((SF2InstrumentRegion)object);
        }
        SF2Layer sF2Layer8 = EmergencySoundbank.new_gpiano(sF2Soundbank);
        object = EmergencySoundbank.new_gpiano2(sF2Soundbank);
        SF2Layer sF2Layer9 = EmergencySoundbank.new_piano_hammer(sF2Soundbank);
        SF2Layer sF2Layer10 = EmergencySoundbank.new_piano1(sF2Soundbank);
        SF2Layer sF2Layer11 = EmergencySoundbank.new_epiano1(sF2Soundbank);
        SF2Layer sF2Layer12 = EmergencySoundbank.new_epiano2(sF2Soundbank);
        SF2Layer sF2Layer13 = EmergencySoundbank.new_guitar1(sF2Soundbank);
        SF2Layer sF2Layer14 = EmergencySoundbank.new_guitar_pick(sF2Soundbank);
        SF2Layer sF2Layer15 = EmergencySoundbank.new_guitar_dist(sF2Soundbank);
        SF2Layer sF2Layer16 = EmergencySoundbank.new_bass1(sF2Soundbank);
        SF2Layer sF2Layer17 = EmergencySoundbank.new_bass2(sF2Soundbank);
        SF2Layer sF2Layer18 = EmergencySoundbank.new_synthbass(sF2Soundbank);
        SF2Layer sF2Layer19 = EmergencySoundbank.new_string2(sF2Soundbank);
        SF2Layer sF2Layer20 = EmergencySoundbank.new_orchhit(sF2Soundbank);
        SF2Layer sF2Layer21 = EmergencySoundbank.new_choir(sF2Soundbank);
        SF2Layer sF2Layer22 = EmergencySoundbank.new_solostring(sF2Soundbank);
        SF2Layer sF2Layer23 = EmergencySoundbank.new_organ(sF2Soundbank);
        SF2Layer sF2Layer24 = EmergencySoundbank.new_ch_organ(sF2Soundbank);
        SF2Layer sF2Layer25 = EmergencySoundbank.new_bell(sF2Soundbank);
        SF2Layer sF2Layer26 = EmergencySoundbank.new_flute(sF2Soundbank);
        SF2Layer sF2Layer27 = EmergencySoundbank.new_timpani(sF2Soundbank);
        SF2Layer sF2Layer28 = EmergencySoundbank.new_melodic_toms(sF2Soundbank);
        SF2Layer sF2Layer29 = EmergencySoundbank.new_trumpet(sF2Soundbank);
        SF2Layer sF2Layer30 = EmergencySoundbank.new_trombone(sF2Soundbank);
        SF2Layer sF2Layer31 = EmergencySoundbank.new_brass_section(sF2Soundbank);
        SF2Layer sF2Layer32 = EmergencySoundbank.new_horn(sF2Soundbank);
        SF2Layer sF2Layer33 = EmergencySoundbank.new_sax(sF2Soundbank);
        SF2Layer sF2Layer34 = EmergencySoundbank.new_oboe(sF2Soundbank);
        SF2Layer sF2Layer35 = EmergencySoundbank.new_bassoon(sF2Soundbank);
        SF2Layer sF2Layer36 = EmergencySoundbank.new_clarinet(sF2Soundbank);
        SF2Layer sF2Layer37 = EmergencySoundbank.new_reverse_cymbal(sF2Soundbank);
        SF2Layer sF2Layer38 = sF2Layer10;
        EmergencySoundbank.newInstrument(sF2Soundbank, "Piano", new Patch(0, 0), sF2Layer8, sF2Layer9);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Piano", new Patch(0, 1), new SF2Layer[]{object, sF2Layer9});
        EmergencySoundbank.newInstrument(sF2Soundbank, "Piano", new Patch(0, 2), sF2Layer10);
        SF2Instrument sF2Instrument2 = EmergencySoundbank.newInstrument(sF2Soundbank, "Honky-tonk Piano", new Patch(0, 3), sF2Layer10, sF2Layer10);
        SF2InstrumentRegion sF2InstrumentRegion = sF2Instrument2.getRegions().get(0);
        sF2InstrumentRegion.putInteger(8, 80);
        sF2InstrumentRegion.putInteger(52, 30);
        sF2InstrumentRegion = sF2Instrument2.getRegions().get(1);
        sF2InstrumentRegion.putInteger(8, 30);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Rhodes", new Patch(0, 4), sF2Layer12);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Rhodes", new Patch(0, 5), sF2Layer12);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Clavinet", new Patch(0, 6), sF2Layer11);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Clavinet", new Patch(0, 7), sF2Layer11);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Rhodes", new Patch(0, 8), sF2Layer12);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Bell", new Patch(0, 9), sF2Layer25);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Bell", new Patch(0, 10), sF2Layer25);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Vibraphone", new Patch(0, 11), sF2Layer25);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Marimba", new Patch(0, 12), sF2Layer25);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Marimba", new Patch(0, 13), sF2Layer25);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Bell", new Patch(0, 14), sF2Layer25);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Rock Organ", new Patch(0, 15), sF2Layer23);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Rock Organ", new Patch(0, 16), sF2Layer23);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Perc Organ", new Patch(0, 17), sF2Layer23);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Rock Organ", new Patch(0, 18), sF2Layer23);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Church Organ", new Patch(0, 19), sF2Layer24);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Accordion", new Patch(0, 20), sF2Layer23);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Accordion", new Patch(0, 21), sF2Layer23);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Accordion", new Patch(0, 22), sF2Layer23);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Accordion", new Patch(0, 23), sF2Layer23);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Guitar", new Patch(0, 24), sF2Layer13, sF2Layer14);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Guitar", new Patch(0, 25), sF2Layer13, sF2Layer14);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Guitar", new Patch(0, 26), sF2Layer13, sF2Layer14);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Guitar", new Patch(0, 27), sF2Layer13, sF2Layer14);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Guitar", new Patch(0, 28), sF2Layer13, sF2Layer14);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Distorted Guitar", new Patch(0, 29), sF2Layer15);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Distorted Guitar", new Patch(0, 30), sF2Layer15);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Guitar", new Patch(0, 31), sF2Layer13, sF2Layer14);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Finger Bass", new Patch(0, 32), sF2Layer16);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Finger Bass", new Patch(0, 33), sF2Layer16);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Finger Bass", new Patch(0, 34), sF2Layer16);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Frettless Bass", new Patch(0, 35), sF2Layer17);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Frettless Bass", new Patch(0, 36), sF2Layer17);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Frettless Bass", new Patch(0, 37), sF2Layer17);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Synth Bass1", new Patch(0, 38), sF2Layer18);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Synth Bass2", new Patch(0, 39), sF2Layer18);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Solo String", new Patch(0, 40), sF2Layer19, sF2Layer22);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Solo String", new Patch(0, 41), sF2Layer19, sF2Layer22);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Solo String", new Patch(0, 42), sF2Layer19, sF2Layer22);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Solo String", new Patch(0, 43), sF2Layer19, sF2Layer22);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Solo String", new Patch(0, 44), sF2Layer19, sF2Layer22);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Def", new Patch(0, 45), sF2Layer38);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Harp", new Patch(0, 46), sF2Layer25);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Timpani", new Patch(0, 47), sF2Layer27);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Strings", new Patch(0, 48), sF2Layer19);
        sF2Instrument2 = EmergencySoundbank.newInstrument(sF2Soundbank, "Slow Strings", new Patch(0, 49), sF2Layer19);
        sF2InstrumentRegion = sF2Instrument2.getRegions().get(0);
        sF2InstrumentRegion.putInteger(34, 2500);
        sF2InstrumentRegion.putInteger(38, 2000);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Synth Strings", new Patch(0, 50), sF2Layer19);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Synth Strings", new Patch(0, 51), sF2Layer19);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Choir", new Patch(0, 52), sF2Layer21);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Choir", new Patch(0, 53), sF2Layer21);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Choir", new Patch(0, 54), sF2Layer21);
        SF2Instrument[] sF2InstrumentArray = EmergencySoundbank.newInstrument(sF2Soundbank, "Orch Hit", new Patch(0, 55), sF2Layer20, sF2Layer20, sF2Layer27);
        sF2InstrumentRegion = sF2InstrumentArray.getRegions().get(0);
        sF2InstrumentRegion.putInteger(51, -12);
        sF2InstrumentRegion.putInteger(48, -100);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Trumpet", new Patch(0, 56), sF2Layer29);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Trombone", new Patch(0, 57), sF2Layer30);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Trombone", new Patch(0, 58), sF2Layer30);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Trumpet", new Patch(0, 59), sF2Layer29);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Horn", new Patch(0, 60), sF2Layer32);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Brass Section", new Patch(0, 61), sF2Layer31);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Brass Section", new Patch(0, 62), sF2Layer31);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Brass Section", new Patch(0, 63), sF2Layer31);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Sax", new Patch(0, 64), sF2Layer33);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Sax", new Patch(0, 65), sF2Layer33);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Sax", new Patch(0, 66), sF2Layer33);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Sax", new Patch(0, 67), sF2Layer33);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Oboe", new Patch(0, 68), sF2Layer34);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Horn", new Patch(0, 69), sF2Layer32);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Bassoon", new Patch(0, 70), sF2Layer35);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Clarinet", new Patch(0, 71), sF2Layer36);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Flute", new Patch(0, 72), sF2Layer26);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Flute", new Patch(0, 73), sF2Layer26);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Flute", new Patch(0, 74), sF2Layer26);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Flute", new Patch(0, 75), sF2Layer26);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Flute", new Patch(0, 76), sF2Layer26);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Flute", new Patch(0, 77), sF2Layer26);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Flute", new Patch(0, 78), sF2Layer26);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Flute", new Patch(0, 79), sF2Layer26);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Organ", new Patch(0, 80), sF2Layer23);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Organ", new Patch(0, 81), sF2Layer23);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Flute", new Patch(0, 82), sF2Layer26);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Organ", new Patch(0, 83), sF2Layer23);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Organ", new Patch(0, 84), sF2Layer23);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Choir", new Patch(0, 85), sF2Layer21);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Organ", new Patch(0, 86), sF2Layer23);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Organ", new Patch(0, 87), sF2Layer23);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Synth Strings", new Patch(0, 88), sF2Layer19);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Organ", new Patch(0, 89), sF2Layer23);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Def", new Patch(0, 90), sF2Layer38);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Choir", new Patch(0, 91), sF2Layer21);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Organ", new Patch(0, 92), sF2Layer23);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Organ", new Patch(0, 93), sF2Layer23);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Organ", new Patch(0, 94), sF2Layer23);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Organ", new Patch(0, 95), sF2Layer23);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Organ", new Patch(0, 96), sF2Layer23);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Organ", new Patch(0, 97), sF2Layer23);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Bell", new Patch(0, 98), sF2Layer25);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Organ", new Patch(0, 99), sF2Layer23);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Organ", new Patch(0, 100), sF2Layer23);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Organ", new Patch(0, 101), sF2Layer23);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Def", new Patch(0, 102), sF2Layer38);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Synth Strings", new Patch(0, 103), sF2Layer19);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Def", new Patch(0, 104), sF2Layer38);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Def", new Patch(0, 105), sF2Layer38);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Def", new Patch(0, 106), sF2Layer38);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Def", new Patch(0, 107), sF2Layer38);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Marimba", new Patch(0, 108), sF2Layer25);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Sax", new Patch(0, 109), sF2Layer33);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Solo String", new Patch(0, 110), sF2Layer19, sF2Layer22);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Oboe", new Patch(0, 111), sF2Layer34);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Bell", new Patch(0, 112), sF2Layer25);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Melodic Toms", new Patch(0, 113), sF2Layer28);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Marimba", new Patch(0, 114), sF2Layer25);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Melodic Toms", new Patch(0, 115), sF2Layer28);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Melodic Toms", new Patch(0, 116), sF2Layer28);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Melodic Toms", new Patch(0, 117), sF2Layer28);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Reverse Cymbal", new Patch(0, 118), sF2Layer37);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Reverse Cymbal", new Patch(0, 119), sF2Layer37);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Guitar", new Patch(0, 120), sF2Layer13);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Def", new Patch(0, 121), sF2Layer38);
        sF2InstrumentArray = EmergencySoundbank.newInstrument(sF2Soundbank, "Seashore/Reverse Cymbal", new Patch(0, 122), sF2Layer37);
        sF2InstrumentRegion = sF2InstrumentArray.getRegions().get(0);
        sF2InstrumentRegion.putInteger(37, 1000);
        sF2InstrumentRegion.putInteger(36, 18500);
        sF2InstrumentRegion.putInteger(38, 4500);
        sF2InstrumentRegion.putInteger(8, -4500);
        sF2InstrumentArray = EmergencySoundbank.newInstrument(sF2Soundbank, "Bird/Flute", new Patch(0, 123), sF2Layer26);
        sF2InstrumentRegion = sF2InstrumentArray.getRegions().get(0);
        sF2InstrumentRegion.putInteger(51, 24);
        sF2InstrumentRegion.putInteger(36, -3000);
        sF2InstrumentRegion.putInteger(37, 1000);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Def", new Patch(0, 124), sF2Layer7);
        sF2InstrumentArray = EmergencySoundbank.newInstrument(sF2Soundbank, "Seashore/Reverse Cymbal", new Patch(0, 125), sF2Layer37);
        sF2InstrumentRegion = sF2InstrumentArray.getRegions().get(0);
        sF2InstrumentRegion.putInteger(37, 1000);
        sF2InstrumentRegion.putInteger(36, 18500);
        sF2InstrumentRegion.putInteger(38, 4500);
        sF2InstrumentRegion.putInteger(8, -4500);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Applause/crash_cymbal", new Patch(0, 126), sF2Layer6);
        EmergencySoundbank.newInstrument(sF2Soundbank, "Gunshot/side_stick", new Patch(0, 127), sF2Layer7);
        for (SF2Instrument sF2Instrument3 : sF2Soundbank.getInstruments()) {
            Patch patch = sF2Instrument3.getPatch();
            if (patch instanceof ModelPatch && ((ModelPatch)patch).isPercussion()) continue;
            sF2Instrument3.setName(general_midi_instruments[patch.getProgram()]);
        }
        return sF2Soundbank;
    }

    public static SF2Layer new_bell(SF2Soundbank sF2Soundbank) {
        Random random = new Random(102030201L);
        int n = 8;
        int n2 = 4096 * n;
        double[] dArray = new double[n2 * 2];
        double d = n * 25;
        double d2 = 0.01;
        double d3 = 0.05;
        double d4 = 0.2;
        double d5 = 1.0E-5;
        double d6 = d4;
        double d7 = Math.pow(d5 / d4, 0.025);
        for (int i = 0; i < 40; ++i) {
            double d8 = 1.0 + (random.nextDouble() * 2.0 - 1.0) * 0.01;
            double d9 = d2 + (d3 - d2) * ((double)i / 40.0);
            EmergencySoundbank.complexGaussianDist(dArray, d * (double)(i + 1) * d8, d9, d6);
            d6 *= d7;
        }
        SF2Sample sF2Sample = EmergencySoundbank.newSimpleFFTSample(sF2Soundbank, "EPiano", dArray, d);
        SF2Layer sF2Layer = EmergencySoundbank.newLayer(sF2Soundbank, "EPiano", sF2Sample);
        SF2Region sF2Region = sF2Layer.getRegions().get(0);
        sF2Region.putInteger(54, 1);
        sF2Region.putInteger(34, -12000);
        sF2Region.putInteger(38, 0);
        sF2Region.putInteger(36, 4000);
        sF2Region.putInteger(37, 1000);
        sF2Region.putInteger(26, 1200);
        sF2Region.putInteger(30, 12000);
        sF2Region.putInteger(11, -9000);
        sF2Region.putInteger(8, 16000);
        return sF2Layer;
    }

    public static SF2Layer new_guitar1(SF2Soundbank sF2Soundbank) {
        int n;
        int n2 = 8;
        int n3 = 4096 * n2;
        double[] dArray = new double[n3 * 2];
        double d = n2 * 25;
        double d2 = 0.01;
        double d3 = 0.01;
        double d4 = 2.0;
        double d5 = 0.01;
        double d6 = d4;
        double d7 = Math.pow(d5 / d4, 0.025);
        double[] dArray2 = new double[40];
        for (n = 0; n < 40; ++n) {
            dArray2[n] = d6;
            d6 *= d7;
        }
        dArray2[0] = 2.0;
        dArray2[1] = 0.5;
        dArray2[2] = 0.45;
        dArray2[3] = 0.2;
        dArray2[4] = 1.0;
        dArray2[5] = 0.5;
        dArray2[6] = 2.0;
        dArray2[7] = 1.0;
        dArray2[8] = 0.5;
        dArray2[9] = 1.0;
        dArray2[9] = 0.5;
        dArray2[10] = 0.2;
        dArray2[11] = 1.0;
        dArray2[12] = 0.7;
        dArray2[13] = 0.5;
        dArray2[14] = 1.0;
        for (n = 0; n < 40; ++n) {
            double d8 = d2 + (d3 - d2) * ((double)n / 40.0);
            EmergencySoundbank.complexGaussianDist(dArray, d * (double)(n + 1), d8, dArray2[n]);
        }
        SF2Sample sF2Sample = EmergencySoundbank.newSimpleFFTSample(sF2Soundbank, "Guitar", dArray, d);
        SF2Layer sF2Layer = EmergencySoundbank.newLayer(sF2Soundbank, "Guitar", sF2Sample);
        SF2Region sF2Region = sF2Layer.getRegions().get(0);
        sF2Region.putInteger(54, 1);
        sF2Region.putInteger(34, -12000);
        sF2Region.putInteger(38, 0);
        sF2Region.putInteger(36, 2400);
        sF2Region.putInteger(37, 1000);
        sF2Region.putInteger(26, -100);
        sF2Region.putInteger(30, 12000);
        sF2Region.putInteger(11, -6000);
        sF2Region.putInteger(8, 16000);
        sF2Region.putInteger(48, -20);
        return sF2Layer;
    }

    public static SF2Layer new_guitar_dist(SF2Soundbank sF2Soundbank) {
        int n;
        int n2 = 8;
        int n3 = 4096 * n2;
        double[] dArray = new double[n3 * 2];
        double d = n2 * 25;
        double d2 = 0.01;
        double d3 = 0.01;
        double d4 = 2.0;
        double d5 = 0.01;
        double d6 = d4;
        double d7 = Math.pow(d5 / d4, 0.025);
        double[] dArray2 = new double[40];
        for (n = 0; n < 40; ++n) {
            dArray2[n] = d6;
            d6 *= d7;
        }
        dArray2[0] = 5.0;
        dArray2[1] = 2.0;
        dArray2[2] = 0.45;
        dArray2[3] = 0.2;
        dArray2[4] = 1.0;
        dArray2[5] = 0.5;
        dArray2[6] = 2.0;
        dArray2[7] = 1.0;
        dArray2[8] = 0.5;
        dArray2[9] = 1.0;
        dArray2[9] = 0.5;
        dArray2[10] = 0.2;
        dArray2[11] = 1.0;
        dArray2[12] = 0.7;
        dArray2[13] = 0.5;
        dArray2[14] = 1.0;
        for (n = 0; n < 40; ++n) {
            double d8 = d2 + (d3 - d2) * ((double)n / 40.0);
            EmergencySoundbank.complexGaussianDist(dArray, d * (double)(n + 1), d8, dArray2[n]);
        }
        SF2Sample sF2Sample = EmergencySoundbank.newSimpleFFTSample_dist(sF2Soundbank, "Distorted Guitar", dArray, d, 10000.0);
        SF2Layer sF2Layer = EmergencySoundbank.newLayer(sF2Soundbank, "Distorted Guitar", sF2Sample);
        SF2Region sF2Region = sF2Layer.getRegions().get(0);
        sF2Region.putInteger(54, 1);
        sF2Region.putInteger(34, -12000);
        sF2Region.putInteger(38, 0);
        sF2Region.putInteger(8, 8000);
        return sF2Layer;
    }

    public static SF2Layer new_guitar_pick(SF2Soundbank sF2Soundbank) {
        int n;
        int n2 = 2;
        int n3 = 4096 * n2;
        Object object = new double[2 * n3];
        Object object2 = new Random(3049912L);
        for (n = 0; n < ((double[])object).length; n += 2) {
            object[n] = 2.0 * (((Random)object2).nextDouble() - 0.5);
        }
        EmergencySoundbank.fft(object);
        for (n = n3 / 2; n < ((double[])object).length; ++n) {
            object[n] = 0.0;
        }
        for (n = 0; n < 2048 * n2; ++n) {
            int n4 = n;
            object[n4] = object[n4] * (Math.exp(-Math.abs((double)(n - 23) / (double)n2) * 1.2) + Math.exp(-Math.abs((double)(n - 40) / (double)n2) * 0.9));
        }
        EmergencySoundbank.randomPhase(object, new Random(3049912L));
        EmergencySoundbank.ifft(object);
        EmergencySoundbank.normalize(object, 0.8);
        object = EmergencySoundbank.realPart(object);
        double d = 1.0;
        int n5 = 0;
        while (n5 < ((double[])object).length) {
            int n6 = n5++;
            object[n6] = object[n6] * d;
            d *= 0.9994;
        }
        double[] dArray = object;
        EmergencySoundbank.fadeUp(object, 80);
        SF2Sample sF2Sample = EmergencySoundbank.newSimpleDrumSample(sF2Soundbank, "Guitar Noise", dArray);
        SF2Layer sF2Layer = new SF2Layer(sF2Soundbank);
        sF2Layer.setName("Guitar Noise");
        object = new SF2GlobalRegion();
        sF2Layer.setGlobalZone((SF2GlobalRegion)object);
        sF2Soundbank.addResource(sF2Layer);
        object2 = new SF2LayerRegion();
        ((SF2Region)object2).putInteger(38, 12000);
        ((SF2LayerRegion)object2).setSample(sF2Sample);
        sF2Layer.getRegions().add((SF2LayerRegion)object2);
        return sF2Layer;
    }

    public static SF2Layer new_gpiano(SF2Soundbank sF2Soundbank) {
        int n;
        int n2 = 8;
        int n3 = 4096 * n2;
        double[] dArray = new double[n3 * 2];
        double d = n2 * 25;
        double d2 = 0.2;
        double d3 = 0.001;
        double d4 = d2;
        double d5 = Math.pow(d3 / d2, 0.06666666666666667);
        double[] dArray2 = new double[30];
        for (n = 0; n < 30; ++n) {
            dArray2[n] = d4;
            d4 *= d5;
        }
        dArray2[0] = dArray2[0] * 2.0;
        dArray2[4] = dArray2[4] * 2.0;
        dArray2[12] = dArray2[12] * 0.9;
        dArray2[13] = dArray2[13] * 0.7;
        n = 14;
        while (n < 30) {
            int n4 = n++;
            dArray2[n4] = dArray2[n4] * 0.5;
        }
        for (n = 0; n < 30; ++n) {
            double d6 = 0.2;
            double d7 = dArray2[n];
            if (n > 10) {
                d6 = 5.0;
                d7 *= 10.0;
            }
            int n5 = 0;
            if (n > 5) {
                n5 = (n - 5) * 7;
            }
            EmergencySoundbank.complexGaussianDist(dArray, d * (double)(n + 1) + (double)n5, d6, d7);
        }
        SF2Sample sF2Sample = EmergencySoundbank.newSimpleFFTSample(sF2Soundbank, "Grand Piano", dArray, d, 200);
        SF2Layer sF2Layer = EmergencySoundbank.newLayer(sF2Soundbank, "Grand Piano", sF2Sample);
        SF2Region sF2Region = sF2Layer.getRegions().get(0);
        sF2Region.putInteger(54, 1);
        sF2Region.putInteger(34, -7000);
        sF2Region.putInteger(38, 0);
        sF2Region.putInteger(36, 4000);
        sF2Region.putInteger(37, 1000);
        sF2Region.putInteger(26, -6000);
        sF2Region.putInteger(30, 12000);
        sF2Region.putInteger(11, -5500);
        sF2Region.putInteger(8, 18000);
        return sF2Layer;
    }

    public static SF2Layer new_gpiano2(SF2Soundbank sF2Soundbank) {
        int n;
        int n2 = 8;
        int n3 = 4096 * n2;
        double[] dArray = new double[n3 * 2];
        double d = n2 * 25;
        double d2 = 0.2;
        double d3 = 0.001;
        double d4 = d2;
        double d5 = Math.pow(d3 / d2, 0.05);
        double[] dArray2 = new double[30];
        for (n = 0; n < 30; ++n) {
            dArray2[n] = d4;
            d4 *= d5;
        }
        dArray2[0] = dArray2[0] * 1.0;
        dArray2[4] = dArray2[4] * 2.0;
        dArray2[12] = dArray2[12] * 0.9;
        dArray2[13] = dArray2[13] * 0.7;
        n = 14;
        while (n < 30) {
            int n4 = n++;
            dArray2[n4] = dArray2[n4] * 0.5;
        }
        for (n = 0; n < 30; ++n) {
            double d6 = 0.2;
            double d7 = dArray2[n];
            if (n > 10) {
                d6 = 5.0;
                d7 *= 10.0;
            }
            int n5 = 0;
            if (n > 5) {
                n5 = (n - 5) * 7;
            }
            EmergencySoundbank.complexGaussianDist(dArray, d * (double)(n + 1) + (double)n5, d6, d7);
        }
        SF2Sample sF2Sample = EmergencySoundbank.newSimpleFFTSample(sF2Soundbank, "Grand Piano", dArray, d, 200);
        SF2Layer sF2Layer = EmergencySoundbank.newLayer(sF2Soundbank, "Grand Piano", sF2Sample);
        SF2Region sF2Region = sF2Layer.getRegions().get(0);
        sF2Region.putInteger(54, 1);
        sF2Region.putInteger(34, -7000);
        sF2Region.putInteger(38, 0);
        sF2Region.putInteger(36, 4000);
        sF2Region.putInteger(37, 1000);
        sF2Region.putInteger(26, -6000);
        sF2Region.putInteger(30, 12000);
        sF2Region.putInteger(11, -5500);
        sF2Region.putInteger(8, 18000);
        return sF2Layer;
    }

    public static SF2Layer new_piano_hammer(SF2Soundbank sF2Soundbank) {
        int n;
        int n2 = 2;
        int n3 = 4096 * n2;
        Object object = new double[2 * n3];
        Object object2 = new Random(3049912L);
        for (n = 0; n < ((double[])object).length; n += 2) {
            object[n] = 2.0 * (((Random)object2).nextDouble() - 0.5);
        }
        EmergencySoundbank.fft(object);
        for (n = n3 / 2; n < ((double[])object).length; ++n) {
            object[n] = 0.0;
        }
        for (n = 0; n < 2048 * n2; ++n) {
            int n4 = n;
            object[n4] = object[n4] * Math.exp(-Math.abs((double)(n - 37) / (double)n2) * 0.05);
        }
        EmergencySoundbank.randomPhase(object, new Random(3049912L));
        EmergencySoundbank.ifft(object);
        EmergencySoundbank.normalize(object, 0.6);
        object = EmergencySoundbank.realPart(object);
        double d = 1.0;
        int n5 = 0;
        while (n5 < ((double[])object).length) {
            int n6 = n5++;
            object[n6] = object[n6] * d;
            d *= 0.9997;
        }
        double[] dArray = object;
        EmergencySoundbank.fadeUp(object, 80);
        SF2Sample sF2Sample = EmergencySoundbank.newSimpleDrumSample(sF2Soundbank, "Piano Hammer", dArray);
        SF2Layer sF2Layer = new SF2Layer(sF2Soundbank);
        sF2Layer.setName("Piano Hammer");
        object = new SF2GlobalRegion();
        sF2Layer.setGlobalZone((SF2GlobalRegion)object);
        sF2Soundbank.addResource(sF2Layer);
        object2 = new SF2LayerRegion();
        ((SF2Region)object2).putInteger(38, 12000);
        ((SF2LayerRegion)object2).setSample(sF2Sample);
        sF2Layer.getRegions().add((SF2LayerRegion)object2);
        return sF2Layer;
    }

    public static SF2Layer new_piano1(SF2Soundbank sF2Soundbank) {
        int n;
        int n2 = 8;
        int n3 = 4096 * n2;
        double[] dArray = new double[n3 * 2];
        double d = n2 * 25;
        double d2 = 0.2;
        double d3 = 1.0E-4;
        double d4 = d2;
        double d5 = Math.pow(d3 / d2, 0.025);
        double[] dArray2 = new double[30];
        for (n = 0; n < 30; ++n) {
            dArray2[n] = d4;
            d4 *= d5;
        }
        dArray2[0] = dArray2[0] * 5.0;
        dArray2[2] = dArray2[2] * 0.1;
        dArray2[7] = dArray2[7] * 5.0;
        for (n = 0; n < 30; ++n) {
            double d6 = 0.2;
            double d7 = dArray2[n];
            if (n > 12) {
                d6 = 5.0;
                d7 *= 10.0;
            }
            int n4 = 0;
            if (n > 5) {
                n4 = (n - 5) * 7;
            }
            EmergencySoundbank.complexGaussianDist(dArray, d * (double)(n + 1) + (double)n4, d6, d7);
        }
        EmergencySoundbank.complexGaussianDist(dArray, d * 15.5, 1.0, 0.1);
        EmergencySoundbank.complexGaussianDist(dArray, d * 17.5, 1.0, 0.01);
        SF2Sample sF2Sample = EmergencySoundbank.newSimpleFFTSample(sF2Soundbank, "EPiano", dArray, d, 200);
        SF2Layer sF2Layer = EmergencySoundbank.newLayer(sF2Soundbank, "EPiano", sF2Sample);
        SF2Region sF2Region = sF2Layer.getRegions().get(0);
        sF2Region.putInteger(54, 1);
        sF2Region.putInteger(34, -12000);
        sF2Region.putInteger(38, 0);
        sF2Region.putInteger(36, 4000);
        sF2Region.putInteger(37, 1000);
        sF2Region.putInteger(26, -1200);
        sF2Region.putInteger(30, 12000);
        sF2Region.putInteger(11, -5500);
        sF2Region.putInteger(8, 16000);
        return sF2Layer;
    }

    public static SF2Layer new_epiano1(SF2Soundbank sF2Soundbank) {
        Random random = new Random(302030201L);
        int n = 8;
        int n2 = 4096 * n;
        double[] dArray = new double[n2 * 2];
        double d = n * 25;
        double d2 = 0.05;
        double d3 = 0.05;
        double d4 = 0.2;
        double d5 = 1.0E-4;
        double d6 = d4;
        double d7 = Math.pow(d5 / d4, 0.025);
        for (int i = 0; i < 40; ++i) {
            double d8 = 1.0 + (random.nextDouble() * 2.0 - 1.0) * 1.0E-4;
            double d9 = d2 + (d3 - d2) * ((double)i / 40.0);
            EmergencySoundbank.complexGaussianDist(dArray, d * (double)(i + 1) * d8, d9, d6);
            d6 *= d7;
        }
        SF2Sample sF2Sample = EmergencySoundbank.newSimpleFFTSample(sF2Soundbank, "EPiano", dArray, d);
        SF2Layer sF2Layer = EmergencySoundbank.newLayer(sF2Soundbank, "EPiano", sF2Sample);
        SF2Region sF2Region = sF2Layer.getRegions().get(0);
        sF2Region.putInteger(54, 1);
        sF2Region.putInteger(34, -12000);
        sF2Region.putInteger(38, 0);
        sF2Region.putInteger(36, 4000);
        sF2Region.putInteger(37, 1000);
        sF2Region.putInteger(26, 1200);
        sF2Region.putInteger(30, 12000);
        sF2Region.putInteger(11, -9000);
        sF2Region.putInteger(8, 16000);
        return sF2Layer;
    }

    public static SF2Layer new_epiano2(SF2Soundbank sF2Soundbank) {
        Random random = new Random(302030201L);
        int n = 8;
        int n2 = 4096 * n;
        double[] dArray = new double[n2 * 2];
        double d = n * 25;
        double d2 = 0.01;
        double d3 = 0.05;
        double d4 = 0.2;
        double d5 = 1.0E-5;
        double d6 = d4;
        double d7 = Math.pow(d5 / d4, 0.025);
        for (int i = 0; i < 40; ++i) {
            double d8 = 1.0 + (random.nextDouble() * 2.0 - 1.0) * 1.0E-4;
            double d9 = d2 + (d3 - d2) * ((double)i / 40.0);
            EmergencySoundbank.complexGaussianDist(dArray, d * (double)(i + 1) * d8, d9, d6);
            d6 *= d7;
        }
        SF2Sample sF2Sample = EmergencySoundbank.newSimpleFFTSample(sF2Soundbank, "EPiano", dArray, d);
        SF2Layer sF2Layer = EmergencySoundbank.newLayer(sF2Soundbank, "EPiano", sF2Sample);
        SF2Region sF2Region = sF2Layer.getRegions().get(0);
        sF2Region.putInteger(54, 1);
        sF2Region.putInteger(34, -12000);
        sF2Region.putInteger(38, 0);
        sF2Region.putInteger(36, 8000);
        sF2Region.putInteger(37, 1000);
        sF2Region.putInteger(26, 2400);
        sF2Region.putInteger(30, 12000);
        sF2Region.putInteger(11, -9000);
        sF2Region.putInteger(8, 16000);
        sF2Region.putInteger(48, -100);
        return sF2Layer;
    }

    public static SF2Layer new_bass1(SF2Soundbank sF2Soundbank) {
        int n;
        int n2 = 8;
        int n3 = 4096 * n2;
        double[] dArray = new double[n3 * 2];
        double d = n2 * 25;
        double d2 = 0.05;
        double d3 = 0.05;
        double d4 = 0.2;
        double d5 = 0.02;
        double d6 = d4;
        double d7 = Math.pow(d5 / d4, 0.04);
        double[] dArray2 = new double[25];
        for (n = 0; n < 25; ++n) {
            dArray2[n] = d6;
            d6 *= d7;
        }
        dArray2[0] = dArray2[0] * 8.0;
        dArray2[1] = dArray2[1] * 4.0;
        dArray2[3] = dArray2[3] * 8.0;
        dArray2[5] = dArray2[5] * 8.0;
        for (n = 0; n < 25; ++n) {
            double d8 = d2 + (d3 - d2) * ((double)n / 40.0);
            EmergencySoundbank.complexGaussianDist(dArray, d * (double)(n + 1), d8, dArray2[n]);
        }
        SF2Sample sF2Sample = EmergencySoundbank.newSimpleFFTSample(sF2Soundbank, "Bass", dArray, d);
        SF2Layer sF2Layer = EmergencySoundbank.newLayer(sF2Soundbank, "Bass", sF2Sample);
        SF2Region sF2Region = sF2Layer.getRegions().get(0);
        sF2Region.putInteger(54, 1);
        sF2Region.putInteger(34, -12000);
        sF2Region.putInteger(38, 0);
        sF2Region.putInteger(36, 4000);
        sF2Region.putInteger(37, 1000);
        sF2Region.putInteger(26, -3000);
        sF2Region.putInteger(30, 12000);
        sF2Region.putInteger(11, -5000);
        sF2Region.putInteger(8, 11000);
        sF2Region.putInteger(48, -100);
        return sF2Layer;
    }

    public static SF2Layer new_synthbass(SF2Soundbank sF2Soundbank) {
        int n;
        int n2 = 8;
        int n3 = 4096 * n2;
        double[] dArray = new double[n3 * 2];
        double d = n2 * 25;
        double d2 = 0.05;
        double d3 = 0.05;
        double d4 = 0.2;
        double d5 = 0.02;
        double d6 = d4;
        double d7 = Math.pow(d5 / d4, 0.04);
        double[] dArray2 = new double[25];
        for (n = 0; n < 25; ++n) {
            dArray2[n] = d6;
            d6 *= d7;
        }
        dArray2[0] = dArray2[0] * 16.0;
        dArray2[1] = dArray2[1] * 4.0;
        dArray2[3] = dArray2[3] * 16.0;
        dArray2[5] = dArray2[5] * 8.0;
        for (n = 0; n < 25; ++n) {
            double d8 = d2 + (d3 - d2) * ((double)n / 40.0);
            EmergencySoundbank.complexGaussianDist(dArray, d * (double)(n + 1), d8, dArray2[n]);
        }
        SF2Sample sF2Sample = EmergencySoundbank.newSimpleFFTSample(sF2Soundbank, "Bass", dArray, d);
        SF2Layer sF2Layer = EmergencySoundbank.newLayer(sF2Soundbank, "Bass", sF2Sample);
        SF2Region sF2Region = sF2Layer.getRegions().get(0);
        sF2Region.putInteger(54, 1);
        sF2Region.putInteger(34, -12000);
        sF2Region.putInteger(38, 0);
        sF2Region.putInteger(36, 4000);
        sF2Region.putInteger(37, 1000);
        sF2Region.putInteger(26, -3000);
        sF2Region.putInteger(30, 12000);
        sF2Region.putInteger(11, -3000);
        sF2Region.putInteger(9, 100);
        sF2Region.putInteger(8, 8000);
        sF2Region.putInteger(48, -100);
        return sF2Layer;
    }

    public static SF2Layer new_bass2(SF2Soundbank sF2Soundbank) {
        int n;
        int n2 = 8;
        int n3 = 4096 * n2;
        double[] dArray = new double[n3 * 2];
        double d = n2 * 25;
        double d2 = 0.05;
        double d3 = 0.05;
        double d4 = 0.2;
        double d5 = 0.002;
        double d6 = d4;
        double d7 = Math.pow(d5 / d4, 0.04);
        double[] dArray2 = new double[25];
        for (n = 0; n < 25; ++n) {
            dArray2[n] = d6;
            d6 *= d7;
        }
        dArray2[0] = dArray2[0] * 8.0;
        dArray2[1] = dArray2[1] * 4.0;
        dArray2[3] = dArray2[3] * 8.0;
        dArray2[5] = dArray2[5] * 8.0;
        for (n = 0; n < 25; ++n) {
            double d8 = d2 + (d3 - d2) * ((double)n / 40.0);
            EmergencySoundbank.complexGaussianDist(dArray, d * (double)(n + 1), d8, dArray2[n]);
        }
        SF2Sample sF2Sample = EmergencySoundbank.newSimpleFFTSample(sF2Soundbank, "Bass2", dArray, d);
        SF2Layer sF2Layer = EmergencySoundbank.newLayer(sF2Soundbank, "Bass2", sF2Sample);
        SF2Region sF2Region = sF2Layer.getRegions().get(0);
        sF2Region.putInteger(54, 1);
        sF2Region.putInteger(34, -8000);
        sF2Region.putInteger(38, 0);
        sF2Region.putInteger(36, 4000);
        sF2Region.putInteger(37, 1000);
        sF2Region.putInteger(26, -6000);
        sF2Region.putInteger(30, 12000);
        sF2Region.putInteger(8, 5000);
        sF2Region.putInteger(48, -100);
        return sF2Layer;
    }

    public static SF2Layer new_solostring(SF2Soundbank sF2Soundbank) {
        int n;
        int n2 = 8;
        int n3 = 4096 * n2;
        double[] dArray = new double[n3 * 2];
        double d = n2 * 25;
        double d2 = 2.0;
        double d3 = 2.0;
        double d4 = 0.2;
        double d5 = 0.01;
        double[] dArray2 = new double[18];
        double d6 = d4;
        double d7 = Math.pow(d5 / d4, 0.025);
        for (n = 0; n < dArray2.length; ++n) {
            dArray2[n] = d6 *= d7;
        }
        dArray2[0] = dArray2[0] * 5.0;
        dArray2[1] = dArray2[1] * 5.0;
        dArray2[2] = dArray2[2] * 5.0;
        dArray2[3] = dArray2[3] * 4.0;
        dArray2[4] = dArray2[4] * 4.0;
        dArray2[5] = dArray2[5] * 3.0;
        dArray2[6] = dArray2[6] * 3.0;
        dArray2[7] = dArray2[7] * 2.0;
        for (n = 0; n < dArray2.length; ++n) {
            double d8 = d2 + (d3 - d2) * ((double)n / 40.0);
            EmergencySoundbank.complexGaussianDist(dArray, d * (double)(n + 1), d8, d6);
        }
        SF2Sample sF2Sample = EmergencySoundbank.newSimpleFFTSample(sF2Soundbank, "Strings", dArray, d);
        SF2Layer sF2Layer = EmergencySoundbank.newLayer(sF2Soundbank, "Strings", sF2Sample);
        SF2Region sF2Region = sF2Layer.getRegions().get(0);
        sF2Region.putInteger(54, 1);
        sF2Region.putInteger(34, -5000);
        sF2Region.putInteger(38, 1000);
        sF2Region.putInteger(36, 4000);
        sF2Region.putInteger(37, -100);
        sF2Region.putInteger(8, 9500);
        sF2Region.putInteger(24, -1000);
        sF2Region.putInteger(6, 15);
        return sF2Layer;
    }

    public static SF2Layer new_orchhit(SF2Soundbank sF2Soundbank) {
        int n = 8;
        int n2 = 4096 * n;
        double[] dArray = new double[n2 * 2];
        double d = n * 25;
        double d2 = 2.0;
        double d3 = 80.0;
        double d4 = 0.2;
        double d5 = 0.001;
        double d6 = d4;
        double d7 = Math.pow(d5 / d4, 0.025);
        for (int i = 0; i < 40; ++i) {
            double d8 = d2 + (d3 - d2) * ((double)i / 40.0);
            EmergencySoundbank.complexGaussianDist(dArray, d * (double)(i + 1), d8, d6);
            d6 *= d7;
        }
        EmergencySoundbank.complexGaussianDist(dArray, d * 4.0, 300.0, 1.0);
        SF2Sample sF2Sample = EmergencySoundbank.newSimpleFFTSample(sF2Soundbank, "Och Strings", dArray, d);
        SF2Layer sF2Layer = EmergencySoundbank.newLayer(sF2Soundbank, "Och Strings", sF2Sample);
        SF2Region sF2Region = sF2Layer.getRegions().get(0);
        sF2Region.putInteger(54, 1);
        sF2Region.putInteger(34, -5000);
        sF2Region.putInteger(38, 200);
        sF2Region.putInteger(36, 200);
        sF2Region.putInteger(37, 1000);
        sF2Region.putInteger(8, 9500);
        return sF2Layer;
    }

    public static SF2Layer new_string2(SF2Soundbank sF2Soundbank) {
        int n = 8;
        int n2 = 4096 * n;
        double[] dArray = new double[n2 * 2];
        double d = n * 25;
        double d2 = 2.0;
        double d3 = 80.0;
        double d4 = 0.2;
        double d5 = 0.001;
        double d6 = d4;
        double d7 = Math.pow(d5 / d4, 0.025);
        for (int i = 0; i < 40; ++i) {
            double d8 = d2 + (d3 - d2) * ((double)i / 40.0);
            EmergencySoundbank.complexGaussianDist(dArray, d * (double)(i + 1), d8, d6);
            d6 *= d7;
        }
        SF2Sample sF2Sample = EmergencySoundbank.newSimpleFFTSample(sF2Soundbank, "Strings", dArray, d);
        SF2Layer sF2Layer = EmergencySoundbank.newLayer(sF2Soundbank, "Strings", sF2Sample);
        SF2Region sF2Region = sF2Layer.getRegions().get(0);
        sF2Region.putInteger(54, 1);
        sF2Region.putInteger(34, -5000);
        sF2Region.putInteger(38, 1000);
        sF2Region.putInteger(36, 4000);
        sF2Region.putInteger(37, -100);
        sF2Region.putInteger(8, 9500);
        return sF2Layer;
    }

    public static SF2Layer new_choir(SF2Soundbank sF2Soundbank) {
        int n;
        int n2 = 8;
        int n3 = 4096 * n2;
        double[] dArray = new double[n3 * 2];
        double d = n2 * 25;
        double d2 = 2.0;
        double d3 = 80.0;
        double d4 = 0.2;
        double d5 = 0.001;
        double d6 = d4;
        double d7 = Math.pow(d5 / d4, 0.025);
        double[] dArray2 = new double[40];
        for (n = 0; n < dArray2.length; ++n) {
            dArray2[n] = d6 *= d7;
        }
        dArray2[5] = dArray2[5] * 0.1;
        dArray2[6] = dArray2[6] * 0.01;
        dArray2[7] = dArray2[7] * 0.1;
        dArray2[8] = dArray2[8] * 0.1;
        for (n = 0; n < dArray2.length; ++n) {
            double d8 = d2 + (d3 - d2) * ((double)n / 40.0);
            EmergencySoundbank.complexGaussianDist(dArray, d * (double)(n + 1), d8, dArray2[n]);
        }
        SF2Sample sF2Sample = EmergencySoundbank.newSimpleFFTSample(sF2Soundbank, "Strings", dArray, d);
        SF2Layer sF2Layer = EmergencySoundbank.newLayer(sF2Soundbank, "Strings", sF2Sample);
        SF2Region sF2Region = sF2Layer.getRegions().get(0);
        sF2Region.putInteger(54, 1);
        sF2Region.putInteger(34, -5000);
        sF2Region.putInteger(38, 1000);
        sF2Region.putInteger(36, 4000);
        sF2Region.putInteger(37, -100);
        sF2Region.putInteger(8, 9500);
        return sF2Layer;
    }

    public static SF2Layer new_organ(SF2Soundbank sF2Soundbank) {
        Random random = new Random(102030201L);
        int n = 1;
        int n2 = 4096 * n;
        double[] dArray = new double[n2 * 2];
        double d = n * 15;
        double d2 = 0.01;
        double d3 = 0.01;
        double d4 = 0.2;
        double d5 = 0.001;
        double d6 = d4;
        double d7 = Math.pow(d5 / d4, 0.025);
        for (int i = 0; i < 12; ++i) {
            double d8 = d2 + (d3 - d2) * ((double)i / 40.0);
            EmergencySoundbank.complexGaussianDist(dArray, d * (double)(i + 1), d8, d6 * (0.5 + 3.0 * random.nextDouble()));
            d6 *= d7;
        }
        SF2Sample sF2Sample = EmergencySoundbank.newSimpleFFTSample(sF2Soundbank, "Organ", dArray, d);
        SF2Layer sF2Layer = EmergencySoundbank.newLayer(sF2Soundbank, "Organ", sF2Sample);
        SF2Region sF2Region = sF2Layer.getRegions().get(0);
        sF2Region.putInteger(54, 1);
        sF2Region.putInteger(34, -6000);
        sF2Region.putInteger(38, -1000);
        sF2Region.putInteger(36, 4000);
        sF2Region.putInteger(37, -100);
        sF2Region.putInteger(8, 9500);
        return sF2Layer;
    }

    public static SF2Layer new_ch_organ(SF2Soundbank sF2Soundbank) {
        int n;
        int n2 = 1;
        int n3 = 4096 * n2;
        double[] dArray = new double[n3 * 2];
        double d = n2 * 15;
        double d2 = 0.01;
        double d3 = 0.01;
        double d4 = 0.2;
        double d5 = 0.001;
        double d6 = d4;
        double d7 = Math.pow(d5 / d4, 0.016666666666666666);
        double[] dArray2 = new double[60];
        for (n = 0; n < dArray2.length; ++n) {
            dArray2[n] = d6 *= d7;
        }
        dArray2[0] = dArray2[0] * 5.0;
        dArray2[1] = dArray2[1] * 2.0;
        dArray2[2] = 0.0;
        dArray2[4] = 0.0;
        dArray2[5] = 0.0;
        dArray2[7] = dArray2[7] * 7.0;
        dArray2[9] = 0.0;
        dArray2[10] = 0.0;
        dArray2[12] = 0.0;
        dArray2[15] = dArray2[15] * 7.0;
        dArray2[18] = 0.0;
        dArray2[20] = 0.0;
        dArray2[24] = 0.0;
        dArray2[27] = dArray2[27] * 5.0;
        dArray2[29] = 0.0;
        dArray2[30] = 0.0;
        dArray2[33] = 0.0;
        dArray2[36] = dArray2[36] * 4.0;
        dArray2[37] = 0.0;
        dArray2[39] = 0.0;
        dArray2[42] = 0.0;
        dArray2[43] = 0.0;
        dArray2[47] = 0.0;
        dArray2[50] = dArray2[50] * 4.0;
        dArray2[52] = 0.0;
        dArray2[55] = 0.0;
        dArray2[57] = 0.0;
        dArray2[10] = dArray2[10] * 0.1;
        dArray2[11] = dArray2[11] * 0.1;
        dArray2[12] = dArray2[12] * 0.1;
        dArray2[13] = dArray2[13] * 0.1;
        dArray2[17] = dArray2[17] * 0.1;
        dArray2[18] = dArray2[18] * 0.1;
        dArray2[19] = dArray2[19] * 0.1;
        dArray2[20] = dArray2[20] * 0.1;
        for (n = 0; n < 60; ++n) {
            double d8 = d2 + (d3 - d2) * ((double)n / 40.0);
            EmergencySoundbank.complexGaussianDist(dArray, d * (double)(n + 1), d8, dArray2[n]);
            d6 *= d7;
        }
        SF2Sample sF2Sample = EmergencySoundbank.newSimpleFFTSample(sF2Soundbank, "Organ", dArray, d);
        SF2Layer sF2Layer = EmergencySoundbank.newLayer(sF2Soundbank, "Organ", sF2Sample);
        SF2Region sF2Region = sF2Layer.getRegions().get(0);
        sF2Region.putInteger(54, 1);
        sF2Region.putInteger(34, -10000);
        sF2Region.putInteger(38, -1000);
        return sF2Layer;
    }

    public static SF2Layer new_flute(SF2Soundbank sF2Soundbank) {
        int n = 8;
        int n2 = 4096 * n;
        double[] dArray = new double[n2 * 2];
        double d = n * 15;
        EmergencySoundbank.complexGaussianDist(dArray, d * 1.0, 0.001, 0.5);
        EmergencySoundbank.complexGaussianDist(dArray, d * 2.0, 0.001, 0.5);
        EmergencySoundbank.complexGaussianDist(dArray, d * 3.0, 0.001, 0.5);
        EmergencySoundbank.complexGaussianDist(dArray, d * 4.0, 0.01, 0.5);
        EmergencySoundbank.complexGaussianDist(dArray, d * 4.0, 100.0, 120.0);
        EmergencySoundbank.complexGaussianDist(dArray, d * 6.0, 100.0, 40.0);
        EmergencySoundbank.complexGaussianDist(dArray, d * 8.0, 100.0, 80.0);
        EmergencySoundbank.complexGaussianDist(dArray, d * 5.0, 0.001, 0.05);
        EmergencySoundbank.complexGaussianDist(dArray, d * 6.0, 0.001, 0.06);
        EmergencySoundbank.complexGaussianDist(dArray, d * 7.0, 0.001, 0.04);
        EmergencySoundbank.complexGaussianDist(dArray, d * 8.0, 0.005, 0.06);
        EmergencySoundbank.complexGaussianDist(dArray, d * 9.0, 0.005, 0.06);
        EmergencySoundbank.complexGaussianDist(dArray, d * 10.0, 0.01, 0.1);
        EmergencySoundbank.complexGaussianDist(dArray, d * 11.0, 0.08, 0.7);
        EmergencySoundbank.complexGaussianDist(dArray, d * 12.0, 0.08, 0.6);
        EmergencySoundbank.complexGaussianDist(dArray, d * 13.0, 0.08, 0.6);
        EmergencySoundbank.complexGaussianDist(dArray, d * 14.0, 0.08, 0.6);
        EmergencySoundbank.complexGaussianDist(dArray, d * 15.0, 0.08, 0.5);
        EmergencySoundbank.complexGaussianDist(dArray, d * 16.0, 0.08, 0.5);
        EmergencySoundbank.complexGaussianDist(dArray, d * 17.0, 0.08, 0.2);
        EmergencySoundbank.complexGaussianDist(dArray, d * 1.0, 10.0, 8.0);
        EmergencySoundbank.complexGaussianDist(dArray, d * 2.0, 10.0, 8.0);
        EmergencySoundbank.complexGaussianDist(dArray, d * 3.0, 10.0, 8.0);
        EmergencySoundbank.complexGaussianDist(dArray, d * 4.0, 10.0, 8.0);
        EmergencySoundbank.complexGaussianDist(dArray, d * 5.0, 10.0, 8.0);
        EmergencySoundbank.complexGaussianDist(dArray, d * 6.0, 20.0, 9.0);
        EmergencySoundbank.complexGaussianDist(dArray, d * 7.0, 20.0, 9.0);
        EmergencySoundbank.complexGaussianDist(dArray, d * 8.0, 20.0, 9.0);
        EmergencySoundbank.complexGaussianDist(dArray, d * 9.0, 20.0, 8.0);
        EmergencySoundbank.complexGaussianDist(dArray, d * 10.0, 30.0, 8.0);
        EmergencySoundbank.complexGaussianDist(dArray, d * 11.0, 30.0, 9.0);
        EmergencySoundbank.complexGaussianDist(dArray, d * 12.0, 30.0, 9.0);
        EmergencySoundbank.complexGaussianDist(dArray, d * 13.0, 30.0, 8.0);
        EmergencySoundbank.complexGaussianDist(dArray, d * 14.0, 30.0, 8.0);
        EmergencySoundbank.complexGaussianDist(dArray, d * 15.0, 30.0, 7.0);
        EmergencySoundbank.complexGaussianDist(dArray, d * 16.0, 30.0, 7.0);
        EmergencySoundbank.complexGaussianDist(dArray, d * 17.0, 30.0, 6.0);
        SF2Sample sF2Sample = EmergencySoundbank.newSimpleFFTSample(sF2Soundbank, "Flute", dArray, d);
        SF2Layer sF2Layer = EmergencySoundbank.newLayer(sF2Soundbank, "Flute", sF2Sample);
        SF2Region sF2Region = sF2Layer.getRegions().get(0);
        sF2Region.putInteger(54, 1);
        sF2Region.putInteger(34, -6000);
        sF2Region.putInteger(38, -1000);
        sF2Region.putInteger(36, 4000);
        sF2Region.putInteger(37, -100);
        sF2Region.putInteger(8, 9500);
        return sF2Layer;
    }

    public static SF2Layer new_horn(SF2Soundbank sF2Soundbank) {
        int n = 8;
        int n2 = 4096 * n;
        double[] dArray = new double[n2 * 2];
        double d = n * 15;
        double d2 = 0.5;
        double d3 = 1.0E-11;
        double d4 = d2;
        double d5 = Math.pow(d3 / d2, 0.025);
        for (int i = 0; i < 40; ++i) {
            if (i == 0) {
                EmergencySoundbank.complexGaussianDist(dArray, d * (double)(i + 1), 0.1, d4 * 0.2);
            } else {
                EmergencySoundbank.complexGaussianDist(dArray, d * (double)(i + 1), 0.1, d4);
            }
            d4 *= d5;
        }
        EmergencySoundbank.complexGaussianDist(dArray, d * 2.0, 100.0, 1.0);
        SF2Sample sF2Sample = EmergencySoundbank.newSimpleFFTSample(sF2Soundbank, "Horn", dArray, d);
        SF2Layer sF2Layer = EmergencySoundbank.newLayer(sF2Soundbank, "Horn", sF2Sample);
        SF2Region sF2Region = sF2Layer.getRegions().get(0);
        sF2Region.putInteger(54, 1);
        sF2Region.putInteger(34, -6000);
        sF2Region.putInteger(38, -1000);
        sF2Region.putInteger(36, 4000);
        sF2Region.putInteger(37, -100);
        sF2Region.putInteger(26, -500);
        sF2Region.putInteger(30, 12000);
        sF2Region.putInteger(11, 5000);
        sF2Region.putInteger(8, 4500);
        return sF2Layer;
    }

    public static SF2Layer new_trumpet(SF2Soundbank sF2Soundbank) {
        int n;
        int n2 = 8;
        int n3 = 4096 * n2;
        double[] dArray = new double[n3 * 2];
        double d = n2 * 15;
        double d2 = 0.5;
        double d3 = 1.0E-5;
        double d4 = d2;
        double d5 = Math.pow(d3 / d2, 0.0125);
        double[] dArray2 = new double[80];
        for (n = 0; n < 80; ++n) {
            dArray2[n] = d4;
            d4 *= d5;
        }
        dArray2[0] = dArray2[0] * 0.05;
        dArray2[1] = dArray2[1] * 0.2;
        dArray2[2] = dArray2[2] * 0.5;
        dArray2[3] = dArray2[3] * 0.85;
        for (n = 0; n < 80; ++n) {
            EmergencySoundbank.complexGaussianDist(dArray, d * (double)(n + 1), 0.1, dArray2[n]);
        }
        EmergencySoundbank.complexGaussianDist(dArray, d * 5.0, 300.0, 3.0);
        SF2Sample sF2Sample = EmergencySoundbank.newSimpleFFTSample(sF2Soundbank, "Trumpet", dArray, d);
        SF2Layer sF2Layer = EmergencySoundbank.newLayer(sF2Soundbank, "Trumpet", sF2Sample);
        SF2Region sF2Region = sF2Layer.getRegions().get(0);
        sF2Region.putInteger(54, 1);
        sF2Region.putInteger(34, -10000);
        sF2Region.putInteger(38, 0);
        sF2Region.putInteger(36, 4000);
        sF2Region.putInteger(37, -100);
        sF2Region.putInteger(26, -4000);
        sF2Region.putInteger(30, -2500);
        sF2Region.putInteger(11, 5000);
        sF2Region.putInteger(8, 4500);
        sF2Region.putInteger(9, 10);
        return sF2Layer;
    }

    public static SF2Layer new_brass_section(SF2Soundbank sF2Soundbank) {
        int n = 8;
        int n2 = 4096 * n;
        double[] dArray = new double[n2 * 2];
        double d = n * 15;
        double d2 = 0.5;
        double d3 = 0.005;
        double d4 = d2;
        double d5 = Math.pow(d3 / d2, 0.03333333333333333);
        double[] dArray2 = new double[30];
        for (int i = 0; i < 30; ++i) {
            dArray2[i] = d4;
            d4 *= d5;
        }
        dArray2[0] = dArray2[0] * 0.8;
        dArray2[1] = dArray2[1] * 0.9;
        double d6 = 5.0;
        for (int i = 0; i < 30; ++i) {
            EmergencySoundbank.complexGaussianDist(dArray, d * (double)(i + 1), 0.1 * d6, dArray2[i] * d6);
            d6 += 6.0;
        }
        EmergencySoundbank.complexGaussianDist(dArray, d * 6.0, 300.0, 2.0);
        SF2Sample sF2Sample = EmergencySoundbank.newSimpleFFTSample(sF2Soundbank, "Brass Section", dArray, d);
        SF2Layer sF2Layer = EmergencySoundbank.newLayer(sF2Soundbank, "Brass Section", sF2Sample);
        SF2Region sF2Region = sF2Layer.getRegions().get(0);
        sF2Region.putInteger(54, 1);
        sF2Region.putInteger(34, -9200);
        sF2Region.putInteger(38, -1000);
        sF2Region.putInteger(36, 4000);
        sF2Region.putInteger(37, -100);
        sF2Region.putInteger(26, -3000);
        sF2Region.putInteger(30, 12000);
        sF2Region.putInteger(11, 5000);
        sF2Region.putInteger(8, 4500);
        return sF2Layer;
    }

    public static SF2Layer new_trombone(SF2Soundbank sF2Soundbank) {
        int n;
        int n2 = 8;
        int n3 = 4096 * n2;
        double[] dArray = new double[n3 * 2];
        double d = n2 * 15;
        double d2 = 0.5;
        double d3 = 0.001;
        double d4 = d2;
        double d5 = Math.pow(d3 / d2, 0.0125);
        double[] dArray2 = new double[80];
        for (n = 0; n < 80; ++n) {
            dArray2[n] = d4;
            d4 *= d5;
        }
        dArray2[0] = dArray2[0] * 0.3;
        dArray2[1] = dArray2[1] * 0.7;
        for (n = 0; n < 80; ++n) {
            EmergencySoundbank.complexGaussianDist(dArray, d * (double)(n + 1), 0.1, dArray2[n]);
        }
        EmergencySoundbank.complexGaussianDist(dArray, d * 6.0, 300.0, 2.0);
        SF2Sample sF2Sample = EmergencySoundbank.newSimpleFFTSample(sF2Soundbank, "Trombone", dArray, d);
        SF2Layer sF2Layer = EmergencySoundbank.newLayer(sF2Soundbank, "Trombone", sF2Sample);
        SF2Region sF2Region = sF2Layer.getRegions().get(0);
        sF2Region.putInteger(54, 1);
        sF2Region.putInteger(34, -8000);
        sF2Region.putInteger(38, -1000);
        sF2Region.putInteger(36, 4000);
        sF2Region.putInteger(37, -100);
        sF2Region.putInteger(26, -2000);
        sF2Region.putInteger(30, 12000);
        sF2Region.putInteger(11, 5000);
        sF2Region.putInteger(8, 4500);
        sF2Region.putInteger(9, 10);
        return sF2Layer;
    }

    public static SF2Layer new_sax(SF2Soundbank sF2Soundbank) {
        int n = 8;
        int n2 = 4096 * n;
        double[] dArray = new double[n2 * 2];
        double d = n * 15;
        double d2 = 0.5;
        double d3 = 0.01;
        double d4 = d2;
        double d5 = Math.pow(d3 / d2, 0.025);
        for (int i = 0; i < 40; ++i) {
            if (i == 0 || i == 2) {
                EmergencySoundbank.complexGaussianDist(dArray, d * (double)(i + 1), 0.1, d4 * 4.0);
            } else {
                EmergencySoundbank.complexGaussianDist(dArray, d * (double)(i + 1), 0.1, d4);
            }
            d4 *= d5;
        }
        EmergencySoundbank.complexGaussianDist(dArray, d * 4.0, 200.0, 1.0);
        SF2Sample sF2Sample = EmergencySoundbank.newSimpleFFTSample(sF2Soundbank, "Sax", dArray, d);
        SF2Layer sF2Layer = EmergencySoundbank.newLayer(sF2Soundbank, "Sax", sF2Sample);
        SF2Region sF2Region = sF2Layer.getRegions().get(0);
        sF2Region.putInteger(54, 1);
        sF2Region.putInteger(34, -6000);
        sF2Region.putInteger(38, -1000);
        sF2Region.putInteger(36, 4000);
        sF2Region.putInteger(37, -100);
        sF2Region.putInteger(26, -3000);
        sF2Region.putInteger(30, 12000);
        sF2Region.putInteger(11, 5000);
        sF2Region.putInteger(8, 4500);
        return sF2Layer;
    }

    public static SF2Layer new_oboe(SF2Soundbank sF2Soundbank) {
        int n = 8;
        int n2 = 4096 * n;
        double[] dArray = new double[n2 * 2];
        double d = n * 15;
        EmergencySoundbank.complexGaussianDist(dArray, d * 5.0, 100.0, 80.0);
        EmergencySoundbank.complexGaussianDist(dArray, d * 1.0, 0.01, 0.53);
        EmergencySoundbank.complexGaussianDist(dArray, d * 2.0, 0.01, 0.51);
        EmergencySoundbank.complexGaussianDist(dArray, d * 3.0, 0.01, 0.48);
        EmergencySoundbank.complexGaussianDist(dArray, d * 4.0, 0.01, 0.49);
        EmergencySoundbank.complexGaussianDist(dArray, d * 5.0, 0.01, 5.0);
        EmergencySoundbank.complexGaussianDist(dArray, d * 6.0, 0.01, 0.51);
        EmergencySoundbank.complexGaussianDist(dArray, d * 7.0, 0.01, 0.5);
        EmergencySoundbank.complexGaussianDist(dArray, d * 8.0, 0.01, 0.59);
        EmergencySoundbank.complexGaussianDist(dArray, d * 9.0, 0.01, 0.61);
        EmergencySoundbank.complexGaussianDist(dArray, d * 10.0, 0.01, 0.52);
        EmergencySoundbank.complexGaussianDist(dArray, d * 11.0, 0.01, 0.49);
        EmergencySoundbank.complexGaussianDist(dArray, d * 12.0, 0.01, 0.51);
        EmergencySoundbank.complexGaussianDist(dArray, d * 13.0, 0.01, 0.48);
        EmergencySoundbank.complexGaussianDist(dArray, d * 14.0, 0.01, 0.51);
        EmergencySoundbank.complexGaussianDist(dArray, d * 15.0, 0.01, 0.46);
        EmergencySoundbank.complexGaussianDist(dArray, d * 16.0, 0.01, 0.35);
        EmergencySoundbank.complexGaussianDist(dArray, d * 17.0, 0.01, 0.2);
        EmergencySoundbank.complexGaussianDist(dArray, d * 18.0, 0.01, 0.1);
        EmergencySoundbank.complexGaussianDist(dArray, d * 19.0, 0.01, 0.5);
        EmergencySoundbank.complexGaussianDist(dArray, d * 20.0, 0.01, 0.1);
        SF2Sample sF2Sample = EmergencySoundbank.newSimpleFFTSample(sF2Soundbank, "Oboe", dArray, d);
        SF2Layer sF2Layer = EmergencySoundbank.newLayer(sF2Soundbank, "Oboe", sF2Sample);
        SF2Region sF2Region = sF2Layer.getRegions().get(0);
        sF2Region.putInteger(54, 1);
        sF2Region.putInteger(34, -6000);
        sF2Region.putInteger(38, -1000);
        sF2Region.putInteger(36, 4000);
        sF2Region.putInteger(37, -100);
        sF2Region.putInteger(8, 9500);
        return sF2Layer;
    }

    public static SF2Layer new_bassoon(SF2Soundbank sF2Soundbank) {
        int n = 8;
        int n2 = 4096 * n;
        double[] dArray = new double[n2 * 2];
        double d = n * 15;
        EmergencySoundbank.complexGaussianDist(dArray, d * 2.0, 100.0, 40.0);
        EmergencySoundbank.complexGaussianDist(dArray, d * 4.0, 100.0, 20.0);
        EmergencySoundbank.complexGaussianDist(dArray, d * 1.0, 0.01, 0.53);
        EmergencySoundbank.complexGaussianDist(dArray, d * 2.0, 0.01, 5.0);
        EmergencySoundbank.complexGaussianDist(dArray, d * 3.0, 0.01, 0.51);
        EmergencySoundbank.complexGaussianDist(dArray, d * 4.0, 0.01, 0.48);
        EmergencySoundbank.complexGaussianDist(dArray, d * 5.0, 0.01, 1.49);
        EmergencySoundbank.complexGaussianDist(dArray, d * 6.0, 0.01, 0.51);
        EmergencySoundbank.complexGaussianDist(dArray, d * 7.0, 0.01, 0.5);
        EmergencySoundbank.complexGaussianDist(dArray, d * 8.0, 0.01, 0.59);
        EmergencySoundbank.complexGaussianDist(dArray, d * 9.0, 0.01, 0.61);
        EmergencySoundbank.complexGaussianDist(dArray, d * 10.0, 0.01, 0.52);
        EmergencySoundbank.complexGaussianDist(dArray, d * 11.0, 0.01, 0.49);
        EmergencySoundbank.complexGaussianDist(dArray, d * 12.0, 0.01, 0.51);
        EmergencySoundbank.complexGaussianDist(dArray, d * 13.0, 0.01, 0.48);
        EmergencySoundbank.complexGaussianDist(dArray, d * 14.0, 0.01, 0.51);
        EmergencySoundbank.complexGaussianDist(dArray, d * 15.0, 0.01, 0.46);
        EmergencySoundbank.complexGaussianDist(dArray, d * 16.0, 0.01, 0.35);
        EmergencySoundbank.complexGaussianDist(dArray, d * 17.0, 0.01, 0.2);
        EmergencySoundbank.complexGaussianDist(dArray, d * 18.0, 0.01, 0.1);
        EmergencySoundbank.complexGaussianDist(dArray, d * 19.0, 0.01, 0.5);
        EmergencySoundbank.complexGaussianDist(dArray, d * 20.0, 0.01, 0.1);
        SF2Sample sF2Sample = EmergencySoundbank.newSimpleFFTSample(sF2Soundbank, "Flute", dArray, d);
        SF2Layer sF2Layer = EmergencySoundbank.newLayer(sF2Soundbank, "Flute", sF2Sample);
        SF2Region sF2Region = sF2Layer.getRegions().get(0);
        sF2Region.putInteger(54, 1);
        sF2Region.putInteger(34, -6000);
        sF2Region.putInteger(38, -1000);
        sF2Region.putInteger(36, 4000);
        sF2Region.putInteger(37, -100);
        sF2Region.putInteger(8, 9500);
        return sF2Layer;
    }

    public static SF2Layer new_clarinet(SF2Soundbank sF2Soundbank) {
        int n = 8;
        int n2 = 4096 * n;
        double[] dArray = new double[n2 * 2];
        double d = n * 15;
        EmergencySoundbank.complexGaussianDist(dArray, d * 1.0, 0.001, 0.5);
        EmergencySoundbank.complexGaussianDist(dArray, d * 2.0, 0.001, 0.02);
        EmergencySoundbank.complexGaussianDist(dArray, d * 3.0, 0.001, 0.2);
        EmergencySoundbank.complexGaussianDist(dArray, d * 4.0, 0.01, 0.1);
        EmergencySoundbank.complexGaussianDist(dArray, d * 4.0, 100.0, 60.0);
        EmergencySoundbank.complexGaussianDist(dArray, d * 6.0, 100.0, 20.0);
        EmergencySoundbank.complexGaussianDist(dArray, d * 8.0, 100.0, 20.0);
        EmergencySoundbank.complexGaussianDist(dArray, d * 5.0, 0.001, 0.1);
        EmergencySoundbank.complexGaussianDist(dArray, d * 6.0, 0.001, 0.09);
        EmergencySoundbank.complexGaussianDist(dArray, d * 7.0, 0.001, 0.02);
        EmergencySoundbank.complexGaussianDist(dArray, d * 8.0, 0.005, 0.16);
        EmergencySoundbank.complexGaussianDist(dArray, d * 9.0, 0.005, 0.96);
        EmergencySoundbank.complexGaussianDist(dArray, d * 10.0, 0.01, 0.9);
        EmergencySoundbank.complexGaussianDist(dArray, d * 11.0, 0.08, 1.2);
        EmergencySoundbank.complexGaussianDist(dArray, d * 12.0, 0.08, 1.8);
        EmergencySoundbank.complexGaussianDist(dArray, d * 13.0, 0.08, 1.6);
        EmergencySoundbank.complexGaussianDist(dArray, d * 14.0, 0.08, 1.2);
        EmergencySoundbank.complexGaussianDist(dArray, d * 15.0, 0.08, 0.9);
        EmergencySoundbank.complexGaussianDist(dArray, d * 16.0, 0.08, 0.5);
        EmergencySoundbank.complexGaussianDist(dArray, d * 17.0, 0.08, 0.2);
        EmergencySoundbank.complexGaussianDist(dArray, d * 1.0, 10.0, 8.0);
        EmergencySoundbank.complexGaussianDist(dArray, d * 2.0, 10.0, 8.0);
        EmergencySoundbank.complexGaussianDist(dArray, d * 3.0, 10.0, 8.0);
        EmergencySoundbank.complexGaussianDist(dArray, d * 4.0, 10.0, 8.0);
        EmergencySoundbank.complexGaussianDist(dArray, d * 5.0, 10.0, 8.0);
        EmergencySoundbank.complexGaussianDist(dArray, d * 6.0, 20.0, 9.0);
        EmergencySoundbank.complexGaussianDist(dArray, d * 7.0, 20.0, 9.0);
        EmergencySoundbank.complexGaussianDist(dArray, d * 8.0, 20.0, 9.0);
        EmergencySoundbank.complexGaussianDist(dArray, d * 9.0, 20.0, 8.0);
        EmergencySoundbank.complexGaussianDist(dArray, d * 10.0, 30.0, 8.0);
        EmergencySoundbank.complexGaussianDist(dArray, d * 11.0, 30.0, 9.0);
        EmergencySoundbank.complexGaussianDist(dArray, d * 12.0, 30.0, 9.0);
        EmergencySoundbank.complexGaussianDist(dArray, d * 13.0, 30.0, 8.0);
        EmergencySoundbank.complexGaussianDist(dArray, d * 14.0, 30.0, 8.0);
        EmergencySoundbank.complexGaussianDist(dArray, d * 15.0, 30.0, 7.0);
        EmergencySoundbank.complexGaussianDist(dArray, d * 16.0, 30.0, 7.0);
        EmergencySoundbank.complexGaussianDist(dArray, d * 17.0, 30.0, 6.0);
        SF2Sample sF2Sample = EmergencySoundbank.newSimpleFFTSample(sF2Soundbank, "Clarinet", dArray, d);
        SF2Layer sF2Layer = EmergencySoundbank.newLayer(sF2Soundbank, "Clarinet", sF2Sample);
        SF2Region sF2Region = sF2Layer.getRegions().get(0);
        sF2Region.putInteger(54, 1);
        sF2Region.putInteger(34, -6000);
        sF2Region.putInteger(38, -1000);
        sF2Region.putInteger(36, 4000);
        sF2Region.putInteger(37, -100);
        sF2Region.putInteger(8, 9500);
        return sF2Layer;
    }

    public static SF2Layer new_timpani(SF2Soundbank sF2Soundbank) {
        int n;
        int n2 = 32768;
        Object object = new double[2 * n2];
        double d = 48.0;
        EmergencySoundbank.complexGaussianDist((double[])object, d * 2.0, 0.2, 1.0);
        EmergencySoundbank.complexGaussianDist((double[])object, d * 3.0, 0.2, 0.7);
        EmergencySoundbank.complexGaussianDist((double[])object, d * 5.0, 10.0, 1.0);
        EmergencySoundbank.complexGaussianDist((double[])object, d * 6.0, 9.0, 1.0);
        EmergencySoundbank.complexGaussianDist((double[])object, d * 8.0, 15.0, 1.0);
        EmergencySoundbank.complexGaussianDist((double[])object, d * 9.0, 18.0, 0.8);
        EmergencySoundbank.complexGaussianDist((double[])object, d * 11.0, 21.0, 0.5);
        EmergencySoundbank.complexGaussianDist((double[])object, d * 13.0, 28.0, 0.3);
        EmergencySoundbank.complexGaussianDist((double[])object, d * 14.0, 22.0, 0.1);
        EmergencySoundbank.randomPhase((double[])object, new Random(3049912L));
        EmergencySoundbank.ifft((double[])object);
        EmergencySoundbank.normalize((double[])object, 0.5);
        object = EmergencySoundbank.realPart((double[])object);
        double d2 = ((double[])object).length;
        int n3 = 0;
        while (n3 < ((double[])object).length) {
            double d3 = 1.0 - (double)n3 / d2;
            int n4 = n3++;
            object[n4] = object[n4] * (d3 * d3);
        }
        EmergencySoundbank.fadeUp((double[])object, 40);
        double[] dArray = object;
        n2 = 16384;
        object = new double[2 * n2];
        Object object2 = new Random(3049912L);
        for (n = 0; n < ((double[])object).length; n += 2) {
            object[n] = 2.0 * (((Random)object2).nextDouble() - 0.5) * 0.1;
        }
        EmergencySoundbank.fft((double[])object);
        for (n = n2 / 2; n < ((double[])object).length; ++n) {
            object[n] = 0.0;
        }
        for (n = 4096; n < 8192; ++n) {
            object[n] = 1.0 - (double)(n - 4096) / 4096.0;
        }
        n = 0;
        while (n < 300) {
            d2 = 1.0 - (double)n / 300.0;
            int n5 = n++;
            object[n5] = object[n5] * (1.0 + 20.0 * d2 * d2);
        }
        for (n = 0; n < 24; ++n) {
            object[n] = 0.0;
        }
        EmergencySoundbank.randomPhase((double[])object, new Random(3049912L));
        EmergencySoundbank.ifft((double[])object);
        EmergencySoundbank.normalize((double[])object, 0.9);
        object = EmergencySoundbank.realPart((double[])object);
        double d4 = 1.0;
        int n6 = 0;
        while (n6 < ((double[])object).length) {
            int n7 = n6++;
            object[n7] = object[n7] * d4;
            d4 *= 0.9998;
        }
        double[] dArray2 = object;
        for (n2 = 0; n2 < dArray2.length; ++n2) {
            int n8 = n2;
            dArray[n8] = dArray[n8] + dArray2[n2] * 0.02;
        }
        EmergencySoundbank.normalize(dArray, 0.9);
        SF2Sample sF2Sample = EmergencySoundbank.newSimpleDrumSample(sF2Soundbank, "Timpani", dArray);
        object = new SF2Layer(sF2Soundbank);
        ((SF2Layer)object).setName("Timpani");
        object2 = new SF2GlobalRegion();
        ((SF2Layer)object).setGlobalZone((SF2GlobalRegion)object2);
        sF2Soundbank.addResource((SoundbankResource)object);
        SF2LayerRegion sF2LayerRegion = new SF2LayerRegion();
        sF2LayerRegion.putInteger(38, 12000);
        sF2LayerRegion.putInteger(48, -100);
        sF2LayerRegion.setSample(sF2Sample);
        ((SF2Layer)object).getRegions().add(sF2LayerRegion);
        return object;
    }

    public static SF2Layer new_melodic_toms(SF2Soundbank sF2Soundbank) {
        int n;
        int n2 = 16384;
        Object object = new double[2 * n2];
        EmergencySoundbank.complexGaussianDist((double[])object, 30.0, 0.5, 1.0);
        EmergencySoundbank.randomPhase((double[])object, new Random(3049912L));
        EmergencySoundbank.ifft((double[])object);
        EmergencySoundbank.normalize((double[])object, 0.8);
        object = EmergencySoundbank.realPart((double[])object);
        double d = ((double[])object).length;
        for (int i = 0; i < ((double[])object).length; ++i) {
            int n3 = i;
            object[n3] = object[n3] * (1.0 - (double)i / d);
        }
        double[] dArray = object;
        n2 = 16384;
        object = new double[2 * n2];
        Object object2 = new Random(3049912L);
        for (n = 0; n < ((double[])object).length; n += 2) {
            object[n] = 2.0 * (((Random)object2).nextDouble() - 0.5) * 0.1;
        }
        EmergencySoundbank.fft((double[])object);
        for (n = n2 / 2; n < ((double[])object).length; ++n) {
            object[n] = 0.0;
        }
        for (n = 4096; n < 8192; ++n) {
            object[n] = 1.0 - (double)(n - 4096) / 4096.0;
        }
        n = 0;
        while (n < 200) {
            double d2 = 1.0 - (double)n / 200.0;
            int n4 = n++;
            object[n4] = object[n4] * (1.0 + 20.0 * d2 * d2);
        }
        for (n = 0; n < 30; ++n) {
            object[n] = 0.0;
        }
        EmergencySoundbank.randomPhase((double[])object, new Random(3049912L));
        EmergencySoundbank.ifft((double[])object);
        EmergencySoundbank.normalize((double[])object, 0.9);
        object = EmergencySoundbank.realPart((double[])object);
        double d3 = 1.0;
        int n5 = 0;
        while (n5 < ((double[])object).length) {
            int n6 = n5++;
            object[n6] = object[n6] * d3;
            d3 *= 0.9996;
        }
        double[] dArray2 = object;
        for (n2 = 0; n2 < dArray2.length; ++n2) {
            int n7 = n2;
            dArray[n7] = dArray[n7] + dArray2[n2] * 0.5;
        }
        for (n2 = 0; n2 < 5; ++n2) {
            int n8 = n2;
            dArray[n8] = dArray[n8] * ((double)n2 / 5.0);
        }
        EmergencySoundbank.normalize(dArray, 0.99);
        SF2Sample sF2Sample = EmergencySoundbank.newSimpleDrumSample(sF2Soundbank, "Melodic Toms", dArray);
        sF2Sample.setOriginalPitch(63);
        object = new SF2Layer(sF2Soundbank);
        ((SF2Layer)object).setName("Melodic Toms");
        object2 = new SF2GlobalRegion();
        ((SF2Layer)object).setGlobalZone((SF2GlobalRegion)object2);
        sF2Soundbank.addResource((SoundbankResource)object);
        SF2LayerRegion sF2LayerRegion = new SF2LayerRegion();
        sF2LayerRegion.putInteger(38, 12000);
        sF2LayerRegion.putInteger(48, -100);
        sF2LayerRegion.setSample(sF2Sample);
        ((SF2Layer)object).getRegions().add(sF2LayerRegion);
        return object;
    }

    public static SF2Layer new_reverse_cymbal(SF2Soundbank sF2Soundbank) {
        int n;
        int n2 = 16384;
        Object object = new double[2 * n2];
        Object object2 = new Random(3049912L);
        for (n = 0; n < ((double[])object).length; n += 2) {
            object[n] = 2.0 * (((Random)object2).nextDouble() - 0.5);
        }
        for (n = n2 / 2; n < ((double[])object).length; ++n) {
            object[n] = 0.0;
        }
        for (n = 0; n < 100; ++n) {
            object[n] = 0.0;
        }
        for (n = 0; n < 1024; ++n) {
            double d = (double)n / 1024.0;
            object[n] = 1.0 - d;
        }
        double[] dArray = object;
        SF2Sample sF2Sample = EmergencySoundbank.newSimpleFFTSample(sF2Soundbank, "Reverse Cymbal", dArray, 100.0, 20);
        object = new SF2Layer(sF2Soundbank);
        ((SF2Layer)object).setName("Reverse Cymbal");
        object2 = new SF2GlobalRegion();
        ((SF2Layer)object).setGlobalZone((SF2GlobalRegion)object2);
        sF2Soundbank.addResource((SoundbankResource)object);
        SF2LayerRegion sF2LayerRegion = new SF2LayerRegion();
        sF2LayerRegion.putInteger(34, -200);
        sF2LayerRegion.putInteger(36, -12000);
        sF2LayerRegion.putInteger(54, 1);
        sF2LayerRegion.putInteger(38, -1000);
        sF2LayerRegion.putInteger(37, 1000);
        sF2LayerRegion.setSample(sF2Sample);
        ((SF2Layer)object).getRegions().add(sF2LayerRegion);
        return object;
    }

    public static SF2Layer new_snare_drum(SF2Soundbank sF2Soundbank) {
        int n;
        int n2 = 16384;
        Object object = new double[2 * n2];
        EmergencySoundbank.complexGaussianDist((double[])object, 24.0, 0.5, 1.0);
        EmergencySoundbank.randomPhase((double[])object, new Random(3049912L));
        EmergencySoundbank.ifft((double[])object);
        EmergencySoundbank.normalize((double[])object, 0.5);
        object = EmergencySoundbank.realPart((double[])object);
        double d = ((double[])object).length;
        for (int i = 0; i < ((double[])object).length; ++i) {
            int n3 = i;
            object[n3] = object[n3] * (1.0 - (double)i / d);
        }
        double[] dArray = object;
        n2 = 16384;
        object = new double[2 * n2];
        Object object2 = new Random(3049912L);
        for (n = 0; n < ((double[])object).length; n += 2) {
            object[n] = 2.0 * (((Random)object2).nextDouble() - 0.5) * 0.1;
        }
        EmergencySoundbank.fft((double[])object);
        for (n = n2 / 2; n < ((double[])object).length; ++n) {
            object[n] = 0.0;
        }
        for (n = 4096; n < 8192; ++n) {
            object[n] = 1.0 - (double)(n - 4096) / 4096.0;
        }
        n = 0;
        while (n < 300) {
            double d2 = 1.0 - (double)n / 300.0;
            int n4 = n++;
            object[n4] = object[n4] * (1.0 + 20.0 * d2 * d2);
        }
        for (n = 0; n < 24; ++n) {
            object[n] = 0.0;
        }
        EmergencySoundbank.randomPhase((double[])object, new Random(3049912L));
        EmergencySoundbank.ifft((double[])object);
        EmergencySoundbank.normalize((double[])object, 0.9);
        object = EmergencySoundbank.realPart((double[])object);
        double d3 = 1.0;
        int n5 = 0;
        while (n5 < ((double[])object).length) {
            int n6 = n5++;
            object[n6] = object[n6] * d3;
            d3 *= 0.9998;
        }
        double[] dArray2 = object;
        for (n2 = 0; n2 < dArray2.length; ++n2) {
            int n7 = n2;
            dArray[n7] = dArray[n7] + dArray2[n2];
        }
        for (n2 = 0; n2 < 5; ++n2) {
            int n8 = n2;
            dArray[n8] = dArray[n8] * ((double)n2 / 5.0);
        }
        SF2Sample sF2Sample = EmergencySoundbank.newSimpleDrumSample(sF2Soundbank, "Snare Drum", dArray);
        object = new SF2Layer(sF2Soundbank);
        ((SF2Layer)object).setName("Snare Drum");
        object2 = new SF2GlobalRegion();
        ((SF2Layer)object).setGlobalZone((SF2GlobalRegion)object2);
        sF2Soundbank.addResource((SoundbankResource)object);
        SF2LayerRegion sF2LayerRegion = new SF2LayerRegion();
        sF2LayerRegion.putInteger(38, 12000);
        sF2LayerRegion.putInteger(56, 0);
        sF2LayerRegion.putInteger(48, -100);
        sF2LayerRegion.setSample(sF2Sample);
        ((SF2Layer)object).getRegions().add(sF2LayerRegion);
        return object;
    }

    public static SF2Layer new_bass_drum(SF2Soundbank sF2Soundbank) {
        int n;
        int n2 = 16384;
        Object object = new double[2 * n2];
        EmergencySoundbank.complexGaussianDist((double[])object, 10.0, 2.0, 1.0);
        EmergencySoundbank.complexGaussianDist((double[])object, 17.2, 2.0, 1.0);
        EmergencySoundbank.randomPhase((double[])object, new Random(3049912L));
        EmergencySoundbank.ifft((double[])object);
        EmergencySoundbank.normalize((double[])object, 0.9);
        object = EmergencySoundbank.realPart((double[])object);
        double d = ((double[])object).length;
        for (int i = 0; i < ((double[])object).length; ++i) {
            int n3 = i;
            object[n3] = object[n3] * (1.0 - (double)i / d);
        }
        double[] dArray = object;
        n2 = 4096;
        object = new double[2 * n2];
        Object object2 = new Random(3049912L);
        for (n = 0; n < ((double[])object).length; n += 2) {
            object[n] = 2.0 * (((Random)object2).nextDouble() - 0.5) * 0.1;
        }
        EmergencySoundbank.fft((double[])object);
        for (n = n2 / 2; n < ((double[])object).length; ++n) {
            object[n] = 0.0;
        }
        for (n = 1024; n < 2048; ++n) {
            object[n] = 1.0 - (double)(n - 1024) / 1024.0;
        }
        for (n = 0; n < 512; ++n) {
            object[n] = (double)(10 * n) / 512.0;
        }
        for (n = 0; n < 10; ++n) {
            object[n] = 0.0;
        }
        EmergencySoundbank.randomPhase((double[])object, new Random(3049912L));
        EmergencySoundbank.ifft((double[])object);
        EmergencySoundbank.normalize((double[])object, 0.9);
        object = EmergencySoundbank.realPart((double[])object);
        double d2 = 1.0;
        int n4 = 0;
        while (n4 < ((double[])object).length) {
            int n5 = n4++;
            object[n5] = object[n5] * d2;
            d2 *= 0.999;
        }
        double[] dArray2 = object;
        for (n2 = 0; n2 < dArray2.length; ++n2) {
            int n6 = n2;
            dArray[n6] = dArray[n6] + dArray2[n2] * 0.5;
        }
        for (n2 = 0; n2 < 5; ++n2) {
            int n7 = n2;
            dArray[n7] = dArray[n7] * ((double)n2 / 5.0);
        }
        SF2Sample sF2Sample = EmergencySoundbank.newSimpleDrumSample(sF2Soundbank, "Bass Drum", dArray);
        object = new SF2Layer(sF2Soundbank);
        ((SF2Layer)object).setName("Bass Drum");
        object2 = new SF2GlobalRegion();
        ((SF2Layer)object).setGlobalZone((SF2GlobalRegion)object2);
        sF2Soundbank.addResource((SoundbankResource)object);
        SF2LayerRegion sF2LayerRegion = new SF2LayerRegion();
        sF2LayerRegion.putInteger(38, 12000);
        sF2LayerRegion.putInteger(56, 0);
        sF2LayerRegion.putInteger(48, -100);
        sF2LayerRegion.setSample(sF2Sample);
        ((SF2Layer)object).getRegions().add(sF2LayerRegion);
        return object;
    }

    public static SF2Layer new_tom(SF2Soundbank sF2Soundbank) {
        int n;
        int n2 = 16384;
        Object object = new double[2 * n2];
        EmergencySoundbank.complexGaussianDist((double[])object, 30.0, 0.5, 1.0);
        EmergencySoundbank.randomPhase((double[])object, new Random(3049912L));
        EmergencySoundbank.ifft((double[])object);
        EmergencySoundbank.normalize((double[])object, 0.8);
        object = EmergencySoundbank.realPart((double[])object);
        double d = ((double[])object).length;
        for (int i = 0; i < ((double[])object).length; ++i) {
            int n3 = i;
            object[n3] = object[n3] * (1.0 - (double)i / d);
        }
        double[] dArray = object;
        n2 = 16384;
        object = new double[2 * n2];
        Object object2 = new Random(3049912L);
        for (n = 0; n < ((double[])object).length; n += 2) {
            object[n] = 2.0 * (((Random)object2).nextDouble() - 0.5) * 0.1;
        }
        EmergencySoundbank.fft((double[])object);
        for (n = n2 / 2; n < ((double[])object).length; ++n) {
            object[n] = 0.0;
        }
        for (n = 4096; n < 8192; ++n) {
            object[n] = 1.0 - (double)(n - 4096) / 4096.0;
        }
        n = 0;
        while (n < 200) {
            double d2 = 1.0 - (double)n / 200.0;
            int n4 = n++;
            object[n4] = object[n4] * (1.0 + 20.0 * d2 * d2);
        }
        for (n = 0; n < 30; ++n) {
            object[n] = 0.0;
        }
        EmergencySoundbank.randomPhase((double[])object, new Random(3049912L));
        EmergencySoundbank.ifft((double[])object);
        EmergencySoundbank.normalize((double[])object, 0.9);
        object = EmergencySoundbank.realPart((double[])object);
        double d3 = 1.0;
        int n5 = 0;
        while (n5 < ((double[])object).length) {
            int n6 = n5++;
            object[n6] = object[n6] * d3;
            d3 *= 0.9996;
        }
        double[] dArray2 = object;
        for (n2 = 0; n2 < dArray2.length; ++n2) {
            int n7 = n2;
            dArray[n7] = dArray[n7] + dArray2[n2] * 0.5;
        }
        for (n2 = 0; n2 < 5; ++n2) {
            int n8 = n2;
            dArray[n8] = dArray[n8] * ((double)n2 / 5.0);
        }
        EmergencySoundbank.normalize(dArray, 0.99);
        SF2Sample sF2Sample = EmergencySoundbank.newSimpleDrumSample(sF2Soundbank, "Tom", dArray);
        sF2Sample.setOriginalPitch(50);
        object = new SF2Layer(sF2Soundbank);
        ((SF2Layer)object).setName("Tom");
        object2 = new SF2GlobalRegion();
        ((SF2Layer)object).setGlobalZone((SF2GlobalRegion)object2);
        sF2Soundbank.addResource((SoundbankResource)object);
        SF2LayerRegion sF2LayerRegion = new SF2LayerRegion();
        sF2LayerRegion.putInteger(38, 12000);
        sF2LayerRegion.putInteger(48, -100);
        sF2LayerRegion.setSample(sF2Sample);
        ((SF2Layer)object).getRegions().add(sF2LayerRegion);
        return object;
    }

    public static SF2Layer new_closed_hihat(SF2Soundbank sF2Soundbank) {
        int n;
        int n2 = 16384;
        Object object = new double[2 * n2];
        Object object2 = new Random(3049912L);
        for (n = 0; n < ((double[])object).length; n += 2) {
            object[n] = 2.0 * (((Random)object2).nextDouble() - 0.5) * 0.1;
        }
        EmergencySoundbank.fft((double[])object);
        for (n = n2 / 2; n < ((double[])object).length; ++n) {
            object[n] = 0.0;
        }
        for (n = 4096; n < 8192; ++n) {
            object[n] = 1.0 - (double)(n - 4096) / 4096.0;
        }
        for (n = 0; n < 2048; ++n) {
            object[n] = 0.2 + 0.8 * ((double)n / 2048.0);
        }
        EmergencySoundbank.randomPhase((double[])object, new Random(3049912L));
        EmergencySoundbank.ifft((double[])object);
        EmergencySoundbank.normalize((double[])object, 0.9);
        object = EmergencySoundbank.realPart((double[])object);
        double d = 1.0;
        int n3 = 0;
        while (n3 < ((double[])object).length) {
            int n4 = n3++;
            object[n4] = object[n4] * d;
            d *= 0.9996;
        }
        double[] dArray = object;
        for (n2 = 0; n2 < 5; ++n2) {
            int n5 = n2;
            dArray[n5] = dArray[n5] * ((double)n2 / 5.0);
        }
        SF2Sample sF2Sample = EmergencySoundbank.newSimpleDrumSample(sF2Soundbank, "Closed Hi-Hat", dArray);
        object = new SF2Layer(sF2Soundbank);
        ((SF2Layer)object).setName("Closed Hi-Hat");
        object2 = new SF2GlobalRegion();
        ((SF2Layer)object).setGlobalZone((SF2GlobalRegion)object2);
        sF2Soundbank.addResource((SoundbankResource)object);
        SF2LayerRegion sF2LayerRegion = new SF2LayerRegion();
        sF2LayerRegion.putInteger(38, 12000);
        sF2LayerRegion.putInteger(56, 0);
        sF2LayerRegion.putInteger(57, 1);
        sF2LayerRegion.setSample(sF2Sample);
        ((SF2Layer)object).getRegions().add(sF2LayerRegion);
        return object;
    }

    public static SF2Layer new_open_hihat(SF2Soundbank sF2Soundbank) {
        int n;
        int n2 = 16384;
        Object object = new double[2 * n2];
        Object object2 = new Random(3049912L);
        for (n = 0; n < ((double[])object).length; n += 2) {
            object[n] = 2.0 * (((Random)object2).nextDouble() - 0.5);
        }
        for (n = n2 / 2; n < ((double[])object).length; ++n) {
            object[n] = 0.0;
        }
        for (n = 0; n < 200; ++n) {
            object[n] = 0.0;
        }
        for (n = 0; n < 8192; ++n) {
            double d;
            object[n] = d = (double)n / 8192.0;
        }
        double[] dArray = object;
        SF2Sample sF2Sample = EmergencySoundbank.newSimpleFFTSample(sF2Soundbank, "Open Hi-Hat", dArray, 1000.0, 5);
        object = new SF2Layer(sF2Soundbank);
        ((SF2Layer)object).setName("Open Hi-Hat");
        object2 = new SF2GlobalRegion();
        ((SF2Layer)object).setGlobalZone((SF2GlobalRegion)object2);
        sF2Soundbank.addResource((SoundbankResource)object);
        SF2LayerRegion sF2LayerRegion = new SF2LayerRegion();
        sF2LayerRegion.putInteger(36, 1500);
        sF2LayerRegion.putInteger(54, 1);
        sF2LayerRegion.putInteger(38, 1500);
        sF2LayerRegion.putInteger(37, 1000);
        sF2LayerRegion.putInteger(56, 0);
        sF2LayerRegion.putInteger(57, 1);
        sF2LayerRegion.setSample(sF2Sample);
        ((SF2Layer)object).getRegions().add(sF2LayerRegion);
        return object;
    }

    public static SF2Layer new_crash_cymbal(SF2Soundbank sF2Soundbank) {
        int n;
        int n2 = 16384;
        Object object = new double[2 * n2];
        Object object2 = new Random(3049912L);
        for (n = 0; n < ((double[])object).length; n += 2) {
            object[n] = 2.0 * (((Random)object2).nextDouble() - 0.5);
        }
        for (n = n2 / 2; n < ((double[])object).length; ++n) {
            object[n] = 0.0;
        }
        for (n = 0; n < 100; ++n) {
            object[n] = 0.0;
        }
        for (n = 0; n < 1024; ++n) {
            double d;
            object[n] = d = (double)n / 1024.0;
        }
        double[] dArray = object;
        SF2Sample sF2Sample = EmergencySoundbank.newSimpleFFTSample(sF2Soundbank, "Crash Cymbal", dArray, 1000.0, 5);
        object = new SF2Layer(sF2Soundbank);
        ((SF2Layer)object).setName("Crash Cymbal");
        object2 = new SF2GlobalRegion();
        ((SF2Layer)object).setGlobalZone((SF2GlobalRegion)object2);
        sF2Soundbank.addResource((SoundbankResource)object);
        SF2LayerRegion sF2LayerRegion = new SF2LayerRegion();
        sF2LayerRegion.putInteger(36, 1800);
        sF2LayerRegion.putInteger(54, 1);
        sF2LayerRegion.putInteger(38, 1800);
        sF2LayerRegion.putInteger(37, 1000);
        sF2LayerRegion.putInteger(56, 0);
        sF2LayerRegion.setSample(sF2Sample);
        ((SF2Layer)object).getRegions().add(sF2LayerRegion);
        return object;
    }

    public static SF2Layer new_side_stick(SF2Soundbank sF2Soundbank) {
        int n;
        int n2 = 16384;
        Object object = new double[2 * n2];
        Object object2 = new Random(3049912L);
        for (n = 0; n < ((double[])object).length; n += 2) {
            object[n] = 2.0 * (((Random)object2).nextDouble() - 0.5) * 0.1;
        }
        EmergencySoundbank.fft((double[])object);
        for (n = n2 / 2; n < ((double[])object).length; ++n) {
            object[n] = 0.0;
        }
        for (n = 4096; n < 8192; ++n) {
            object[n] = 1.0 - (double)(n - 4096) / 4096.0;
        }
        n = 0;
        while (n < 200) {
            double d = 1.0 - (double)n / 200.0;
            int n3 = n++;
            object[n3] = object[n3] * (1.0 + 20.0 * d * d);
        }
        for (n = 0; n < 30; ++n) {
            object[n] = 0.0;
        }
        EmergencySoundbank.randomPhase((double[])object, new Random(3049912L));
        EmergencySoundbank.ifft((double[])object);
        EmergencySoundbank.normalize((double[])object, 0.9);
        object = EmergencySoundbank.realPart((double[])object);
        double d = 1.0;
        int n4 = 0;
        while (n4 < ((double[])object).length) {
            int n5 = n4++;
            object[n5] = object[n5] * d;
            d *= 0.9996;
        }
        double[] dArray = object;
        for (n2 = 0; n2 < 10; ++n2) {
            int n6 = n2;
            dArray[n6] = dArray[n6] * ((double)n2 / 10.0);
        }
        SF2Sample sF2Sample = EmergencySoundbank.newSimpleDrumSample(sF2Soundbank, "Side Stick", dArray);
        object = new SF2Layer(sF2Soundbank);
        ((SF2Layer)object).setName("Side Stick");
        object2 = new SF2GlobalRegion();
        ((SF2Layer)object).setGlobalZone((SF2GlobalRegion)object2);
        sF2Soundbank.addResource((SoundbankResource)object);
        SF2LayerRegion sF2LayerRegion = new SF2LayerRegion();
        sF2LayerRegion.putInteger(38, 12000);
        sF2LayerRegion.putInteger(56, 0);
        sF2LayerRegion.putInteger(48, -50);
        sF2LayerRegion.setSample(sF2Sample);
        ((SF2Layer)object).getRegions().add(sF2LayerRegion);
        return object;
    }

    public static SF2Sample newSimpleFFTSample(SF2Soundbank sF2Soundbank, String string, double[] dArray, double d) {
        return EmergencySoundbank.newSimpleFFTSample(sF2Soundbank, string, dArray, d, 10);
    }

    public static SF2Sample newSimpleFFTSample(SF2Soundbank sF2Soundbank, String string, double[] dArray, double d, int n) {
        int n2 = dArray.length / 2;
        AudioFormat audioFormat = new AudioFormat(44100.0f, 16, 1, true, false);
        double d2 = d / (double)n2 * (double)audioFormat.getSampleRate() * 0.5;
        EmergencySoundbank.randomPhase(dArray);
        EmergencySoundbank.ifft(dArray);
        dArray = EmergencySoundbank.realPart(dArray);
        EmergencySoundbank.normalize(dArray, 0.9);
        float[] fArray = EmergencySoundbank.toFloat(dArray);
        fArray = EmergencySoundbank.loopExtend(fArray, fArray.length + 512);
        EmergencySoundbank.fadeUp(fArray, n);
        byte[] byArray = EmergencySoundbank.toBytes(fArray, audioFormat);
        SF2Sample sF2Sample = new SF2Sample(sF2Soundbank);
        sF2Sample.setName(string);
        sF2Sample.setData(byArray);
        sF2Sample.setStartLoop(256L);
        sF2Sample.setEndLoop(n2 + 256);
        sF2Sample.setSampleRate((long)audioFormat.getSampleRate());
        double d3 = 81.0 + 12.0 * Math.log(d2 / 440.0) / Math.log(2.0);
        sF2Sample.setOriginalPitch((int)d3);
        sF2Sample.setPitchCorrection((byte)(-(d3 - (double)((int)d3)) * 100.0));
        sF2Soundbank.addResource(sF2Sample);
        return sF2Sample;
    }

    public static SF2Sample newSimpleFFTSample_dist(SF2Soundbank sF2Soundbank, String string, double[] dArray, double d, double d2) {
        int n = dArray.length / 2;
        AudioFormat audioFormat = new AudioFormat(44100.0f, 16, 1, true, false);
        double d3 = d / (double)n * (double)audioFormat.getSampleRate() * 0.5;
        EmergencySoundbank.randomPhase(dArray);
        EmergencySoundbank.ifft(dArray);
        dArray = EmergencySoundbank.realPart(dArray);
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = (1.0 - Math.exp(-Math.abs(dArray[i] * d2))) * Math.signum(dArray[i]);
        }
        EmergencySoundbank.normalize(dArray, 0.9);
        float[] fArray = EmergencySoundbank.toFloat(dArray);
        fArray = EmergencySoundbank.loopExtend(fArray, fArray.length + 512);
        EmergencySoundbank.fadeUp(fArray, 80);
        byte[] byArray = EmergencySoundbank.toBytes(fArray, audioFormat);
        SF2Sample sF2Sample = new SF2Sample(sF2Soundbank);
        sF2Sample.setName(string);
        sF2Sample.setData(byArray);
        sF2Sample.setStartLoop(256L);
        sF2Sample.setEndLoop(n + 256);
        sF2Sample.setSampleRate((long)audioFormat.getSampleRate());
        double d4 = 81.0 + 12.0 * Math.log(d3 / 440.0) / Math.log(2.0);
        sF2Sample.setOriginalPitch((int)d4);
        sF2Sample.setPitchCorrection((byte)(-(d4 - (double)((int)d4)) * 100.0));
        sF2Soundbank.addResource(sF2Sample);
        return sF2Sample;
    }

    public static SF2Sample newSimpleDrumSample(SF2Soundbank sF2Soundbank, String string, double[] dArray) {
        int n = dArray.length;
        AudioFormat audioFormat = new AudioFormat(44100.0f, 16, 1, true, false);
        byte[] byArray = EmergencySoundbank.toBytes(EmergencySoundbank.toFloat(EmergencySoundbank.realPart(dArray)), audioFormat);
        SF2Sample sF2Sample = new SF2Sample(sF2Soundbank);
        sF2Sample.setName(string);
        sF2Sample.setData(byArray);
        sF2Sample.setStartLoop(256L);
        sF2Sample.setEndLoop(n + 256);
        sF2Sample.setSampleRate((long)audioFormat.getSampleRate());
        sF2Sample.setOriginalPitch(60);
        sF2Soundbank.addResource(sF2Sample);
        return sF2Sample;
    }

    public static SF2Layer newLayer(SF2Soundbank sF2Soundbank, String string, SF2Sample sF2Sample) {
        SF2LayerRegion sF2LayerRegion = new SF2LayerRegion();
        sF2LayerRegion.setSample(sF2Sample);
        SF2Layer sF2Layer = new SF2Layer(sF2Soundbank);
        sF2Layer.setName(string);
        sF2Layer.getRegions().add(sF2LayerRegion);
        sF2Soundbank.addResource(sF2Layer);
        return sF2Layer;
    }

    public static SF2Instrument newInstrument(SF2Soundbank sF2Soundbank, String string, Patch patch, SF2Layer ... sF2LayerArray) {
        SF2Instrument sF2Instrument = new SF2Instrument(sF2Soundbank);
        sF2Instrument.setPatch(patch);
        sF2Instrument.setName(string);
        sF2Soundbank.addInstrument(sF2Instrument);
        for (int i = 0; i < sF2LayerArray.length; ++i) {
            SF2InstrumentRegion sF2InstrumentRegion = new SF2InstrumentRegion();
            sF2InstrumentRegion.setLayer(sF2LayerArray[i]);
            sF2Instrument.getRegions().add(sF2InstrumentRegion);
        }
        return sF2Instrument;
    }

    public static void ifft(double[] dArray) {
        new FFT(dArray.length / 2, 1).transform(dArray);
    }

    public static void fft(double[] dArray) {
        new FFT(dArray.length / 2, -1).transform(dArray);
    }

    public static void complexGaussianDist(double[] dArray, double d, double d2, double d3) {
        for (int i = 0; i < dArray.length / 4; ++i) {
            int n = i * 2;
            dArray[n] = dArray[n] + d3 * (1.0 / (d2 * Math.sqrt(Math.PI * 2)) * Math.exp(-0.5 * Math.pow(((double)i - d) / d2, 2.0)));
        }
    }

    public static void randomPhase(double[] dArray) {
        for (int i = 0; i < dArray.length; i += 2) {
            double d = Math.random() * 2.0 * Math.PI;
            double d2 = dArray[i];
            dArray[i] = Math.sin(d) * d2;
            dArray[i + 1] = Math.cos(d) * d2;
        }
    }

    public static void randomPhase(double[] dArray, Random random) {
        for (int i = 0; i < dArray.length; i += 2) {
            double d = random.nextDouble() * 2.0 * Math.PI;
            double d2 = dArray[i];
            dArray[i] = Math.sin(d) * d2;
            dArray[i + 1] = Math.cos(d) * d2;
        }
    }

    public static void normalize(double[] dArray, double d) {
        double d2 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            if (dArray[i] > d2) {
                d2 = dArray[i];
            }
            if (!(-dArray[i] > d2)) continue;
            d2 = -dArray[i];
        }
        if (d2 == 0.0) {
            return;
        }
        double d3 = d / d2;
        int n = 0;
        while (n < dArray.length) {
            int n2 = n++;
            dArray[n2] = dArray[n2] * d3;
        }
    }

    public static void normalize(float[] fArray, double d) {
        double d2 = 0.5;
        for (int i = 0; i < fArray.length; ++i) {
            if ((double)fArray[i * 2] > d2) {
                d2 = fArray[i * 2];
            }
            if (!((double)(-fArray[i * 2]) > d2)) continue;
            d2 = -fArray[i * 2];
        }
        double d3 = d / d2;
        for (int i = 0; i < fArray.length; ++i) {
            int n = i * 2;
            fArray[n] = (float)((double)fArray[n] * d3);
        }
    }

    public static double[] realPart(double[] dArray) {
        double[] dArray2 = new double[dArray.length / 2];
        for (int i = 0; i < dArray2.length; ++i) {
            dArray2[i] = dArray[i * 2];
        }
        return dArray2;
    }

    public static double[] imgPart(double[] dArray) {
        double[] dArray2 = new double[dArray.length / 2];
        for (int i = 0; i < dArray2.length; ++i) {
            dArray2[i] = dArray[i * 2];
        }
        return dArray2;
    }

    public static float[] toFloat(double[] dArray) {
        float[] fArray = new float[dArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = (float)dArray[i];
        }
        return fArray;
    }

    public static byte[] toBytes(float[] fArray, AudioFormat audioFormat) {
        byte[] byArray = new byte[fArray.length * audioFormat.getFrameSize()];
        return AudioFloatConverter.getConverter(audioFormat).toByteArray(fArray, byArray);
    }

    public static void fadeUp(double[] dArray, int n) {
        double d = n;
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            dArray[n2] = dArray[n2] * ((double)i / d);
        }
    }

    public static void fadeUp(float[] fArray, int n) {
        double d = n;
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            fArray[n2] = (float)((double)fArray[n2] * ((double)i / d));
        }
    }

    public static double[] loopExtend(double[] dArray, int n) {
        double[] dArray2 = new double[n];
        int n2 = dArray.length;
        int n3 = 0;
        for (int i = 0; i < dArray2.length; ++i) {
            dArray2[i] = dArray[n3];
            if (++n3 != n2) continue;
            n3 = 0;
        }
        return dArray2;
    }

    public static float[] loopExtend(float[] fArray, int n) {
        float[] fArray2 = new float[n];
        int n2 = fArray.length;
        int n3 = 0;
        for (int i = 0; i < fArray2.length; ++i) {
            fArray2[i] = fArray[n3];
            if (++n3 != n2) continue;
            n3 = 0;
        }
        return fArray2;
    }
}

