/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.validation.api.builtin;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.validation.api.Problem;
import org.netbeans.validation.api.Problems;
import org.netbeans.validation.api.Severity;
import org.netbeans.validation.api.Validator;
import org.netbeans.validation.api.builtin.EncodableInCharsetValidator;
import org.netbeans.validation.api.builtin.MayNotContainSpacesValidator;
import org.netbeans.validation.api.builtin.ValidHostNameOrIPValidator;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EmailAddressValidator
implements Validator<String> {
    private final ValidHostNameOrIPValidator hv = new ValidHostNameOrIPValidator(false);
    static final Pattern ADDRESS_PATTERN = Pattern.compile("(.*?)<(.*)>$");

    EmailAddressValidator() {
    }

    @Override
    public boolean validate(Problems problems, String compName, String model) {
        String address;
        Matcher m = ADDRESS_PATTERN.matcher(model);
        String realName = null;
        if (m.lookingAt()) {
            if (m.groupCount() == 2) {
                address = m.group(2);
                realName = m.group(1);
            } else {
                address = m.group(1);
            }
        } else {
            address = model;
        }
        return this.validate(realName, address, problems, compName);
    }

    private boolean validate(String realName, String address, Problems problems, String compName) {
        boolean result;
        String[] nameAndHost = address.split("@");
        if (nameAndHost.length == 1 && nameAndHost[0].contains("@")) {
            problems.add(NbBundle.getMessage(EmailAddressValidator.class, (String)"EMAIL_MISSING_HOST", (Object)compName, (Object)nameAndHost[0]));
            return false;
        }
        if (nameAndHost.length > 2) {
            problems.add(NbBundle.getMessage(EmailAddressValidator.class, (String)"EMAIL_HAS_>1_@", (Object)compName, (Object)address));
            return false;
        }
        String name = nameAndHost[0];
        if (name.length() == 0) {
            problems.add(NbBundle.getMessage(EmailAddressValidator.class, (String)"EMAIL_MISSING_NAME", (Object)compName, (Object)name));
            return false;
        }
        if (name.length() > 64) {
            problems.add(new Problem(NbBundle.getMessage(EmailAddressValidator.class, (String)"ADDRESS_MAY_BE_TOO_LONG", (Object)compName, (Object)name), Severity.WARNING));
        }
        String host = nameAndHost.length >= 2 ? nameAndHost[1] : null;
        boolean bl = result = host != null;
        if (result) {
            Validator<String> v;
            result = this.hv.validate(problems, compName, host);
            if (result) {
                v = new MayNotContainSpacesValidator();
                result = ((MayNotContainSpacesValidator)v).validate(problems, compName, name);
            }
            v = new EncodableInCharsetValidator("US-ASCII");
            if (result) {
                result = v.validate(problems, compName, address);
            }
        } else {
            problems.add(NbBundle.getMessage(EmailAddressValidator.class, (String)"EMAIL_MISSING_HOST", (Object)compName, (Object)nameAndHost[0]));
        }
        return result;
    }

    private boolean validate(String realName, String name, String host, Problems problems, String compName) {
        return false;
    }
}

