/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.exporter.plugin;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.text.JTextComponent;
import org.gephi.io.exporter.plugin.ExporterGML;
import org.gephi.lib.validation.ValidationClient;
import org.netbeans.validation.api.Validator;
import org.netbeans.validation.api.builtin.Validators;
import org.netbeans.validation.api.ui.ValidationGroup;
import org.netbeans.validation.api.ui.ValidationPanel;
import org.openide.util.NbBundle;

public class UIExporterGMLPanel
extends JPanel
implements ValidationClient {
    private JCheckBox exportColorsCheckBox;
    private JCheckBox exportEdgeWeightCheckBox;
    private JLabel exportLabel;
    private JCheckBox exportLabelCheckBox;
    private JCheckBox exportNotRecognizedCheckBox;
    private JCheckBox exportPositionCheckBox;
    private JCheckBox exportSizeCheckBox;
    private JCheckBox normalizeCheckBox;
    private JLabel normalizeLabel;
    private JLabel spacesLabel;
    private JTextField spacesTextField;

    public UIExporterGMLPanel() {
        this.initComponents();
    }

    void setup(ExporterGML exporter) {
        this.exportColorsCheckBox.setSelected(exporter.isExportColor());
        this.exportEdgeWeightCheckBox.setSelected(exporter.isExportEdgeSize());
        this.exportNotRecognizedCheckBox.setSelected(exporter.isExportNotRecognizedElements());
        this.exportPositionCheckBox.setSelected(exporter.isExportCoordinates());
        this.exportSizeCheckBox.setSelected(exporter.isExportNodeSize());
        this.normalizeCheckBox.setSelected(exporter.isNormalize());
        this.exportLabelCheckBox.setSelected(exporter.isExportLabel());
        this.spacesTextField.setText(Integer.toString(exporter.getSpaces()));
    }

    void unsetup(ExporterGML exporter) {
        exporter.setExportColor(this.exportColorsCheckBox.isSelected());
        exporter.setExportCoordinates(this.exportPositionCheckBox.isSelected());
        exporter.setExportEdgeSize(this.exportEdgeWeightCheckBox.isSelected());
        exporter.setExportLabel(this.exportLabelCheckBox.isSelected());
        exporter.setExportNodeSize(this.exportSizeCheckBox.isSelected());
        exporter.setExportNotRecognizedElements(this.exportNotRecognizedCheckBox.isSelected());
        exporter.setNormalize(this.normalizeCheckBox.isSelected());
        exporter.setSpaces(Integer.parseInt(this.spacesTextField.getText()));
    }

    private void initComponents() {
        this.exportLabel = new JLabel();
        this.exportPositionCheckBox = new JCheckBox();
        this.exportColorsCheckBox = new JCheckBox();
        this.exportSizeCheckBox = new JCheckBox();
        this.exportEdgeWeightCheckBox = new JCheckBox();
        this.exportNotRecognizedCheckBox = new JCheckBox();
        this.normalizeCheckBox = new JCheckBox();
        this.normalizeLabel = new JLabel();
        this.exportLabelCheckBox = new JCheckBox();
        this.spacesLabel = new JLabel();
        this.spacesTextField = new JTextField();
        this.exportLabel.setText(NbBundle.getMessage(UIExporterGMLPanel.class, (String)"UIExporterGML.exportLabel.text"));
        this.exportPositionCheckBox.setText(NbBundle.getMessage(UIExporterGMLPanel.class, (String)"UIExporterGML.positionLabel.text"));
        this.exportColorsCheckBox.setText(NbBundle.getMessage(UIExporterGMLPanel.class, (String)"UIExporterGML.colorsLabel.text"));
        this.exportSizeCheckBox.setText(NbBundle.getMessage(UIExporterGMLPanel.class, (String)"UIExporterGML.sizeLabel.text"));
        this.exportEdgeWeightCheckBox.setText(NbBundle.getMessage(UIExporterGMLPanel.class, (String)"UIExporterGML.edgeWeightLabel.text"));
        this.exportNotRecognizedCheckBox.setText(NbBundle.getMessage(UIExporterGMLPanel.class, (String)"UIExporterGML.attributes.text"));
        this.exportNotRecognizedCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UIExporterGMLPanel.this.exportNotRecognizedCheckBoxActionPerformed(evt);
            }
        });
        this.normalizeCheckBox.setText(NbBundle.getMessage(UIExporterGMLPanel.class, (String)"UIExporterGML.normalize.text"));
        this.normalizeCheckBox.setLabel(NbBundle.getMessage(UIExporterGMLPanel.class, (String)"UIExporterGML.normalize.text"));
        this.normalizeLabel.setFont(new Font("Ubuntu", 0, 10));
        this.normalizeLabel.setText(NbBundle.getMessage(UIExporterGMLPanel.class, (String)"UIExporterGML.normalizeHintLabel.text"));
        this.exportLabelCheckBox.setText(NbBundle.getMessage(UIExporterGMLPanel.class, (String)"UIExporterGML.labelLabel.text"));
        this.spacesLabel.setText(NbBundle.getMessage(UIExporterGMLPanel.class, (String)"UIExporterGML.indentationLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.exportLabel).addComponent(this.normalizeCheckBox).addComponent(this.spacesLabel)).addGap(23, 23, 23).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.normalizeLabel).addComponent(this.exportEdgeWeightCheckBox).addComponent(this.exportSizeCheckBox).addComponent(this.exportColorsCheckBox).addComponent(this.exportPositionCheckBox).addComponent(this.exportLabelCheckBox).addComponent(this.exportNotRecognizedCheckBox).addComponent(this.spacesTextField, -2, 60, -2)).addContainerGap(90, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.exportLabel, -2, 18, -2).addComponent(this.exportPositionCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.exportColorsCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.exportSizeCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.exportEdgeWeightCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.exportLabelCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.exportNotRecognizedCheckBox).addGap(3, 3, 3).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.normalizeCheckBox).addComponent(this.normalizeLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.spacesLabel).addComponent(this.spacesTextField, -2, -1, -2)).addGap(21, 21, 21)));
        this.exportNotRecognizedCheckBox.getAccessibleContext().setAccessibleName("\n");
        this.exportNotRecognizedCheckBox.getAccessibleContext().setAccessibleDescription("");
        this.spacesTextField.getAccessibleContext().setAccessibleName("Indentation");
    }

    private void exportNotRecognizedCheckBoxActionPerformed(ActionEvent evt) {
    }

    public void validate(ValidationGroup group) {
        group.add((JTextComponent)this.spacesTextField, new Validator[]{Validators.REQUIRE_NON_EMPTY_STRING, Validators.REQUIRE_NON_NEGATIVE_NUMBER, Validators.REQUIRE_VALID_INTEGER});
    }

    public static ValidationPanel createValidationPanel(UIExporterGMLPanel innerPanel) {
        ValidationPanel validationPanel = new ValidationPanel();
        validationPanel.setInnerComponent((Component)innerPanel);
        ValidationGroup group = validationPanel.getValidationGroup();
        innerPanel.validate(group);
        return validationPanel;
    }
}

