/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classloader;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import org.gradle.internal.Cast;
import org.gradle.internal.Factory;
import org.gradle.internal.classloader.ClassLoaderHierarchy;
import org.gradle.internal.classloader.ClassLoaderSpec;
import org.gradle.internal.classloader.ClassLoaderVisitor;
import org.gradle.internal.classpath.ClassPath;

public class VisitableURLClassLoader
extends URLClassLoader
implements ClassLoaderHierarchy {
    private final EnumMap<UserData, Object> userData = new EnumMap(UserData.class);
    private final String name;

    public synchronized <T> T getUserData(UserData user, Factory<T> onMiss) {
        if (this.userData.containsKey((Object)user)) {
            return Cast.uncheckedCast(this.userData.get((Object)user));
        }
        T value = onMiss.create();
        this.userData.put(user, value);
        return value;
    }

    public VisitableURLClassLoader(String name, ClassLoader parent, Collection<URL> urls) {
        this(name, urls.toArray(new URL[0]), parent);
    }

    public VisitableURLClassLoader(String name, ClassLoader parent, ClassPath classPath) {
        this(name, classPath.getAsURLArray(), parent);
    }

    private VisitableURLClassLoader(String name, URL[] classpath, ClassLoader parent) {
        super(classpath, parent);
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
    }

    public String toString() {
        return VisitableURLClassLoader.class.getSimpleName() + "(" + this.name + ")";
    }

    @Override
    public void visit(ClassLoaderVisitor visitor) {
        URL[] urls = this.getURLs();
        visitor.visitSpec(new Spec(this.name, Arrays.asList(urls)));
        visitor.visitClassPath(urls);
        visitor.visitParent(this.getParent());
    }

    static {
        try {
            ClassLoader.registerAsParallelCapable();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    public static class Spec
    extends ClassLoaderSpec {
        final String name;
        final List<URL> classpath;

        public String getName() {
            return this.name;
        }

        public Spec(String name, List<URL> classpath) {
            this.name = name;
            this.classpath = classpath;
        }

        public List<URL> getClasspath() {
            return this.classpath;
        }

        public String toString() {
            return "{url-class-loader name:" + this.name + ", classpath:" + this.classpath + "}";
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Spec other = (Spec)obj;
            return this.classpath.equals(other.classpath);
        }

        public int hashCode() {
            return this.classpath.hashCode();
        }
    }

    public static enum UserData {
        NAMED_OBJECT_INSTANTIATOR;

    }
}

