/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.components;

import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.CollectionLiteralKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.SimpleKotlinCallArgument;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.multiplatform.ExpectedActualResolver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValueWithSmartCastInfo;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.checker.IntersectionTypeKt;
import org.jetbrains.kotlin.utils.DFS;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000@\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u001a \u0010\u0013\u001a\u00020\u0001*\u00020\u00022\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00010\u0015H\u0002\u001a\u001c\u0010\u0016\u001a\u00020\t*\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\u001a\n\u0010\u001a\u001a\u00020\u0001*\u00020\u0002\u001a\u001c\u0010\u001b\u001a\u00020\u0001*\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u001a\f\u0010\u001c\u001a\u00020\u0001*\u00020\u0012H\u0002\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\"\u0015\u0010\u0004\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0003\"\u0015\u0010\u0005\u001a\u00020\u0001*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007\"\u0015\u0010\u0005\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0003\"\u0018\u0010\b\u001a\u00020\t*\u00020\n8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\"\u001a\u0010\r\u001a\u0004\u0018\u00010\t*\u00020\n8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u001d"}, d2={"isActualParameterWithAnyExpectedDefault", "", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;)Z", "isActualParameterWithCorrespondingExpectedDefault", "isVararg", "Lorg/jetbrains/kotlin/descriptors/ParameterDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/ParameterDescriptor;)Z", "stableType", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValueWithSmartCastInfo;", "getStableType", "(Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValueWithSmartCastInfo;)Lorg/jetbrains/kotlin/types/UnwrappedType;", "unstableType", "getUnstableType", "unexpectedArgument", "", "argument", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallArgument;", "checkExpectedParameter", "checker", "Lkotlin/Function1;", "getExpectedType", "parameter", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "hasDefaultValue", "isArrayAssignedAsNamedArgumentInAnnotation", "isArrayOrArrayLiteral", "resolution"})
public final class ArgumentsUtilsKt {
    @NotNull
    public static final Void unexpectedArgument(@NotNull KotlinCallArgument argument) {
        Intrinsics.checkParameterIsNotNull((Object)argument, (String)"argument");
        String string = "Unexpected argument type: " + argument + ", " + argument.getClass().getCanonicalName() + '.';
        throw (Throwable)new IllegalStateException(string.toString());
    }

    @Nullable
    public static final UnwrappedType getUnstableType(@NotNull ReceiverValueWithSmartCastInfo $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        if ($receiver.isStable() || $receiver.getPossibleTypes().isEmpty()) {
            return null;
        }
        Set<KotlinType> set = $receiver.getPossibleTypes();
        KotlinType kotlinType = $receiver.getReceiverValue().getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"receiverValue.type");
        return IntersectionTypeKt.intersectWrappedTypes(SetsKt.plus(set, (Object)kotlinType));
    }

    @NotNull
    public static final UnwrappedType getStableType(@NotNull ReceiverValueWithSmartCastInfo $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        if (!$receiver.isStable() || $receiver.getPossibleTypes().isEmpty()) {
            return $receiver.getReceiverValue().getType().unwrap();
        }
        Set<KotlinType> set = $receiver.getPossibleTypes();
        KotlinType kotlinType = $receiver.getReceiverValue().getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"receiverValue.type");
        return IntersectionTypeKt.intersectWrappedTypes(SetsKt.plus(set, (Object)kotlinType));
    }

    @NotNull
    public static final UnwrappedType getExpectedType(@NotNull KotlinCallArgument $receiver, @NotNull ParameterDescriptor parameter, @NotNull LanguageVersionSettings languageVersionSettings) {
        Annotated annotated;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)parameter, (String)"parameter");
        Intrinsics.checkParameterIsNotNull((Object)languageVersionSettings, (String)"languageVersionSettings");
        if ($receiver.isSpread() || ArgumentsUtilsKt.isArrayAssignedAsNamedArgumentInAnnotation($receiver, parameter, languageVersionSettings)) {
            annotated = parameter.getType().unwrap();
        } else {
            ParameterDescriptor $receiver$iv = parameter;
            ParameterDescriptor parameterDescriptor = $receiver$iv;
            if (!(parameterDescriptor instanceof ValueParameterDescriptor)) {
                parameterDescriptor = null;
            }
            if ((annotated = (ValueParameterDescriptor)parameterDescriptor) == null || (annotated = annotated.getVarargElementType()) == null || (annotated = ((KotlinType)annotated).unwrap()) == null) {
                annotated = parameter.getType().unwrap();
            }
        }
        return annotated;
    }

    public static final boolean isVararg(@NotNull ValueParameterDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return $receiver.getVarargElementType() != null;
    }

    public static final boolean isVararg(@NotNull ParameterDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        ParameterDescriptor $receiver$iv = $receiver;
        ParameterDescriptor parameterDescriptor = $receiver$iv;
        if (!(parameterDescriptor instanceof ValueParameterDescriptor)) {
            parameterDescriptor = null;
        }
        ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)parameterDescriptor;
        return valueParameterDescriptor != null ? ArgumentsUtilsKt.isVararg(valueParameterDescriptor) : false;
    }

    public static final boolean hasDefaultValue(@NotNull ValueParameterDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Boolean bl = DFS.ifAny(CollectionsKt.listOf((Object)$receiver), hasDefaultValue.1.INSTANCE, hasDefaultValue.2.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"DFS.ifAny(\n        listO\u2026ngExpectedDefault }\n    )");
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean checkExpectedParameter(@NotNull ValueParameterDescriptor $receiver, Function1<? super ValueParameterDescriptor, Boolean> checker) {
        CallableDescriptor function2 = $receiver.getContainingDeclaration();
        if (!(function2 instanceof FunctionDescriptor)) return false;
        if (!((FunctionDescriptor)function2).isActual()) return false;
        ExpectedActualResolver expectedActualResolver = ExpectedActualResolver.INSTANCE;
        ExpectedActualResolver $receiver2 = expectedActualResolver;
        MemberDescriptor expected = (MemberDescriptor)CollectionsKt.firstOrNull($receiver2.findCompatibleExpectedForActual((MemberDescriptor)((Object)function2), DescriptorUtilsKt.getModule(function2)));
        if (!(expected instanceof FunctionDescriptor)) return false;
        ValueParameterDescriptor valueParameterDescriptor = ((FunctionDescriptor)expected).getValueParameters().get($receiver.getIndex());
        Intrinsics.checkExpressionValueIsNotNull((Object)valueParameterDescriptor, (String)"expected.valueParameters[index]");
        if ((Boolean)checker.invoke((Object)valueParameterDescriptor) == false) return false;
        return true;
    }

    public static final boolean isActualParameterWithAnyExpectedDefault(@NotNull ValueParameterDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return ArgumentsUtilsKt.checkExpectedParameter($receiver, (Function1<? super ValueParameterDescriptor, Boolean>)((Function1)isActualParameterWithAnyExpectedDefault.1.INSTANCE));
    }

    public static final boolean isActualParameterWithCorrespondingExpectedDefault(@NotNull ValueParameterDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return ArgumentsUtilsKt.checkExpectedParameter($receiver, (Function1<? super ValueParameterDescriptor, Boolean>)((Function1)isActualParameterWithCorrespondingExpectedDefault.1.INSTANCE));
    }

    private static final boolean isArrayAssignedAsNamedArgumentInAnnotation(@NotNull KotlinCallArgument $receiver, ParameterDescriptor parameter, LanguageVersionSettings languageVersionSettings) {
        if (!languageVersionSettings.supportsFeature(LanguageFeature.AssigningArraysToVarargsInNamedFormInAnnotations)) {
            return false;
        }
        if ($receiver.getArgumentName() == null || !ArgumentsUtilsKt.isVararg(parameter)) {
            return false;
        }
        return DescriptorUtilsKt.isParameterOfAnnotation(parameter) && ArgumentsUtilsKt.isArrayOrArrayLiteral($receiver);
    }

    private static final boolean isArrayOrArrayLiteral(@NotNull KotlinCallArgument $receiver) {
        if ($receiver instanceof CollectionLiteralKotlinCallArgument) {
            return true;
        }
        if (!($receiver instanceof SimpleKotlinCallArgument)) {
            return false;
        }
        KotlinType kotlinType = ((SimpleKotlinCallArgument)$receiver).getReceiver().getReceiverValue().getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"this.receiver.receiverValue.type");
        KotlinType type2 = kotlinType;
        return KotlinBuiltIns.isArrayOrPrimitiveArray(type2);
    }
}

