/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.ide.visualstudio.internal;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.Named;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.collections.ImmutableFileCollection;
import org.gradle.ide.visualstudio.internal.VisualStudioTargetBinary;
import org.gradle.language.cpp.CppBinary;
import org.gradle.language.cpp.CppComponent;
import org.gradle.language.cpp.CppPlatform;
import org.gradle.language.cpp.internal.DefaultCppBinary;
import org.gradle.language.cpp.tasks.CppCompile;
import org.gradle.language.nativeplatform.internal.Dimensions;
import org.gradle.nativeplatform.platform.NativePlatform;
import org.gradle.nativeplatform.toolchain.internal.MacroArgsConverter;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;
import org.gradle.nativeplatform.toolchain.internal.SystemLibraries;
import org.gradle.nativeplatform.toolchain.internal.ToolType;
import org.gradle.nativeplatform.toolchain.internal.metadata.CompilerMetadata;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.WindowsSdkLibraries;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.metadata.VisualCppMetadata;
import org.gradle.util.VersionNumber;

public abstract class AbstractCppBinaryVisualStudioTargetBinary
implements VisualStudioTargetBinary {
    protected final String projectName;
    private final String projectPath;
    private final CppComponent component;
    private final VersionNumber visualStudioVersion;
    private final VersionNumber windowsSdkVersion;

    protected AbstractCppBinaryVisualStudioTargetBinary(String projectName, String projectPath, CppComponent component, CppBinary binary) {
        this.projectName = projectName;
        this.projectPath = projectPath;
        this.component = component;
        PlatformToolProvider provider = ((DefaultCppBinary)binary).getPlatformToolProvider();
        CompilerMetadata compilerMetadata = provider.getCompilerMetadata(ToolType.CPP_COMPILER);
        this.visualStudioVersion = compilerMetadata instanceof VisualCppMetadata ? ((VisualCppMetadata)compilerMetadata).getVisualStudioVersion() : VersionNumber.version((int)14);
        SystemLibraries systemLibraries = provider.getSystemLibraries(ToolType.CPP_COMPILER);
        if (systemLibraries instanceof WindowsSdkLibraries) {
            WindowsSdkLibraries sdkLibraries = (WindowsSdkLibraries)systemLibraries;
            this.windowsSdkVersion = sdkLibraries.getSdkVersion();
        } else {
            this.windowsSdkVersion = VersionNumber.parse((String)"8.1");
        }
    }

    abstract CppBinary getBinary();

    @Override
    public String getProjectPath() {
        return this.projectPath;
    }

    @Override
    public String getComponentName() {
        return this.projectName;
    }

    @Override
    public String getVisualStudioProjectName() {
        return this.projectName + this.getProjectType().getSuffix();
    }

    @Override
    public String getVisualStudioConfigurationName() {
        String buildType = "debug";
        if (this.getBinary().isOptimized()) {
            buildType = "release";
        }
        String operatingSystemFamilySuffix = Dimensions.createDimensionSuffix((Named)this.getBinary().getTargetPlatform().getOperatingSystemFamily(), (Collection)this.component.getBinaries().get().stream().map(CppBinary::getTargetPlatform).map(CppPlatform::getOperatingSystemFamily).collect(Collectors.toSet()));
        String architectureSuffix = Dimensions.createDimensionSuffix((Named)this.getBinary().getTargetPlatform().getArchitecture(), (Collection)this.component.getBinaries().get().stream().map(CppBinary::getTargetPlatform).map(NativePlatform::getArchitecture).collect(Collectors.toSet()));
        return buildType + operatingSystemFamilySuffix + architectureSuffix;
    }

    protected String taskPath(String taskName) {
        if (":".equals(this.projectPath)) {
            return ":" + taskName;
        }
        return this.projectPath + ":" + taskName;
    }

    @Override
    public VersionNumber getVisualStudioVersion() {
        return this.visualStudioVersion;
    }

    @Override
    public VersionNumber getSdkVersion() {
        return this.windowsSdkVersion;
    }

    @Override
    public List<String> getVariantDimensions() {
        return Lists.newArrayList((Object[])new String[]{this.getBinary().getName()});
    }

    @Override
    public FileCollection getSourceFiles() {
        return this.getBinary().getCppSource();
    }

    @Override
    public FileCollection getResourceFiles() {
        return ImmutableFileCollection.of();
    }

    @Override
    public FileCollection getHeaderFiles() {
        return this.component.getHeaderFiles();
    }

    @Override
    public String getCleanTaskPath() {
        return this.taskPath("clean");
    }

    @Override
    public boolean isDebuggable() {
        return this.getBinary().isDebuggable();
    }

    @Override
    public List<String> getCompilerDefines() {
        return new MacroArgsConverter().transform(((CppCompile)this.getBinary().getCompileTask().get()).getMacros());
    }

    @Override
    public Set<File> getIncludePaths() {
        return this.getBinary().getCompileIncludePath().getFiles();
    }
}

