/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.groovy.scripts;

import groovy.lang.Closure;
import java.io.File;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.PathValidation;
import org.gradle.api.Script;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.DeleteSpec;
import org.gradle.api.file.FileTree;
import org.gradle.api.initialization.dsl.ScriptHandler;
import org.gradle.api.internal.ProcessOperations;
import org.gradle.api.internal.file.DefaultFileOperations;
import org.gradle.api.internal.file.FileLookup;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.HasFileOperations;
import org.gradle.api.internal.file.collections.DirectoryFileTreeFactory;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.initialization.ScriptHandlerFactory;
import org.gradle.api.internal.plugins.DefaultObjectConfigurationAction;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.logging.LoggingManager;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.resources.ResourceHandler;
import org.gradle.api.tasks.WorkResult;
import org.gradle.configuration.ScriptPluginFactory;
import org.gradle.groovy.scripts.BasicScript;
import org.gradle.internal.Actions;
import org.gradle.internal.hash.FileHasher;
import org.gradle.internal.hash.StreamHasher;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.resource.TextResourceLoader;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.process.ExecResult;
import org.gradle.process.ExecSpec;
import org.gradle.process.JavaExecSpec;
import org.gradle.process.internal.ExecFactory;
import org.gradle.util.ConfigureUtil;

public abstract class DefaultScript
extends BasicScript {
    private static final Logger LOGGER = Logging.getLogger(Script.class);
    private FileOperations fileOperations;
    private ProcessOperations processOperations;
    private ProviderFactory providerFactory;
    private LoggingManager loggingManager;
    public ServiceRegistry __scriptServices;

    @Override
    public void init(Object target, ServiceRegistry services) {
        File sourceFile;
        super.init(target, services);
        this.__scriptServices = services;
        this.loggingManager = (LoggingManager)services.get(LoggingManager.class);
        Instantiator instantiator = (Instantiator)services.get(Instantiator.class);
        FileLookup fileLookup = (FileLookup)services.get(FileLookup.class);
        ExecFactory execFactory = (ExecFactory)services.get(ExecFactory.class);
        DirectoryFileTreeFactory directoryFileTreeFactory = (DirectoryFileTreeFactory)services.get(DirectoryFileTreeFactory.class);
        StreamHasher streamHasher = (StreamHasher)services.get(StreamHasher.class);
        FileHasher fileHasher = (FileHasher)services.get(FileHasher.class);
        TextResourceLoader textResourceLoader = (TextResourceLoader)services.get(TextResourceLoader.class);
        this.fileOperations = target instanceof HasFileOperations ? ((HasFileOperations)target).getFileOperations() : ((sourceFile = this.getScriptSource().getResource().getLocation().getFile()) != null ? new DefaultFileOperations(fileLookup.getFileResolver(sourceFile.getParentFile()), null, null, instantiator, fileLookup, directoryFileTreeFactory, streamHasher, fileHasher, execFactory, textResourceLoader) : new DefaultFileOperations(fileLookup.getFileResolver(), null, null, instantiator, fileLookup, directoryFileTreeFactory, streamHasher, fileHasher, execFactory, textResourceLoader));
        this.processOperations = (ProcessOperations)((Object)this.fileOperations);
        this.providerFactory = (ProviderFactory)services.get(ProviderFactory.class);
    }

    public FileResolver getFileResolver() {
        return this.fileOperations.getFileResolver();
    }

    @Override
    public FileOperations getFileOperations() {
        return this.fileOperations;
    }

    private DefaultObjectConfigurationAction createObjectConfigurationAction() {
        ClassLoaderScope classLoaderScope = (ClassLoaderScope)this.__scriptServices.get(ClassLoaderScope.class);
        return new DefaultObjectConfigurationAction(this.getFileResolver(), (ScriptPluginFactory)this.__scriptServices.get(ScriptPluginFactory.class), (ScriptHandlerFactory)this.__scriptServices.get(ScriptHandlerFactory.class), classLoaderScope, (TextResourceLoader)this.__scriptServices.get(TextResourceLoader.class), this.getScriptTarget());
    }

    public void apply(Closure closure) {
        DefaultObjectConfigurationAction action = this.createObjectConfigurationAction();
        ConfigureUtil.configure((Closure)closure, (Object)action);
        action.execute();
    }

    public void apply(Map options) {
        DefaultObjectConfigurationAction action = this.createObjectConfigurationAction();
        ConfigureUtil.configureByMap((Map)options, (Object)action);
        action.execute();
    }

    public ScriptHandler getBuildscript() {
        return (ScriptHandler)this.__scriptServices.get(ScriptHandler.class);
    }

    public void buildscript(Closure configureClosure) {
        ConfigureUtil.configure((Closure)configureClosure, (Object)this.getBuildscript());
    }

    public File file(Object path) {
        return this.fileOperations.file(path);
    }

    public File file(Object path, PathValidation validation) {
        return this.fileOperations.file(path, validation);
    }

    public URI uri(Object path) {
        return this.fileOperations.uri(path);
    }

    public ConfigurableFileCollection files(Object ... paths) {
        return this.fileOperations.configurableFiles(paths);
    }

    public ConfigurableFileCollection files(Object paths, Closure configureClosure) {
        return (ConfigurableFileCollection)ConfigureUtil.configure((Closure)configureClosure, (Object)this.fileOperations.configurableFiles(paths));
    }

    public String relativePath(Object path) {
        return this.fileOperations.relativePath(path);
    }

    public ConfigurableFileTree fileTree(Object baseDir) {
        return this.fileOperations.fileTree(baseDir);
    }

    public ConfigurableFileTree fileTree(Map<String, ?> args) {
        return this.fileOperations.fileTree(args);
    }

    public ConfigurableFileTree fileTree(Object baseDir, Closure configureClosure) {
        return (ConfigurableFileTree)ConfigureUtil.configure((Closure)configureClosure, (Object)this.fileOperations.fileTree(baseDir));
    }

    public FileTree zipTree(Object zipPath) {
        return this.fileOperations.zipTree(zipPath);
    }

    public FileTree tarTree(Object tarPath) {
        return this.fileOperations.tarTree(tarPath);
    }

    public ResourceHandler getResources() {
        return this.fileOperations.getResources();
    }

    public WorkResult copy(Closure closure) {
        return this.copy((Action<? super CopySpec>)ConfigureUtil.configureUsing((Closure)closure));
    }

    public WorkResult copy(Action<? super CopySpec> action) {
        return this.fileOperations.copy(action);
    }

    public WorkResult sync(Action<? super CopySpec> action) {
        return this.fileOperations.sync(action);
    }

    public CopySpec copySpec(Closure closure) {
        return (CopySpec)Actions.with((Object)this.copySpec(), (Action)ConfigureUtil.configureUsing((Closure)closure));
    }

    public CopySpec copySpec() {
        return this.fileOperations.copySpec();
    }

    public File mkdir(Object path) {
        return this.fileOperations.mkdir(path);
    }

    public boolean delete(Object ... paths) {
        return this.fileOperations.delete(paths);
    }

    public WorkResult delete(Action<? super DeleteSpec> action) {
        return this.fileOperations.delete(action);
    }

    public ExecResult javaexec(Closure closure) {
        return this.processOperations.javaexec((Action<? super JavaExecSpec>)ConfigureUtil.configureUsing((Closure)closure));
    }

    public ExecResult javaexec(Action<? super JavaExecSpec> action) {
        return this.processOperations.javaexec(action);
    }

    public ExecResult exec(Closure closure) {
        return this.processOperations.exec((Action<? super ExecSpec>)ConfigureUtil.configureUsing((Closure)closure));
    }

    public ExecResult exec(Action<? super ExecSpec> action) {
        return this.processOperations.exec(action);
    }

    public <T> Provider<T> provider(Callable<T> value) {
        return this.providerFactory.provider(value);
    }

    public LoggingManager getLogging() {
        return this.loggingManager;
    }

    public Logger getLogger() {
        return LOGGER;
    }

    public String toString() {
        return "script";
    }
}

