/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.molxyz;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.PT;
import org.jmol.adapter.readers.molxyz.V3000Rdr;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.api.JmolAdapter;
import org.jmol.util.Logger;

public class MolReader
extends AtomSetCollectionReader {
    private boolean optimize2D;
    private boolean haveAtomSerials;
    protected String dimension;
    protected boolean allow2D = true;
    private int iatom0;
    private V3000Rdr vr;
    private int atomCount;
    private String[] atomData;

    @Override
    public void initializeReader() throws Exception {
        this.optimize2D = this.checkFilterKey("2D");
    }

    @Override
    protected boolean checkLine() throws Exception {
        boolean bl = this.line.startsWith("$MDL");
        if (bl) {
            this.discardLinesUntilStartsWith("$HDR");
            this.rd();
            if (this.line == null) {
                Logger.warn("$HDR not found in MDL RG file");
                this.continuing = false;
                return false;
            }
        } else if (this.line.equals("M  END")) {
            return true;
        }
        if (this.doGetModel(++this.modelNumber, null)) {
            this.iatom0 = this.asc.ac;
            this.processMolSdHeader();
            this.processCtab(bl);
            this.vr = null;
            if (this.isLastModel(this.modelNumber)) {
                this.continuing = false;
                return false;
            }
        }
        if (this.line != null && this.line.indexOf("$$$$") < 0) {
            this.discardLinesUntilStartsWith("$$$$");
        }
        return true;
    }

    @Override
    public void finalizeSubclassReader() throws Exception {
        this.finalizeReaderMR();
    }

    protected void finalizeReaderMR() throws Exception {
        if (this.optimize2D) {
            this.set2D();
        }
        this.isTrajectory = false;
        this.finalizeReaderASCR();
    }

    private void processMolSdHeader() throws Exception {
        String string = "";
        String string2 = this.line.trim();
        this.asc.setCollectionName(string2);
        string = String.valueOf(string) + this.line + "\n";
        this.rd();
        if (this.line == null) {
            return;
        }
        string = String.valueOf(string) + this.line + "\n";
        String string3 = this.dimension = this.line.length() < 22 ? "3D" : this.line.substring(20, 22);
        if (this.dimension.equals("2D")) {
            if (!this.allow2D) {
                throw new Exception("File is 2D, not 3D");
            }
            this.appendLoadNote("This model is 2D. Its 3D structure has not been generated.");
        }
        this.asc.setInfo("dimension", this.dimension);
        this.rd();
        if (this.line == null) {
            return;
        }
        this.line = this.line.trim();
        string = String.valueOf(string) + this.line + "\n";
        Logger.info(string);
        this.checkCurrentLineForScript();
        this.asc.setInfo("fileHeader", string);
        this.newAtomSet(string2);
    }

    private void processCtab(boolean bl) throws Exception {
        if (bl) {
            this.discardLinesUntilStartsWith("$CTAB");
        }
        if (this.rd() == null) {
            return;
        }
        if (this.line.indexOf("V3000") >= 0) {
            this.optimize2D = this.dimension.equals("2D");
            this.vr = ((V3000Rdr)this.getInterface("org.jmol.adapter.readers.molxyz.V3000Rdr")).set(this);
            this.discardLinesUntilContains("COUNTS");
            this.vr.readAtomsAndBonds(this.getTokens());
        } else {
            this.readAtomsAndBonds(this.parseIntRange(this.line, 0, 3), this.parseIntRange(this.line, 3, 6));
        }
        this.applySymmetryAndSetTrajectory();
    }

    private void readAtomsAndBonds(int n, int n2) throws Exception {
        String string;
        this.atomCount = n;
        int n3 = 0;
        while (n3 < n) {
            this.rd();
            int n4 = this.line.length();
            int n5 = 0;
            int n6 = 0;
            int n7 = Integer.MIN_VALUE;
            float f = this.parseFloatRange(this.line, 0, 10);
            float f2 = this.parseFloatRange(this.line, 10, 20);
            float f3 = this.parseFloatRange(this.line, 20, 30);
            if (n4 < 34) {
                string = this.line.substring(31).trim();
            } else {
                string = this.line.substring(31, 34).trim();
                if (string.equals("H1")) {
                    string = "H";
                    n6 = 1;
                }
                if (n4 >= 39) {
                    int n8 = this.parseIntRange(this.line, 36, 39);
                    if (n8 >= 1 && n8 <= 7) {
                        n5 = 4 - n8;
                    }
                    if ((n8 = this.parseIntRange(this.line, 34, 36)) != 0 && n8 >= -3 && n8 <= 4) {
                        n6 = JmolAdapter.getNaturalIsotope(JmolAdapter.getElementNumber(string)) + n8;
                    }
                    if (n7 == Integer.MIN_VALUE && this.haveAtomSerials) {
                        n7 = n3 + 1;
                    }
                }
            }
            this.addMolAtom(n7, n6, string, n5, f, f2, f3);
            ++n3;
        }
        this.rd();
        if (this.line.startsWith("V  ")) {
            this.readAtomValues();
        }
        if (n2 == 0) {
            this.asc.setNoAutoBond();
        }
        n3 = 0;
        while (n3 < n2) {
            if (n3 > 0) {
                this.rd();
            }
            int n9 = 0;
            String string2 = this.line.substring(0, 3).trim();
            string = this.line.substring(3, 6).trim();
            int n10 = this.parseIntRange(this.line, 6, 9);
            if (this.optimize2D && n10 == 1 && this.line.length() >= 12) {
                n9 = this.parseIntRange(this.line, 9, 12);
            }
            n10 = this.fixOrder(n10, n9);
            if (this.haveAtomSerials) {
                this.asc.addNewBondFromNames(string2, string, n10);
            } else {
                this.asc.addNewBondWithOrder(this.iatom0 + this.parseIntStr(string2) - 1, this.iatom0 + this.parseIntStr(string) - 1, n10);
            }
            ++n3;
        }
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        this.rd();
        while (this.line != null && this.line.indexOf("$$$$") != 0) {
            if (this.line.indexOf(">") == 0) {
                this.readMolData(hashtable);
                continue;
            }
            if (this.line.startsWith("M  ISO")) {
                this.readIsotopes();
                continue;
            }
            this.rd();
        }
        if (this.atomData != null) {
            Object v = hashtable.get("atom_value_name");
            hashtable.put(v == null ? "atom_values" : v.toString(), this.atomData);
        }
        if (!hashtable.isEmpty()) {
            this.asc.setCurrentModelInfo("molData", hashtable);
        }
    }

    private void readAtomValues() throws Exception {
        this.atomData = new String[this.atomCount];
        int n = this.atomData.length;
        while (--n >= 0) {
            this.atomData[n] = "";
        }
        while (this.line.indexOf("V  ") == 0) {
            String string;
            n = this.parseIntAt(this.line, 3);
            if (n < 1 || n > this.atomCount) {
                Logger.error("V  nnn does not evalute to a valid atom number: " + n);
                return;
            }
            this.atomData[n - 1] = string = this.line.substring(6).trim();
            this.rd();
        }
    }

    private void readIsotopes() throws Exception {
        int n = this.parseIntAt(this.line, 6);
        try {
            int n2 = this.asc.getLastAtomSetAtomIndex();
            int n3 = 0;
            int n4 = 9;
            while (n3 < n) {
                int n5 = this.parseIntAt(this.line, n4);
                Atom atom = this.asc.atoms[n5 + n2 - 1];
                int n6 = this.parseIntAt(this.line, n4 + 4);
                n4 += 8;
                atom.elementSymbol = n6 + PT.replaceAllCharacters(atom.elementSymbol, "0123456789", "");
                ++n3;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.rd();
    }

    /*
     * Unable to fully structure code
     */
    private void readMolData(Map<String, Object> var1_1) throws Exception {
        var2_2 = this.asc.atoms;
        var3_3 = PT.trim(this.line, "> <").toLowerCase();
        var4_4 = "";
        var5_5 = null;
        while (this.rd() != null && !this.line.equals("$$$$") && this.line.length() > 0) {
            var4_4 = String.valueOf(var4_4) + (this.line.length() == 81 && this.line.charAt(80) == '+' ? this.line.substring(0, 80) : String.valueOf(this.line) + "\n");
        }
        var4_4 = PT.trim(var4_4, "\n");
        Logger.info(String.valueOf(var3_3) + ":" + PT.esc(var4_4));
        var1_1.put(var3_3, var4_4);
        var6_6 = 0;
        if (var3_3.toUpperCase().contains("_PARTIAL_CHARGES")) {
            block14: {
                try {
                    var5_5 = PT.parseFloatArray(var4_4);
                    var7_7 = this.asc.getLastAtomSetAtomIndex();
                    var8_11 = this.asc.ac;
                    while (var7_7 < var8_11) {
                        var2_2[var7_7].partialCharge = 0.0f;
                        ++var7_7;
                    }
                    var7_7 = 0;
                    var8_11 = (int)var5_5[var7_7++];
                    while (--var8_11 >= 0) {
                        var9_14 = (int)var5_5[var7_7++] + this.iatom0 - 1;
                        var2_2[var9_14].partialCharge = var10_17 = var5_5[var7_7++];
                        ++var6_6;
                    }
                    break block14;
                }
                catch (Throwable var7_8) {
                    var8_12 = this.asc.getLastAtomSetAtomIndex();
                    var9_15 = this.asc.ac;
                    ** while (var8_12 < var9_15)
                }
lbl-1000:
                // 1 sources

                {
                    var2_2[var8_12].partialCharge = 0.0f;
                    ++var8_12;
                    continue;
                }
lbl37:
                // 1 sources

                Logger.error("error reading " + var3_3 + " field -- partial charges cleared");
            }
            Logger.info(String.valueOf(var6_6) + " partial charges read");
        } else if (var3_3.toUpperCase().contains("ATOM_NAMES")) {
            var6_6 = 0;
            try {
                var7_9 = PT.getTokens(var4_4);
                var8_13 = 0;
                var9_16 = this.parseIntStr(var7_9[var8_13++]);
                while (--var9_16 >= 0) {
                    while ((var10_18 = this.parseIntStr(var7_9[var8_13++])) == -2147483648) {
                    }
                    var11_19 = var10_18 + this.iatom0 - 1;
                    if (!(var12_20 = var7_9[var8_13++]).equals(".")) {
                        var2_2[var11_19].atomName = var12_20;
                    }
                    ++var6_6;
                }
            }
            catch (Throwable var7_10) {
                Logger.error("error reading " + var3_3 + " field");
            }
            Logger.info(String.valueOf(var6_6) + " atom names read");
        }
    }

    public void addMolAtom(int n, int n2, String string, int n3, float f, float f2, float f3) {
        switch (n2) {
            case 0: {
                break;
            }
            case 1: {
                string = "1H";
                break;
            }
            case 2: {
                string = "2H";
                break;
            }
            case 3: {
                string = "3H";
                break;
            }
            default: {
                string = String.valueOf(n2) + string;
            }
        }
        if (this.optimize2D && f3 != 0.0f) {
            this.optimize2D = false;
        }
        Atom atom = new Atom();
        atom.elementSymbol = string;
        atom.formalCharge = n3;
        this.setAtomCoordXYZ(atom, f, f2, f3);
        if (n == Integer.MIN_VALUE) {
            this.asc.addAtom(atom);
        } else {
            this.haveAtomSerials = true;
            atom.atomSerial = n;
            this.asc.addAtomWithMappedSerialNumber(atom);
        }
    }

    int fixOrder(int n, int n2) {
        switch (n) {
            default: {
                return 1;
            }
            case 1: {
                switch (n2) {
                    case 1: {
                        return 1025;
                    }
                    case 3: 
                    case 6: {
                        return 1041;
                    }
                }
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                return 515;
            }
            case 5: {
                return 66;
            }
            case 6: {
                return 513;
            }
            case 7: {
                return 514;
            }
            case 8: 
            case 9: {
                return 33;
            }
            case 14: {
                return 4;
            }
            case 15: {
                return 5;
            }
            case 16: {
                return 6;
            }
        }
        return n;
    }

    public void addMolBond(String string, String string2, int n, int n2) {
        n = this.fixOrder(n, n2);
        if (this.haveAtomSerials) {
            this.asc.addNewBondFromNames(string, string2, n);
        } else {
            this.asc.addNewBondWithOrder(this.iatom0 + this.parseIntStr(string) - 1, this.iatom0 + this.parseIntStr(string2) - 1, n);
        }
    }
}

