/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.quantum;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.PT;
import org.jmol.adapter.readers.quantum.BasisFunctionReader;
import org.jmol.adapter.readers.quantum.MOReader;
import org.jmol.util.Logger;

public abstract class GamessReader
extends MOReader {
    protected Lst<String> atomNames;
    private Map<String, String> calcOptions;
    private boolean isTypeSet;

    protected abstract void readAtomsInBohrCoordinates() throws Exception;

    protected void readEnergy() {
        String[] stringArray = PT.getTokens(this.line.substring(this.line.indexOf("ENERGY")));
        if (stringArray.length < 3) {
            return;
        }
        String string = stringArray[2];
        float f = this.parseFloatStr(string);
        if (!Float.isNaN(f)) {
            this.asc.setAtomSetEnergy(string, f);
        }
    }

    protected void readGaussianBasis(String string, String string2) throws Exception {
        int n;
        String[] stringArray;
        Lst<String[]> lst = new Lst<String[]>();
        this.gaussianCount = 0;
        int n2 = 0;
        this.shellCount = 0;
        String string3 = "0";
        this.discardLinesUntilContains(string);
        this.rd();
        int[] nArray = null;
        Hashtable hashtable = new Hashtable();
        Lst<int[]> lst2 = new Lst<int[]>();
        String string4 = null;
        while (this.rd() != null && this.line.indexOf(string2) < 0) {
            if (this.line.indexOf("(") >= 0) {
                this.line = GamessReader.fixBasisLine(this.line);
            }
            stringArray = this.getTokens();
            switch (stringArray.length) {
                case 1: {
                    if (string4 != null) {
                        if (nArray != null) {
                            nArray[2] = n2;
                            lst2.addLast(nArray);
                            nArray = null;
                        }
                        hashtable.put(string4, lst2);
                    }
                    lst2 = new Lst();
                    string4 = stringArray[0];
                    break;
                }
                case 0: {
                    break;
                }
                default: {
                    if (!stringArray[0].equals(string3)) {
                        if (nArray != null) {
                            nArray[2] = n2;
                            lst2.addLast(nArray);
                        }
                        string3 = stringArray[0];
                        ++this.shellCount;
                        int[] nArray2 = new int[3];
                        nArray2[0] = BasisFunctionReader.getQuantumShellTagID(this.fixShellTag(stringArray[1]));
                        nArray2[1] = this.gaussianCount;
                        nArray = nArray2;
                        n2 = 0;
                    }
                    ++n2;
                    ++this.gaussianCount;
                    lst.addLast(stringArray);
                }
            }
        }
        if (nArray != null) {
            nArray[2] = n2;
            lst2.addLast(nArray);
        }
        if (string4 != null) {
            hashtable.put(string4, lst2);
        }
        this.gaussians = AU.newFloat2(this.gaussianCount);
        int n3 = 0;
        while (n3 < this.gaussianCount) {
            stringArray = (String[])lst.get(n3);
            this.gaussians[n3] = new float[stringArray.length - 3];
            n = 3;
            while (n < stringArray.length) {
                this.gaussians[n3][n - 3] = this.parseFloatStr(stringArray[n]);
                ++n;
            }
            ++n3;
        }
        n3 = this.atomNames.size();
        if (this.shells == null && n3 > 0) {
            this.shells = new Lst();
            n = 0;
            while (n < n3) {
                string4 = (String)this.atomNames.get(n);
                Lst lst3 = (Lst)hashtable.get(string4);
                if (lst3 == null) {
                    Logger.error("slater for atom " + n + " atomType " + string4 + " was not found in listing. Ignoring molecular orbitals");
                    return;
                }
                int n4 = 0;
                while (n4 < lst3.size()) {
                    nArray = (int[])lst3.get(n4);
                    this.shells.addLast(new int[]{n + 1, nArray[0], nArray[1] + 1, nArray[2]});
                    ++n4;
                }
                ++n;
            }
        }
        if (this.debugging) {
            Logger.debug(String.valueOf(this.shellCount) + " slater shells read");
            Logger.debug(String.valueOf(this.gaussianCount) + " gaussian primitives read");
        }
    }

    protected abstract String fixShellTag(String var1);

    protected void readFrequencies() throws Exception {
        this.discardLinesUntilContains("FREQUENCY:");
        boolean bl = false;
        while (this.line != null && this.line.indexOf("FREQUENCY:") >= 0) {
            int n = 0;
            String[] stringArray = this.getTokens();
            float[] fArray = new float[stringArray.length];
            int n2 = 0;
            while (n2 < stringArray.length) {
                float f = this.parseFloatStr(stringArray[n2]);
                if (stringArray[n2].equals("I")) {
                    fArray[n - 1] = -fArray[n - 1];
                }
                if (!Float.isNaN(f)) {
                    fArray[n++] = f;
                    if (this.debugging) {
                        Logger.debug(String.valueOf(this.vibrationNumber + 1) + " frequency=" + f);
                    }
                }
                ++n2;
            }
            String[] stringArray2 = null;
            String[] stringArray3 = null;
            this.rd();
            if (this.line.indexOf("MASS") >= 0) {
                stringArray2 = this.getTokens();
                this.rd();
            }
            if (this.line.indexOf("INTENS") >= 0) {
                stringArray3 = this.getTokens();
            }
            int n3 = this.asc.getLastAtomSetAtomCount();
            int n4 = this.asc.ac;
            boolean[] blArray = new boolean[n];
            int n5 = 0;
            while (n5 < n) {
                boolean bl2 = blArray[n5] = !this.doGetVibration(++this.vibrationNumber);
                if (!blArray[n5]) {
                    if (bl) {
                        this.asc.cloneLastAtomSet();
                    } else {
                        bl = true;
                        n4 -= n3;
                    }
                    this.asc.setAtomSetFrequency(this.vibrationNumber, null, null, "" + fArray[n5], null);
                    if (stringArray2 != null) {
                        this.asc.setAtomSetModelProperty("ReducedMass", String.valueOf(stringArray2[stringArray2.length - n + n5]) + " AMU");
                    }
                    if (stringArray3 != null) {
                        this.asc.setAtomSetModelProperty("IRIntensity", String.valueOf(stringArray3[stringArray3.length - n + n5]) + " D^2/AMU-Angstrom^2");
                    }
                }
                ++n5;
            }
            this.discardLinesUntilBlank();
            this.fillFrequencyData(n4, n3, n3, blArray, false, 20, 12, null, 0, null);
            this.readLines(13);
        }
    }

    protected static String fixBasisLine(String string) {
        int n;
        string = string.replace(')', ' ');
        while ((n = string.indexOf("(")) >= 0) {
            int n2 = n;
            while (string.charAt(--n2) == ' ') {
            }
            while (string.charAt(--n2) != ' ') {
            }
            string = String.valueOf(string.substring(0, ++n2)) + string.substring(n + 1);
        }
        return string;
    }

    protected void setCalculationType() {
        if (this.calcOptions == null || this.isTypeSet) {
            return;
        }
        this.isTypeSet = true;
        String string = this.calcOptions.get("contrl_options_SCFTYP");
        String string2 = this.calcOptions.get("contrl_options_RUNTYP");
        String string3 = this.calcOptions.get("basis_options_IGAUSS");
        String string4 = this.calcOptions.get("basis_options_GBASIS");
        boolean bl = !"0".equals(this.calcOptions.get("basis_options_NDFUNC"));
        boolean bl2 = !"0".equals(this.calcOptions.get("basis_options_NPFUNC"));
        boolean bl3 = !"0".equals(this.calcOptions.get("basis_options_NFFUNC"));
        String string5 = this.calcOptions.get("contrl_options_DFTTYP");
        int n = this.parseIntStr(this.calcOptions.get("contrl_options_MPLEVL"));
        String string6 = this.calcOptions.get("contrl_options_CITYP");
        String string7 = this.calcOptions.get("contrl_options_CCTYP");
        if (string3 == null && string == null) {
            return;
        }
        if (this.calculationType.equals("?")) {
            this.calculationType = "";
        }
        if (string3 != null) {
            if ("0".equals(string3)) {
                boolean bl4 = false;
                if (this.calculationType.length() > 0) {
                    this.calculationType = String.valueOf(this.calculationType) + " ";
                }
                if (string4.startsWith("ACC")) {
                    this.calculationType = String.valueOf(this.calculationType) + "aug-cc-p";
                }
                if (string4.startsWith("CC")) {
                    this.calculationType = String.valueOf(this.calculationType) + "cc-p";
                }
                if ((string4.startsWith("ACC") || string4.startsWith("CC")) && string4.endsWith("C")) {
                    this.calculationType = String.valueOf(this.calculationType) + "C";
                }
                if (string4.indexOf("CCD") >= 0) {
                    this.calculationType = String.valueOf(this.calculationType) + "VDZ";
                    bl4 = true;
                }
                if (string4.indexOf("CCT") >= 0) {
                    this.calculationType = String.valueOf(this.calculationType) + "VTZ";
                    bl4 = true;
                }
                if (string4.indexOf("CCQ") >= 0) {
                    this.calculationType = String.valueOf(this.calculationType) + "VQZ";
                    bl4 = true;
                }
                if (string4.indexOf("CC5") >= 0) {
                    this.calculationType = String.valueOf(this.calculationType) + "V5Z";
                    bl4 = true;
                }
                if (string4.indexOf("CC6") >= 0) {
                    this.calculationType = String.valueOf(this.calculationType) + "V6Z";
                    bl4 = true;
                }
                if (!bl4) {
                    this.calculationType = String.valueOf(this.calculationType) + string4;
                }
            } else {
                if (this.calculationType.length() > 0) {
                    this.calculationType = String.valueOf(this.calculationType) + " ";
                }
                this.calculationType = String.valueOf(this.calculationType) + string3 + "-" + PT.rep(string4, "N", "");
                if ("T".equals(this.calcOptions.get("basis_options_DIFFSP"))) {
                    if ("T".equals(this.calcOptions.get("basis_options_DIFFS"))) {
                        this.calculationType = String.valueOf(this.calculationType) + "+";
                    }
                    this.calculationType = String.valueOf(this.calculationType) + "+";
                }
                this.calculationType = String.valueOf(this.calculationType) + "G";
                if (bl || bl2 || bl3) {
                    this.calculationType = String.valueOf(this.calculationType) + "(";
                    if (bl3) {
                        this.calculationType = String.valueOf(this.calculationType) + "f";
                        if (bl || bl2) {
                            this.calculationType = String.valueOf(this.calculationType) + ",";
                        }
                    }
                    if (bl) {
                        this.calculationType = String.valueOf(this.calculationType) + "d";
                        if (bl2) {
                            this.calculationType = String.valueOf(this.calculationType) + ",";
                        }
                    }
                    if (bl2) {
                        this.calculationType = String.valueOf(this.calculationType) + "p";
                    }
                    this.calculationType = String.valueOf(this.calculationType) + ")";
                }
            }
            if (string5 != null && string5.indexOf("NONE") < 0) {
                if (this.calculationType.length() > 0) {
                    this.calculationType = String.valueOf(this.calculationType) + " ";
                }
                this.calculationType = String.valueOf(this.calculationType) + string5;
            }
            if (string6 != null && string6.indexOf("NONE") < 0) {
                if (this.calculationType.length() > 0) {
                    this.calculationType = String.valueOf(this.calculationType) + " ";
                }
                this.calculationType = String.valueOf(this.calculationType) + string6;
            }
            if (string7 != null && string7.indexOf("NONE") < 0) {
                if (this.calculationType.length() > 0) {
                    this.calculationType = String.valueOf(this.calculationType) + " ";
                }
                this.calculationType = String.valueOf(this.calculationType) + string7;
            }
            if (n > 0) {
                if (this.calculationType.length() > 0) {
                    this.calculationType = String.valueOf(this.calculationType) + " ";
                }
                this.calculationType = String.valueOf(this.calculationType) + "MP" + n;
            }
            if (string != null) {
                if (this.calculationType.length() > 0) {
                    this.calculationType = String.valueOf(this.calculationType) + " ";
                }
                this.calculationType = String.valueOf(this.calculationType) + string + " " + string2;
            }
        }
    }

    protected void readControlInfo() throws Exception {
        this.readCalculationInfo("contrl_options_");
    }

    protected void readBasisInfo() throws Exception {
        this.readCalculationInfo("basis_options_");
    }

    private void readCalculationInfo(String string) throws Exception {
        if (this.calcOptions == null) {
            this.calcOptions = new Hashtable<String, String>();
            this.asc.setInfo("calculationOptions", this.calcOptions);
        }
        while (this.rd() != null && (this.line = this.line.trim()).length() > 0) {
            if (this.line.indexOf("=") < 0) continue;
            String[] stringArray = PT.getTokens(String.valueOf(PT.rep(this.line, "=", " = ")) + " ?");
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].equals("=")) {
                    try {
                        String string2;
                        String string3 = String.valueOf(string) + stringArray[n - 1];
                        String string4 = string2 = string3.equals("basis_options_SPLIT3") ? String.valueOf(stringArray[++n]) + " " + stringArray[++n] + " " + stringArray[++n] : stringArray[++n];
                        if (this.debugging) {
                            Logger.debug(String.valueOf(string3) + " = " + string2);
                        }
                        this.calcOptions.put(string3, string2);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++n;
            }
        }
    }
}

