/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.quantum;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.Lst;
import org.jmol.adapter.readers.quantum.MopacSlaterReader;
import org.jmol.adapter.smarter.Atom;

public class MopacGraphfReader
extends MopacSlaterReader {
    private int ac;
    private int nCoefficients;
    private float[][] invMatrix;
    private boolean isNewFormat;
    private Lst<float[]> orbitalData;
    private Lst<String> orbitalInfo;

    @Override
    protected void initializeReader() {
        this.alphaBeta = "alpha";
    }

    @Override
    protected boolean checkLine() throws Exception {
        this.readAtoms();
        if (this.doReadMolecularOrbitals) {
            this.readSlaterBasis();
            this.readMolecularOrbitals(false);
            if (this.readKeywords()) {
                this.readMolecularOrbitals(true);
            }
        }
        this.continuing = false;
        return false;
    }

    private void readAtoms() throws Exception {
        this.asc.newAtomSet();
        this.ac = this.parseIntStr(this.line);
        this.atomicNumbers = new int[this.ac];
        int n = 0;
        while (n < this.ac) {
            this.rd();
            this.atomicNumbers[n] = this.parseIntRange(this.line, 0, 4);
            Atom atom = this.asc.addNewAtom();
            this.setAtomCoordXYZ(atom, this.parseFloatRange(this.line, 4, 17), this.parseFloatRange(this.line, 17, 29), this.parseFloatRange(this.line, 29, 41));
            if (this.line.length() > 41) {
                atom.partialCharge = this.parseFloatStr(this.line.substring(41));
            }
            atom.elementSymbol = MopacGraphfReader.getElementSymbol(this.atomicNumbers[n]);
            ++n;
        }
    }

    private void readSlaterBasis() throws Exception {
        this.nCoefficients = 0;
        float[] fArray = new float[3];
        int n = 0;
        while (n < this.ac) {
            MopacGraphfReader.getTokensFloat(this.rd(), fArray, 3);
            int n2 = this.atomicNumbers[n];
            float f = fArray[0];
            if (f != 0.0f) {
                this.createSphericalSlaterByType(n, n2, "S", f, 1.0f);
            }
            if ((f = fArray[1]) != 0.0f) {
                this.createSphericalSlaterByType(n, n2, "Px", f, 1.0f);
                this.createSphericalSlaterByType(n, n2, "Py", f, 1.0f);
                this.createSphericalSlaterByType(n, n2, "Pz", f, 1.0f);
            }
            if ((f = fArray[2]) != 0.0f) {
                this.createSphericalSlaterByType(n, n2, "Dx2-y2", f, 1.0f);
                this.createSphericalSlaterByType(n, n2, "Dxz", f, 1.0f);
                this.createSphericalSlaterByType(n, n2, "Dz2", f, 1.0f);
                this.createSphericalSlaterByType(n, n2, "Dyz", f, 1.0f);
                this.createSphericalSlaterByType(n, n2, "Dxy", f, 1.0f);
            }
            ++n;
        }
        this.nCoefficients = this.slaters.size();
        this.setSlaters(true, false);
    }

    private void readMolecularOrbitals(boolean bl) throws Exception {
        int n;
        if (bl) {
            this.alphaBeta = "beta";
        }
        float[][] fArray = null;
        if (this.rd() == null) {
            return;
        }
        boolean bl2 = this.isNewFormat = this.line.indexOf("ORBITAL") >= 0;
        if (this.isNewFormat) {
            this.orbitalData = new Lst();
            if (this.line.length() > 10) {
                this.orbitalInfo = new Lst();
            }
        } else {
            fArray = new float[this.nCoefficients][this.nCoefficients];
        }
        int n2 = 0;
        while (n2 < this.nCoefficients) {
            float[] fArray2;
            if (n2 != 0) {
                this.rd();
            }
            if (this.isNewFormat) {
                if (this.line == null || this.line.indexOf("ORBITAL") < 0 || this.line.indexOf("ORBITAL_LIST") >= 0) break;
                fArray2 = new float[this.nCoefficients];
                this.orbitalData.addLast(fArray2);
                if (this.orbitalInfo != null) {
                    this.orbitalInfo.addLast(this.line);
                }
                this.rd();
            } else {
                fArray2 = fArray[n2];
            }
            this.fillFloatArray(this.line, 15, fArray2);
            ++n2;
        }
        if (this.invMatrix == null) {
            if (this.isNewFormat && this.line.indexOf("MATRIX") < 0) {
                this.rd();
            }
            this.invMatrix = AU.newFloat2(this.nCoefficients);
            n2 = 0;
            while (n2 < this.nCoefficients) {
                this.invMatrix[n2] = new float[n2 + 1];
                this.fillFloatArray(null, 15, this.invMatrix[n2]);
                ++n2;
            }
        }
        int n3 = this.nOrbitals = this.orbitalData == null ? this.nCoefficients : this.orbitalData.size();
        if (this.orbitalData != null) {
            fArray = AU.newFloat2(this.nOrbitals);
            n2 = this.nOrbitals;
            while (--n2 >= 0) {
                fArray[n2] = (float[])this.orbitalData.get(n2);
            }
        }
        float[][] fArray3 = new float[this.nOrbitals][this.nCoefficients];
        int n4 = 0;
        while (n4 < this.nOrbitals) {
            n = 0;
            while (n < this.nCoefficients) {
                int n5 = 0;
                while (n5 < this.nCoefficients) {
                    float[] fArray4 = fArray3[n4];
                    int n6 = n;
                    fArray4[n6] = fArray4[n6] + fArray[n4][n5] * (n5 >= n ? this.invMatrix[n5][n] : this.invMatrix[n][n5]);
                    ++n5;
                }
                if (Math.abs(fArray3[n4][n]) < 1.0E-4f) {
                    fArray3[n4][n] = 0.0f;
                }
                ++n;
            }
            ++n4;
        }
        if (this.isNewFormat && this.orbitalInfo == null && this.line != null && this.line.indexOf("ORBITAL_LIST") < 0) {
            this.rd();
        }
        float[] fArray5 = new float[2];
        n = 0;
        while (n < this.nOrbitals) {
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            if (this.orbitalInfo != null) {
                this.line = (String)this.orbitalInfo.get(n);
                String[] stringArray = this.getTokens();
                hashtable.put("energy", Float.valueOf(this.parseFloatStr(stringArray[3])));
                hashtable.put("occupancy", Float.valueOf(this.parseFloatStr(stringArray[1])));
            } else if (this.rd() != null) {
                MopacGraphfReader.getTokensFloat(this.line, fArray5, 2);
                hashtable.put("energy", Float.valueOf(fArray5[0]));
                hashtable.put("occupancy", Float.valueOf(fArray5[1]));
            }
            hashtable.put("coefficients", fArray3[n]);
            if (bl) {
                hashtable.put("type", "beta");
            }
            this.line = "\n";
            if (this.filterMO()) {
                this.setMO(hashtable);
            }
            ++n;
        }
        this.setMOs("eV");
    }

    private boolean readKeywords() throws Exception {
        boolean bl;
        if (this.rd() == null || this.line.indexOf(" Keywords:") < 0) {
            return false;
        }
        this.calculationType = this.line.substring(11).trim();
        this.moData.put("calculationType", this.calculationType);
        boolean bl2 = bl = this.line.indexOf("UHF") >= 0;
        if (bl) {
            int n = this.orbitals.size();
            while (--n >= 0) {
                ((Map)this.orbitals.get(n)).put("type", "alpha");
            }
        }
        return bl;
    }
}

