/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.quantum;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.SB;
import org.jmol.adapter.readers.quantum.BasisFunctionReader;
import org.jmol.adapter.readers.quantum.MoldenReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.api.JmolAdapter;
import org.jmol.util.Logger;
import org.qcschema.QCSchemaUnits;

public class QCJSONReader
extends MoldenReader {
    private Map<String, Object> job;
    private int jobCount;
    private int modelCount;
    private boolean haveEnergy = true;
    String lastBasisID = null;

    @Override
    protected void initializeReader() {
        super.initializeReader();
        SB sB = new SB();
        try {
            while (this.rd() != null) {
                sB.append(this.line);
            }
            Lst<Object> lst = this.vwr.parseJSONArray(sB.toString());
            Logger.info(lst.get(0).toString());
            this.jobCount = lst.size() - 2;
            int n = 0;
            while (n < this.jobCount) {
                this.processJob((Map)lst.get(n + 2));
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.continuing = false;
    }

    private void processJob(Map<String, Object> map) throws Exception {
        this.job = map;
        this.readSteps();
    }

    @Override
    public void finalizeSubclassReader() throws Exception {
        this.finalizeReaderASCR();
    }

    private void readSteps() throws Exception {
        ArrayList<Object> arrayList = QCSchemaUnits.getList(this.job, "steps");
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < n) {
            if (!this.doGetModel(++this.modelCount, null)) {
                if (!this.checkLastModel()) {
                    return;
                }
            } else {
                int n3;
                this.asc.newAtomSet();
                Map map = (Map)arrayList.get(n2);
                Map<String, Object> map2 = QCJSONReader.getMapSafely(map, "topology");
                Map<String, Object> map3 = QCJSONReader.getMapSafely(map2, "atoms");
                String[] stringArray = QCSchemaUnits.getStringArray(map3, "symbol");
                int[] nArray = QCSchemaUnits.getIntArray(map3, "atom_number");
                String[] stringArray2 = QCSchemaUnits.getStringArray(map3, "atom_names");
                double[] dArray = QCSchemaUnits.getDoubleArray(map3, "coords");
                this.modelAtomCount = dArray.length / 3;
                double d = QCSchemaUnits.getConversionFactor(map3, "coords", "angstroms");
                boolean bl = d == 0.0;
                this.setFractionalCoordinates(bl);
                if (bl) {
                    d = QCSchemaUnits.getConversionFactor(map3, "unit_cell", "angstroms");
                    double[] dArray2 = QCSchemaUnits.getDoubleArray(map3, "unit_cell");
                    if (dArray2 == null) {
                        Logger.error("topology.unit_cell is missing even though atoms are listed as fractional");
                    } else {
                        n3 = 0;
                        while (n3 < 6) {
                            switch (n3) {
                                case 3: {
                                    d = 1.0;
                                }
                            }
                            this.setUnitCellItem(n3, (float)(dArray2[n3] * d));
                            ++n3;
                        }
                    }
                }
                int n4 = 0;
                n3 = 0;
                while (n4 < this.modelAtomCount) {
                    Atom atom = this.asc.addNewAtom();
                    this.setAtomCoordXYZ(atom, (float)(dArray[n3++] * d), (float)(dArray[n3++] * d), (float)(dArray[n3++] * d));
                    String string = stringArray == null ? JmolAdapter.getElementSymbol(nArray[n4]) : stringArray[n4];
                    atom.atomName = stringArray2 == null ? string : stringArray2[n4];
                    atom.elementNumber = (short)(nArray == null ? JmolAdapter.getElementNumber(string) : nArray[n4]);
                    ++n4;
                }
                if (this.doReadMolecularOrbitals) {
                    this.readMolecularOrbitals(QCJSONReader.getMapSafely(map, "molecular_orbitals"));
                    this.clearOrbitals();
                }
                this.applySymmetryAndSetTrajectory();
                if (this.loadVibrations) {
                    this.readFreqsAndModes(QCSchemaUnits.getList(map, "vibrations"));
                }
            }
            ++n2;
        }
    }

    private boolean readFreqsAndModes(ArrayList<Object> arrayList) throws Exception {
        if (arrayList != null) {
            int n = arrayList.size();
            int n2 = 0;
            while (n2 < n) {
                if (this.doGetVibration(++this.vibrationNumber)) {
                    Map map = (Map)arrayList.get(n2);
                    double d = QCSchemaUnits.getDouble(map, "frequency", "cm-1");
                    double[] dArray = QCSchemaUnits.getDoubleArray(map, "vectors");
                    if (n2 > 0) {
                        this.asc.cloneLastAtomSet();
                    }
                    this.asc.setAtomSetFrequency(this.vibrationNumber, null, null, "" + d, "cm-1");
                    int n3 = this.asc.getLastAtomSetAtomIndex();
                    int n4 = 0;
                    int n5 = 0;
                    while (n4 < this.modelAtomCount) {
                        this.asc.addVibrationVector(n4 + n3, (float)(dArray[n5++] * 0.529177188873291), (float)(dArray[n5++] * 0.529177188873291), (float)(dArray[n5++] * 0.529177188873291));
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        return true;
    }

    private boolean readMolecularOrbitals(Map<String, Object> map) throws Exception {
        ArrayList<Object> arrayList;
        Map map2;
        if (map == null) {
            return false;
        }
        String string = map.get("basis_id").toString();
        if (!this.readBasis(string)) {
            return false;
        }
        Boolean bl = (Boolean)map.get("__jmol_normalized");
        if (bl != null && bl.booleanValue()) {
            this.moData.put("isNormalized", bl);
        }
        this.calculationType = (String)map.get("__jmol_calculation_type");
        if (this.calculationType == null) {
            this.calculationType = "?";
        }
        this.moData.put("calculationType", this.calculationType);
        ArrayList<Object> arrayList2 = QCSchemaUnits.getList(map, "orbitals");
        int n = arrayList2.size();
        int n2 = 0;
        while (n2 < n) {
            map2 = (Map)arrayList2.get(n2);
            double d = QCSchemaUnits.getDouble(map2, "energy", "ev");
            double d2 = QCSchemaUnits.getDouble(map2, "occupancy", null);
            String string2 = (String)map2.get("symmetry");
            String string3 = (String)map2.get("type");
            if (string3 != null) {
                if (string3.indexOf("beta") >= 0) {
                    this.alphaBeta = "beta";
                } else if (string3.indexOf("alpha") >= 0) {
                    this.alphaBeta = "alpha";
                }
            }
            float[] fArray = this.toFloatArray(QCSchemaUnits.getDoubleArray(map2, "coefficients"));
            this.line = string2;
            if (this.filterMO()) {
                Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
                hashtable.put("coefficients", fArray);
                if (Double.isNaN(d)) {
                    this.haveEnergy = false;
                } else {
                    hashtable.put("energy", Float.valueOf((float)d));
                }
                if (!Double.isNaN(d2)) {
                    hashtable.put("occupancy", Float.valueOf((float)d2));
                }
                if (string2 != null) {
                    hashtable.put("symmetry", string2);
                }
                if (this.alphaBeta.length() > 0) {
                    hashtable.put("type", this.alphaBeta);
                }
                this.setMO(hashtable);
                if (this.debugging) {
                    Logger.debug(String.valueOf(fArray.length) + " coefficients in MO " + this.orbitals.size());
                }
            }
            ++n2;
        }
        if (this.debugging) {
            Logger.debug("read " + this.orbitals.size() + " MOs");
        }
        map2 = (arrayList = QCSchemaUnits.getList(map, "orbitals_energy_units")) == null ? null : arrayList.get(0).toString();
        this.setMOs((String)(map2 == null || ((String)((Object)map2)).equals("?") ? "?" : map2));
        if (this.haveEnergy && this.doSort) {
            this.sortMOs();
        }
        return false;
    }

    private float[] toFloatArray(double[] dArray) {
        float[] fArray = new float[dArray.length];
        int n = dArray.length;
        while (--n >= 0) {
            fArray[n] = (float)dArray[n];
        }
        return fArray;
    }

    private boolean readBasis(String string) throws Exception {
        Map<String, Object> map = QCJSONReader.getMapSafely(this.job, "mo_bases");
        Map<String, Object> map2 = QCJSONReader.getMapSafely(map, string);
        if (map2 == null) {
            Logger.error("No job.mo_bases entry for " + string);
            return false;
        }
        if (string == this.lastBasisID) {
            return true;
        }
        this.lastBasisID = string;
        ArrayList<Object> arrayList = QCSchemaUnits.getList(map2, "gaussians");
        ArrayList<Object> arrayList2 = QCSchemaUnits.getList(map2, "shells");
        if (arrayList == null && arrayList2 == null) {
            arrayList = arrayList2 = QCSchemaUnits.getList(map2, "slaters");
        }
        if (arrayList == null != (arrayList2 == null)) {
            Logger.error("gaussians/shells or slaters missing");
            return false;
        }
        if (arrayList == arrayList2) {
            this.readSlaterBasis(arrayList2);
        } else {
            this.readGaussianBasis(arrayList, arrayList2);
        }
        return true;
    }

    boolean readSlaterBasis(ArrayList<Object> arrayList) throws Exception {
        this.nCoef = arrayList.size();
        int n = 0;
        while (n < this.nCoef) {
            double[] dArray = QCSchemaUnits.getDoubleArray(arrayList.get(n), null);
            this.addSlater((int)dArray[0], (int)dArray[1], (int)dArray[2], (int)dArray[3], (int)dArray[4], (float)dArray[5], (float)dArray[6]);
            ++n;
        }
        this.setSlaters(false, false);
        return true;
    }

    private boolean readGaussianBasis(ArrayList<Object> arrayList, ArrayList<Object> arrayList2) throws Exception {
        this.shells = new Lst();
        int n = 0;
        while (n < arrayList2.size()) {
            this.shells.addLast(QCSchemaUnits.getIntArray(arrayList2.get(n), null));
            ++n;
        }
        n = arrayList.size();
        float[][] fArray = AU.newFloat2(n);
        int n2 = 0;
        while (n2 < n) {
            fArray[n2] = this.toFloatArray(QCSchemaUnits.getDoubleArray(arrayList.get(n2), null));
            ++n2;
        }
        this.moData.put("shells", this.shells);
        this.moData.put("gaussians", fArray);
        Logger.info(String.valueOf(this.shells.size()) + " slater shells read");
        Logger.info(String.valueOf(fArray.length) + " gaussian primitives read");
        this.asc.setCurrentModelInfo("moData", this.moData);
        return false;
    }

    private void sortMOs() {
        Object[] objectArray = this.orbitals.toArray(new Object[this.orbitals.size()]);
        Arrays.sort(objectArray, new BasisFunctionReader.MOEnergySorter());
        this.orbitals.clear();
        int n = 0;
        while (n < objectArray.length) {
            this.orbitals.addLast((Map)objectArray[n]);
            ++n;
        }
    }

    private static Map<String, Object> getMapSafely(Map<String, Object> map, String string) {
        return map == null ? null : (Map)map.get(string);
    }
}

