/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.simple;

import javajs.util.PT;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;

public class GhemicalMMReader
extends AtomSetCollectionReader {
    @Override
    protected boolean checkLine() throws Exception {
        if (this.line.startsWith("!Header")) {
            this.processHeader();
            return true;
        }
        if (this.line.startsWith("!Info")) {
            this.processInfo();
            return true;
        }
        if (this.line.startsWith("!Atoms")) {
            this.processAtoms();
            return true;
        }
        if (this.line.startsWith("!Bonds")) {
            this.processBonds();
            return true;
        }
        if (this.line.startsWith("!Coord")) {
            this.processCoord();
            return true;
        }
        if (this.line.startsWith("!Charges")) {
            this.processCharges();
            return true;
        }
        return true;
    }

    void processHeader() {
    }

    void processInfo() {
    }

    void processAtoms() throws Exception {
        int n = this.parseIntAt(this.line, 6);
        int n2 = 0;
        while (n2 < n) {
            if (this.asc.ac != n2) {
                throw new Exception("GhemicalMMReader error #1");
            }
            this.rd();
            int n3 = this.parseIntStr(this.line);
            if (n3 != n2) {
                throw new Exception("bad atom index in !Atomsexpected: " + n2 + " saw:" + n3);
            }
            int n4 = this.parseInt();
            Atom atom = this.asc.addNewAtom();
            atom.elementNumber = (short)n4;
            ++n2;
        }
    }

    void processBonds() throws Exception {
        int n = this.parseIntAt(this.line, 6);
        int n2 = 0;
        while (n2 < n) {
            this.rd();
            int n3 = this.parseIntStr(this.line);
            int n4 = this.parseInt();
            String string = this.parseToken();
            int n5 = 0;
            switch (string.charAt(0)) {
                case 'C': {
                    n5 = 515;
                    break;
                }
                case 'T': {
                    n5 = 3;
                    break;
                }
                case 'D': {
                    n5 = 2;
                    break;
                }
                default: {
                    n5 = 1;
                }
            }
            this.asc.addNewBondWithOrder(n3, n4, n5);
            ++n2;
        }
    }

    void processCoord() throws Exception {
        Atom[] atomArray = this.asc.atoms;
        int n = this.asc.ac;
        int n2 = 0;
        while (n2 < n) {
            this.setAtomCoordScaled(atomArray[n2], PT.getTokens(this.rd()), 1, 10.0f);
            ++n2;
        }
    }

    void processCharges() throws Exception {
        Atom[] atomArray = this.asc.atoms;
        int n = this.asc.ac;
        int n2 = 0;
        while (n2 < n) {
            this.rd();
            int n3 = this.parseIntStr(this.line);
            if (n3 != n2) {
                throw new Exception("bad atom index in !Chargesexpected: " + n2 + " saw:" + n3);
            }
            atomArray[n2].partialCharge = this.parseFloat();
            ++n2;
        }
    }
}

