/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xtal;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.V3;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Bond;
import org.jmol.util.Logger;

public class CgdReader
extends AtomSetCollectionReader {
    private boolean noBondSym;
    private String[] tokens;
    private Map<Atom, V3[]> htEdges;
    private String lastName;
    private Lst<String> edgeData;
    private static final String SG_ALIASES = ";P2=P121;P21=P1211;C2=C121;A2=A121;I2=I121;Pm=P1m1;Pc=P1c1;Pn=P1n1;Pa=P1a1;Cm=C1m1;Am=A1m1;Im=I1m1;Cc=C1c1;An=A1n1;Ia=I1a1;Aa=A1a1;Cn=C1n1;Ic=I1c1;P2/m=P12/m1;P21/m=P121/m1;C2/m=C12/m1;A2/m=A12/m1;I2/m=I12/m1;P2/c=P12/c1;P2/n=P12/n1;P2/a=P12/a1;P21/c=P121/c1;P21/n=P121/n1;P21/a=P121/a1;C2/c=C12/c1;A2/n=A12/n1;I2/a=I12/a1;A2/a=A12/a1;C2/n=C12/n1;I2/c=I12/c1;Pm3=Pm-3;Pn3=Pn-3;Fm3=Fm-3;Fd3=Fd-3;Im3=Im-3;Pa3=Pa-3;Ia3=Ia-3;Pm3m=Pm-3m;Pn3n=Pn-3n;Pm3n=Pm-3n;Pn3m=Pn-3m;Fm3m=Fm-3m;Fm3c=Fm-3c;Fd3m=Fd-3m;Fd3c=Fd-3c;Im3m=Im-3m;Ia3d=Ia-3d;";
    private static final V3[] vecs;

    static {
        V3[] v3Array = new V3[15];
        v3Array[0] = V3.new3(0.0f, 0.0f, -1.0f);
        v3Array[1] = V3.new3(1.0f, 0.0f, -1.0f);
        v3Array[3] = V3.new3(0.0f, 1.0f, -1.0f);
        v3Array[4] = V3.new3(0.0f, -1.0f, 0.0f);
        v3Array[5] = V3.new3(1.0f, -1.0f, 0.0f);
        v3Array[6] = V3.new3(-1.0f, 0.0f, 0.0f);
        v3Array[8] = V3.new3(1.0f, 0.0f, 0.0f);
        v3Array[9] = V3.new3(-1.0f, 1.0f, 0.0f);
        v3Array[10] = V3.new3(0.0f, 1.0f, 0.0f);
        v3Array[11] = V3.new3(0.0f, -1.0f, 1.0f);
        v3Array[13] = V3.new3(-1.0f, 0.0f, 1.0f);
        v3Array[14] = V3.new3(0.0f, 0.0f, 1.0f);
        vecs = v3Array;
    }

    @Override
    public void initializeReader() {
        this.setFractionalCoordinates(true);
        this.asc.setNoAutoBond();
        this.asc.vibScale = 1;
        this.forceSymmetry(!this.checkFilterKey("NOPACK"));
        this.noBondSym = this.checkFilterKey("NOBONDSYM");
    }

    @Override
    protected boolean checkLine() throws Exception {
        this.line = this.line.trim();
        if (this.line.length() == 0 || this.line.startsWith("#")) {
            return true;
        }
        if (!Character.isLetter(this.line.charAt(0))) {
            this.line = String.valueOf(this.lastName) + " " + this.line;
        }
        this.tokens = this.getTokens();
        if (this.tokens.length > 0) {
            this.lastName = this.tokens[0].toUpperCase();
            int n = "NAME |CELL |GROUP|ATOM |EDGE |".indexOf(this.lastName);
            if (this.tokens.length > 1 && (n == 0 || this.doProcessLines)) {
                switch (n) {
                    case 0: {
                        if (!this.doGetModel(++this.modelNumber, null)) {
                            return this.checkLastModel();
                        }
                        this.applySymmetryAndSetTrajectory();
                        this.setFractionalCoordinates(true);
                        this.asc.newAtomSet();
                        this.asc.setAtomSetName(this.line.substring(6).trim());
                        this.htEdges = null;
                        this.edgeData = null;
                        break;
                    }
                    case 6: {
                        int n2 = 0;
                        while (n2 < 6) {
                            this.setUnitCellItem(n2, (float)(n2 < 3 ? 10 : 1) * this.parseFloatStr(this.tokens[n2 + 1]));
                            ++n2;
                        }
                        break;
                    }
                    case 12: {
                        this.setSpaceGroupName("bilbao:" + this.group(this.tokens[1]));
                        break;
                    }
                    case 18: {
                        this.atom();
                        break;
                    }
                    case 24: {
                        if (!this.doApplySymmetry) break;
                        if (this.edgeData == null) {
                            this.edgeData = new Lst();
                        }
                        this.edgeData.addLast(this.line);
                    }
                }
            }
        }
        return true;
    }

    private String group(String string) {
        int n;
        String string2 = null;
        if (string.charAt(0) == '\"') {
            string = string.substring(1, string.length() - 1);
        }
        if ((n = SG_ALIASES.indexOf(";" + string + "=")) >= 0) {
            string2 = string;
            string = SG_ALIASES.substring(SG_ALIASES.indexOf("=", n) + 1, SG_ALIASES.indexOf(";", n + 1));
        }
        Logger.info("CgdReader using GROUP " + string + (string2 == null ? "" : " alias of " + string2));
        return string;
    }

    private void atom() {
        String string = this.getName(this.tokens[1]);
        int n = this.parseIntStr(this.tokens[2]);
        int n2 = 3;
        while (n2 < 6) {
            if (this.tokens[n2].indexOf("/") >= 0) {
                this.tokens[n2] = "" + PT.parseFloatFraction(this.tokens[n2]);
            }
            ++n2;
        }
        Atom atom = this.addAtomXYZSymName(this.tokens, 3, null, string);
        if (!this.doApplySymmetry) {
            return;
        }
        this.asc.atomSymbolicMap.put(string, atom);
        this.asc.addVibrationVector(atom.index, 1.0f, 3.0f, 7.0f);
        if (this.htEdges == null) {
            this.htEdges = new Hashtable<Atom, V3[]>();
        }
        this.htEdges.put(atom, new V3[n]);
    }

    private String getName(String string) {
        return string.charAt(0) == '\"' ? string.substring(1, string.length() - 1) : (Character.isDigit(string.charAt(0)) ? "C" + string : string);
    }

    @Override
    public void finalizeSubclassReader() throws Exception {
        this.finalizeReaderASCR();
        if (this.doApplySymmetry) {
            this.finalizeNet();
        }
    }

    private void finalizeEdges() {
        int n = 0;
        while (n < this.edgeData.size()) {
            block8: {
                P3 p3;
                V3[] v3Array;
                this.line = (String)this.edgeData.get(n);
                this.tokens = PT.getTokens(this.line);
                switch (this.tokens.length) {
                    case 3: {
                        String string = this.getName(this.tokens[1]);
                        Atom atom = this.asc.getAtomFromName(string);
                        v3Array = this.htEdges.get(atom);
                        p3 = this.asc.getAtomFromName(this.getName(this.tokens[2]));
                        break;
                    }
                    case 5: {
                        String string = this.getName(this.tokens[1]);
                        Atom atom = this.asc.getAtomFromName(string);
                        v3Array = this.htEdges.get(atom);
                        p3 = this.getCoord(2);
                        break;
                    }
                    case 7: {
                        v3Array = this.htEdges.get(this.findAtom(this.getCoord(1)));
                        p3 = this.getCoord(4);
                        break;
                    }
                    default: {
                        Logger.error("EDGE record skipped: " + this.line);
                        break block8;
                    }
                }
                int n2 = 0;
                int n3 = v3Array.length;
                while (n2 < n3) {
                    if (v3Array[n2] == null) {
                        v3Array[n2] = V3.newV(p3);
                        break;
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }

    private P3 getCoord(int n) {
        return P3.new3(PT.parseFloatFraction(this.tokens[n++]), PT.parseFloatFraction(this.tokens[n++]), PT.parseFloatFraction(this.tokens[n++]));
    }

    private void finalizeNet() {
        this.finalizeEdges();
        M3 m3 = new M3();
        P3 p3 = new P3();
        int n = 0;
        int n2 = this.asc.ac;
        while (n < n2) {
            V3[] v3Array;
            Atom atom = this.asc.atoms[n];
            Atom atom2 = this.asc.atoms[atom.atomSite];
            if (!(this.noBondSym && atom != atom2 || (v3Array = this.htEdges.get(atom2)) == null)) {
                int n3 = (int)atom.vib.x + 7;
                int n4 = (int)atom.vib.y + 7;
                int n5 = (int)atom.vib.z + 7;
                m3.setRowV(0, vecs[n3]);
                m3.setRowV(1, vecs[n4]);
                m3.setRowV(2, vecs[n5]);
                int n6 = 0;
                int n7 = v3Array.length;
                while (n6 < n7) {
                    p3.sub2(v3Array[n6], atom2);
                    m3.rotate(p3);
                    p3.add(atom);
                    Atom atom3 = this.findAtom(p3);
                    if (atom3 != null) {
                        this.asc.addBond(new Bond(atom.index, atom3.index, 1));
                    } else if (p3.x >= 0.0f && p3.x <= 1.0f && p3.y >= 0.0f && p3.y <= 1.0f && p3.z >= 0.0f && p3.z <= 1.0f) {
                        Logger.error(" not found: i=" + n + "  pt=" + p3 + " for a=" + atom + "\n a0=" + atom2 + " edge[" + n6 + "]=" + v3Array[n6] + "\n a.vib=" + atom.vib + "\n m=" + m3);
                    }
                    ++n6;
                }
                atom.vib = null;
            }
            ++n;
        }
    }

    private Atom findAtom(P3 p3) {
        int n = this.asc.ac;
        while (--n >= 0) {
            if (!(this.asc.atoms[n].distanceSquared(p3) < 1.0E-5f)) continue;
            return this.asc.atoms[n];
        }
        return null;
    }
}

