/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.i18n;

import org.jmol.i18n.GT;

public class Language {
    public final String code;
    public final String language;
    public final String nativeLanguage;
    public boolean display;

    public static Language[] getLanguageList() {
        return new Language[]{new Language("ar", GT.$("Arabic"), "\u0627\u0644\u0639\u0631\u0628\u064a\u0629", false), new Language("ast", GT.$("Asturian"), "Asturian", false), new Language("az", GT.$("Azerbaijani"), "az\u0259rbaycan dili", false), new Language("bs", GT.$("Bosnian"), "bosanski jezik", false), new Language("ca", GT.$("Catalan"), "Catal\u00e0", true), new Language("cs", GT.$("Czech"), "\u010ce\u0161tina", true), new Language("da", GT.$("Danish"), "Dansk", true), new Language("de", GT.$("German"), "Deutsch", true), new Language("el", GT.$("Greek"), "\u0395\u03bb\u03bb\u03b7\u03bd\u03b9\u03ba\u03ac", false), new Language("en_AU", GT.$("Australian English"), "Australian English", false), new Language("en_GB", GT.$("British English"), "British English", true), new Language("en_US", GT.$("American English"), "American English", true), new Language("es", GT.$("Spanish"), "Espa\u00f1ol", true), new Language("et", GT.$("Estonian"), "Eesti", false), new Language("eu", GT.$("Basque"), "Euskara", true), new Language("fi", GT.$("Finnish"), "Suomi", true), new Language("fo", GT.$("Faroese"), "F\u00f8royskt", false), new Language("fr", GT.$("French"), "Fran\u00e7ais", true), new Language("fy", GT.$("Frisian"), "Frysk", false), new Language("gl", GT.$("Galician"), "Galego", false), new Language("hr", GT.$("Croatian"), "Hrvatski", false), new Language("hu", GT.$("Hungarian"), "Magyar", true), new Language("hy", GT.$("Armenian"), "\u0540\u0561\u0575\u0565\u0580\u0565\u0576", false), new Language("id", GT.$("Indonesian"), "Indonesia", true), new Language("it", GT.$("Italian"), "Italiano", true), new Language("ja", GT.$("Japanese"), "\u65e5\u672c\u8a9e", true), new Language("jv", GT.$("Javanese"), "Basa Jawa", false), new Language("ko", GT.$("Korean"), "\ud55c\uad6d\uc5b4", true), new Language("ms", GT.$("Malay"), "Bahasa Melayu", true), new Language("nb", GT.$("Norwegian Bokmal"), "Norsk Bokm\u00e5l", false), new Language("nl", GT.$("Dutch"), "Nederlands", true), new Language("oc", GT.$("Occitan"), "Occitan", false), new Language("pl", GT.$("Polish"), "Polski", false), new Language("pt", GT.$("Portuguese"), "Portugu\u00eas", false), new Language("pt_BR", GT.$("Brazilian Portuguese"), "Portugu\u00eas brasileiro", true), new Language("ru", GT.$("Russian"), "\u0420\u0443\u0441\u0441\u043a\u0438\u0439", true), new Language("sl", GT.$("Slovenian"), "Sloven\u0161\u010dina", false), new Language("sr", GT.$("Serbian"), "\u0441\u0440\u043f\u0441\u043a\u0438 \u0458\u0435\u0437\u0438\u043a", false), new Language("sv", GT.$("Swedish"), "Svenska", true), new Language("ta", GT.$("Tamil"), "\u0ba4\u0bae\u0bbf\u0bb4\u0bcd", false), new Language("te", GT.$("Telugu"), "\u0c24\u0c46\u0c32\u0c41\u0c17\u0c41", false), new Language("tr", GT.$("Turkish"), "T\u00fcrk\u00e7e", true), new Language("ug", GT.$("Uyghur"), "Uy\u01a3urq\u0259", false), new Language("uk", GT.$("Ukrainian"), "\u0423\u043a\u0440\u0430\u0457\u043d\u0441\u044c\u043a\u0430", true), new Language("uz", GT.$("Uzbek"), "O'zbek", false), new Language("zh_CN", GT.$("Simplified Chinese"), "\u7b80\u4f53\u4e2d\u6587", true), new Language("zh_TW", GT.$("Traditional Chinese"), "\u7e41\u9ad4\u4e2d\u6587", true)};
    }

    private Language(String string, String string2, String string3, boolean bl) {
        this.code = string;
        this.language = string2;
        this.nativeLanguage = string3;
        this.display = bl;
    }

    static String getSupported(Language[] languageArray, String string) {
        int n = languageArray.length;
        while (--n >= 0) {
            if (!languageArray[n].code.equalsIgnoreCase(string)) continue;
            return languageArray[n].code;
        }
        n = languageArray.length;
        while (--n >= 0) {
            if (!languageArray[n].code.startsWith(string)) continue;
            return languageArray[n].code;
        }
        return null;
    }
}

