/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.io;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Map;
import javajs.api.GenericBinaryDocument;
import javajs.api.ZInputStream;
import javajs.util.AU;
import javajs.util.PT;
import javajs.util.Rdr;
import org.jmol.api.Interface;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;

public class FileReader {
    private final Viewer vwr;
    private String fileNameIn;
    private String fullPathNameIn;
    private String nameAsGivenIn;
    private String fileTypeIn;
    private Object atomSetCollection;
    private Object readerOrDocument;
    private Map<String, Object> htParams;
    private boolean isAppend;
    private Object bytesOrStream;

    public FileReader(Viewer viewer, String string, String string2, String string3, String string4, Object object, Map<String, Object> map, boolean bl) {
        this.vwr = viewer;
        this.fileNameIn = string == null ? string2 : string;
        this.fullPathNameIn = string2 == null ? this.fileNameIn : string2;
        this.nameAsGivenIn = string3 == null ? this.fileNameIn : string3;
        this.fileTypeIn = string4;
        if (object != null) {
            if (AU.isAB(object) || object instanceof BufferedInputStream) {
                this.bytesOrStream = object;
                object = null;
            } else if (object instanceof Reader && !(object instanceof BufferedReader)) {
                object = new BufferedReader((Reader)object);
            }
        }
        this.readerOrDocument = object;
        this.htParams = map;
        this.isAppend = bl;
    }

    public void run() {
        if (!this.isAppend && this.vwr.displayLoadErrors) {
            this.vwr.zap(false, true, false);
        }
        String string = null;
        Object object = null;
        if (this.fullPathNameIn.contains("#_DOCACHE_")) {
            this.readerOrDocument = FileReader.getChangeableReader(this.vwr, this.nameAsGivenIn, this.fullPathNameIn);
        }
        if (this.readerOrDocument == null) {
            object = this.vwr.fm.getUnzippedReaderOrStreamFromName(this.fullPathNameIn, this.bytesOrStream, true, false, false, true, this.htParams);
            if (object == null || object instanceof String) {
                String string2 = string = object == null ? "error opening:" + this.nameAsGivenIn : (String)object;
                if (!string.startsWith("NOTE:")) {
                    Logger.error("file ERROR: " + this.fullPathNameIn + "\n" + string);
                }
                this.atomSetCollection = string;
                return;
            }
            if (object instanceof BufferedReader) {
                this.readerOrDocument = object;
            } else if (object instanceof ZInputStream) {
                String string3 = this.fullPathNameIn;
                String[] stringArray = null;
                if ((string3 = string3.replace('\\', '/')).indexOf("|") >= 0 && !string3.endsWith(".zip")) {
                    stringArray = PT.split(string3, "|");
                    string3 = stringArray[0];
                }
                if (stringArray != null) {
                    this.htParams.put("subFileList", stringArray);
                }
                InputStream inputStream = (InputStream)object;
                String[] stringArray2 = this.vwr.fm.getZipDirectory(string3, true, true);
                this.atomSetCollection = object = this.vwr.fm.getJzu().getAtomSetCollectionOrBufferedReaderFromZip(this.vwr, inputStream, string3, stringArray2, this.htParams, 1, false);
                try {
                    inputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (object instanceof BufferedInputStream) {
            this.readerOrDocument = ((GenericBinaryDocument)Interface.getInterface("javajs.util.BinaryDocument", this.vwr, "file")).setStream((BufferedInputStream)object, !this.htParams.containsKey("isLittleEndian"));
        }
        if (this.readerOrDocument != null) {
            this.atomSetCollection = this.vwr.getModelAdapter().getAtomSetCollectionReader(this.fullPathNameIn, this.fileTypeIn, this.readerOrDocument, this.htParams);
            if (!(this.atomSetCollection instanceof String)) {
                this.atomSetCollection = this.vwr.getModelAdapter().getAtomSetCollection(this.atomSetCollection);
            }
            try {
                if (this.readerOrDocument instanceof BufferedReader) {
                    ((BufferedReader)this.readerOrDocument).close();
                } else if (this.readerOrDocument instanceof GenericBinaryDocument) {
                    ((GenericBinaryDocument)this.readerOrDocument).close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.atomSetCollection instanceof String) {
            return;
        }
        if (!this.isAppend && !this.vwr.displayLoadErrors) {
            this.vwr.zap(false, true, false);
        }
        this.vwr.fm.setFileInfo(new String[]{this.fullPathNameIn, this.fileNameIn, this.nameAsGivenIn});
    }

    static final BufferedReader getChangeableReader(Viewer viewer, String string, String string2) {
        return Rdr.getBR((String)viewer.getLigandModel(string, string2, "_file", null));
    }

    public Object getAtomSetCollection() {
        return this.atomSetCollection;
    }
}

