/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.V3;
import org.jmol.api.SymmetryInterface;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Model;
import org.jmol.modelset.ModelSet;
import org.jmol.modelsetbio.BioModel;
import org.jmol.viewer.Viewer;

public class Trajectory {
    private Viewer vwr;
    ModelSet ms;
    Lst<P3[]> steps;
    boolean isFractional = true;

    Trajectory set(Viewer viewer, ModelSet modelSet, Lst<P3[]> lst) {
        this.vwr = viewer;
        this.ms = modelSet;
        this.steps = lst;
        return this;
    }

    void setUnitCell(int n) {
        SymmetryInterface symmetryInterface = this.ms.getUnitCell(n);
        if (symmetryInterface != null && symmetryInterface.getCoordinatesAreFractional() && symmetryInterface.isSupercell()) {
            P3[] p3Array = (P3[])this.ms.trajectory.steps.get(n);
            int n2 = p3Array.length;
            while (--n2 >= 0) {
                if (p3Array[n2] == null) continue;
                symmetryInterface.toSupercell(p3Array[n2]);
            }
        }
    }

    void setModel(int n) {
        Model[] modelArray = this.ms.am;
        int n2 = modelArray[n].trajectoryBaseIndex;
        modelArray[n2].selectedTrajectory = n;
        this.isFractional = !this.ms.getMSInfoB("ignoreUnitCell");
        this.setAtomPositions(n2, n, (P3[])this.steps.get(n), null, 0.0f, this.ms.vibrationSteps == null ? null : (V3[])this.ms.vibrationSteps.get(n), this.isFractional);
        int n3 = this.vwr.am.cmi;
        if (n3 >= 0 && n3 != n && modelArray[n3].fileIndex == modelArray[n].fileIndex) {
            this.vwr.setCurrentModelIndexClear(n, false);
        }
    }

    private void setAtomPositions(int n, int n2, P3[] p3Array, P3[] p3Array2, float f, V3[] v3Array, boolean bl) {
        BS bS = new BS();
        V3 v3 = new V3();
        Model[] modelArray = this.ms.am;
        Atom[] atomArray = this.ms.at;
        int n3 = modelArray[n].firstAtomIndex;
        int n4 = n3 + this.ms.getAtomCountInModel(n);
        if (f == 0.0f) {
            int n5 = 0;
            int n6 = n3;
            while (n6 < n4 && n5 < p3Array.length) {
                atomArray[n6].mi = (short)n2;
                if (p3Array[n5] != null) {
                    if (bl) {
                        atomArray[n6].setFractionalCoordTo(p3Array[n5], true);
                    } else {
                        atomArray[n6].setT(p3Array[n5]);
                    }
                    if (this.ms.vibrationSteps != null) {
                        if (v3Array != null && v3Array[n5] != null) {
                            v3 = v3Array[n5];
                        }
                        this.ms.setVibrationVector(n6, v3);
                    }
                    bS.set(n6);
                }
                ++n6;
                ++n5;
            }
        } else {
            P3 p3 = new P3();
            int n7 = Math.min(p3Array.length, p3Array2.length);
            int n8 = 0;
            int n9 = n3;
            while (n9 < n4 && n8 < n7) {
                atomArray[n9].mi = (short)n2;
                if (p3Array[n8] != null && p3Array2[n8] != null) {
                    p3.sub2(p3Array2[n8], p3Array[n8]);
                    p3.scaleAdd2(f, p3, p3Array[n8]);
                    if (bl) {
                        atomArray[n9].setFractionalCoordTo(p3, true);
                    } else {
                        atomArray[n9].setT(p3);
                    }
                    bS.set(n9);
                }
                ++n9;
                ++n8;
            }
        }
        this.ms.initializeBspf();
        this.ms.validateBspfForModel(n, false);
        this.ms.recalculateLeadMidpointsAndWingVectors(n);
        this.ms.sm.notifyAtomPositionsChanged(n, bS, null);
        if (modelArray[n].hasRasmolHBonds) {
            ((BioModel)modelArray[n]).resetRasmolBonds(bS, 2);
        }
    }

    BS getModelsSelected() {
        BS bS = new BS();
        int n = this.ms.mc;
        while (--n >= 0) {
            int n2 = this.ms.am[n].selectedTrajectory;
            if (n2 < 0) continue;
            bS.set(n2);
            n = this.ms.am[n].trajectoryBaseIndex;
        }
        return bS;
    }

    void morph(int n, int n2, float f) {
        if (f == 0.0f) {
            this.ms.setTrajectory(n);
            return;
        }
        if (f == 1.0f) {
            this.ms.setTrajectory(n2);
            return;
        }
        int n3 = this.ms.am[n].trajectoryBaseIndex;
        this.ms.am[n3].selectedTrajectory = n;
        this.setAtomPositions(n3, n, (P3[])this.steps.get(n), (P3[])this.steps.get(n2), f, this.ms.vibrationSteps == null ? null : (V3[])this.ms.vibrationSteps.get(n), true);
        int n4 = this.vwr.am.cmi;
        if (n4 >= 0 && n4 != n && this.ms.am[n4].fileIndex == this.ms.am[n].fileIndex) {
            this.vwr.setCurrentModelIndexClear(n, false);
        }
    }

    void fixAtom(Atom atom) {
        short s = atom.mi;
        boolean bl = this.ms.unitCells != null && this.ms.unitCells[s].getCoordinatesAreFractional();
        P3 p3 = ((P3[])this.steps.get(s))[atom.i - this.ms.am[s].firstAtomIndex];
        p3.set(atom.x, atom.y, atom.z);
        if (bl) {
            this.ms.unitCells[s].toFractional(p3, true);
        }
    }

    public void getFractional(Atom atom, P3 p3) {
        atom.setFractionalCoordPt(p3, ((P3[])this.steps.get(atom.mi))[atom.i - this.ms.am[atom.mi].firstAtomIndex], true);
    }

    public String getState() {
        String string = "";
        int n = this.ms.mc;
        while (--n >= 0) {
            int n2 = this.ms.am[n].selectedTrajectory;
            if (n2 < 0) continue;
            string = " or " + this.ms.getModelNumberDotted(n2) + string;
            n = this.ms.am[n].trajectoryBaseIndex;
        }
        return string.length() > 0 ? (string = "set trajectory {" + string.substring(4) + "}") : "";
    }

    public boolean hasMeasure(int[] nArray) {
        if (nArray != null) {
            int n = 1;
            int n2 = nArray[0];
            while (n <= n2) {
                int n3 = nArray[n];
                if (n3 >= 0 && this.ms.am[this.ms.at[n3].mi].isTrajectory) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public void selectDisplayed(BS bS) {
        int n = this.ms.mc;
        while (--n >= 0) {
            if (!this.ms.am[n].isTrajectory || this.ms.at[this.ms.am[n].firstAtomIndex].mi == n) continue;
            bS.clear(n);
        }
    }

    public void getModelBS(int n, BS bS) {
        int n2 = this.ms.am[n].trajectoryBaseIndex;
        int n3 = this.ms.mc;
        while (--n3 >= n2) {
            if (this.ms.am[n3].trajectoryBaseIndex != n2) continue;
            bS.set(n3);
        }
    }

    public void setBaseModels(BS bS) {
        int n = this.ms.mc;
        while (--n >= 0) {
            if (!bS.get(n) || !this.ms.am[n].isTrajectory) continue;
            bS.set(this.ms.am[n].trajectoryBaseIndex);
        }
    }
}

