/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.V3;
import org.jmol.c.STR;
import org.jmol.modelsetbio.AlphaPolymer;
import org.jmol.modelsetbio.ProteinStructure;

public class Helix
extends ProteinStructure {
    Helix(AlphaPolymer alphaPolymer, int n, int n2, STR sTR) {
        this.setupPS(alphaPolymer, STR.HELIX, n, n2);
        this.subtype = sTR;
    }

    @Override
    public void calcAxis() {
        if (this.axisA != null) {
            return;
        }
        P3[] p3Array = new P3[this.nRes + 1];
        int n = 0;
        while (n <= this.nRes) {
            p3Array[n] = new P3();
            this.apolymer.getLeadMidPoint(this.monomerIndexFirst + n, p3Array[n]);
            ++n;
        }
        this.axisA = new P3();
        this.axisUnitVector = new V3();
        Measure.calcBestAxisThroughPoints(p3Array, this.axisA, this.axisUnitVector, this.vectorProjection, 4);
        this.axisB = P3.newP(p3Array[this.nRes]);
        Measure.projectOntoAxis(this.axisB, this.axisA, this.axisUnitVector, this.vectorProjection);
    }
}

