/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import javajs.util.BS;
import javajs.util.Eigen;
import javajs.util.M3;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.Quat;
import javajs.util.V3;
import org.jmol.util.EigenSort;
import org.jmol.util.Escape;

public class Tensor {
    private static final float ADP_FACTOR = (float)(Math.sqrt(0.5) / Math.PI);
    private static final float MAGNETIC_SUSCEPTIBILITY_FACTOR = 0.01f;
    private static final float INTERACTION_FACTOR = 0.04f;
    private static EigenSort tSort;
    public String id;
    public String type;
    public int iType = -1;
    private static final String KNOWN_TYPES = ";iso........;adp........;tls-u......;tls-r......;ms.........;efg........;isc........;charge.....;quadrupole.;raman......";
    public static final int TYPE_OTHER = -1;
    public static final int TYPE_ISO = 0;
    public static final int TYPE_ADP = 1;
    public static final int TYPE_TLS_U = 2;
    public static final int TYPE_TLS_R = 3;
    public static final int TYPE_MS = 4;
    public static final int TYPE_EFG = 5;
    public static final int TYPE_ISC = 6;
    public static final int TYPE_CHARGE = 7;
    public static final int TYPE_QUADRUPOLE = 8;
    public static final int TYPE_RAMAN = 9;
    public double[][] asymMatrix;
    public double[][] symMatrix;
    public V3[] eigenVectors;
    public float[] eigenValues;
    public float[] parBorU;
    public String altType;
    public boolean isIsotropic;
    public boolean forThermalEllipsoid;
    public int eigenSignMask = 7;
    private float typeFactor = 1.0f;
    private boolean sortIso;
    public int modelIndex;
    public int atomIndex1 = -1;
    public int atomIndex2 = -1;
    public boolean isModulated;
    public boolean isUnmodulated;
    private static final String infoList = ";.............;eigenvalues..;eigenvectors.;asymmatrix...;symmatrix....;value........;isotropy.....;anisotropy...;asymmetry....;eulerzyz.....;eulerzxz.....;quaternion...;indices......;string.......;type.........;id...........;span.........;skew.........";

    private static int getType(String string) {
        int n = string.indexOf("_");
        if (n >= 0) {
            string = string.substring(0, n);
        }
        return (n = KNOWN_TYPES.indexOf(";" + string.toLowerCase() + ".")) < 0 ? -1 : n / 11;
    }

    private static int getInfoIndex(String string) {
        if (string.charAt(0) != ';') {
            string = ";" + string + ".";
        }
        return infoList.indexOf(string) / 14;
    }

    public static boolean isFloatInfo(String string) {
        switch (Tensor.getInfoIndex(string)) {
            default: {
                return false;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 17: 
        }
        return true;
    }

    public Object getInfo(String string) {
        switch (Tensor.getInfoIndex(string)) {
            default: {
                Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
                Object[] objectArray = PT.getTokens(PT.replaceWithCharacter(infoList, ";.", ' ').trim());
                Arrays.sort(objectArray);
                int n = 0;
                while (n < objectArray.length) {
                    Object object = this.getInfo((String)objectArray[n]);
                    if (object != null) {
                        hashtable.put(objectArray[n], object);
                    }
                    ++n;
                }
                return hashtable;
            }
            case 1: {
                return this.eigenValues;
            }
            case 2: {
                P3[] p3Array = new P3[3];
                int n = 0;
                while (n < 3) {
                    p3Array[n] = P3.newP(this.eigenVectors[n]);
                    ++n;
                }
                return p3Array;
            }
            case 3: {
                if (this.asymMatrix == null) {
                    return null;
                }
                float[] fArray = new float[9];
                int n = 0;
                int n2 = 0;
                while (n2 < 3) {
                    int n3 = 0;
                    while (n3 < 3) {
                        fArray[n++] = (float)this.asymMatrix[n2][n3];
                        ++n3;
                    }
                    ++n2;
                }
                return M3.newA9(fArray);
            }
            case 4: {
                if (this.symMatrix == null) {
                    return null;
                }
                float[] fArray = new float[9];
                int n = 0;
                int n4 = 0;
                while (n4 < 3) {
                    int n5 = 0;
                    while (n5 < 3) {
                        fArray[n++] = (float)this.symMatrix[n4][n5];
                        ++n5;
                    }
                    ++n4;
                }
                return M3.newA9(fArray);
            }
            case 5: {
                return Float.valueOf(this.eigenValues[2]);
            }
            case 6: {
                return Float.valueOf(this.isotropy());
            }
            case 7: {
                return Float.valueOf(this.anisotropy());
            }
            case 8: {
                return Float.valueOf(this.asymmetry());
            }
            case 9: {
                return ((Quat)this.getInfo("quaternion")).getEulerZYZ();
            }
            case 10: {
                return ((Quat)this.getInfo("quaternion")).getEulerZXZ();
            }
            case 11: {
                return Quat.getQuaternionFrame(null, this.eigenVectors[0], this.eigenVectors[1]);
            }
            case 12: {
                return new int[]{this.modelIndex, this.atomIndex1, this.atomIndex2};
            }
            case 13: {
                return this.toString();
            }
            case 14: {
                return this.type;
            }
            case 15: {
                return this.id;
            }
            case 16: {
                return Float.valueOf(this.span());
            }
            case 17: 
        }
        return Float.valueOf(this.skew());
    }

    public float isotropy() {
        return (this.eigenValues[0] + this.eigenValues[1] + this.eigenValues[2]) / 3.0f;
    }

    public float span() {
        return Math.abs(this.eigenValues[2] - this.eigenValues[0]);
    }

    public float skew() {
        return this.span() == 0.0f ? 0.0f : 3.0f * (this.eigenValues[1] - this.isotropy()) / this.span();
    }

    public float anisotropy() {
        return this.eigenValues[2] - (this.eigenValues[0] + this.eigenValues[1]) / 2.0f;
    }

    public float reducedAnisotropy() {
        return this.anisotropy() * 2.0f / 3.0f;
    }

    public float asymmetry() {
        return this.span() == 0.0f ? 0.0f : (this.eigenValues[1] - this.eigenValues[0]) / this.reducedAnisotropy();
    }

    public Tensor copyTensor() {
        Tensor tensor = new Tensor();
        tensor.setType(this.type);
        tensor.eigenValues = this.eigenValues;
        tensor.eigenVectors = this.eigenVectors;
        tensor.asymMatrix = this.asymMatrix;
        tensor.symMatrix = this.symMatrix;
        tensor.eigenSignMask = this.eigenSignMask;
        tensor.modelIndex = this.modelIndex;
        tensor.atomIndex1 = this.atomIndex1;
        tensor.atomIndex2 = this.atomIndex2;
        tensor.parBorU = this.parBorU;
        tensor.id = this.id;
        return tensor;
    }

    public Tensor setFromAsymmetricTensor(double[][] dArray, String string, String string2) {
        double[][] dArray2 = new double[3][3];
        int n = 3;
        while (--n >= 0) {
            int n2 = 3;
            while (--n2 >= 0) {
                dArray2[n][n2] = dArray[n][n2];
            }
        }
        if (dArray2[0][1] != dArray2[1][0]) {
            double d = (dArray2[0][1] + dArray2[1][0]) / 2.0;
            dArray2[1][0] = d;
            dArray2[0][1] = d;
        }
        if (dArray2[1][2] != dArray2[2][1]) {
            double d = (dArray2[1][2] + dArray2[2][1]) / 2.0;
            dArray2[2][1] = d;
            dArray2[1][2] = d;
        }
        if (dArray2[0][2] != dArray2[2][0]) {
            double d = (dArray2[0][2] + dArray2[2][0]) / 2.0;
            dArray2[2][0] = d;
            dArray2[0][2] = d;
        }
        M3 m3 = new M3();
        float[] fArray = new float[9];
        int n3 = 0;
        int n4 = 0;
        while (n3 < 3) {
            int n5 = 0;
            while (n5 < 3) {
                fArray[n4++] = (float)dArray2[n3][n5];
                ++n5;
            }
            ++n3;
        }
        m3.setA(fArray);
        V3[] v3Array = new V3[3];
        float[] fArray2 = new float[3];
        new Eigen().setM(dArray2).fillFloatArrays(v3Array, fArray2);
        this.newTensorType(v3Array, fArray2, string, string2);
        this.asymMatrix = dArray;
        this.symMatrix = dArray2;
        this.id = string2;
        return this;
    }

    public Tensor setFromEigenVectors(V3[] v3Array, float[] fArray, String string, String string2, Tensor tensor) {
        float[] fArray2 = new float[3];
        V3[] v3Array2 = new V3[3];
        int n = 0;
        while (n < 3) {
            v3Array2[n] = V3.newV(v3Array[n]);
            fArray2[n] = fArray[n];
            ++n;
        }
        this.newTensorType(v3Array2, fArray2, string, string2);
        if (tensor != null) {
            this.isModulated = tensor.isModulated;
            this.isUnmodulated = tensor.isUnmodulated;
            this.parBorU = tensor.parBorU;
        }
        return this;
    }

    public Tensor setFromAxes(V3[] v3Array) {
        this.eigenValues = new float[3];
        this.eigenVectors = new V3[3];
        int n = 0;
        while (n < 3) {
            this.eigenVectors[n] = V3.newV(v3Array[n]);
            this.eigenValues[n] = v3Array[n].length();
            if (this.eigenValues[n] == 0.0f) {
                return null;
            }
            this.eigenVectors[n].normalize();
            ++n;
        }
        if (Math.abs(this.eigenVectors[0].dot(this.eigenVectors[1])) > 1.0E-4f || Math.abs(this.eigenVectors[1].dot(this.eigenVectors[2])) > 1.0E-4f || Math.abs(this.eigenVectors[2].dot(this.eigenVectors[0])) > 1.0E-4f) {
            return null;
        }
        this.setType("other");
        this.sortAndNormalize();
        return this;
    }

    public Tensor setFromThermalEquation(double[] dArray, String string) {
        this.eigenValues = new float[3];
        this.eigenVectors = new V3[3];
        this.id = string == null ? "coefs=" + Escape.eAD(dArray) : string;
        double[][] dArray2 = new double[3][3];
        dArray2[0][0] = dArray[0];
        dArray2[1][1] = dArray[1];
        dArray2[2][2] = dArray[2];
        double d = dArray[3] / 2.0;
        dArray2[1][0] = d;
        dArray2[0][1] = d;
        double d2 = dArray[4] / 2.0;
        dArray2[2][0] = d2;
        dArray2[0][2] = d2;
        double d3 = dArray[5] / 2.0;
        dArray2[2][1] = d3;
        dArray2[1][2] = d3;
        new Eigen().setM(dArray2).fillFloatArrays(this.eigenVectors, this.eigenValues);
        this.setType("adp");
        this.sortAndNormalize();
        return this;
    }

    public Tensor setType(String string) {
        if (this.type == null || string == null) {
            this.type = string;
        }
        if (string != null) {
            this.processType();
        }
        return this;
    }

    public float getFactoredValue(int n) {
        float f = Math.abs(this.eigenValues[n]);
        return (this.forThermalEllipsoid ? (float)Math.sqrt(f) : f) * this.typeFactor;
    }

    public void setAtomIndexes(int n, int n2) {
        this.atomIndex1 = n;
        this.atomIndex2 = n2;
    }

    public boolean isSelected(BS bS, int n) {
        return n >= 0 ? this.atomIndex1 == n || this.atomIndex2 == n : bS.get(this.atomIndex1) && (this.atomIndex2 < 0 || bS.get(this.atomIndex2));
    }

    private void newTensorType(V3[] v3Array, float[] fArray, String string, String string2) {
        this.eigenValues = fArray;
        this.eigenVectors = v3Array;
        int n = 0;
        while (n < 3) {
            this.eigenVectors[n].normalize();
            ++n;
        }
        this.setType(string);
        this.id = string2;
        this.sortAndNormalize();
        this.eigenSignMask = (this.eigenValues[0] >= 0.0f ? 1 : 0) + (this.eigenValues[1] >= 0.0f ? 2 : 0) + (this.eigenValues[2] >= 0.0f ? 4 : 0);
    }

    private void processType() {
        this.forThermalEllipsoid = false;
        this.isIsotropic = false;
        this.altType = null;
        this.typeFactor = 1.0f;
        this.sortIso = false;
        this.iType = Tensor.getType(this.type);
        switch (this.iType) {
            case 0: {
                this.forThermalEllipsoid = true;
                this.isIsotropic = true;
                this.altType = "1";
                this.type = "adp";
                break;
            }
            case 1: {
                this.forThermalEllipsoid = true;
                this.typeFactor = ADP_FACTOR;
                this.altType = "1";
                break;
            }
            case 4: {
                this.sortIso = true;
                this.typeFactor = 0.01f;
                break;
            }
            case 5: {
                this.sortIso = true;
                break;
            }
            case 6: {
                this.sortIso = true;
                this.typeFactor = 0.04f;
                break;
            }
            case 3: {
                this.altType = "2";
                break;
            }
            case 2: {
                this.altType = "3";
                break;
            }
        }
    }

    private void sortAndNormalize() {
        Object[] objectArray = new Object[]{new Object[]{V3.newV(this.eigenVectors[0]), Float.valueOf(this.eigenValues[0])}, new Object[]{V3.newV(this.eigenVectors[1]), Float.valueOf(this.eigenValues[1])}, new Object[]{V3.newV(this.eigenVectors[2]), Float.valueOf(this.eigenValues[2])}};
        Arrays.sort(objectArray, Tensor.getEigenSort());
        int n = 0;
        while (n < 3) {
            int n2 = n;
            this.eigenVectors[n] = (V3)((Object[])objectArray[n2])[0];
            this.eigenValues[n] = ((Float)((Object[])objectArray[n2])[1]).floatValue();
            ++n;
        }
        if (this.sortIso && this.eigenValues[2] - this.eigenValues[1] < this.eigenValues[1] - this.eigenValues[0]) {
            V3 v3 = this.eigenVectors[0];
            this.eigenVectors[0] = this.eigenVectors[2];
            this.eigenVectors[2] = v3;
            float f = this.eigenValues[0];
            this.eigenValues[0] = this.eigenValues[2];
            this.eigenValues[2] = f;
        }
        int n3 = 0;
        while (n3 < 3) {
            this.eigenVectors[n3].normalize();
            ++n3;
        }
    }

    public boolean isEquiv(Tensor tensor) {
        if (tensor.iType != this.iType) {
            return false;
        }
        float f = Math.abs(this.eigenValues[0] + this.eigenValues[1] + this.eigenValues[2]);
        int n = 0;
        while (n < 3) {
            if (Math.abs(tensor.eigenValues[n] - this.eigenValues[n]) / f > 3.0E-4f) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private static Comparator<? super Object> getEigenSort() {
        return tSort == null ? (tSort = new EigenSort()) : tSort;
    }

    public String toString() {
        return String.valueOf(this.type) + " " + this.modelIndex + " " + this.atomIndex1 + " " + this.atomIndex2 + "\n" + (this.eigenVectors == null ? "" + this.eigenValues[0] : this.eigenVectors[0] + "\t" + this.eigenValues[0] + "\t" + "\n" + this.eigenVectors[1] + "\t" + this.eigenValues[1] + "\t" + "\n" + this.eigenVectors[2] + "\t" + this.eigenValues[2] + "\t" + "\n");
    }
}

