/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.webexport;

import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.PT;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jmol.i18n.GT;
import org.jmol.util.Logger;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.Viewer;
import org.openscience.jmol.app.jmolpanel.GuiMap;
import org.openscience.jmol.app.jmolpanel.HelpDialog;
import org.openscience.jmol.app.webexport.ArrayListTransferHandler;
import org.openscience.jmol.app.webexport.JmolInstance;
import org.openscience.jmol.app.webexport.LogPanel;
import org.openscience.jmol.app.webexport.WebExport;
import org.openscience.jmol.app.webexport.Widgets;

abstract class WebPanel
extends JPanel
implements ActionListener,
ListSelectionListener,
ItemListener {
    protected String panelName;
    protected String htmlAppletTemplate;
    protected String listLabel;
    protected String appletInfoDivs;
    protected JSpinner appletSizeSpinnerW;
    protected JSpinner appletSizeSpinnerH;
    protected JSpinner appletSizeSpinnerP;
    private JScrollPane editorScrollPane;
    private JButton saveButton;
    private JButton viewButton;
    private JButton helpButton;
    private JButton addInstanceButton;
    private JButton deleteInstanceButton;
    private JButton showInstanceButton;
    private JTextField remoteAppletPath;
    private JTextField localAppletPath;
    private JTextField pageAuthorName;
    private JTextField webPageTitle;
    private JFileChooser fc;
    protected JList<JmolInstance> instanceList;
    protected Widgets theWidgets;
    protected int nWidgets;
    private Checkbox[] widgetCheckboxes;
    protected Viewer vwr;
    private int panelIndex;
    private WebPanel[] webPanels;
    private int errCount;
    private String htmlPath;

    abstract String getAppletDefs(int var1, String var2, StringBuilder var3, JmolInstance var4);

    abstract String fixHtml(String var1);

    abstract JPanel appletParamPanel();

    protected WebPanel(Viewer viewer, JFileChooser jFileChooser, WebPanel[] webPanelArray, int n) {
        this.vwr = viewer;
        this.fc = jFileChooser;
        this.webPanels = webPanelArray;
        this.panelIndex = n;
        this.theWidgets = new Widgets();
        this.nWidgets = this.theWidgets.widgetList.length;
        this.widgetCheckboxes = new Checkbox[this.nWidgets];
        this.remoteAppletPath = new JTextField(20);
        this.remoteAppletPath.addActionListener(this);
        this.remoteAppletPath.setText(WebExport.getAppletPath(true));
        this.localAppletPath = new JTextField(20);
        this.localAppletPath.addActionListener(this);
        this.localAppletPath.setText(WebExport.getAppletPath(false));
        this.pageAuthorName = new JTextField(20);
        this.pageAuthorName.addActionListener(this);
        this.pageAuthorName.setText(WebExport.getPageAuthorName());
        this.webPageTitle = new JTextField(20);
        this.webPageTitle.addActionListener(this);
        this.webPageTitle.setText(GT.$("A web page with JSmol objects"));
    }

    JPanel getPanel(int n, int n2) {
        this.instanceList = new JList(new DefaultListModel());
        this.instanceList.setSelectionMode(1);
        this.instanceList.setTransferHandler(new ArrayListTransferHandler(this));
        this.instanceList.setCellRenderer(new InstanceCellRenderer());
        this.instanceList.setDragEnabled(true);
        this.instanceList.setPreferredSize(new Dimension(350, 200));
        this.instanceList.addListSelectionListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.instanceList);
        jScrollPane.setPreferredSize(new Dimension(350, 200));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)new JLabel(this.listLabel), "North");
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.add((Component)new JLabel(GT.$("click and drag to reorder")), "South");
        this.addInstanceButton = new JButton(GT.$("Add present Jmol state as instance..."));
        this.addInstanceButton.addActionListener(this);
        JPanel jPanel2 = new JPanel();
        jPanel2.setMaximumSize(new Dimension(350, 50));
        this.deleteInstanceButton = new JButton(GT.$("Delete selected"));
        this.deleteInstanceButton.addActionListener(this);
        jPanel2.add(this.deleteInstanceButton);
        JPanel jPanel3 = this.appletParamPanel();
        jPanel3.setMaximumSize(new Dimension(350, 70));
        JPanel jPanel4 = new JPanel();
        jPanel4.add(this.addInstanceButton);
        jPanel4.setSize(300, 70);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout());
        jPanel5.add((Component)jPanel4, "North");
        jPanel5.add((Component)jPanel2, "South");
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout());
        jPanel6.add((Component)jPanel, "Center");
        jPanel6.add((Component)jPanel5, "South");
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new BorderLayout());
        jPanel7.setMinimumSize(new Dimension(350, 350));
        jPanel7.setMaximumSize(new Dimension(350, 1000));
        jPanel7.add((Component)jPanel3, "North");
        jPanel7.add((Component)jPanel6, "Center");
        jPanel7.setBorder(BorderFactory.createTitledBorder(GT.$("JSmol Instances:")));
        JPanel jPanel8 = new JPanel();
        jPanel8.setMinimumSize(new Dimension(150, 150));
        jPanel8.setLayout(new BoxLayout(jPanel8, 1));
        jPanel8.setBorder(BorderFactory.createTitledBorder(GT.$("Select widgets:")));
        int n3 = 0;
        while (n3 < this.nWidgets) {
            this.widgetCheckboxes[n3] = new Checkbox(this.theWidgets.widgetList[n3].name);
            this.widgetCheckboxes[n3].addItemListener(this);
            jPanel8.add(this.widgetCheckboxes[n3]);
            ++n3;
        }
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new BorderLayout());
        JPanel jPanel10 = this.getLeftPanel(n, n2);
        jPanel10.setMaximumSize(new Dimension(350, 1000));
        jPanel9.add((Component)jPanel10, "West");
        jPanel9.add((Component)jPanel7, "Center");
        jPanel9.add((Component)jPanel8, "East");
        this.enableButtons(this.instanceList);
        return jPanel9;
    }

    protected JList<JmolInstance> getInstanceList() {
        return this.instanceList;
    }

    private JPanel getLeftPanel(int n, int n2) {
        this.helpButton = new JButton(GT.$("Help/Instructions"));
        this.helpButton.addActionListener(this);
        String string = String.valueOf(this.panelName) + ".png";
        URL uRL = GuiMap.getResource(this, string);
        ImageIcon imageIcon = null;
        if (uRL != null) {
            imageIcon = new ImageIcon(uRL, GT.$("Cartoon of Page"));
        } else {
            System.err.println("Error Loading Page Cartoon Image " + string);
        }
        JLabel jLabel = new JLabel(imageIcon);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(String.valueOf(GT.$("Cartoon of Page")) + ":"));
        jPanel.add(jLabel);
        this.saveButton = new JButton(GT.$("Save HTML as..."));
        this.saveButton.addActionListener(this);
        this.viewButton = new JButton(GT.$("View HTML"));
        this.viewButton.addActionListener(this);
        JPanel jPanel2 = new JPanel();
        jPanel2.add(this.saveButton);
        jPanel2.add(this.viewButton);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.setBorder(BorderFactory.createTitledBorder(GT.$("Relative server path to JSmol.min.js:")));
        jPanel3.add((Component)this.remoteAppletPath, "North");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout());
        jPanel4.setBorder(BorderFactory.createTitledBorder(GT.$("Relative local path to JSmol.min.js:")));
        jPanel4.add((Component)this.localAppletPath, "North");
        JPanel jPanel5 = new JPanel();
        jPanel5.setBorder(BorderFactory.createTitledBorder(GT.$("Author (your name):")));
        jPanel5.add((Component)this.pageAuthorName, "North");
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout());
        jPanel6.setBorder(BorderFactory.createTitledBorder(GT.$("Browser window title for this web page:")));
        jPanel6.add((Component)this.webPageTitle, "North");
        jPanel6.add((Component)jPanel2, "South");
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new BorderLayout());
        jPanel7.add((Component)jPanel3, "North");
        jPanel7.add((Component)jPanel4, "South");
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new BorderLayout());
        jPanel8.add((Component)jPanel7, "North");
        jPanel8.add((Component)jPanel5, "Center");
        jPanel8.add((Component)jPanel6, "South");
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new BorderLayout());
        jPanel9.add((Component)this.helpButton, "North");
        jPanel9.add((Component)jPanel, "Center");
        jPanel9.add((Component)jPanel8, "South");
        return jPanel9;
    }

    int getInfoWidth() {
        return this.editorScrollPane.getWidth();
    }

    int getInfoHeight() {
        return this.editorScrollPane.getHeight();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        DefaultListModel defaultListModel = (DefaultListModel)this.instanceList.getModel();
        int[] nArray = this.instanceList.getSelectedIndices();
        if (nArray.length == 0) {
            return;
        }
        JmolInstance jmolInstance = (JmolInstance)defaultListModel.get(nArray[0]);
        Object object = itemEvent.getSource();
        int n = itemEvent.getStateChange();
        int n2 = 0;
        while (n2 < this.nWidgets) {
            if (object == this.widgetCheckboxes[n2]) {
                if (n == 1) {
                    jmolInstance.addWidget(n2);
                }
                if (n == 2) {
                    jmolInstance.deleteWidget(n2);
                }
            }
            ++n2;
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.helpButton) {
            HelpDialog helpDialog = new HelpDialog(WebExport.getFrame(), GuiMap.getHtmlResource(this, String.valueOf(this.panelName) + "_instructions"));
            helpDialog.setVisible(true);
            helpDialog.setDefaultCloseOperation(2);
            return;
        }
        if (actionEvent.getSource() == this.remoteAppletPath) {
            String string = this.remoteAppletPath.getText();
            WebExport.setAppletPath(string, true);
            return;
        }
        if (actionEvent.getSource() == this.localAppletPath) {
            String string = this.localAppletPath.getText();
            WebExport.setAppletPath(string, false);
            return;
        }
        if (actionEvent.getSource() == this.addInstanceButton) {
            JmolInstance jmolInstance;
            String string = this.instanceList.getSelectedIndices().length != 1 ? "" : this.getInstanceName(-1);
            String string2 = JOptionPane.showInputDialog(GT.$("Give the occurrence of JSmol a name:"), (Object)string);
            if (string2 == null || string2.length() == 0) {
                return;
            }
            DefaultListModel defaultListModel = (DefaultListModel)this.instanceList.getModel();
            int n = 300;
            int n2 = 300;
            if (this.appletSizeSpinnerH != null) {
                n = ((SpinnerNumberModel)this.appletSizeSpinnerW.getModel()).getNumber().intValue();
                n2 = ((SpinnerNumberModel)this.appletSizeSpinnerH.getModel()).getNumber().intValue();
            }
            if ((jmolInstance = JmolInstance.getInstance(this.vwr, string2, n, n2, this.nWidgets)) == null) {
                LogPanel.log(GT.$("Error creating new instance containing script(s) and image."));
                return;
            }
            int n3 = this.instanceList.getModel().getSize();
            while (--n3 >= 0) {
                if (this.getInstanceName(n3).equals(jmolInstance.name)) break;
            }
            String string3 = GT.$("added Instance {0}");
            if (n3 < 0) {
                n3 = defaultListModel.getSize();
                defaultListModel.addElement(jmolInstance);
                LogPanel.log(GT.o(string3, jmolInstance.name));
            } else {
                defaultListModel.setElementAt(jmolInstance, n3);
                LogPanel.log(GT.o(string3, jmolInstance.name));
            }
            this.instanceList.setSelectedIndex(n3);
            this.syncLists();
            return;
        }
        if (actionEvent.getSource() == this.deleteInstanceButton) {
            DefaultListModel defaultListModel = (DefaultListModel)this.instanceList.getModel();
            int[] nArray = this.instanceList.getSelectedIndices();
            int n = 0;
            while (n < nArray.length) {
                JmolInstance jmolInstance = (JmolInstance)defaultListModel.get(nArray[n]);
                try {
                    jmolInstance.delete();
                }
                catch (IOException iOException) {
                    LogPanel.log(iOException.getMessage());
                }
                ++n;
            }
            defaultListModel.removeRange(nArray[0], nArray[nArray.length - 1]);
            this.syncLists();
            return;
        }
        if (actionEvent.getSource() == this.showInstanceButton) {
            DefaultListModel defaultListModel = (DefaultListModel)this.instanceList.getModel();
            int[] nArray = this.instanceList.getSelectedIndices();
            if (nArray.length != 1) {
                return;
            }
            JmolInstance jmolInstance = (JmolInstance)defaultListModel.get(nArray[0]);
            this.vwr.evalStringQuiet(")" + jmolInstance.script);
            return;
        }
        if (actionEvent.getSource() == this.viewButton) {
            this.vwr.showUrl(this.htmlPath);
        } else if (actionEvent.getSource() == this.saveButton) {
            this.fc.setDialogTitle(GT.$("Select a folder to create or an HTML file to save"));
            int n = this.fc.showSaveDialog(this);
            if (n != 0) {
                return;
            }
            File file = this.fc.getSelectedFile();
            this.htmlPath = "file:///" + file.getAbsolutePath().replace('\\', '/');
            String string = null;
            this.errCount = 0;
            try {
                String string4 = this.remoteAppletPath.getText();
                WebExport.setAppletPath(string4, true);
                string4 = this.localAppletPath.getText();
                WebExport.setAppletPath(string4, false);
                String string5 = this.pageAuthorName.getText();
                WebExport.setWebPageAuthor(string5);
                string = this.fileWriter(file, this.instanceList);
                this.viewButton.setEnabled(true);
            }
            catch (IOException iOException) {
                LogPanel.log(iOException.getMessage());
                ++this.errCount;
            }
            if (string != null) {
                LogPanel.log(GT.o(GT.$("file {0} created"), string));
            } else {
                LogPanel.log(GT.$("Call to FileWriter unsuccessful."));
                ++this.errCount;
            }
            if (this.errCount > 0) {
                LogPanel.log(GT.$("Errors occurred during web page creation.  See Log Tab!"));
            }
            return;
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        JList jList = (JList)listSelectionEvent.getSource();
        if (jList.isSelectionEmpty()) {
            return;
        }
        if (jList.getMinSelectionIndex() != jList.getMaxSelectionIndex()) {
            return;
        }
        int n = jList.getSelectedIndex();
        JmolInstance jmolInstance = (JmolInstance)jList.getModel().getElementAt(n);
        int n2 = jmolInstance.width;
        int n3 = jmolInstance.height;
        if (this.appletSizeSpinnerW != null) {
            this.appletSizeSpinnerW.getModel().setValue(n2);
        }
        if (this.appletSizeSpinnerH != null) {
            this.appletSizeSpinnerH.getModel().setValue(n3);
        }
        this.vwr.evalStringQuiet(")" + jmolInstance.script);
        int n4 = 0;
        while (n4 < this.nWidgets) {
            this.widgetCheckboxes[n4].setState(jmolInstance.whichWidgets.get(n4));
            ++n4;
        }
    }

    String getInstanceName(int n) {
        JmolInstance jmolInstance;
        if (n < 0) {
            n = this.instanceList.getSelectedIndex();
        }
        return (jmolInstance = this.instanceList.getModel().getElementAt(n)) == null ? "" : jmolInstance.name;
    }

    String fileWriter(File file, JList<JmolInstance> jList) throws IOException {
        StringBuilder stringBuilder;
        String string;
        Object object;
        String string2;
        String string3 = file.getPath().replace('\\', '/');
        String string4 = file.getName();
        if (string4.indexOf(".htm") < 0) {
            File file2 = new File(String.valueOf(string3) + ".html");
            if (file2.exists()) {
                string4 = String.valueOf(string4) + ".html";
                file = file2;
            } else {
                file2 = new File(String.valueOf(string3) + ".htm");
                if (file2.exists()) {
                    string4 = String.valueOf(string4) + ".htm";
                    file = file2;
                }
            }
        }
        if (string4.indexOf(".htm") > 0) {
            string2 = string4;
            string3 = file.getParent();
            file = new File(string3);
            string4 = file.getName();
        } else {
            string2 = String.valueOf(string4) + ".html";
        }
        string3 = string3.replace('\\', '/');
        string2 = String.valueOf(string3) + "/" + string2;
        boolean bl = file.exists() && file.isDirectory() || file.mkdir();
        DefaultListModel defaultListModel = (DefaultListModel)jList.getModel();
        LogPanel.log("");
        if (bl) {
            Object object2;
            int n;
            Object object3;
            Object object4;
            Object object5;
            LogPanel.log(GT.o(GT.$("Using directory {0}"), string3));
            LogPanel.log("  " + GT.o(GT.$("adding {0}"), "support.js"));
            this.vwr.writeTextFile(String.valueOf(string3) + "/support.js", GuiMap.getResourceString(this, "support.js"));
            int n2 = 0;
            while (n2 < defaultListModel.getSize()) {
                Object object6;
                object5 = (JmolInstance)defaultListModel.getElementAt(n2);
                object4 = ((JmolInstance)object5).javaname;
                String string5 = ((JmolInstance)object5).script;
                LogPanel.log("  ...jmolApplet" + n2);
                LogPanel.log("      ..." + GT.o(GT.$("adding {0}"), String.valueOf(object4) + ".png"));
                ((JmolInstance)object5).movepict(string3);
                object3 = new Lst();
                object = this.localAppletPath.getText();
                if (((String)object).equals(".") || this.remoteAppletPath.getText().equals(".")) {
                    try {
                        object6 = this.jmolJarPath().substring(0, this.jmolJarPath().lastIndexOf("/"));
                        ((Lst)object3).addLast(String.valueOf(object6) + "/jsmol.zip");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        LogPanel.log(GT.$("There was an error in the text encoding so the path to jsmol.zip is unknown."));
                    }
                }
                FileManager.getFileReferences(string5, (Lst<String>)object3);
                object6 = new ArrayList();
                n = ((ArrayList)object3).size();
                int n3 = 0;
                while (n3 < n) {
                    object2 = this.copyBinaryFile((String)((ArrayList)object3).get(n3), string3);
                    ((ArrayList)object6).add(((String)object2).substring(((String)object2).lastIndexOf(47) + 1));
                    ++n3;
                }
                string5 = WebPanel.replaceQuotedStrings(string5, (ArrayList<String>)object3, (ArrayList<String>)object6);
                LogPanel.log("      ..." + GT.o(GT.$("adding {0}"), String.valueOf(object4) + ".spt"));
                this.vwr.writeTextFile(String.valueOf(string3) + "/" + (String)object4 + ".spt", string5);
                ++n2;
            }
            string = GuiMap.getResourceString(this, String.valueOf(this.panelName) + "_template");
            string = this.fixHtml(string);
            object5 = "";
            object4 = this.allSelectedWidgets();
            int n4 = 0;
            while (n4 < this.nWidgets) {
                if (((BS)object4).get(n4)) {
                    int n5;
                    object3 = this.theWidgets.widgetList[n4].getJavaScriptFileName();
                    if (!((String)object3).equalsIgnoreCase("none")) {
                        object5 = String.valueOf(object5) + "\n<script src=\"" + (String)object3 + "\" type=\"text/javascript\"></script>";
                        LogPanel.log("  " + GT.o(GT.$("adding {0}"), object3));
                        this.vwr.writeTextFile(String.valueOf(string3) + "/" + (String)object3, GuiMap.getResourceString(this, (String)object3));
                    }
                    if ((n5 = ((String[])(object = this.theWidgets.widgetList[n4].getSupportFileNames())).length) != 0) {
                        n = 0;
                        while (n < n5) {
                            URL uRL;
                            Object object7;
                            object2 = object7 = object[n];
                            if (((String)object7).lastIndexOf("/") != -1) {
                                object2 = ((String)object7).substring(((String)object7).lastIndexOf("/") + 1);
                            }
                            if ((uRL = GuiMap.getResource(this, (String)object7)) == null) {
                                LogPanel.log("    " + GT.o(GT.$("Unable to load resource {0}"), object7));
                                ++this.errCount;
                            } else {
                                InputStream inputStream = uRL.openConnection().getInputStream();
                                FileOutputStream fileOutputStream = new FileOutputStream(String.valueOf(string3) + "/" + (String)object2);
                                int n6 = inputStream.read();
                                while (n6 != -1) {
                                    fileOutputStream.write(n6);
                                    n6 = inputStream.read();
                                }
                                fileOutputStream.flush();
                                fileOutputStream.close();
                                LogPanel.log("  " + GT.o(GT.$("adding {0}"), object2));
                            }
                            ++n;
                        }
                    }
                }
                ++n4;
            }
            string = PT.rep(string, "@WIDGETJSFILES@", (String)object5);
            this.appletInfoDivs = "";
            stringBuilder = new StringBuilder();
            this.htmlAppletTemplate = GuiMap.getResourceString(this, String.valueOf(this.panelName) + "_template2");
            int n7 = 0;
            while (n7 < defaultListModel.getSize()) {
                string = this.getAppletDefs(n7, string, stringBuilder, (JmolInstance)defaultListModel.getElementAt(n7));
                ++n7;
            }
            string = PT.rep(string, "@AUTHOR@", GT.escapeHTML(this.pageAuthorName.getText()));
            string = PT.rep(string, "@TITLE@", GT.escapeHTML(this.webPageTitle.getText()));
            string = PT.rep(string, "@REMOTEAPPLETPATH@", this.remoteAppletPath.getText());
            String string6 = this.localAppletPath.getText();
            if (string6.contentEquals(".")) {
                string6 = "jsmol";
            }
            string = PT.rep(string, "@LOCALAPPLETPATH@", string6);
            string = PT.rep(string, "@DATADIRNAME@", string4);
            if (this.appletInfoDivs.length() > 0) {
                this.appletInfoDivs = "\n<div style='display:none'>\n" + this.appletInfoDivs + "\n</div>\n";
            }
        } else {
            IOException iOException = new IOException(String.valueOf(GT.$("Error creating directory: ")) + string3);
            throw iOException;
        }
        object = stringBuilder.toString();
        string = PT.rep(string, "@APPLETINFO@", this.appletInfoDivs);
        string = PT.rep(string, "@APPLETDEFS@", (String)object);
        string = PT.rep(string, "@CREATIONDATA@", GT.escapeHTML(WebExport.TimeStamp_WebLink()));
        string = PT.rep(string, "@AUTHORDATA@", GT.escapeHTML(GT.$("Based on a template by A. Herr&#x00E1;ez and J. Gutow")));
        string = PT.rep(string, "@LOGDATA@", "<pre>\n" + LogPanel.getText() + "\n</pre>\n");
        LogPanel.log("      ..." + GT.o(GT.$("creating {0}"), string2));
        this.vwr.writeTextFile(string2, string);
        return string2;
    }

    public static String replaceQuotedStrings(String string, ArrayList<String> arrayList, ArrayList<String> arrayList2) {
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < n) {
            String string2 = arrayList.get(n2);
            String string3 = arrayList2.get(n2);
            if (!string3.equals(string2)) {
                string = PT.rep(string, "\"" + string2 + "\"", "\"" + string3 + "\"");
            }
            ++n2;
        }
        return string;
    }

    public BS allSelectedWidgets() {
        BS bS = BS.newN(this.nWidgets);
        DefaultListModel defaultListModel = (DefaultListModel)this.instanceList.getModel();
        int n = 0;
        while (n < defaultListModel.getSize()) {
            JmolInstance jmolInstance = (JmolInstance)defaultListModel.getElementAt(n);
            bS.or(jmolInstance.whichWidgets);
            ++n;
        }
        return bS;
    }

    private String copyBinaryFile(String string, String string2) {
        String string3 = string.substring(string.lastIndexOf(47) + 1).replace('|', '_');
        if (string3.contentEquals("jsmol.zip")) {
            LogPanel.log(GT.o(GT.$("copying and unzipping jsmol.zip directory into {0}"), string2));
            String string4 = this.copyandUnzip(string, string2, string3);
            return string4;
        }
        string3 = String.valueOf(string2) + "/" + string3;
        String string5 = String.valueOf(string3) + ".gz";
        File file = new File(string3);
        File file2 = new File(string5);
        if (file.exists()) {
            return string3;
        }
        if (file2.exists()) {
            return string5;
        }
        try {
            Object object = this.vwr.fm.getFileAsBytes(string, null);
            if (object instanceof String) {
                LogPanel.log(GT.o(GT.$("Could not find or open:\n{0}\nPlease check that you are using a Jmol.jar that is part of a full Jmol distribution."), string));
                ++this.errCount;
            } else {
                LogPanel.log("      ..." + GT.o(GT.$("copying\n{0}\n         to"), string));
                byte[] byArray = (byte[])object;
                String[] stringArray = new String[]{string3};
                int n = string3.indexOf(".js") >= 0 ? Integer.MAX_VALUE : 100000;
                String string6 = WebPanel.writeFileZipped(stringArray, byArray, n);
                if (!stringArray[0].equals(string3)) {
                    string3 = stringArray[0];
                    LogPanel.log("      ..." + GT.$("compressing large data file to") + "\n" + string3);
                }
                LogPanel.log(string3);
                if (string6 != null) {
                    LogPanel.log(string6);
                    ++this.errCount;
                }
            }
        }
        catch (Exception exception) {
            LogPanel.log(exception.getMessage());
            ++this.errCount;
        }
        return string3;
    }

    private static String writeFileZipped(String[] stringArray, byte[] byArray, int n) {
        String string = null;
        try {
            boolean bl = false;
            if (byArray.length > n) {
                bl = true;
                int n2 = 0;
                while (n2 < 10) {
                    if (byArray[n2] < 10) {
                        bl = false;
                    }
                    ++n2;
                }
            }
            if (bl) {
                stringArray[0] = String.valueOf(stringArray[0]) + ".gz";
                GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(new FileOutputStream(stringArray[0]));
                gZIPOutputStream.write(byArray);
                gZIPOutputStream.flush();
                gZIPOutputStream.close();
            } else {
                FileOutputStream fileOutputStream = new FileOutputStream(stringArray[0]);
                fileOutputStream.write(byArray);
                fileOutputStream.flush();
                fileOutputStream.close();
            }
        }
        catch (IOException iOException) {
            string = iOException.getMessage();
        }
        return string;
    }

    private String copyandUnzip(String string, String string2, String string3) {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(string);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            File file = null;
            FileOutputStream fileOutputStream = null;
            byte[] byArray = new byte[1024];
            while (enumeration.hasMoreElements()) {
                block12: {
                    try {
                        fileOutputStream = null;
                        ZipEntry zipEntry = enumeration.nextElement();
                        if (zipEntry.getName().endsWith(".htm") || zipEntry.getName().contains("data" + File.separator) || zipEntry.getName().contains(".html")) break block12;
                        InputStream inputStream = zipFile.getInputStream(zipEntry);
                        file = new File(String.valueOf(string2) + File.separator + zipEntry.getName());
                        if (zipEntry.isDirectory()) {
                            Logger.info("creating directory " + file);
                            file.mkdirs();
                        } else {
                            file.getParentFile().mkdirs();
                            file.createNewFile();
                            fileOutputStream = new FileOutputStream(file);
                            int n = 0;
                            while ((n = inputStream.read(byArray)) != -1) {
                                fileOutputStream.write(byArray, 0, n);
                            }
                        }
                    }
                    catch (IOException iOException) {
                        Logger.error(iOException.getMessage());
                        break;
                    }
                }
                if (fileOutputStream == null) continue;
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        catch (IOException iOException) {
            LogPanel.log(GT.$("Error encountered while openning zip file. You may not have\na complete copy of the Jmol distribution.  Check for the file jsmol.zip.\n" + iOException.getMessage()));
            ++this.errCount;
        }
        try {
            zipFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string2;
    }

    private URL jmolJarURL() {
        return this.getClass().getProtectionDomain().getCodeSource().getLocation();
    }

    private String jmolJarPath() throws UnsupportedEncodingException {
        String string = null;
        URL uRL = this.jmolJarURL();
        string = URLDecoder.decode(uRL.toString(), System.getProperty("file.encoding"));
        string = string.substring(string.indexOf(":") + 1, string.length());
        return string;
    }

    void syncLists() {
        DefaultListModel defaultListModel = (DefaultListModel)this.instanceList.getModel();
        int n = 0;
        while (n < this.webPanels.length) {
            if (n != this.panelIndex) {
                JList<JmolInstance> jList = this.webPanels[n].instanceList;
                DefaultListModel defaultListModel2 = (DefaultListModel)jList.getModel();
                defaultListModel2.clear();
                int n2 = defaultListModel.getSize();
                int n3 = 0;
                while (n3 < n2) {
                    defaultListModel2.addElement((JmolInstance)defaultListModel.get(n3));
                    ++n3;
                }
                jList.setSelectedIndices(new int[0]);
                this.webPanels[n].enableButtons(jList);
            }
            ++n;
        }
        this.enableButtons(this.instanceList);
    }

    void enableButtons(JList<?> jList) {
        int n = jList.getSelectedIndices().length;
        int n2 = jList.getModel().getSize();
        this.saveButton.setEnabled(n2 > 0);
        this.viewButton.setEnabled(false);
        this.deleteInstanceButton.setEnabled(n > 0);
    }

    public static boolean checkOption(Object object) {
        return object instanceof Boolean && (Boolean)object != false || object instanceof Integer && (Integer)object != 0;
    }

    class InstanceCellRenderer
    extends JLabel
    implements ListCellRenderer<Object> {
        InstanceCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> jList, Object object, int n, boolean bl, boolean bl2) {
            this.setText(" " + ((JmolInstance)object).name);
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setEnabled(jList.isEnabled());
            this.setFont(jList.getFont());
            this.setOpaque(true);
            WebPanel.this.enableButtons(jList);
            return this;
        }
    }
}

