/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.quantum;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.adapter.readers.quantum.SlaterReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.quantum.SlaterData;
import org.jmol.util.Logger;

public class DgridReader
extends SlaterReader {
    private String title;
    Map<String, Float> htExponents = new Hashtable<String, Float>();
    private Map<String, Integer> htFuncMap;

    @Override
    protected boolean checkLine() throws Exception {
        if (this.line.indexOf(":title") == 0) {
            this.title = this.rd().substring(2);
            return true;
        }
        if (this.line.indexOf("basis:  CARTESIAN  STO") >= 0) {
            this.readSlaterBasis();
            return true;
        }
        if (this.line.indexOf(":atom") == 0) {
            this.readCoordinates();
            return true;
        }
        if (this.line.indexOf(" MO  DATA ") >= 0) {
            if (this.doReadMolecularOrbitals) {
                this.readMolecularOrbitals();
            }
            return true;
        }
        return true;
    }

    private void readCoordinates() throws Exception {
        String[] tokens;
        this.asc.newAtomSet();
        this.asc.setAtomSetName(this.title);
        this.discardLinesUntilContains("----");
        while (this.rd() != null && !this.line.startsWith(":-----") && (tokens = this.getTokens()).length >= 5) {
            this.setAtomCoordScaled(null, (String[])tokens, (int)2, (float)0.5291772f).elementSymbol = tokens[0];
        }
    }

    private void readSlaterBasis() throws Exception {
        this.discardLinesUntilContains(":-");
        char ch = 'a';
        while (this.rd() != null && this.line.indexOf(":-") < 0) {
            String atomSymbol = this.line.substring(3, 6).trim();
            String xyz = this.line.substring(19, 21);
            String code = atomSymbol + xyz;
            if (this.htExponents.get(code) == null) {
                ch = 'a';
            } else {
                char c = ch;
                ch = (char)(ch + 1);
                code = code + "_" + c;
            }
            String exp = this.line.substring(34);
            this.htExponents.put(code, Float.valueOf(this.parseFloatStr(exp)));
        }
    }

    private void readMolecularOrbitals() throws Exception {
        this.htFuncMap = new Hashtable<String, Integer>();
        this.readLines(3);
        while (this.line != null && this.line.indexOf(":") != 0) {
            this.discardLinesUntilContains("sym: ");
            String symmetry = this.line.substring(4, 10).trim();
            if (symmetry.indexOf("_FC") >= 0) break;
            SB data = new SB();
            data.append(this.line.substring(15));
            while (this.rd() != null && this.line.length() >= 15) {
                data.append(this.line);
            }
            String[] tokens = PT.getTokens(data.toString());
            int nFuncs = tokens.length / 2;
            int[] ptSlater = new int[nFuncs];
            Atom[] atoms = this.asc.atoms;
            int i = 0;
            int pt = 0;
            while (i < tokens.length) {
                int iAtom = this.parseIntStr(tokens[i++]) - 1;
                String code = tokens[i++];
                String key = iAtom + "_" + code;
                if (this.htFuncMap.containsKey(key)) {
                    ptSlater[pt++] = this.htFuncMap.get(key);
                    continue;
                }
                int n = this.slaters.size();
                ptSlater[pt++] = n;
                this.htFuncMap.put(key, n);
                this.addSlater(this.createSlaterData(iAtom + 1, atoms[iAtom].elementSymbol, code), n);
            }
            this.discardLinesUntilContains(":-");
            this.rd();
            while (this.line != null && this.line.length() >= 20) {
                int iOrb = this.parseIntRange(this.line, 0, 10);
                float energy = this.parseFloatRange(this.line, 10, 20);
                SB cData = new SB();
                cData.append(this.line.substring(20));
                while (this.rd() != null && this.line.length() >= 10 && this.line.charAt(3) == ' ') {
                    cData.append(this.line);
                }
                float[] list = new float[this.slaters.size()];
                tokens = PT.getTokens(cData.toString());
                if (tokens.length != nFuncs) {
                    Logger.error("DgridReader: number of coefficients (" + tokens.length + ") does not equal number of functions (" + nFuncs + ")");
                }
                for (int i2 = 0; i2 < tokens.length; ++i2) {
                    int pt2 = ptSlater[i2];
                    list[pt2] = this.parseFloatStr(tokens[i2]);
                }
                Hashtable<String, Object> mo = new Hashtable<String, Object>();
                mo.put("energy", Float.valueOf(energy));
                mo.put("coefficients", list);
                mo.put("symmetry", symmetry + "_" + iOrb);
                this.setMO(mo);
            }
        }
        this.discardLinesUntilContains(":  #  symmetry");
        this.rd();
        for (int i = 0; i < this.orbitals.size(); ++i) {
            this.rd();
            float occupancy = this.parseFloatRange(this.line, 31, 45) + this.parseFloatRange(this.line, 47, 61);
            ((Map)this.orbitals.get(i)).put("occupancy", Float.valueOf(occupancy));
        }
        this.sortOrbitals();
        this.setSlaters(true, true);
        this.setMOs("eV");
    }

    private SlaterData createSlaterData(int iAtom, String atomSymbol, String xyz) {
        char abc = ' ';
        char type = ' ';
        int exp = 1;
        int el = 0;
        int x = 0;
        int y = 0;
        int z = 0;
        int i = xyz.length();
        block7: while (--i >= 0) {
            char ch = xyz.charAt(i);
            switch (ch) {
                case '_': {
                    type = abc;
                    continue block7;
                }
                case '1': 
                case '2': 
                case '3': 
                case '4': {
                    exp = ch - 48;
                    continue block7;
                }
                case 'x': {
                    x = exp;
                    el += exp;
                    exp = 1;
                    continue block7;
                }
                case 'y': {
                    y = exp;
                    el += exp;
                    exp = 1;
                    continue block7;
                }
                case 'z': {
                    z = exp;
                    el += exp;
                    exp = 1;
                    continue block7;
                }
            }
            abc = ch;
        }
        int r = exp - el - 1;
        String code = atomSymbol + xyz.substring(0, 2);
        if (type != ' ') {
            code = code + "_" + type;
        }
        Float f = this.htExponents.get(code);
        float zeta = 0.0f;
        if (f == null) {
            Logger.error("Exponent for " + code + " not found");
        } else {
            zeta = f.floatValue();
        }
        return new SlaterData(iAtom, x, y, z, r, zeta, 1.0);
    }
}

