/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.render;

import java.util.Map;
import javajs.util.BS;
import org.jmol.api.Interface;
import org.jmol.api.JmolRendererInterface;
import org.jmol.api.JmolRepaintManager;
import org.jmol.api.JmolToJSmolInterface;
import org.jmol.modelset.ModelSet;
import org.jmol.render.ShapeRenderer;
import org.jmol.shape.Shape;
import org.jmol.util.GData;
import org.jmol.util.Logger;
import org.jmol.util.Rectangle;
import org.jmol.viewer.JC;
import org.jmol.viewer.ShapeManager;
import org.jmol.viewer.Viewer;

public class RepaintManager
implements JmolRepaintManager {
    private Viewer vwr;
    private ShapeManager shapeManager;
    private ShapeRenderer[] renderers;
    private final BS bsTranslucent = BS.newN(37);
    public int holdRepaint = 0;
    private boolean repaintPending;

    @Override
    public void set(Viewer vwr, ShapeManager shapeManager) {
        this.vwr = vwr;
        this.shapeManager = shapeManager;
    }

    @Override
    public boolean isRepaintPending() {
        return this.repaintPending;
    }

    @Override
    public void pushHoldRepaint(String why) {
        ++this.holdRepaint;
    }

    @Override
    public void popHoldRepaint(boolean andRepaint, String why) {
        --this.holdRepaint;
        if (this.holdRepaint <= 0) {
            this.holdRepaint = 0;
            if (andRepaint) {
                this.repaintPending = true;
                this.repaintNow(why);
            }
        }
    }

    @Override
    public synchronized void requestRepaintAndWait(String why) {
        JmolToJSmolInterface jmol = null;
        if (jmol != null) {
            jmol._repaint(this.vwr.html5Applet, false);
            this.repaintDone();
        }
        try {
            this.repaintNow(why);
            this.wait(this.vwr.g.repaintWaitMs);
            if (this.repaintPending) {
                Logger.error("repaintManager requestRepaintAndWait timeout");
                this.repaintDone();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public boolean repaintIfReady(String why) {
        if (this.repaintPending) {
            return false;
        }
        this.repaintPending = true;
        if (this.holdRepaint == 0) {
            this.repaintNow(why);
        }
        return true;
    }

    private void repaintNow(String why) {
        if (!this.vwr.haveDisplay) {
            return;
        }
        this.vwr.apiPlatform.repaint(this.vwr.display);
    }

    @Override
    public synchronized void repaintDone() {
        this.repaintPending = false;
        this.notify();
    }

    @Override
    public void clear(int iShape) {
        if (this.renderers == null) {
            return;
        }
        if (iShape >= 0) {
            this.renderers[iShape] = null;
        } else {
            for (int i = 0; i < 37; ++i) {
                this.renderers[i] = null;
            }
        }
    }

    private ShapeRenderer getRenderer(int shapeID) {
        if (this.renderers[shapeID] != null) {
            return this.renderers[shapeID];
        }
        String className = JC.getShapeClassName(shapeID, true) + "Renderer";
        ShapeRenderer renderer = (ShapeRenderer)Interface.getInterface(className, this.vwr, "render");
        if (renderer == null) {
            return null;
        }
        renderer.setViewerG3dShapeID(this.vwr, shapeID);
        this.renderers[shapeID] = renderer;
        return this.renderers[shapeID];
    }

    @Override
    public void render(GData gdata, ModelSet modelSet, boolean isFirstPass, int[] navMinMax) {
        JmolRendererInterface g3d = (JmolRendererInterface)((Object)gdata);
        if (this.renderers == null) {
            this.renderers = new ShapeRenderer[37];
        }
        this.getAllRenderers();
        try {
            boolean logTime = this.vwr.getBoolean(603979934);
            g3d.renderBackground(null);
            if (isFirstPass) {
                Rectangle band;
                this.bsTranslucent.clearAll();
                if (navMinMax != null) {
                    g3d.renderCrossHairs(navMinMax, this.vwr.getScreenWidth(), this.vwr.getScreenHeight(), this.vwr.tm.getNavigationOffset(), this.vwr.tm.navigationDepthPercent);
                }
                if ((band = this.vwr.getRubberBandSelection()) != null && g3d.setC(this.vwr.cm.colixRubberband)) {
                    g3d.drawRect(band.x, band.y, 0, 0, band.width, band.height);
                }
                this.vwr.noFrankEcho = true;
            }
            String msg = null;
            for (int i = 0; i < 37 && gdata.currentlyRendering; ++i) {
                Shape shape = this.shapeManager.getShape(i);
                if (shape == null) continue;
                if (logTime) {
                    msg = "rendering " + JC.getShapeClassName(i, false);
                    Logger.startTimer(msg);
                }
                if ((isFirstPass || this.bsTranslucent.get(i)) && this.getRenderer(i).renderShape(g3d, modelSet, shape)) {
                    this.bsTranslucent.set(i);
                }
                if (!logTime) continue;
                Logger.checkTimer(msg, false);
            }
            g3d.renderAllStrings(null);
        }
        catch (Exception e) {
            if (!Viewer.isJS) {
                e.printStackTrace();
            }
            if (this.vwr.async && "Interface".equals(e.getMessage())) {
                throw new NullPointerException();
            }
            Logger.error("rendering error? " + e);
        }
    }

    private void getAllRenderers() {
        boolean isOK = true;
        for (int i = 0; i < 37; ++i) {
            if (this.shapeManager.getShape(i) == null || this.getRenderer(i) != null) continue;
            this.repaintPending = !this.vwr.async;
            isOK = this.repaintPending;
        }
        if (!isOK) {
            throw new NullPointerException();
        }
    }

    @Override
    public String renderExport(GData gdata, ModelSet modelSet, Map<String, Object> params) {
        boolean isOK;
        this.shapeManager.finalizeAtoms(null, true);
        JmolRendererInterface exporter3D = this.vwr.initializeExporter(params);
        boolean bl = isOK = exporter3D != null;
        if (!isOK) {
            Logger.error("Cannot export " + params.get("type"));
            return null;
        }
        if (this.renderers == null) {
            this.renderers = new ShapeRenderer[37];
        }
        this.getAllRenderers();
        String msg = null;
        try {
            boolean logTime = this.vwr.getBoolean(603979934);
            exporter3D.renderBackground(exporter3D);
            for (int i = 0; i < 37; ++i) {
                Shape shape = this.shapeManager.getShape(i);
                if (shape == null) continue;
                if (logTime) {
                    msg = "rendering " + JC.getShapeClassName(i, false);
                    Logger.startTimer(msg);
                }
                this.getRenderer(i).renderShape(exporter3D, modelSet, shape);
                if (!logTime) continue;
                Logger.checkTimer(msg, false);
            }
            exporter3D.renderAllStrings(exporter3D);
            msg = exporter3D.finalizeOutput();
        }
        catch (Exception e) {
            if (!Viewer.isJS) {
                e.printStackTrace();
            }
            Logger.error("rendering error? " + e);
        }
        return msg;
    }
}

