/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.core.shader;

import org.sunflow.SunflowAPI;
import org.sunflow.core.LightSample;
import org.sunflow.core.ParameterList;
import org.sunflow.core.Ray;
import org.sunflow.core.Shader;
import org.sunflow.core.ShadingState;
import org.sunflow.image.Color;
import org.sunflow.math.OrthoNormalBasis;
import org.sunflow.math.Vector3;

public class AnisotropicWardShader
implements Shader {
    private Color rhoD = Color.GRAY;
    private Color rhoS = Color.GRAY;
    private float alphaX = 1.0f;
    private float alphaY = 1.0f;
    private int numRays = 4;

    public boolean update(ParameterList parameterList, SunflowAPI sunflowAPI) {
        this.rhoD = parameterList.getColor("diffuse", this.rhoD);
        this.rhoS = parameterList.getColor("specular", this.rhoS);
        this.alphaX = parameterList.getFloat("roughnessX", this.alphaX);
        this.alphaY = parameterList.getFloat("roughnessY", this.alphaY);
        this.numRays = parameterList.getInt("samples", this.numRays);
        return true;
    }

    protected Color getDiffuse(ShadingState shadingState) {
        return this.rhoD;
    }

    private float brdf(Vector3 vector3, Vector3 vector32, OrthoNormalBasis orthoNormalBasis) {
        float f = (float)Math.PI * 4 * this.alphaX * this.alphaY;
        float f2 = orthoNormalBasis.untransformZ(vector3) * orthoNormalBasis.untransformZ(vector32);
        f = f2 > 0.0f ? (f *= (float)Math.sqrt(f2)) : 0.0f;
        Vector3 vector33 = Vector3.add(vector3, vector32, new Vector3());
        orthoNormalBasis.untransform(vector33);
        float f3 = vector33.x / this.alphaX;
        f3 *= f3;
        float f4 = vector33.y / this.alphaY;
        f4 *= f4;
        float f5 = vector33.z * vector33.z;
        if (f > 0.0f) {
            f = (float)Math.exp(-(f3 + f4) / f5) / f;
        }
        return f;
    }

    public Color getRadiance(ShadingState shadingState) {
        shadingState.faceforward();
        OrthoNormalBasis orthoNormalBasis = shadingState.getBasis();
        shadingState.initLightSamples();
        shadingState.initCausticSamples();
        Color color = Color.black();
        if (shadingState.includeSpecular()) {
            Vector3 vector3 = shadingState.getRay().getDirection().negate(new Vector3());
            for (LightSample lightSample : shadingState) {
                float f = lightSample.dot(shadingState.getNormal());
                float f2 = this.brdf(vector3, lightSample.getShadowRay().getDirection(), orthoNormalBasis);
                color.madd(f * f2, lightSample.getSpecularRadiance());
            }
            if (this.numRays > 0) {
                int n = shadingState.getDepth() == 0 ? this.numRays : 1;
                for (int i = 0; i < n; ++i) {
                    double d;
                    double d2 = shadingState.getRandom(i, 0, n);
                    double d3 = shadingState.getRandom(i, 1, n);
                    float f = this.alphaY / this.alphaX;
                    float f3 = 0.0f;
                    if (d2 < 0.25) {
                        d = 4.0 * d2;
                        f3 = (float)Math.atan((double)f * Math.tan(1.5707963267948966 * d));
                    } else if (d2 < 0.5) {
                        d = 1.0 - 4.0 * (0.5 - d2);
                        f3 = (float)Math.atan((double)f * Math.tan(1.5707963267948966 * d));
                        f3 = (float)Math.PI - f3;
                    } else if (d2 < 0.75) {
                        d = 4.0 * (d2 - 0.5);
                        f3 = (float)Math.atan((double)f * Math.tan(1.5707963267948966 * d));
                        f3 = (float)((double)f3 + Math.PI);
                    } else {
                        d = 1.0 - 4.0 * (1.0 - d2);
                        f3 = (float)Math.atan((double)f * Math.tan(1.5707963267948966 * d));
                        f3 = (float)Math.PI * 2 - f3;
                    }
                    float f4 = (float)Math.cos(f3);
                    float f5 = (float)Math.sin(f3);
                    float f6 = f4 * f4 / (this.alphaX * this.alphaX) + f5 * f5 / (this.alphaY * this.alphaY);
                    float f7 = (float)Math.atan(Math.sqrt(-Math.log(1.0 - d3) / (double)f6));
                    float f8 = (float)Math.sin(f7);
                    float f9 = (float)Math.cos(f7);
                    Vector3 vector32 = new Vector3();
                    vector32.x = f8 * f4;
                    vector32.y = f8 * f5;
                    vector32.z = f9;
                    orthoNormalBasis.transform(vector32);
                    Vector3 vector33 = new Vector3();
                    float f10 = Vector3.dot(vector32, vector3);
                    vector33.x = 2.0f * f10 * vector32.x - vector3.x;
                    vector33.y = 2.0f * f10 * vector32.y - vector3.y;
                    vector33.z = 2.0f * f10 * vector32.z - vector3.z;
                    float f11 = orthoNormalBasis.untransformZ(vector33);
                    float f12 = orthoNormalBasis.untransformZ(vector3);
                    float f13 = f10 * f9 * f9 * f9 * (float)Math.sqrt(Math.abs(f11 / f12));
                    Ray ray = new Ray(shadingState.getPoint(), vector33);
                    color.madd(f13 / (float)n, shadingState.traceGlossy(ray, i));
                }
            }
            color.mul(this.rhoS);
        }
        color.add(shadingState.diffuse(this.getDiffuse(shadingState)));
        return color;
    }

    public void scatterPhoton(ShadingState shadingState, Color color) {
        shadingState.faceforward();
        Color color2 = this.getDiffuse(shadingState);
        shadingState.storePhoton(shadingState.getRay().getDirection(), color, color2);
        float f = color2.getAverage();
        float f2 = this.rhoS.getAverage();
        double d = shadingState.getRandom(0, 0, 1);
        if (d < (double)f) {
            color.mul(color2).mul(1.0f / f);
            OrthoNormalBasis orthoNormalBasis = shadingState.getBasis();
            double d2 = Math.PI * 2 * d / (double)f;
            double d3 = shadingState.getRandom(0, 1, 1);
            float f3 = (float)Math.sqrt(d3);
            float f4 = (float)Math.sqrt(1.0 - d3);
            Vector3 vector3 = new Vector3((float)Math.cos(d2) * f3, (float)Math.sin(d2) * f3, f4);
            vector3 = orthoNormalBasis.transform(vector3, new Vector3());
            shadingState.traceDiffusePhoton(new Ray(shadingState.getPoint(), vector3), color);
        } else if (d < (double)(f + f2)) {
            double d4;
            color.mul(this.rhoS).mul(1.0f / f2);
            OrthoNormalBasis orthoNormalBasis = shadingState.getBasis();
            Vector3 vector3 = shadingState.getRay().getDirection().negate(new Vector3());
            double d5 = d / (double)f2;
            double d6 = shadingState.getRandom(0, 1, 1);
            float f5 = this.alphaY / this.alphaX;
            float f6 = 0.0f;
            if (d5 < 0.25) {
                d4 = 4.0 * d5;
                f6 = (float)Math.atan((double)f5 * Math.tan(1.5707963267948966 * d4));
            } else if (d5 < 0.5) {
                d4 = 1.0 - 4.0 * (0.5 - d5);
                f6 = (float)Math.atan((double)f5 * Math.tan(1.5707963267948966 * d4));
                f6 = (float)Math.PI - f6;
            } else if (d5 < 0.75) {
                d4 = 4.0 * (d5 - 0.5);
                f6 = (float)Math.atan((double)f5 * Math.tan(1.5707963267948966 * d4));
                f6 = (float)((double)f6 + Math.PI);
            } else {
                d4 = 1.0 - 4.0 * (1.0 - d5);
                f6 = (float)Math.atan((double)f5 * Math.tan(1.5707963267948966 * d4));
                f6 = (float)Math.PI * 2 - f6;
            }
            float f7 = (float)Math.cos(f6);
            float f8 = (float)Math.sin(f6);
            float f9 = f7 * f7 / (this.alphaX * this.alphaX) + f8 * f8 / (this.alphaY * this.alphaY);
            float f10 = (float)Math.atan(Math.sqrt(-Math.log(1.0 - d6) / (double)f9));
            float f11 = (float)Math.sin(f10);
            float f12 = (float)Math.cos(f10);
            Vector3 vector32 = new Vector3();
            vector32.x = f11 * f7;
            vector32.y = f11 * f8;
            vector32.z = f12;
            orthoNormalBasis.transform(vector32);
            Vector3 vector33 = new Vector3();
            float f13 = Vector3.dot(vector32, vector3);
            vector33.x = 2.0f * f13 * vector32.x - vector3.x;
            vector33.y = 2.0f * f13 * vector32.y - vector3.y;
            vector33.z = 2.0f * f13 * vector32.z - vector3.z;
            Ray ray = new Ray(shadingState.getPoint(), vector33);
            shadingState.traceReflectionPhoton(ray, color);
        }
    }

    public boolean isOpaque() {
        return true;
    }

    public Color getOpacity(ShadingState shadingState) {
        return null;
    }
}

