/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.CloseButton;
import org.netbeans.lib.profiler.ui.swing.EditableHistoryCombo;
import org.netbeans.lib.profiler.ui.swing.InvisibleToolbar;
import org.netbeans.lib.profiler.ui.swing.ProfilerTable;
import org.netbeans.lib.profiler.ui.swing.ProfilerTreeTable;
import org.netbeans.modules.profiler.api.ActionsSupport;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.spi.ActionsSupportProvider;

public final class SearchUtils {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.swing.Bundle");
    public static final String ACTION_FIND = messages.getString("SearchUtils_ActionFind");
    private static final String MSG_NODATA = messages.getString("SearchUtils_MsgNoData");
    private static final String MSG_NOTFOUND = messages.getString("SearchUtils_MsgNotFound");
    private static final String SIDEBAR_CAPTION = messages.getString("SearchUtils_SidebarCaption");
    private static final String BTN_PREVIOUS = messages.getString("SearchUtils_BtnPrevious");
    private static final String BTN_PREVIOUS_TOOLTIP = messages.getString("SearchUtils_BtnPreviousTooltip");
    private static final String BTN_NEXT = messages.getString("SearchUtils_BtnNext");
    private static final String BTN_NEXT_TOOLTIP = messages.getString("SearchUtils_BtnNextTooltip");
    private static final String BTN_MATCH_CASE_TOOLTIP = messages.getString("SearchUtils_BtnMatchCaseTooltip");
    private static final String BTN_CLOSE_TOOLTIP = messages.getString("SearchUtils_BtnCloseTooltip");
    public static final String FIND_ACTION_KEY = "find-action-key";
    public static final String FIND_NEXT_ACTION_KEY = "find-next-action-key";
    public static final String FIND_PREV_ACTION_KEY = "find-prev-action-key";
    public static final String FIND_SEL_ACTION_KEY = "find-sel-action-key";
    private static final String LAST_FIND_TEXT = "last-find-text";
    private static final String LAST_FIND_MATCH_CASE = "last-find-match-case";
    private static final String FIND_TREE_HELPER = "find-tree-helper";

    public static boolean findString(ProfilerTable profilerTable, String string) {
        return SearchUtils.findString(profilerTable, string, true, true);
    }

    public static boolean findString(ProfilerTable profilerTable, String string, boolean bl, boolean bl2) {
        boolean bl3;
        int n = profilerTable.getRowCount();
        ProfilerTreeTable profilerTreeTable = null;
        if (n == 0) {
            ProfilerDialogs.displayWarning((String)MSG_NODATA, (String)ACTION_FIND, null);
            return false;
        }
        if (n == 1) {
            if (!(profilerTable instanceof ProfilerTreeTable)) {
                return false;
            }
            profilerTreeTable = (ProfilerTreeTable)profilerTable;
            TreeNode treeNode = profilerTreeTable.getValueForRow(0);
            if (treeNode == null || treeNode.isLeaf()) {
                return false;
            }
        }
        if (profilerTreeTable != null || profilerTable instanceof ProfilerTreeTable) {
            if (profilerTreeTable == null) {
                profilerTreeTable = (ProfilerTreeTable)profilerTable;
            }
            return SearchUtils.findString(profilerTreeTable, string, bl, bl2, null);
        }
        profilerTable.putClientProperty(LAST_FIND_TEXT, string);
        profilerTable.putClientProperty(LAST_FIND_MATCH_CASE, bl);
        if (!bl) {
            string = string.toLowerCase();
        }
        int n2 = profilerTable.convertColumnIndexToView(profilerTable.getMainColumn());
        int n3 = profilerTable.getSelectedRow();
        boolean bl4 = bl3 = n3 != -1;
        n3 = !bl3 ? (bl2 ? 0 : n - 1) : (bl2 ? profilerTable.getNextRow(n3) : profilerTable.getPreviousRow(n3));
        int n4 = bl3 ? n - 1 : n;
        for (int i = 0; i < n4; ++i) {
            String string2 = profilerTable.getStringValue(n3, n2);
            if (!bl) {
                string2 = string2.toLowerCase();
            }
            if (string2.contains(string)) {
                profilerTable.selectRow(n3, true);
                return true;
            }
            n3 = bl2 ? profilerTable.getNextRow(n3) : profilerTable.getPreviousRow(n3);
        }
        ProfilerDialogs.displayInfo((String)MSG_NOTFOUND, (String)ACTION_FIND, null);
        return false;
    }

    public static boolean findString(ProfilerTreeTable profilerTreeTable, String string, boolean bl, boolean bl2, TreeHelper treeHelper) {
        profilerTreeTable.putClientProperty(LAST_FIND_TEXT, string);
        profilerTreeTable.putClientProperty(LAST_FIND_MATCH_CASE, bl);
        if (!bl) {
            string = string.toLowerCase();
        }
        int n = profilerTreeTable.convertColumnIndexToView(profilerTreeTable.getMainColumn());
        TreePath treePath = profilerTreeTable.getSelectionPath();
        if (treePath == null) {
            treePath = profilerTreeTable.getRootPath();
        }
        boolean bl3 = true;
        TreePath treePath2 = null;
        int n2 = treeHelper == null ? 10 : treeHelper.getNodeType(treePath);
        do {
            treePath = bl2 ? profilerTreeTable.getNextPath(treePath, TreeHelper.isDown(n2)) : profilerTreeTable.getPreviousPath(treePath, TreeHelper.isDown(n2));
            TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
            if (treeHelper != null) {
                n2 = treeHelper.getNodeType(treeNode);
            }
            if (TreeHelper.isSearch(n2)) {
                String string2 = profilerTreeTable.getStringValue(treeNode, n);
                if (!bl) {
                    string2 = string2.toLowerCase();
                }
                if (string2.contains(string)) {
                    profilerTreeTable.selectPath(treePath, true);
                    return true;
                }
            }
            if (treePath2 == null) {
                treePath2 = treePath;
                continue;
            }
            if (!bl3) continue;
            bl3 = false;
        } while (bl3 || !treePath.equals(treePath2));
        ProfilerDialogs.displayInfo((String)MSG_NOTFOUND, (String)ACTION_FIND, null);
        return false;
    }

    public static void enableSearchActions(final ProfilerTable profilerTable) {
        ActionMap actionMap = profilerTable.getActionMap();
        InputMap inputMap = profilerTable.getInputMap();
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Object object = profilerTable.getClientProperty(SearchUtils.LAST_FIND_TEXT);
                        Object object2 = profilerTable.getClientProperty(SearchUtils.LAST_FIND_MATCH_CASE);
                        if (object != null && object2 != null) {
                            TreeHelper treeHelper = (TreeHelper)profilerTable.getClientProperty(SearchUtils.FIND_TREE_HELPER);
                            if (treeHelper == null) {
                                SearchUtils.findString(profilerTable, object.toString(), Boolean.TRUE == object2, true);
                            } else {
                                SearchUtils.findString((ProfilerTreeTable)profilerTable, object.toString(), Boolean.TRUE == object2, true, treeHelper);
                            }
                        }
                    }
                });
            }
        };
        ActionsSupport.registerAction((String)FIND_NEXT_ACTION_KEY, (Action)abstractAction, (ActionMap)actionMap, (InputMap)inputMap);
        AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Object object = profilerTable.getClientProperty(SearchUtils.LAST_FIND_TEXT);
                        Object object2 = profilerTable.getClientProperty(SearchUtils.LAST_FIND_MATCH_CASE);
                        if (object != null && object2 != null) {
                            TreeHelper treeHelper = (TreeHelper)profilerTable.getClientProperty(SearchUtils.FIND_TREE_HELPER);
                            if (treeHelper == null) {
                                SearchUtils.findString(profilerTable, object.toString(), Boolean.TRUE == object2, false);
                            } else {
                                SearchUtils.findString((ProfilerTreeTable)profilerTable, object.toString(), Boolean.TRUE == object2, false, treeHelper);
                            }
                        }
                    }
                });
            }
        };
        ActionsSupport.registerAction((String)FIND_PREV_ACTION_KEY, (Action)abstractAction2, (ActionMap)actionMap, (InputMap)inputMap);
        AbstractAction abstractAction3 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        int n = profilerTable.getSelectedRow();
                        if (n == -1) {
                            return;
                        }
                        int n2 = profilerTable.convertColumnIndexToView(profilerTable.getMainColumn());
                        TreeHelper treeHelper = (TreeHelper)profilerTable.getClientProperty(SearchUtils.FIND_TREE_HELPER);
                        if (treeHelper == null) {
                            SearchUtils.findString(profilerTable, profilerTable.getStringValue(n, n2), true, true);
                        } else {
                            SearchUtils.findString((ProfilerTreeTable)profilerTable, profilerTable.getStringValue(n, n2), true, true, treeHelper);
                        }
                    }
                });
            }
        };
        ActionsSupport.registerAction((String)FIND_SEL_ACTION_KEY, (Action)abstractAction3, (ActionMap)actionMap, (InputMap)inputMap);
    }

    public static JComponent createSearchPanel(ProfilerTable profilerTable) {
        return SearchUtils.createSearchPanel(profilerTable, null);
    }

    public static JComponent createSearchPanel(ProfilerTable profilerTable, Component[] componentArray) {
        return SearchUtils.createSearchPanelImpl(profilerTable, null, componentArray);
    }

    public static JComponent createSearchPanel(ProfilerTreeTable profilerTreeTable, TreeHelper treeHelper, Component[] componentArray) {
        return SearchUtils.createSearchPanelImpl(profilerTreeTable, treeHelper, componentArray);
    }

    private static JComponent createSearchPanelImpl(final ProfilerTable profilerTable, final TreeHelper treeHelper, Component[] componentArray) {
        InvisibleToolbar invisibleToolbar = new InvisibleToolbar();
        if (UIUtils.isWindowsModernLookAndFeel()) {
            invisibleToolbar.setBorder(BorderFactory.createEmptyBorder(2, 2, 1, 2));
        } else if (!UIUtils.isNimbusLookAndFeel() && !UIUtils.isAquaLookAndFeel()) {
            invisibleToolbar.setBorder(BorderFactory.createEmptyBorder(1, 2, 1, 2));
        }
        invisibleToolbar.add(Box.createHorizontalStrut(6));
        invisibleToolbar.add(new JLabel(SIDEBAR_CAPTION));
        invisibleToolbar.add(Box.createHorizontalStrut(3));
        final EditableHistoryCombo editableHistoryCombo = new EditableHistoryCombo();
        final JTextComponent jTextComponent = editableHistoryCombo.getTextComponent();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)editableHistoryCombo, "Center");
        jPanel.setMinimumSize(editableHistoryCombo.getMinimumSize());
        jPanel.setPreferredSize(editableHistoryCombo.getPreferredSize());
        jPanel.setMaximumSize(editableHistoryCombo.getMaximumSize());
        invisibleToolbar.add(jPanel);
        invisibleToolbar.add(Box.createHorizontalStrut(5));
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(10, 1);
        KeyStroke keyStroke3 = KeyStroke.getKeyStroke(10, 0);
        final JToggleButton jToggleButton = new JToggleButton(Icons.getIcon((String)"GeneralIcons.MatchCase"));
        jToggleButton.setToolTipText(BTN_MATCH_CASE_TOOLTIP);
        final JButton jButton = new JButton(BTN_PREVIOUS, Icons.getIcon((String)"GeneralIcons.FindPrevious")){

            @Override
            protected void fireActionPerformed(ActionEvent actionEvent) {
                super.fireActionPerformed(actionEvent);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        String string = SearchUtils.getSearchString(editableHistoryCombo);
                        if (string == null || string.isEmpty()) {
                            return;
                        }
                        if (treeHelper == null) {
                            if (SearchUtils.findString(profilerTable, string, jToggleButton.isSelected(), false)) {
                                editableHistoryCombo.addItem(string);
                            }
                        } else if (SearchUtils.findString((ProfilerTreeTable)profilerTable, string, jToggleButton.isSelected(), false, treeHelper)) {
                            editableHistoryCombo.addItem(string);
                        }
                    }
                });
            }
        };
        jButton.putClientProperty("JButton.buttonType", "segmented");
        jButton.putClientProperty("JButton.segmentPosition", "first");
        String string = ActionsSupport.keyAcceleratorString((KeyStroke)keyStroke2);
        jButton.setToolTipText(MessageFormat.format(BTN_PREVIOUS_TOOLTIP, string));
        jButton.setEnabled(false);
        invisibleToolbar.add(jButton);
        if (!UIUtils.isAquaLookAndFeel()) {
            invisibleToolbar.add(Box.createHorizontalStrut(2));
        }
        final JButton jButton2 = new JButton(BTN_NEXT, Icons.getIcon((String)"GeneralIcons.FindNext")){

            @Override
            protected void fireActionPerformed(ActionEvent actionEvent) {
                super.fireActionPerformed(actionEvent);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        String string = SearchUtils.getSearchString(editableHistoryCombo);
                        if (string == null || string.isEmpty()) {
                            return;
                        }
                        if (treeHelper == null) {
                            if (SearchUtils.findString(profilerTable, string, jToggleButton.isSelected(), true)) {
                                editableHistoryCombo.addItem(string);
                            }
                        } else if (SearchUtils.findString((ProfilerTreeTable)profilerTable, string, jToggleButton.isSelected(), true, treeHelper)) {
                            editableHistoryCombo.addItem(string);
                        }
                    }
                });
            }
        };
        jButton2.putClientProperty("JButton.buttonType", "segmented");
        jButton2.putClientProperty("JButton.segmentPosition", "last");
        String string2 = ActionsSupport.keyAcceleratorString((KeyStroke)keyStroke3);
        jButton2.setToolTipText(MessageFormat.format(BTN_NEXT_TOOLTIP, string2));
        jButton2.setEnabled(false);
        invisibleToolbar.add(jButton2);
        invisibleToolbar.add(Box.createHorizontalStrut(2));
        ((JToolBar)invisibleToolbar).addSeparator();
        invisibleToolbar.add(Box.createHorizontalStrut(1));
        invisibleToolbar.add(jToggleButton);
        if (componentArray != null) {
            for (Component object2 : componentArray) {
                invisibleToolbar.add(object2);
            }
        }
        invisibleToolbar.add(Box.createHorizontalStrut(2));
        editableHistoryCombo.setOnTextChangeHandler(new Runnable(){

            @Override
            public void run() {
                boolean bl = !editableHistoryCombo.getText().trim().isEmpty();
                jButton.setEnabled(bl);
                jButton2.setEnabled(bl);
            }
        });
        final JPanel jPanel2 = new JPanel(new BorderLayout()){

            @Override
            public void setVisible(boolean bl) {
                super.setVisible(bl);
                if (!bl) {
                    profilerTable.requestFocusInWindow();
                }
            }

            @Override
            public boolean requestFocusInWindow() {
                if (jTextComponent != null) {
                    jTextComponent.selectAll();
                }
                return editableHistoryCombo.requestFocusInWindow();
            }
        };
        jPanel2.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, UIManager.getColor("controlShadow")));
        jPanel2.add((Component)invisibleToolbar, "Center");
        final Runnable runnable = new Runnable(){

            @Override
            public void run() {
                jPanel2.setVisible(false);
            }
        };
        JButton jButton3 = CloseButton.create(runnable);
        String string3 = ActionsSupport.keyAcceleratorString((KeyStroke)keyStroke);
        jButton3.setToolTipText(MessageFormat.format(BTN_CLOSE_TOOLTIP, string3));
        jPanel2.add((Component)jButton3, "East");
        String string4 = "hide-action";
        InputMap inputMap = jPanel2.getInputMap(1);
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                runnable.run();
            }
        };
        jPanel2.getActionMap().put(string4, abstractAction);
        inputMap.put(keyStroke, string4);
        if (jTextComponent != null) {
            inputMap = jTextComponent.getInputMap();
            ActionMap actionMap = jTextComponent.getActionMap();
            String string5 = "search-next-action";
            AbstractAction abstractAction2 = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (editableHistoryCombo.isPopupVisible()) {
                        editableHistoryCombo.hidePopup();
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (jButton2.isEnabled()) {
                                jButton2.doClick();
                            }
                        }
                    });
                }
            };
            actionMap.put(string5, abstractAction2);
            inputMap.put(keyStroke3, string5);
            KeyStroke keyStroke4 = ActionsSupport.registerAction((String)FIND_NEXT_ACTION_KEY, (Action)abstractAction2, (ActionMap)actionMap, (InputMap)inputMap);
            String string6 = ActionsSupport.keyAcceleratorString((KeyStroke)keyStroke4);
            if (string6 != null) {
                jButton2.setToolTipText(MessageFormat.format(BTN_NEXT_TOOLTIP, string2 + ", " + string6));
            }
            String string7 = "search-prev-action";
            AbstractAction abstractAction3 = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (editableHistoryCombo.isPopupVisible()) {
                        editableHistoryCombo.hidePopup();
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (jButton2.isEnabled()) {
                                jButton.doClick();
                            }
                        }
                    });
                }
            };
            actionMap.put(string7, abstractAction3);
            inputMap.put(keyStroke2, string7);
            KeyStroke keyStroke5 = ActionsSupport.registerAction((String)FIND_PREV_ACTION_KEY, (Action)abstractAction3, (ActionMap)actionMap, (InputMap)inputMap);
            String string8 = ActionsSupport.keyAcceleratorString((KeyStroke)keyStroke5);
            if (string8 != null) {
                jButton.setToolTipText(MessageFormat.format(BTN_PREVIOUS_TOOLTIP, string + ", " + string8));
            }
        }
        if (treeHelper != null) {
            profilerTable.putClientProperty(FIND_TREE_HELPER, treeHelper);
        }
        return jPanel2;
    }

    private static String getSearchString(EditableHistoryCombo editableHistoryCombo) {
        String string = editableHistoryCombo.getText();
        return string == null ? null : string.trim();
    }

    private SearchUtils() {
    }

    private static interface Support {

        public static final class SearchActionProvider
        extends ActionsSupportProvider {
            public KeyStroke registerAction(String string, Action action, ActionMap actionMap, InputMap inputMap) {
                KeyStroke keyStroke = null;
                if (SearchUtils.FIND_ACTION_KEY.equals(string)) {
                    keyStroke = KeyStroke.getKeyStroke(71, 2);
                } else if (SearchUtils.FIND_NEXT_ACTION_KEY.equals(string)) {
                    keyStroke = KeyStroke.getKeyStroke(114, 0);
                } else if (SearchUtils.FIND_PREV_ACTION_KEY.equals(string)) {
                    keyStroke = KeyStroke.getKeyStroke(114, 1);
                } else if (SearchUtils.FIND_SEL_ACTION_KEY.equals(string)) {
                    keyStroke = KeyStroke.getKeyStroke(114, 2);
                }
                if (keyStroke != null) {
                    actionMap.put(string, action);
                    inputMap.put(keyStroke, string);
                }
                return keyStroke;
            }
        }
    }

    public static abstract class TreeHelper {
        public static final int NODE_SEARCH_DOWN = 10;
        public static final int NODE_SEARCH_NEXT = 11;
        public static final int NODE_SKIP_DOWN = 100;
        public static final int NODE_SKIP_NEXT = 101;

        public abstract int getNodeType(TreeNode var1);

        int getNodeType(TreePath treePath) {
            return this.getNodeType((TreeNode)treePath.getLastPathComponent());
        }

        static boolean isSearch(int n) {
            return n < 100;
        }

        static boolean isDown(int n) {
            return (n & 1) == 0;
        }
    }
}

