/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.v2.features;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import javax.swing.AbstractButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.ui.components.ProfilerToolbar;
import org.netbeans.lib.profiler.ui.monitor.MonitorView;
import org.netbeans.lib.profiler.ui.swing.GrayLabel;
import org.netbeans.lib.profiler.ui.swing.MultiButtonGroup;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.v2.features.Bundle;
import org.netbeans.modules.profiler.v2.features.FeatureUI;

abstract class MonitorFeatureUI
extends FeatureUI {
    private static final String CPU_GRAPH_FLAG = "CPU_GRAPH_FLAG";
    private static final String MEM_GRAPH_FLAG = "MEM_GRAPH_FLAG";
    private static final String GC_GRAPH_FLAG = "GC_GRAPH_FLAG";
    private static final String THCL_GRAPH_FLAG = "THCL_GRAPH_FLAG";
    private ProfilerToolbar toolbar;
    private MonitorView monitorView;
    private JLabel grLabel;

    MonitorFeatureUI() {
    }

    abstract Profiler getProfiler();

    abstract String readFlag(String var1, String var2);

    abstract void storeFlag(String var1, String var2);

    @Override
    ProfilerToolbar getToolbar() {
        if (this.toolbar == null) {
            this.initUI();
        }
        return this.toolbar;
    }

    @Override
    JPanel getResultsUI() {
        if (this.monitorView == null) {
            this.initUI();
        }
        return this.monitorView;
    }

    void cleanup() {
        if (this.monitorView != null) {
            this.monitorView.cleanup();
        }
    }

    @Override
    void sessionStateChanged(int n) {
        this.refreshToolbar(n);
    }

    private void initUI() {
        assert (SwingUtilities.isEventDispatchThread());
        this.monitorView = new MonitorView(this.getProfiler().getVMTelemetryManager());
        this.monitorView.putClientProperty((Object)"HelpCtx.Key", (Object)"ProfileTelemetry.HelpCtx");
        MultiButtonGroup multiButtonGroup = new MultiButtonGroup();
        this.toolbar = ProfilerToolbar.create((boolean)true);
        this.toolbar.addSpace(2);
        this.toolbar.addSeparator();
        this.toolbar.addSpace(5);
        this.grLabel = new GrayLabel(Bundle.MonitorFeatureUI_graphs());
        this.toolbar.add((Component)this.grLabel);
        this.toolbar.addSpace(2);
        JToggleButton jToggleButton = new JToggleButton(Icons.getIcon((String)"ProfilerIcons.Cpu")){

            @Override
            protected void fireActionPerformed(ActionEvent actionEvent) {
                super.fireActionPerformed(actionEvent);
                MonitorFeatureUI.this.monitorView.setupCPUView(this.isSelected());
            }

            @Override
            protected void fireItemStateChanged(ItemEvent itemEvent) {
                super.fireItemStateChanged(itemEvent);
                MonitorFeatureUI.this.storeFlag(MonitorFeatureUI.CPU_GRAPH_FLAG, this.isSelected() ? null : Boolean.FALSE.toString());
            }
        };
        jToggleButton.putClientProperty("JButton.buttonType", "segmented");
        jToggleButton.putClientProperty("JButton.segmentPosition", "first");
        jToggleButton.setToolTipText(Bundle.MonitorFeatureUI_cpuGraph());
        multiButtonGroup.add((AbstractButton)jToggleButton);
        boolean bl = Boolean.parseBoolean(this.readFlag(CPU_GRAPH_FLAG, Boolean.TRUE.toString()));
        this.monitorView.setupCPUView(bl);
        jToggleButton.setSelected(bl);
        this.toolbar.add((Component)jToggleButton);
        JToggleButton jToggleButton2 = new JToggleButton(Icons.getIcon((String)"ProfilerIcons.Memory")){

            @Override
            protected void fireActionPerformed(ActionEvent actionEvent) {
                super.fireActionPerformed(actionEvent);
                MonitorFeatureUI.this.monitorView.setupMemoryView(this.isSelected());
            }

            @Override
            protected void fireItemStateChanged(ItemEvent itemEvent) {
                super.fireItemStateChanged(itemEvent);
                MonitorFeatureUI.this.storeFlag(MonitorFeatureUI.MEM_GRAPH_FLAG, this.isSelected() ? null : Boolean.FALSE.toString());
            }
        };
        jToggleButton2.putClientProperty("JButton.buttonType", "segmented");
        jToggleButton2.putClientProperty("JButton.segmentPosition", "middle");
        jToggleButton2.setToolTipText(Bundle.MonitorFeatureUI_memoryGraph());
        multiButtonGroup.add((AbstractButton)jToggleButton2);
        boolean bl2 = Boolean.parseBoolean(this.readFlag(MEM_GRAPH_FLAG, Boolean.TRUE.toString()));
        this.monitorView.setupMemoryView(bl2);
        jToggleButton2.setSelected(bl2);
        this.toolbar.add((Component)jToggleButton2);
        JToggleButton jToggleButton3 = new JToggleButton(Icons.getIcon((String)"ProfilerIcons.RunGC")){

            @Override
            protected void fireActionPerformed(ActionEvent actionEvent) {
                super.fireActionPerformed(actionEvent);
                MonitorFeatureUI.this.monitorView.setupGCView(this.isSelected());
            }

            @Override
            protected void fireItemStateChanged(ItemEvent itemEvent) {
                super.fireItemStateChanged(itemEvent);
                MonitorFeatureUI.this.storeFlag(MonitorFeatureUI.GC_GRAPH_FLAG, this.isSelected() ? null : Boolean.FALSE.toString());
            }
        };
        jToggleButton3.putClientProperty("JButton.buttonType", "segmented");
        jToggleButton3.putClientProperty("JButton.segmentPosition", "middle");
        jToggleButton3.setToolTipText(Bundle.MonitorFeatureUI_gcGraph());
        multiButtonGroup.add((AbstractButton)jToggleButton3);
        boolean bl3 = Boolean.parseBoolean(this.readFlag(GC_GRAPH_FLAG, Boolean.TRUE.toString()));
        this.monitorView.setupGCView(bl3);
        jToggleButton3.setSelected(bl3);
        this.toolbar.add((Component)jToggleButton3);
        JToggleButton jToggleButton4 = new JToggleButton(Icons.getIcon((String)"ProfilerIcons.WindowThreads")){

            @Override
            protected void fireActionPerformed(ActionEvent actionEvent) {
                super.fireActionPerformed(actionEvent);
                MonitorFeatureUI.this.monitorView.setupThreadsView(this.isSelected());
            }

            @Override
            protected void fireItemStateChanged(ItemEvent itemEvent) {
                super.fireItemStateChanged(itemEvent);
                MonitorFeatureUI.this.storeFlag(MonitorFeatureUI.THCL_GRAPH_FLAG, this.isSelected() ? null : Boolean.FALSE.toString());
            }
        };
        jToggleButton4.putClientProperty("JButton.buttonType", "segmented");
        jToggleButton4.putClientProperty("JButton.segmentPosition", "last");
        jToggleButton4.setToolTipText(Bundle.MonitorFeatureUI_threadsGraph());
        multiButtonGroup.add((AbstractButton)jToggleButton4);
        boolean bl4 = Boolean.parseBoolean(this.readFlag(THCL_GRAPH_FLAG, Boolean.TRUE.toString()));
        this.monitorView.setupThreadsView(bl4);
        jToggleButton4.setSelected(bl4);
        this.toolbar.add((Component)jToggleButton4);
        this.sessionStateChanged(this.getSessionState());
    }

    private void refreshToolbar(int n) {
    }
}

