/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.UserCancelException;

public final class PropertiesMembershipChoiceDialog
extends ExtendedDialog {
    private final transient ExistingBothNewChoice tags;
    private final transient ExistingBothNewChoice memberships;

    private PropertiesMembershipChoiceDialog(boolean preselectNew, boolean queryTags, boolean queryMemberships) {
        super((Component)MainApplication.getMainFrame(), I18n.tr("Tags/Memberships", new Object[0]), I18n.tr("Unglue", new Object[0]), I18n.tr("Cancel", new Object[0]));
        this.setButtonIcons("unglueways", "cancel");
        JPanel content = new JPanel(new GridBagLayout());
        if (queryTags) {
            content.add((Component)new JLabel(I18n.tr("Where should the tags of the node be put?", new Object[0])), GBC.std(1, 1).span(3).insets(0, 20, 0, 0));
            this.tags = new ExistingBothNewChoice(preselectNew);
            content.add((Component)this.tags.oldNode, GBC.std(1, 2));
            content.add((Component)this.tags.bothNodes, GBC.std(2, 2));
            content.add((Component)this.tags.newNode, GBC.std(3, 2));
        } else {
            this.tags = null;
        }
        if (queryMemberships) {
            content.add((Component)new JLabel(I18n.tr("Where should the memberships of this node be put?", new Object[0])), GBC.std(1, 3).span(3).insets(0, 20, 0, 0));
            this.memberships = new ExistingBothNewChoice(preselectNew);
            content.add((Component)this.memberships.oldNode, GBC.std(1, 4));
            content.add((Component)this.memberships.bothNodes, GBC.std(2, 4));
            content.add((Component)this.memberships.newNode, GBC.std(3, 4));
        } else {
            this.memberships = null;
        }
        this.setContent(content);
        this.setResizable(false);
    }

    public ExistingBothNewChoice getTags() {
        return this.tags;
    }

    public ExistingBothNewChoice getMemberships() {
        return this.memberships;
    }

    public static PropertiesMembershipChoiceDialog showIfNecessary(Collection<Node> selectedNodes, boolean preselectNew) throws UserCancelException {
        boolean queryTags = PropertiesMembershipChoiceDialog.isTagged(selectedNodes);
        boolean queryMemberships = PropertiesMembershipChoiceDialog.isUsedInRelations(selectedNodes);
        if (queryTags || queryMemberships) {
            PropertiesMembershipChoiceDialog dialog = new PropertiesMembershipChoiceDialog(preselectNew, queryTags, queryMemberships);
            dialog.showDialog();
            if (dialog.getValue() != 1) {
                throw new UserCancelException();
            }
            return dialog;
        }
        return null;
    }

    private static boolean isTagged(Collection<Node> existingNodes) {
        return existingNodes.stream().anyMatch(AbstractPrimitive::hasKeys);
    }

    private static boolean isUsedInRelations(Collection<Node> existingNodes) {
        return existingNodes.stream().anyMatch(selectedNode -> selectedNode.getReferrers().stream().anyMatch(Relation.class::isInstance));
    }

    public static class ExistingBothNewChoice {
        public final AbstractButton oldNode = new JToggleButton(I18n.tr("Existing node", new Object[0]), ImageProvider.get("dialogs/conflict/tagkeeptheir"));
        public final AbstractButton bothNodes = new JToggleButton(I18n.tr("Both nodes", new Object[0]), ImageProvider.get("dialogs/conflict/tagundecide"));
        public final AbstractButton newNode = new JToggleButton(I18n.tr("New node", new Object[0]), ImageProvider.get("dialogs/conflict/tagkeepmine"));

        ExistingBothNewChoice(boolean preselectNew) {
            ButtonGroup tagsGroup = new ButtonGroup();
            tagsGroup.add(this.oldNode);
            tagsGroup.add(this.bothNodes);
            tagsGroup.add(this.newNode);
            tagsGroup.setSelected((preselectNew ? this.newNode : this.oldNode).getModel(), true);
        }
    }
}

