/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.lm.values;

import edu.berkeley.nlp.lm.array.CustomWidthArray;
import edu.berkeley.nlp.lm.collections.LongToIntHashMap;
import edu.berkeley.nlp.lm.util.Annotations;
import edu.berkeley.nlp.lm.util.LongRef;
import edu.berkeley.nlp.lm.values.RankedValueContainer;
import edu.berkeley.nlp.lm.values.ValueContainer;

public final class CountValueContainer
extends RankedValueContainer<LongRef> {
    private static final long serialVersionUID = 964277160049236607L;
    @Annotations.PrintMemoryCount
    private final long[] countsForRank;
    private transient LongToIntHashMap countIndexer;
    private long unigramSum = 0L;

    public CountValueContainer(LongToIntHashMap countCounter, int valueRadix, boolean storePrefixes, long[] numNgramsForEachOrder) {
        super(valueRadix, storePrefixes, numNgramsForEachOrder);
        boolean hasDefaultVal = countCounter.get(this.getDefaultVal().asLong(), -1) >= 0;
        this.countsForRank = new long[countCounter.size() + (hasDefaultVal ? 0 : 1)];
        this.countIndexer = new LongToIntHashMap();
        int k = 0;
        for (LongToIntHashMap.Entry pair : countCounter.getObjectsSortedByValue(true)) {
            this.countIndexer.put(pair.key, this.countIndexer.size());
            this.countsForRank[k++] = pair.key;
            if (this.countIndexer.size() != 10 || hasDefaultVal) continue;
            this.countIndexer.put(this.getDefaultVal().asLong(), this.countIndexer.size());
            this.countsForRank[k++] = this.getDefaultVal().asLong();
        }
        if (this.countIndexer.size() < 10 && !hasDefaultVal) {
            this.countIndexer.put(this.getDefaultVal().asLong(), this.countIndexer.size());
            this.countsForRank[k++] = this.getDefaultVal().asLong();
        }
        this.valueWidth = CustomWidthArray.numBitsNeeded(this.countIndexer.size());
    }

    private CountValueContainer(int valueRadix, boolean storePrefixIndexes, long[] numNgramsForEachOrder, long[] countsForRank, LongToIntHashMap countIndexer, int wordWidth) {
        super(valueRadix, storePrefixIndexes, numNgramsForEachOrder);
        this.countsForRank = countsForRank;
        this.countIndexer = countIndexer;
        this.valueWidth = wordWidth;
    }

    public CountValueContainer createFreshValues(long[] numNgramsForEachOrder_) {
        return new CountValueContainer(this.valueRadix, this.storeSuffixIndexes, numNgramsForEachOrder_, this.countsForRank, this.countIndexer, this.valueWidth);
    }

    @Override
    public void getFromOffset(long index, int ngramOrder, @Annotations.OutputParameter LongRef outputVal) {
        outputVal.value = this.getCount(ngramOrder, index, this.countsForRank);
    }

    @Override
    protected void getFromRank(long rank, @Annotations.OutputParameter LongRef outputVal) {
        outputVal.value = this.countsForRank[(int)rank];
    }

    public final long getCount(int ngramOrder, long index) {
        return this.getCount(ngramOrder, index, this.countsForRank);
    }

    private long getCount(int ngramOrder, long index, long[] array) {
        int countIndex = (int)this.valueRanks[ngramOrder].get(index);
        return array[countIndex];
    }

    @Override
    protected LongRef getDefaultVal() {
        return new LongRef(-1L);
    }

    @Override
    public void trimAfterNgram(int ngramOrder, long size) {
        super.trimAfterNgram(ngramOrder, size);
        if (ngramOrder == 0) {
            int i = 0;
            while ((long)i < this.valueRanks[ngramOrder].size()) {
                this.unigramSum += this.countsForRank[(int)this.valueRanks[ngramOrder].get(i)];
                ++i;
            }
        }
    }

    public long getUnigramSum() {
        return this.unigramSum;
    }

    @Override
    public LongRef getScratchValue() {
        return new LongRef(-1L);
    }

    @Override
    public void setFromOtherValues(ValueContainer<LongRef> o) {
        super.setFromOtherValues(o);
        this.countIndexer = ((CountValueContainer)o).countIndexer;
    }

    @Override
    public void trim() {
        super.trim();
        this.countIndexer = null;
    }

    @Override
    protected long getCountRank(long val) {
        return this.countIndexer.get(val, -1);
    }
}

