/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.DoubleCharHashMap;
import com.carrotsearch.hppc.HashOrderMixing;

public class DoubleCharScatterMap
extends DoubleCharHashMap {
    public DoubleCharScatterMap() {
        this(4);
    }

    public DoubleCharScatterMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public DoubleCharScatterMap(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor, HashOrderMixing.none());
    }

    @Override
    protected int hashKey(double key) {
        return BitMixer.mixPhi(key);
    }

    public static DoubleCharScatterMap from(double[] keys, char[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        DoubleCharScatterMap map = new DoubleCharScatterMap(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }
}

