/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.annotation;

import java.util.ArrayList;
import org.protege.editor.owl.model.annotation.AnnotationProvider;
import org.protege.editor.owl.model.annotation.AnnotationValueProvider;
import org.protege.editor.owl.model.annotation.DateAnnotationValueProvider;
import org.protege.editor.owl.model.annotation.DefaultDateAnnotationPropertyIriProvider;
import org.protege.editor.owl.model.annotation.DefaultUserNameAnnotationPropertyIriProvider;
import org.protege.editor.owl.model.annotation.EntityCreationMetadataPreferencesManager;
import org.protege.editor.owl.model.annotation.EntityCreationMetadataProvider;
import org.protege.editor.owl.model.annotation.OrcidAnnotationValueProvider;
import org.protege.editor.owl.model.annotation.SimpleEntityCreationMetadataProvider;
import org.protege.editor.owl.model.annotation.UserNameAnnotationValueProvider;
import org.protege.editor.owl.model.user.DefaultUserNameProvider;
import org.protege.editor.owl.model.user.OrcidPreferencesManager;
import org.protege.editor.owl.model.user.UserNamePreferencesManager;

public class PreferencesBasedEntityCreationMetadataProviderFactory {
    private final UserNamePreferencesManager userNamePreferencesManager;
    private final OrcidPreferencesManager orcidPreferencesManager;
    private final EntityCreationMetadataPreferencesManager metadataPreferencesManager;

    public PreferencesBasedEntityCreationMetadataProviderFactory(UserNamePreferencesManager userNamePreferencesManager, OrcidPreferencesManager orcidPreferencesManager, EntityCreationMetadataPreferencesManager metadataPreferencesManager) {
        this.userNamePreferencesManager = userNamePreferencesManager;
        this.orcidPreferencesManager = orcidPreferencesManager;
        this.metadataPreferencesManager = metadataPreferencesManager;
    }

    public EntityCreationMetadataProvider getProvider() {
        AnnotationProvider provider;
        ArrayList<AnnotationProvider> fields = new ArrayList<AnnotationProvider>();
        if (this.metadataPreferencesManager.isCreatedByAnnotationEnabled()) {
            provider = this.getCreatedByAnnotationProvider();
            fields.add(provider);
        }
        if (this.metadataPreferencesManager.isCreationDateAnnotationEnabled()) {
            provider = this.getCreationDateAnnotationProvider();
            fields.add(provider);
        }
        return new SimpleEntityCreationMetadataProvider(fields);
    }

    private AnnotationProvider getCreationDateAnnotationProvider() {
        return new AnnotationProvider(new DefaultDateAnnotationPropertyIriProvider(this.metadataPreferencesManager), new DateAnnotationValueProvider(this.metadataPreferencesManager.getDateFormatter()));
    }

    private AnnotationProvider getCreatedByAnnotationProvider() {
        AnnotationValueProvider createdByValueProvider = this.metadataPreferencesManager.isCreatedByValueOrcid() && this.orcidPreferencesManager.getOrcid().isPresent() ? new OrcidAnnotationValueProvider(this.orcidPreferencesManager) : new UserNameAnnotationValueProvider(new DefaultUserNameProvider(this.userNamePreferencesManager, System.getProperties()));
        return new AnnotationProvider(new DefaultUserNameAnnotationPropertyIriProvider(this.metadataPreferencesManager), createdByValueProvider);
    }
}

