/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.ui.UIUtils;

public abstract class SwingWorker {
    private static ExecutorService warmupService;
    private static ExecutorService taskService;
    private final Object warmupLock = new Object();
    private boolean useEQ;
    private final Semaphore throughputSemaphore;
    private final AtomicBoolean cancelFlag = new AtomicBoolean(false);
    private final AtomicBoolean primed = new AtomicBoolean(true);
    private boolean workerRunning;
    private Runnable warmupTimer = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = SwingWorker.this.warmupLock;
            synchronized (object) {
                try {
                    if (SwingWorker.this.workerRunning) {
                        SwingWorker.this.warmupLock.wait(SwingWorker.this.getWarmup());
                    }
                    if (SwingWorker.this.workerRunning && !SwingWorker.this.isCancelled()) {
                        SwingWorker.this.nonResponding();
                    }
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        }
    };

    public SwingWorker(boolean bl) {
        this(bl, null);
    }

    public SwingWorker() {
        this(true, null);
    }

    public SwingWorker(Semaphore semaphore) {
        this(true, semaphore);
    }

    public SwingWorker(boolean bl, Semaphore semaphore) {
        SwingWorker.sinit();
        this.useEQ = bl;
        this.throughputSemaphore = semaphore;
    }

    public void execute() {
        if (!this.primed.compareAndSet(true, false)) {
            throw new IllegalStateException("SwingWorker instance may be used only once");
        }
        this.postRunnable(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block32: {
                    try {
                        if (SwingWorker.this.throughputSemaphore != null) {
                            SwingWorker.this.throughputSemaphore.acquire();
                        }
                        if (SwingWorker.this.isCancelled()) break block32;
                        Object object = SwingWorker.this.warmupLock;
                        synchronized (object) {
                            SwingWorker.this.workerRunning = true;
                        }
                        warmupService.submit(SwingWorker.this.warmupTimer);
                        try {
                            SwingWorker.this.doInBackground();
                        }
                        catch (Throwable throwable) {
                            try {
                                Logger.getLogger(SwingWorker.class.getName()).log(Level.SEVERE, "SwingWorker", throwable);
                            }
                            catch (Throwable throwable2) {
                                Object object2 = SwingWorker.this.warmupLock;
                                synchronized (object2) {
                                    SwingWorker.this.workerRunning = false;
                                    SwingWorker.this.warmupLock.notify();
                                }
                                if (!SwingWorker.this.isCancelled()) {
                                    if (SwingWorker.this.useEQ) {
                                        SwingWorker.runInEventDispatchThread(new Runnable(){

                                            @Override
                                            public void run() {
                                                SwingWorker.this.done();
                                            }
                                        });
                                    } else {
                                        SwingWorker.this.done();
                                    }
                                }
                                throw throwable2;
                            }
                            Object object3 = SwingWorker.this.warmupLock;
                            synchronized (object3) {
                                SwingWorker.this.workerRunning = false;
                                SwingWorker.this.warmupLock.notify();
                            }
                            if (!SwingWorker.this.isCancelled()) {
                                if (SwingWorker.this.useEQ) {
                                    SwingWorker.runInEventDispatchThread(new /* invalid duplicate definition of identical inner class */);
                                } else {
                                    SwingWorker.this.done();
                                }
                            }
                            break block32;
                        }
                        object = SwingWorker.this.warmupLock;
                        synchronized (object) {
                            SwingWorker.this.workerRunning = false;
                            SwingWorker.this.warmupLock.notify();
                        }
                        if (!SwingWorker.this.isCancelled()) {
                            if (SwingWorker.this.useEQ) {
                                SwingWorker.runInEventDispatchThread(new /* invalid duplicate definition of identical inner class */);
                            } else {
                                SwingWorker.this.done();
                            }
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    finally {
                        if (SwingWorker.this.throughputSemaphore != null) {
                            SwingWorker.this.throughputSemaphore.release();
                        }
                    }
                }
            }
        });
    }

    public final void cancel() {
        if (this.cancelFlag.compareAndSet(false, true)) {
            this.cancelled();
            if (this.throughputSemaphore != null) {
                this.throughputSemaphore.release();
            }
        }
    }

    protected final boolean isCancelled() {
        return this.cancelFlag.get();
    }

    protected int getWarmup() {
        return 500;
    }

    protected abstract void doInBackground();

    protected void done() {
    }

    protected void cancelled() {
    }

    protected void nonResponding() {
    }

    protected void postRunnable(Runnable runnable) {
        taskService.submit(runnable);
    }

    static synchronized void sinit() {
        if (warmupService == null) {
            UIUtils.runInEventDispatchThreadAndWait(new Runnable(){

                @Override
                public void run() {
                    warmupService = Executors.newCachedThreadPool();
                    taskService = Executors.newCachedThreadPool();
                }
            });
        }
    }

    private static void runInEventDispatchThread(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    private static void runInEventDispatchThreadAndWait(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }
}

