# Reference
<!-- DO NOT EDIT: This document was generated by Puppet Strings -->

## Table of Contents

**Resource types**

* [`yumrepo`](#yumrepo): The client-side description of a yum repository. Repository configurations are found by parsing `/etc/yum.conf` and the files indicated by th

## Resource types

### yumrepo

The client-side description of a yum repository. Repository
configurations are found by parsing `/etc/yum.conf` and
the files indicated by the `reposdir` option in that file
(see `yum.conf(5)` for details).

Most parameters are identical to the ones documented
in the `yum.conf(5)` man page.

Continuation lines that yum supports (for the `baseurl`, for example)
are not supported. This type does not attempt to read or verify the
existence of files listed in the `include` attribute.

#### Properties

The following properties are available in the `yumrepo` type.

##### `ensure`

Valid values: present, absent

The basic property that the resource should be in.

Default value: present

##### `descr`

Valid values: %r{.*}, absent

A human-readable description of the repository.
This corresponds to the name parameter in `yum.conf(5)`.

##### `mirrorlist`

Valid values: %r{.*}, absent

The URL that holds the list of mirrors for this repository.

##### `baseurl`

Valid values: %r{.*}, absent

The URL for this repository.

##### `enabled`

Valid values: YUM_BOOLEAN, absent

Whether this repository is enabled.

##### `gpgcheck`

Valid values: YUM_BOOLEAN, absent

Whether to check the GPG signature on packages installed
from this repository.

##### `payload_gpgcheck`

Valid values: YUM_BOOLEAN, absent

Whether to check the GPG signature of the packages payload.

##### `repo_gpgcheck`

Valid values: YUM_BOOLEAN, absent

Whether to check the GPG signature on repodata.

##### `gpgkey`

Valid values: %r{.*}, absent

The URL for the GPG key with which packages from this
repository are signed.

##### `mirrorlist_expire`

Valid values: %r{^[0-9]+$}, absent

Time (in seconds) after which the mirrorlist locally cached
will expire.\n

##### `include`

Valid values: %r{.*}, absent

The URL of a remote file containing additional yum configuration
settings. Puppet does not check for this file's existence or validity.

##### `exclude`

Valid values: %r{.*}, absent

The string of package names or shell globs separated by spaces to exclude.
Packages that match the package name given or shell globs will never be
considered in updates or installs for this repo.

##### `gpgcakey`

Valid values: %r{.*}, absent

The URL for the GPG CA key for this repository.

##### `includepkgs`

Valid values: %r{.*}, absent

The string of package names or shell globs separated by spaces to
include. If this is set, only packages matching one of the package
names or shell globs will be considered for update or install
from this repository.

##### `enablegroups`

Valid values: YUM_BOOLEAN, absent

Whether yum will allow the use of package groups for this
repository.

##### `failovermethod`

Valid values: %r{^roundrobin|priority$}, absent

The failover method for this repository; should be either
`roundrobin` or `priority`.

##### `keepalive`

Valid values: YUM_BOOLEAN, absent

Whether HTTP/1.1 keepalive should be used with this repository.

##### `retries`

Valid values: %r{^[0-9]+$}, absent

Set the number of times any attempt to retrieve a file should
 retry before returning an error. Setting this to `0` makes yum
try forever.\n

##### `http_caching`

Valid values: %r{^(packages|all|none)$}, absent

What to cache from this repository.

##### `timeout`

Valid values: %r{^\d+$}, absent

Number of seconds to wait for a connection before timing
out.

##### `metadata_expire`

Valid values: %r{^([0-9]+[dhm]?|never)$}, absent

Number of seconds after which the metadata will expire.

##### `protect`

Valid values: YUM_BOOLEAN, absent

Enable or disable protection for this repository. Requires
that the `protectbase` plugin is installed and enabled.

##### `priority`

Valid values: %r{^-?\d+$}, absent

Priority of this repository. Can be any integer value
(including negative). Requires that the `priorities` plugin
is installed and enabled.

##### `throttle`

Valid values: %r{^\d+[kMG%]?$}, absent

Enable bandwidth throttling for downloads. This option
can be expressed as a absolute data rate in bytes/sec or a
percentage `60%`. An SI prefix (k, M or G) may be appended
to the data rate values.\n

##### `bandwidth`

Valid values: %r{^\d+[kMG]?$}, absent

Use to specify the maximum available network bandwidth
in bytes/second. Used with the `throttle` option. If `throttle`
is a percentage and `bandwidth` is `0` then bandwidth throttling
will be disabled. If `throttle` is expressed as a data rate then
this option is ignored.\n

##### `cost`

Valid values: %r{^\d+$}, absent

Cost of this repository.

##### `proxy`

Valid values: %r{.*}, absent

URL of a proxy server that Yum should use when accessing this repository.
This attribute can also be set to `'_none_'`, which will make Yum bypass any
global proxy settings when accessing this repository.

##### `proxy_username`

Valid values: %r{.*}, absent

Username for this proxy.

##### `proxy_password`

Valid values: %r{.*}, absent

Password for this proxy.

##### `s3_enabled`

Valid values: YUM_BOOLEAN, absent

Access the repository via S3.

##### `sslcacert`

Valid values: %r{.*}, absent

Path to the directory containing the databases of the
certificate authorities yum should use to verify SSL certificates.

##### `sslverify`

Valid values: YUM_BOOLEAN, absent

Should yum verify SSL certificates/hosts at all.

##### `sslclientcert`

Valid values: %r{.*}, absent

Path  to the SSL client certificate yum should use to connect
to repositories/remote sites.

##### `sslclientkey`

Valid values: %r{.*}, absent

Path to the SSL client key yum should use to connect
to repositories/remote sites.

##### `metalink`

Valid values: %r{.*}, absent

Metalink for mirrors.

##### `skip_if_unavailable`

Valid values: YUM_BOOLEAN, absent

Should yum skip this repository if unable to reach it.

##### `assumeyes`

Valid values: YUM_BOOLEAN, absent

Determines if yum prompts for confirmation of critical actions.

##### `deltarpm_percentage`

Valid values: %r{^\d+$}, absent

Percentage value that determines when to use deltas for this repository.
When the delta is larger than this percentage value of the package, the
delta is not used.

##### `deltarpm_metadata_percentage`

Valid values: %r{^\d+$}, absent

Percentage value that determines when to download deltarpm metadata.
When the deltarpm metadata is larger than this percentage value of the
package, deltarpm metadata is not downloaded.

##### `username`

Valid values: %r{.*}, absent

Username to use for basic authentication to a repo or really any url.

##### `password`

Valid values: %r{.*}, absent

Password to use with the username for basic authentication.

#### Parameters

The following parameters are available in the `yumrepo` type.

##### `name`

namevar

The name of the repository.  This corresponds to the
`repositoryid` parameter in `yum.conf(5)`.

##### `target`

The target parameter will be enabled in a future release and should not be used.

Default value: absent

