/*
 * Decompiled with CFR 0.152.
 */
package jnr.constants.platform.solaris;

import java.util.EnumMap;
import java.util.Map;
import jnr.constants.Constant;

public enum TCP implements Constant
{
    TCP_MSS(536L),
    TCP_NODELAY(1L),
    TCP_MAXSEG(2L),
    TCP_KEEPALIVE(8L);

    private final long value;
    public static final long MIN_VALUE = 1L;
    public static final long MAX_VALUE = 536L;

    private TCP(long value2) {
        this.value = value2;
    }

    public final String toString() {
        return StringTable.descriptions.get(this);
    }

    public final int value() {
        return (int)this.value;
    }

    @Override
    public final int intValue() {
        return (int)this.value;
    }

    @Override
    public final long longValue() {
        return this.value;
    }

    @Override
    public final boolean defined() {
        return true;
    }

    static final class StringTable {
        public static final Map<TCP, String> descriptions = StringTable.generateTable();

        StringTable() {
        }

        public static final Map<TCP, String> generateTable() {
            EnumMap<TCP, String> map2 = new EnumMap<TCP, String>(TCP.class);
            map2.put(TCP_MSS, "TCP_MSS");
            map2.put(TCP_NODELAY, "TCP_NODELAY");
            map2.put(TCP_MAXSEG, "TCP_MAXSEG");
            map2.put(TCP_KEEPALIVE, "TCP_KEEPALIVE");
            return map2;
        }
    }
}

