/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.lexer;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.EUCJPEncoding;
import org.jcodings.specific.SJISEncoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.Ruby;
import org.jruby.RubyEncoding;
import org.jruby.RubyRegexp;
import org.jruby.exceptions.RaiseException;
import org.jruby.lexer.LexerSource;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.lexer.yacc.SimpleSourcePosition;
import org.jruby.lexer.yacc.StackState;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.CommonByteLists;
import org.jruby.util.KCode;
import org.jruby.util.RegexpOptions;
import org.jruby.util.StringSupport;
import org.jruby.util.io.EncodingUtils;

public abstract class LexingCommon {
    public static final int EXPR_BEG = 1;
    public static final int EXPR_END = 2;
    public static final int EXPR_ENDARG = 4;
    public static final int EXPR_ENDFN = 8;
    public static final int EXPR_ARG = 16;
    public static final int EXPR_CMDARG = 32;
    public static final int EXPR_MID = 64;
    public static final int EXPR_FNAME = 128;
    public static final int EXPR_DOT = 256;
    public static final int EXPR_CLASS = 512;
    public static final int EXPR_LABEL = 1024;
    public static final int EXPR_LABELED = 2048;
    public static final int EXPR_FITEM = 4096;
    public static final int EXPR_VALUE = 1;
    public static final int EXPR_BEG_ANY = 577;
    public static final int EXPR_ARG_ANY = 48;
    public static final int EXPR_END_ANY = 14;
    protected int braceNest = 0;
    public boolean commandStart;
    protected StackState conditionState = new StackState();
    protected StackState cmdArgumentState = new StackState();
    private ByteList current_arg;
    private Encoding current_enc;
    protected boolean __end__seen = false;
    public boolean eofp = false;
    protected boolean has_shebang = false;
    protected int heredoc_end = 0;
    protected int heredoc_indent = 0;
    protected int heredoc_line_indent = 0;
    public boolean inKwarg = false;
    protected int last_cr_line;
    protected int last_state;
    private int leftParenBegin = 0;
    public ByteList lexb = null;
    public ByteList lex_lastline = null;
    protected ByteList lex_nextline = null;
    public int lex_p = 0;
    protected int lex_pbeg = 0;
    public int lex_pend = 0;
    protected int lex_state;
    protected int line_count = 0;
    protected int line_offset = 0;
    protected int parenNest = 0;
    protected int ruby_sourceline = 0;
    protected LexerSource src;
    protected int token;
    private int tokenCR;
    protected boolean tokenSeen = false;
    public ISourcePosition tokline;
    public int tokp = 0;
    protected Object yaccValue;
    public final ByteList BACKTICK = new ByteList(new byte[]{96}, USASCII_ENCODING);
    public final ByteList EQ_EQ_EQ = new ByteList(new byte[]{61, 61, 61}, USASCII_ENCODING);
    public final ByteList EQ_EQ = new ByteList(new byte[]{61, 61}, USASCII_ENCODING);
    protected ByteList EQ_TILDE = new ByteList(new byte[]{61, 126}, USASCII_ENCODING);
    protected ByteList EQ_GT = new ByteList(new byte[]{61, 62}, USASCII_ENCODING);
    protected ByteList EQ = new ByteList(new byte[]{61}, USASCII_ENCODING);
    public static final ByteList AMPERSAND_AMPERSAND = CommonByteLists.AMPERSAND_AMPERSAND;
    protected ByteList AMPERSAND = new ByteList(new byte[]{38}, USASCII_ENCODING);
    public ByteList AMPERSAND_DOT = new ByteList(new byte[]{38, 46}, USASCII_ENCODING);
    public final ByteList BANG = new ByteList(new byte[]{33}, USASCII_ENCODING);
    protected ByteList BANG_EQ = new ByteList(new byte[]{33, 61}, USASCII_ENCODING);
    protected ByteList BANG_TILDE = new ByteList(new byte[]{33, 126}, USASCII_ENCODING);
    protected ByteList CARET = new ByteList(new byte[]{94}, USASCII_ENCODING);
    protected ByteList COLON_COLON = new ByteList(new byte[]{58, 58}, USASCII_ENCODING);
    protected ByteList COLON = new ByteList(new byte[]{58}, USASCII_ENCODING);
    protected ByteList COMMA = new ByteList(new byte[]{44}, USASCII_ENCODING);
    protected ByteList DOT_DOT_DOT = new ByteList(new byte[]{46, 46, 46}, USASCII_ENCODING);
    protected ByteList DOT_DOT = new ByteList(new byte[]{46, 46}, USASCII_ENCODING);
    public ByteList DOT = new ByteList(new byte[]{46}, USASCII_ENCODING);
    protected ByteList GT_EQ = new ByteList(new byte[]{62, 61}, USASCII_ENCODING);
    protected ByteList GT_GT = new ByteList(new byte[]{62, 62}, USASCII_ENCODING);
    protected ByteList GT = new ByteList(new byte[]{62}, USASCII_ENCODING);
    protected ByteList LBRACKET_RBRACKET_EQ = new ByteList(new byte[]{91, 93, 61}, USASCII_ENCODING);
    public static ByteList LBRACKET_RBRACKET = new ByteList(new byte[]{91, 93}, USASCIIEncoding.INSTANCE);
    protected ByteList LBRACKET = new ByteList(new byte[]{91}, USASCII_ENCODING);
    protected ByteList LCURLY = new ByteList(new byte[]{123}, USASCII_ENCODING);
    protected ByteList LT_EQ_RT = new ByteList(new byte[]{60, 61, 62}, USASCII_ENCODING);
    protected ByteList LT_EQ = new ByteList(new byte[]{60, 61}, USASCII_ENCODING);
    protected ByteList LT_LT = new ByteList(new byte[]{60, 60}, USASCII_ENCODING);
    protected ByteList LT = new ByteList(new byte[]{60}, USASCII_ENCODING);
    protected ByteList MINUS_AT = new ByteList(new byte[]{45, 64}, USASCII_ENCODING);
    protected ByteList MINUS = new ByteList(new byte[]{45}, USASCII_ENCODING);
    protected ByteList MINUS_GT = new ByteList(new byte[]{45, 62}, USASCII_ENCODING);
    protected ByteList PERCENT = new ByteList(new byte[]{37}, USASCII_ENCODING);
    public static final ByteList OR_OR = CommonByteLists.OR_OR;
    protected ByteList OR = new ByteList(new byte[]{124}, USASCII_ENCODING);
    protected ByteList PLUS_AT = new ByteList(new byte[]{43, 64}, USASCII_ENCODING);
    protected ByteList PLUS = new ByteList(new byte[]{43}, USASCII_ENCODING);
    protected ByteList QUESTION = new ByteList(new byte[]{63}, USASCII_ENCODING);
    protected ByteList RBRACKET = new ByteList(new byte[]{93}, USASCII_ENCODING);
    protected ByteList RCURLY = new ByteList(new byte[]{125}, USASCII_ENCODING);
    protected ByteList RPAREN = new ByteList(new byte[]{41}, USASCII_ENCODING);
    protected ByteList Q = new ByteList(new byte[]{39}, USASCII_ENCODING);
    protected ByteList SLASH = new ByteList(new byte[]{47}, USASCII_ENCODING);
    protected ByteList STAR = new ByteList(new byte[]{42}, USASCII_ENCODING);
    protected ByteList STAR_STAR = new ByteList(new byte[]{42, 42}, USASCII_ENCODING);
    protected ByteList TILDE = new ByteList(new byte[]{126}, USASCII_ENCODING);
    protected ByteList QQ = new ByteList(new byte[]{34}, USASCII_ENCODING);
    protected ByteList SEMICOLON = new ByteList(new byte[]{59}, USASCII_ENCODING);
    protected ByteList BACKSLASH = new ByteList(new byte[]{92}, USASCII_ENCODING);
    public static final ByteList CALL = new ByteList(new byte[]{99, 97, 108, 108}, USASCIIEncoding.INSTANCE);
    public static final ByteList DOLLAR_BANG = new ByteList(new byte[]{36, 33}, USASCIIEncoding.INSTANCE);
    public static final ByteList DOLLAR_UNDERSCORE = new ByteList(new byte[]{36, 95}, USASCIIEncoding.INSTANCE);
    public static final ByteList DOLLAR_DOT = new ByteList(new byte[]{36, 95}, USASCIIEncoding.INSTANCE);
    public static final int TAB_WIDTH = 8;
    public static final int STR_FUNC_ESCAPE = 1;
    public static final int STR_FUNC_EXPAND = 2;
    public static final int STR_FUNC_REGEXP = 4;
    public static final int STR_FUNC_QWORDS = 8;
    public static final int STR_FUNC_SYMBOL = 16;
    public static final int STR_FUNC_INDENT = 32;
    public static final int STR_FUNC_LABEL = 64;
    public static final int STR_FUNC_LIST = 16384;
    public static final int STR_FUNC_TERM = 32768;
    public static final int str_label = 64;
    public static final int str_squote = 0;
    public static final int str_dquote = 2;
    public static final int str_xquote = 2;
    public static final int str_regexp = 7;
    public static final int str_sword = 16392;
    public static final int str_dword = 16394;
    public static final int str_ssym = 16;
    public static final int str_dsym = 18;
    public static final int EOF = -1;
    public static ByteList END_MARKER = new ByteList(new byte[]{95, 95, 69, 78, 68, 95, 95});
    public static ByteList BEGIN_DOC_MARKER = new ByteList(new byte[]{98, 101, 103, 105, 110});
    public static ByteList END_DOC_MARKER = new ByteList(new byte[]{101, 110, 100});
    public static ByteList CODING = new ByteList(new byte[]{99, 111, 100, 105, 110, 103});
    public static final Encoding UTF8_ENCODING = UTF8Encoding.INSTANCE;
    public static final Encoding USASCII_ENCODING = USASCIIEncoding.INSTANCE;
    public static final Encoding ASCII8BIT_ENCODING = ASCIIEncoding.INSTANCE;
    public static final int SUFFIX_R = 1;
    public static final int SUFFIX_I = 2;
    public static final int SUFFIX_ALL = 3;

    public LexingCommon(LexerSource src) {
        this.src = src;
    }

    public int column() {
        return this.tokp - this.lex_pbeg;
    }

    protected boolean comment_at_top() {
        int pend = this.lex_p - 1;
        if (this.line_count != (this.has_shebang ? 2 : 1)) {
            return false;
        }
        for (int p2 = this.lex_pbeg; p2 < pend; ++p2) {
            if (Character.isSpaceChar(this.p(p2))) continue;
            return false;
        }
        return true;
    }

    public int getRubySourceline() {
        return this.ruby_sourceline;
    }

    public void setRubySourceline(int line) {
        this.ruby_sourceline = line;
    }

    public ByteList createTokenByteList() {
        return new ByteList(this.lexb.unsafeBytes(), this.lexb.begin() + this.tokp, this.lex_p - this.tokp, this.getEncoding(), true);
    }

    public ByteList createTokenByteList(int start2) {
        return new ByteList(this.lexb.unsafeBytes(), this.lexb.begin() + start2, this.lex_p - this.tokp, this.getEncoding(), false);
    }

    public String createTokenString(int start2) {
        return this.createAsEncodedString(this.lexb.getUnsafeBytes(), this.lexb.begin() + start2, this.lex_p - start2, this.getEncoding());
    }

    public String createAsEncodedString(byte[] bytes2, int start2, int length2, Encoding encoding2) {
        try {
            Charset charset = EncodingUtils.charsetForEncoding(this.getEncoding());
            if (charset != null) {
                if (charset == RubyEncoding.UTF8) {
                    return RubyEncoding.decodeUTF8(bytes2, start2, length2);
                }
                return new String(bytes2, start2, length2, charset);
            }
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            // empty catch block
        }
        return new String(bytes2, start2, length2);
    }

    public String createTokenString() {
        return this.createTokenString(this.tokp);
    }

    public static int dedent_string(ByteList string2, int width) {
        long len = string2.realSize();
        int col = 0;
        byte[] str = string2.unsafeBytes();
        int begin2 = string2.begin();
        int i2 = 0;
        while ((long)i2 < len && col < width) {
            if (str[begin2 + i2] == 32) {
                ++col;
            } else {
                int n;
                if (str[begin2 + i2] != 9 || (n = 8 * (col / 8 + 1)) > width) break;
                col = n;
            }
            ++i2;
        }
        string2.setBegin(begin2 + i2);
        string2.setRealSize((int)len - i2);
        return i2;
    }

    protected void flush() {
        this.tokp = this.lex_p;
    }

    public int getBraceNest() {
        return this.braceNest;
    }

    public StackState getCmdArgumentState() {
        return this.cmdArgumentState;
    }

    public StackState getConditionState() {
        return this.conditionState;
    }

    public ByteList getCurrentArg() {
        return this.current_arg;
    }

    public String getCurrentLine() {
        return this.lex_lastline.toString();
    }

    public Encoding getEncoding() {
        return this.current_enc;
    }

    public String getFile() {
        return this.src.getFilename();
    }

    public int getHeredocIndent() {
        return this.heredoc_indent;
    }

    public int getHeredocLineIndent() {
        return this.heredoc_line_indent;
    }

    public int getLeftParenBegin() {
        return this.leftParenBegin;
    }

    public ISourcePosition getPosition() {
        if (this.tokline != null && this.ruby_sourceline == this.tokline.getLine()) {
            return this.tokline;
        }
        return new SimpleSourcePosition(this.getFile(), this.ruby_sourceline);
    }

    public int getLineOffset() {
        return this.line_offset;
    }

    public int getState() {
        return this.lex_state;
    }

    public int getTokenCR() {
        return this.tokenCR;
    }

    public int incrementParenNest() {
        ++this.parenNest;
        return this.parenNest;
    }

    public boolean isEndSeen() {
        return this.__end__seen;
    }

    public boolean isASCII() {
        return Encoding.isMbcAscii((byte)this.lexb.get(this.lex_p - 1));
    }

    public boolean isASCII(int c) {
        return Encoding.isMbcAscii((byte)c);
    }

    public int peekVariableName(int tSTRING_DVAR, int tSTRING_DBEG) throws IOException {
        int c = this.nextc();
        int significant = -1;
        switch (c) {
            case 36: {
                int c2 = this.nextc();
                if (c2 == 45) {
                    int c3 = this.nextc();
                    if (c3 == -1) {
                        this.pushback(c3);
                        this.pushback(c2);
                        return 0;
                    }
                    significant = c3;
                    this.pushback(c3);
                    this.pushback(c2);
                    break;
                }
                if (this.isGlobalCharPunct(c2)) {
                    this.setValue("#" + (char)c2);
                    this.pushback(c2);
                    this.pushback(c);
                    return tSTRING_DVAR;
                }
                significant = c2;
                this.pushback(c2);
                break;
            }
            case 64: {
                int c2 = this.nextc();
                if (c2 == 64) {
                    int c3 = this.nextc();
                    if (c3 == -1) {
                        this.pushback(c3);
                        this.pushback(c2);
                        return 0;
                    }
                    significant = c3;
                    this.pushback(c3);
                    this.pushback(c2);
                    break;
                }
                significant = c2;
                this.pushback(c2);
                break;
            }
            case 123: {
                this.setValue("#" + (char)c);
                this.commandStart = true;
                return tSTRING_DBEG;
            }
            default: {
                return 0;
            }
        }
        if (significant != -1 && Character.isAlphabetic(significant) || significant == 95) {
            this.pushback(c);
            this.setValue("#" + significant);
            return tSTRING_DVAR;
        }
        return 0;
    }

    public boolean isGlobalCharPunct(int c) {
        switch (c) {
            case 33: 
            case 34: 
            case 36: 
            case 38: 
            case 39: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 92: 
            case 95: 
            case 96: 
            case 126: {
                return true;
            }
        }
        return this.isIdentifierChar(c);
    }

    public boolean isIdentifierChar(int c) {
        return c != -1 && (Character.isLetterOrDigit(c) || c == 95 || !this.isASCII(c));
    }

    public void lex_goto_eol() {
        this.lex_p = this.lex_pend;
    }

    public int lineno() {
        return this.ruby_sourceline + this.src.getLineOffset();
    }

    protected void magicCommentEncoding(ByteList encoding2) {
        if (!this.comment_at_top()) {
            return;
        }
        this.setEncoding(encoding2);
    }

    public void newtok(boolean unreadOnce) {
        this.tokline = this.getPosition();
        this.tokenCR = 16;
        this.tokp = this.lex_p - (unreadOnce ? 1 : 0);
    }

    protected int numberLiteralSuffix(int mask) throws IOException {
        int c = this.nextc();
        if (c == 105) {
            return (mask & 2) != 0 ? mask & 2 : 0;
        }
        if (c == 114) {
            int result2 = 0;
            if ((mask & 1) != 0) {
                result2 |= mask & 1;
            }
            if (this.peek(105) && (mask & 2) != 0) {
                c = this.nextc();
                result2 |= mask & 2;
            }
            return result2;
        }
        if (c == 46) {
            int c2 = this.nextc();
            if (Character.isDigit(c2)) {
                this.compile_error("unexpected fraction part after numeric literal");
                while (this.isIdentifierChar(c2 = this.nextc())) {
                }
            } else {
                this.pushback(c2);
            }
        }
        this.pushback(c);
        return 0;
    }

    public void parser_prepare() {
        int c = this.nextc();
        switch (c) {
            case 35: {
                if (!this.peek(33)) break;
                this.has_shebang = true;
                break;
            }
            case 239: {
                if (this.lex_pend - this.lex_p < 2 || this.p(this.lex_p) != 187 || this.p(this.lex_p + 1) != 191) break;
                this.setEncoding(UTF8_ENCODING);
                this.lex_p += 2;
                this.lex_pbeg = this.lex_p;
                return;
            }
            case -1: {
                return;
            }
        }
        this.pushback(c);
        this.current_enc = this.lex_lastline.getEncoding();
    }

    public int p(int offset2) {
        return this.lexb.get(offset2) & 0xFF;
    }

    public boolean peek(int c) {
        return this.peek(c, 0);
    }

    protected boolean peek(int c, int n) {
        return this.lex_p + n < this.lex_pend && this.p(this.lex_p + n) == c;
    }

    public int precise_mbclen() {
        byte[] data2 = this.lexb.getUnsafeBytes();
        int begin2 = this.lexb.begin();
        return this.current_enc.length(data2, begin2 + this.lex_p - 1, begin2 + this.lex_pend);
    }

    public void printState() {
        if (this.lex_state == 0) {
            System.out.println("NULL");
        } else {
            System.out.println(this.lex_state);
        }
    }

    public void pushback(int c) {
        if (c == -1) {
            return;
        }
        --this.lex_p;
        if (this.lex_p > this.lex_pbeg && this.p(this.lex_p) == 10 && this.p(this.lex_p - 1) == 13) {
            --this.lex_p;
        }
    }

    public void reset() {
        this.braceNest = 0;
        this.commandStart = true;
        this.heredoc_indent = 0;
        this.heredoc_line_indent = 0;
        this.last_cr_line = -1;
        this.parenNest = 0;
        this.ruby_sourceline = 0;
        this.token = 0;
        this.tokenSeen = false;
        this.tokp = 0;
        this.yaccValue = null;
        this.setState(0);
        this.resetStacks();
    }

    public void resetStacks() {
        this.conditionState.reset();
        this.cmdArgumentState.reset();
    }

    protected char scanOct(int count2) throws IOException {
        char value2 = '\u0000';
        for (int i2 = 0; i2 < count2; ++i2) {
            int c = this.nextc();
            if (!LexingCommon.isOctChar(c)) {
                this.pushback(c);
                break;
            }
            value2 = (char)(value2 << 3);
            value2 = (char)(value2 | Integer.parseInt(String.valueOf((char)c), 8));
        }
        return value2;
    }

    public void setCurrentArg(ByteList current_arg) {
        this.current_arg = current_arg;
    }

    public void setCurrentEncoding(Encoding encoding2) {
        this.current_enc = encoding2;
    }

    public void setEncoding(Encoding encoding2) {
        this.setCurrentEncoding(encoding2);
        this.src.setEncoding(encoding2);
        this.lexb.setEncoding(encoding2);
    }

    protected void set_file_encoding(int str, int send2) {
        boolean sep = false;
        block9: while (true) {
            if (send2 - str <= 6) {
                return;
            }
            switch (this.p(str + 6)) {
                case 67: 
                case 99: {
                    str += 6;
                    continue block9;
                }
                case 79: 
                case 111: {
                    str += 5;
                    continue block9;
                }
                case 68: 
                case 100: {
                    str += 4;
                    continue block9;
                }
                case 73: 
                case 105: {
                    str += 3;
                    continue block9;
                }
                case 78: 
                case 110: {
                    str += 2;
                    continue block9;
                }
                case 71: 
                case 103: {
                    ++str;
                    continue block9;
                }
                case 58: 
                case 61: {
                    sep = true;
                    str += 6;
                    break;
                }
                default: {
                    if (!Character.isSpaceChar(this.p(str += 6))) continue block9;
                }
            }
            if (this.lexb.makeShared(str - 6, 6).caseInsensitiveCmp(CODING) == 0) break;
        }
        while (true) {
            if (++str >= send2) {
                return;
            }
            if (Character.isSpaceChar(this.p(str))) continue;
            if (sep) break;
            if (this.p(str) != 61 && this.p(str) != 58) {
                return;
            }
            sep = true;
            ++str;
        }
        int beg = str;
        while ((this.p(str) == 45 || this.p(str) == 95 || Character.isLetterOrDigit(this.p(str))) && ++str < send2) {
        }
        this.setEncoding(this.lexb.makeShared(beg, str - beg));
    }

    public void setHeredocLineIndent(int heredoc_line_indent) {
        this.heredoc_line_indent = heredoc_line_indent;
    }

    public void setHeredocIndent(int heredoc_indent) {
        this.heredoc_indent = heredoc_indent;
    }

    public void setBraceNest(int nest) {
        this.braceNest = nest;
    }

    public void setLeftParenBegin(int value2) {
        this.leftParenBegin = value2;
    }

    public void setSource(LexerSource source2) {
        this.src = source2;
    }

    public void setState(int state2) {
        this.lex_state = state2;
    }

    public void setValue(Object yaccValue) {
        this.yaccValue = yaccValue;
    }

    protected boolean strncmp(ByteList one, ByteList two, int length2) {
        if (one.length() < length2 || two.length() < length2) {
            return false;
        }
        return one.makeShared(0, length2).equal(two.makeShared(0, length2));
    }

    public void tokAdd(int first_byte, ByteList buffer) {
        buffer.append((byte)first_byte);
    }

    public void tokCopy(int length2, ByteList buffer) {
        buffer.append(this.lexb, this.lex_p - length2, length2);
    }

    public boolean tokadd_ident(int c) {
        do {
            if (this.tokadd_mbchar(c)) continue;
            return false;
        } while (this.isIdentifierChar(c = this.nextc()));
        this.pushback(c);
        return true;
    }

    public boolean tokadd_mbchar(int first_byte) {
        int length2 = this.precise_mbclen();
        if (length2 <= 0) {
            this.compile_error("invalid multibyte char (" + this.getEncoding() + ")");
            return false;
        }
        if (length2 > 1) {
            this.tokenCR = 32;
        }
        this.lex_p += length2 - 1;
        return true;
    }

    public boolean tokadd_mbchar(int first_byte, ByteList buffer) {
        int length2 = this.precise_mbclen();
        if (length2 <= 0) {
            this.compile_error("invalid multibyte char (" + this.getEncoding() + ")");
            return false;
        }
        this.tokAdd(first_byte, buffer);
        this.lex_p += length2 - 1;
        if (length2 > 1) {
            this.tokCopy(length2 - 1, buffer);
        }
        return true;
    }

    public void tokaddmbc(int codepoint, ByteList buffer) {
        Encoding encoding2 = buffer.getEncoding();
        int length2 = encoding2.codeToMbcLength(codepoint);
        buffer.ensure(buffer.getRealSize() + length2);
        encoding2.codeToMbc(codepoint, buffer.getUnsafeBytes(), buffer.begin() + buffer.getRealSize());
        buffer.setRealSize(buffer.getRealSize() + length2);
    }

    public int token() {
        return this.token;
    }

    public boolean update_heredoc_indent(int c) {
        if (this.heredoc_line_indent == -1) {
            if (c == 10) {
                this.heredoc_line_indent = 0;
            }
        } else {
            if (c == 32) {
                ++this.heredoc_line_indent;
                return true;
            }
            if (c == 9) {
                int w = this.heredoc_line_indent / 8 + 1;
                this.heredoc_line_indent = w * 8;
                return true;
            }
            if (c != 10) {
                if (this.heredoc_indent > this.heredoc_line_indent) {
                    this.heredoc_indent = this.heredoc_line_indent;
                }
                this.heredoc_line_indent = -1;
            }
        }
        return false;
    }

    public void validateFormalIdentifier(ByteList identifier) {
        char first2 = identifier.charAt(0);
        if (Character.isUpperCase(first2)) {
            this.compile_error("formal argument cannot be a constant");
        }
        switch (first2) {
            case '@': {
                if (identifier.charAt(1) == '@') {
                    this.compile_error("formal argument cannot be a class variable");
                    break;
                }
                this.compile_error("formal argument cannot be an instance variable");
                break;
            }
            case '$': {
                this.compile_error("formal argument cannot be a global variable");
                break;
            }
            default: {
                char last2 = identifier.charAt(identifier.length() - 1);
                if (last2 != '=' && last2 != '?' && last2 != '!') break;
                this.compile_error("formal argument must be local variable");
            }
        }
    }

    @Deprecated
    public void validateFormalIdentifier(String identifier) {
        char first2 = identifier.charAt(0);
        if (Character.isUpperCase(first2)) {
            this.compile_error("formal argument cannot be a constant");
        }
        switch (first2) {
            case '@': {
                if (identifier.charAt(1) == '@') {
                    this.compile_error("formal argument cannot be a class variable");
                    break;
                }
                this.compile_error("formal argument cannot be an instance variable");
                break;
            }
            case '$': {
                this.compile_error("formal argument cannot be a global variable");
                break;
            }
            default: {
                char last2 = identifier.charAt(identifier.length() - 1);
                if (last2 != '=' && last2 != '?' && last2 != '!') break;
                this.compile_error("formal argument must be local variable");
            }
        }
    }

    public Object value() {
        return this.yaccValue;
    }

    protected void warn_balanced(int c, boolean spaceSeen, String op, String syn) {
        if (!LexingCommon.isLexState(this.last_state, 904) && spaceSeen && !Character.isWhitespace(c)) {
            this.ambiguousOperator(op, syn);
        }
    }

    public boolean was_bol() {
        return this.lex_p == this.lex_pbeg + 1;
    }

    public boolean whole_match_p(ByteList eos, boolean indent) {
        int n;
        int len = eos.length();
        int p2 = this.lex_pbeg;
        if (indent) {
            for (int i2 = 0; i2 < this.lex_pend; ++i2) {
                if (Character.isWhitespace(this.p(i2 + p2))) continue;
                p2 += i2;
                break;
            }
        }
        if ((n = this.lex_pend - (p2 + len)) < 0) {
            return false;
        }
        if (n > 0 && this.p(p2 + len) != 10) {
            if (this.p(p2 + len) != 13) {
                return false;
            }
            if (n == 1 || this.p(p2 + len + 1) != 10) {
                return false;
            }
        }
        return this.strncmp(eos, this.lexb.makeShared(p2, len), len);
    }

    protected abstract void ambiguousOperator(String var1, String var2);

    public abstract void compile_error(String var1);

    public abstract int nextc();

    protected abstract void setCompileOptionFlag(String var1, ByteList var2);

    protected abstract void setEncoding(ByteList var1);

    protected abstract void setTokenInfo(String var1, ByteList var2);

    public abstract int tokenize_ident(int var1);

    public static boolean isHexChar(int c) {
        return Character.isDigit(c) || 97 <= c && c <= 102 || 65 <= c && c <= 70;
    }

    public static boolean isLexState(int state2, int mask) {
        return (mask & state2) != 0;
    }

    protected boolean isLexStateAll(int state2, int mask) {
        return (mask & state2) == mask;
    }

    protected boolean isARG() {
        return LexingCommon.isLexState(this.lex_state, 48);
    }

    protected boolean isBEG() {
        return LexingCommon.isLexState(this.lex_state, 577) || this.isLexStateAll(this.lex_state, 2064);
    }

    protected boolean isEND() {
        return LexingCommon.isLexState(this.lex_state, 14);
    }

    protected boolean isLabelPossible(boolean commandState) {
        return LexingCommon.isLexState(this.lex_state, 1032) && !commandState || this.isARG();
    }

    public boolean isLabelSuffix() {
        return this.peek(58) && !this.peek(58, 1);
    }

    protected boolean isAfterOperator() {
        return LexingCommon.isLexState(this.lex_state, 384);
    }

    protected boolean isNext_identchar() throws IOException {
        int c = this.nextc();
        this.pushback(c);
        return c != -1 && (Character.isLetterOrDigit(c) || c == 95);
    }

    public static boolean isOctChar(int c) {
        return 48 <= c && c <= 55;
    }

    public static boolean isSpace(int c) {
        return c == 32 || 9 <= c && c <= 13;
    }

    protected boolean isSpaceArg(int c, boolean spaceSeen) {
        return this.isARG() && spaceSeen && !Character.isWhitespace(c);
    }

    public static int magicCommentMarker(ByteList str, int begin2) {
        int i2 = begin2;
        int len = str.length();
        block4: while (i2 < len) {
            switch (str.charAt(i2)) {
                case '-': {
                    if (i2 >= 2 && str.charAt(i2 - 1) == '*' && str.charAt(i2 - 2) == '-') {
                        return i2 + 1;
                    }
                    i2 += 2;
                    continue block4;
                }
                case '*': {
                    if (i2 + 1 >= len) {
                        return -1;
                    }
                    if (str.charAt(i2 + 1) != '-') {
                        i2 += 4;
                        continue block4;
                    }
                    if (str.charAt(i2 - 1) != '-') {
                        i2 += 2;
                        continue block4;
                    }
                    return i2 + 2;
                }
            }
            i2 += 3;
        }
        return -1;
    }

    public boolean parser_magic_comment(ByteList magicLine) {
        int end2;
        boolean indicator = false;
        int length2 = magicLine.realSize();
        int str = 0;
        if (length2 <= 7) {
            return false;
        }
        int beg = LexingCommon.magicCommentMarker(magicLine, 0);
        if (beg >= 0) {
            end2 = LexingCommon.magicCommentMarker(magicLine, beg);
            if (end2 < 0) {
                return false;
            }
            indicator = true;
            str = beg;
            length2 = end2 - beg - 3;
        }
        while (length2 > 0) {
            ByteList value2;
            String name2;
            int vend;
            int vbeg;
            char c;
            block7: while (length2 > 0) {
                c = magicLine.charAt(str);
                switch (c) {
                    case '\"': 
                    case '\'': 
                    case ':': 
                    case ';': {
                        break;
                    }
                    default: {
                        if (!Character.isWhitespace(c)) break block7;
                    }
                }
                ++str;
                --length2;
            }
            beg = str;
            block8: while (length2 > 0) {
                c = magicLine.charAt(str);
                switch (c) {
                    case '\"': 
                    case '\'': 
                    case ':': 
                    case ';': {
                        break block8;
                    }
                    default: {
                        if (Character.isWhitespace(c)) break block8;
                        ++str;
                        --length2;
                        continue block8;
                    }
                }
            }
            end2 = str;
            while (length2 > 0 && Character.isWhitespace(magicLine.charAt(str))) {
                ++str;
                --length2;
            }
            if (length2 == 0) break;
            c = magicLine.charAt(str);
            if (c != ':') {
                if (indicator) continue;
                return false;
            }
            while (--length2 > 0 && Character.isWhitespace(magicLine.charAt(++str))) {
            }
            if (length2 == 0) break;
            if (magicLine.charAt(str) == '\"') {
                vbeg = ++str;
                while (--length2 > 0 && str < length2 && magicLine.charAt(str) != '\"') {
                    if (magicLine.charAt(str) == '\\') {
                        --length2;
                        ++str;
                    }
                    ++str;
                }
                vend = str++;
                if (length2 > 0) {
                    --length2;
                }
            } else {
                vbeg = str;
                while (length2 > 0 && magicLine.charAt(str) != '\"' && magicLine.charAt(str) != ';' && !Character.isWhitespace(magicLine.charAt(str))) {
                    --length2;
                    ++str;
                }
                vend = str;
            }
            if (indicator) {
                while (length2 > 0 && (magicLine.charAt(str) == ';' || Character.isWhitespace(magicLine.charAt(str)))) {
                    --length2;
                    ++str;
                }
            } else {
                while (length2 > 0 && Character.isWhitespace(magicLine.charAt(str))) {
                    --length2;
                    ++str;
                }
                if (length2 > 0) {
                    return false;
                }
            }
            if (this.onMagicComment(name2 = magicLine.subSequence(beg, end2).toString().replace('-', '_'), value2 = magicLine.makeShared(vbeg, vend - vbeg))) continue;
            return false;
        }
        return true;
    }

    protected boolean onMagicComment(String name2, ByteList value2) {
        if ("coding".equalsIgnoreCase(name2) || "encoding".equalsIgnoreCase(name2)) {
            this.magicCommentEncoding(value2);
            return true;
        }
        if ("frozen_string_literal".equalsIgnoreCase(name2)) {
            this.setCompileOptionFlag(name2, value2);
            return true;
        }
        if ("warn_indent".equalsIgnoreCase(name2)) {
            this.setTokenInfo(name2, value2);
            return true;
        }
        return false;
    }

    protected abstract RegexpOptions parseRegexpFlags() throws IOException;

    protected RegexpOptions parseRegexpFlags(StringBuilder unknownFlags) throws IOException {
        RegexpOptions options2 = new RegexpOptions();
        this.newtok(true);
        int c = this.nextc();
        while (c != -1 && Character.isLetter(c)) {
            switch (c) {
                case 105: {
                    options2.setIgnorecase(true);
                    break;
                }
                case 120: {
                    options2.setExtended(true);
                    break;
                }
                case 109: {
                    options2.setMultiline(true);
                    break;
                }
                case 111: {
                    options2.setOnce(true);
                    break;
                }
                case 110: {
                    options2.setExplicitKCode(KCode.NONE);
                    break;
                }
                case 101: {
                    options2.setExplicitKCode(KCode.EUC);
                    break;
                }
                case 115: {
                    options2.setExplicitKCode(KCode.SJIS);
                    break;
                }
                case 117: {
                    options2.setExplicitKCode(KCode.UTF8);
                    break;
                }
                case 106: {
                    options2.setJava(true);
                    break;
                }
                default: {
                    unknownFlags.append((char)c);
                }
            }
            c = this.nextc();
        }
        this.pushback(c);
        return options2;
    }

    public void checkRegexpFragment(Ruby runtime2, ByteList value2, RegexpOptions options2) {
        this.setRegexpEncoding(runtime2, value2, options2);
        ThreadContext context = runtime2.getCurrentContext();
        IRubyObject $ex = context.getErrorInfo();
        try {
            RubyRegexp.preprocessCheck(runtime2, value2);
        }
        catch (RaiseException re) {
            context.setErrorInfo($ex);
            this.compile_error(re.getMessage());
        }
    }

    public void checkRegexpSyntax(Ruby runtime2, ByteList value2, RegexpOptions options2) {
        String stringValue = value2.toString();
        if (stringValue.startsWith("(?u)") || stringValue.startsWith("(?a)") || stringValue.startsWith("(?d)")) {
            return;
        }
        ThreadContext context = runtime2.getCurrentContext();
        IRubyObject $ex = context.getErrorInfo();
        try {
            RubyRegexp.newRegexpParser(runtime2, value2, options2.clone());
        }
        catch (RaiseException re) {
            context.setErrorInfo($ex);
            this.compile_error(re.getMessage());
        }
    }

    protected abstract void mismatchedRegexpEncodingError(Encoding var1, Encoding var2);

    public void setRegexpEncoding(Ruby runtime2, ByteList value2, RegexpOptions options2) {
        Encoding optionsEncoding = options2.setup(runtime2);
        if (optionsEncoding != null) {
            if (optionsEncoding != value2.getEncoding() && !this.is7BitASCII(value2)) {
                this.mismatchedRegexpEncodingError(optionsEncoding, value2.getEncoding());
            }
            value2.setEncoding(optionsEncoding);
        } else if (options2.isEncodingNone()) {
            if (value2.getEncoding() != ASCII8BIT_ENCODING && !this.is7BitASCII(value2)) {
                this.mismatchedRegexpEncodingError(optionsEncoding, value2.getEncoding());
            }
            value2.setEncoding(ASCII8BIT_ENCODING);
        } else if (this.getEncoding() == USASCII_ENCODING) {
            if (!this.is7BitASCII(value2)) {
                value2.setEncoding(USASCII_ENCODING);
            } else {
                value2.setEncoding(ASCII8BIT_ENCODING);
            }
        }
    }

    private boolean is7BitASCII(ByteList value2) {
        return StringSupport.codeRangeScan(value2.getEncoding(), value2) == 16;
    }

    protected char optionsEncodingChar(Encoding optionEncoding) {
        if (optionEncoding == USASCII_ENCODING) {
            return 'n';
        }
        if (optionEncoding == EUCJPEncoding.INSTANCE) {
            return 'e';
        }
        if (optionEncoding == SJISEncoding.INSTANCE) {
            return 's';
        }
        if (optionEncoding == UTF8_ENCODING) {
            return 'u';
        }
        return ' ';
    }
}

