/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import javajs.util.BS;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.V3;
import org.jmol.c.STR;
import org.jmol.modelsetbio.AlphaMonomer;
import org.jmol.modelsetbio.BioPolymer;
import org.jmol.modelsetbio.Helix;
import org.jmol.modelsetbio.Monomer;
import org.jmol.modelsetbio.ProteinStructure;
import org.jmol.modelsetbio.Sheet;
import org.jmol.modelsetbio.Turn;
import org.jmol.util.Logger;

public class AlphaPolymer
extends BioPolymer {
    public int pt0;
    private static final String[] dsspTypes;

    static {
        String[] stringArray = new String[7];
        stringArray[0] = "H";
        stringArray[2] = "H";
        stringArray[3] = "S";
        stringArray[4] = "H";
        stringArray[6] = "T";
        dsspTypes = stringArray;
    }

    AlphaPolymer(Monomer[] monomerArray, int n) {
        this.pt0 = n;
        this.set(monomerArray);
        this.hasStructure = true;
    }

    @Override
    public ProteinStructure getProteinStructure(int n) {
        return (ProteinStructure)this.monomers[n].getStructure();
    }

    @Override
    protected P3 getControlPoint(int n, V3 v3) {
        if (!this.monomers[n].isSheet()) {
            return this.leadPoints[n];
        }
        v3.sub2(this.leadMidpoints[n], this.leadPoints[n]);
        v3.scale(this.sheetSmoothing);
        P3 p3 = P3.newP(this.leadPoints[n]);
        p3.add(v3);
        return p3;
    }

    public void addStructure(STR sTR, String string, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, BS bS) {
        int n9;
        int n10;
        int n11;
        int n12 = -1;
        int n13 = -1;
        if (n7 < n8) {
            if (this.monomers[0].firstAtomIndex > n8 || this.monomers[this.monomerCount - 1].lastAtomIndex < n7) {
                return;
            }
            n12 = n7;
            n13 = n8;
        }
        if ((n11 = this.getIndex(n3, n4, n12, n13)) == -1 || (n10 = this.getIndex(n5, n6, n12, n13)) == -1) {
            return;
        }
        if (n7 >= 0 && bS != null && (n9 = bS.nextSetBit(this.monomers[n11].firstAtomIndex)) >= 0 && n9 < this.monomers[n10].lastAtomIndex) {
            return;
        }
        if (this.addStructureProtected(sTR, string, n, n2, n11, n10) && n7 >= 0) {
            bS.setBits(n7, n8 + 1);
        }
    }

    public boolean addStructureProtected(STR sTR, String string, int n, int n2, int n3, int n4) {
        if (n4 < n3) {
            Logger.error("AlphaPolymer:addSecondaryStructure error:  indexStart:" + n3 + " indexEnd:" + n4);
            return false;
        }
        int n5 = n4 - n3 + 1;
        ProteinStructure proteinStructure = null;
        switch (sTR) {
            case HELIX: 
            case HELIX310: 
            case HELIXALPHA: 
            case HELIXPI: {
                proteinStructure = new Helix(this, n3, n5, sTR);
                break;
            }
            case SHEET: {
                proteinStructure = new Sheet(this, n3, n5, sTR);
                break;
            }
            case TURN: {
                proteinStructure = new Turn(this, n3, n5);
                break;
            }
            default: {
                Logger.error("unrecognized secondary structure type");
                return false;
            }
        }
        proteinStructure.structureID = string;
        proteinStructure.serialID = n;
        proteinStructure.strandCount = n2;
        int n6 = n3;
        while (n6 <= n4) {
            ((AlphaMonomer)this.monomers[n6]).setStructure(proteinStructure);
            ++n6;
        }
        return true;
    }

    @Override
    public void clearStructures() {
        int n = 0;
        while (n < this.monomerCount) {
            ((AlphaMonomer)this.monomers[n]).setStructure(null);
            ++n;
        }
    }

    public void calculateStructures(boolean bl) {
        if (this.monomerCount < 4) {
            return;
        }
        float[] fArray = this.calculateAnglesInDegrees();
        Code[] codeArray = this.calculateCodes(fArray);
        this.checkBetaSheetAlphaHelixOverlap(codeArray, fArray);
        STR[] sTRArray = this.calculateRunsFourOrMore(codeArray);
        this.extendRuns(sTRArray);
        this.searchForTurns(codeArray, fArray, sTRArray);
        this.addStructuresFromTags(sTRArray);
    }

    private float[] calculateAnglesInDegrees() {
        float[] fArray = new float[this.monomerCount];
        int n = this.monomerCount - 1;
        while (--n >= 2) {
            fArray[n] = Measure.computeTorsion(this.monomers[n - 2].getLeadAtom(), this.monomers[n - 1].getLeadAtom(), this.monomers[n].getLeadAtom(), this.monomers[n + 1].getLeadAtom(), true);
        }
        return fArray;
    }

    private Code[] calculateCodes(float[] fArray) {
        Code[] codeArray = new Code[this.monomerCount];
        int n = this.monomerCount - 1;
        while (--n >= 2) {
            float f = fArray[n];
            Code code = f >= 10.0f && f < 120.0f ? Code.RIGHT_HELIX : (f >= 120.0f || f < -90.0f ? Code.BETA_SHEET : (codeArray[n] = f >= -90.0f && f < 0.0f ? Code.LEFT_HELIX : Code.NADA));
        }
        return codeArray;
    }

    private void checkBetaSheetAlphaHelixOverlap(Code[] codeArray, float[] fArray) {
        int n = this.monomerCount - 2;
        while (--n >= 2) {
            if (codeArray[n] != Code.BETA_SHEET || !(fArray[n] <= 140.0f) || codeArray[n - 2] != Code.RIGHT_HELIX || codeArray[n - 1] != Code.RIGHT_HELIX || codeArray[n + 1] != Code.RIGHT_HELIX || codeArray[n + 2] != Code.RIGHT_HELIX) continue;
            codeArray[n] = Code.RIGHT_HELIX;
        }
    }

    private STR[] calculateRunsFourOrMore(Code[] codeArray) {
        STR[] sTRArray = new STR[this.monomerCount];
        STR sTR = STR.NONE;
        Code code = Code.NADA;
        int n = 0;
        int n2 = 0;
        while (n2 < this.monomerCount) {
            if (codeArray[n2] == code && code != Code.NADA && code != Code.BETA_SHEET) {
                if (++n == 4) {
                    sTR = code == Code.BETA_SHEET ? STR.SHEET : STR.HELIX;
                    int n3 = 4;
                    while (--n3 >= 0) {
                        sTRArray[n2 - n3] = sTR;
                    }
                } else if (n > 4) {
                    sTRArray[n2] = sTR;
                }
            } else {
                n = 1;
                code = codeArray[n2];
            }
            ++n2;
        }
        return sTRArray;
    }

    private void extendRuns(STR[] sTRArray) {
        int n = 1;
        while (n < this.monomerCount - 4) {
            if (sTRArray[n] == STR.NONE && sTRArray[n + 1] != STR.NONE) {
                sTRArray[n] = sTRArray[n + 1];
            }
            ++n;
        }
        sTRArray[0] = sTRArray[1];
        sTRArray[this.monomerCount - 1] = sTRArray[this.monomerCount - 2];
    }

    private void searchForTurns(Code[] codeArray, float[] fArray, STR[] sTRArray) {
        int n = this.monomerCount - 1;
        while (--n >= 2) {
            codeArray[n] = Code.NADA;
            if (sTRArray[n] != null && sTRArray[n] != STR.NONE) continue;
            float f = fArray[n];
            if (f >= -90.0f && f < 0.0f) {
                codeArray[n] = Code.LEFT_TURN;
                continue;
            }
            if (!(f >= 0.0f) || !(f < 90.0f)) continue;
            codeArray[n] = Code.RIGHT_TURN;
        }
        n = this.monomerCount - 1;
        while (--n >= 0) {
            if (codeArray[n] == Code.NADA || codeArray[n + 1] != codeArray[n] || sTRArray[n] != STR.NONE) continue;
            sTRArray[n] = STR.TURN;
        }
    }

    private void addStructuresFromTags(STR[] sTRArray) {
        int n = 0;
        while (n < this.monomerCount) {
            STR sTR = sTRArray[n];
            if (sTR == null || sTR == STR.NONE) {
                ++n;
                continue;
            }
            int n2 = n + 1;
            while (n2 < this.monomerCount && sTRArray[n2] == sTR) {
                ++n2;
            }
            this.addStructureProtected(sTR, null, 0, 0, n, n2 - 1);
            n = n2;
        }
    }

    public int setStructureBS(int n, int n2, STR sTR, BS bS, boolean bl) {
        int n3 = bl ? this.pt0 : 0;
        int n4 = 0;
        int n5 = bS.nextSetBit(n3);
        int n6 = 0;
        int n7 = this.monomerCount + n3;
        while (n5 >= 0 && n5 < n7) {
            n6 = bS.nextClearBit(n5);
            if (n6 < 0 || n6 > n7) {
                n6 = n7;
            }
            this.addStructureProtected(sTR, String.valueOf(dsspTypes[n2]) + ++n4, n++, n2 == 3 ? 1 : 0, n5 - n3, n6 - 1 - n3);
            n5 = bS.nextSetBit(n6 + 1);
        }
        return n;
    }

    private static enum Code {
        NADA,
        RIGHT_HELIX,
        BETA_SHEET,
        LEFT_HELIX,
        LEFT_TURN,
        RIGHT_TURN;

    }
}

