/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.Arrays;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import javajs.awt.Font;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.api.JmolModulationSet;
import org.jmol.api.JmolScriptFunction;
import org.jmol.api.SymmetryInterface;
import org.jmol.c.PAL;
import org.jmol.c.STR;
import org.jmol.c.VDW;
import org.jmol.modelset.Atom;
import org.jmol.modelset.AtomCollection;
import org.jmol.modelset.Bond;
import org.jmol.modelset.BondSet;
import org.jmol.modelset.Measurement;
import org.jmol.modelset.Model;
import org.jmol.modelset.ModelSet;
import org.jmol.modelset.StateScript;
import org.jmol.modelset.Text;
import org.jmol.modelset.TickInfo;
import org.jmol.script.SV;
import org.jmol.script.T;
import org.jmol.shape.AtomShape;
import org.jmol.shape.Axes;
import org.jmol.shape.Balls;
import org.jmol.shape.Echo;
import org.jmol.shape.FontLineShape;
import org.jmol.shape.Frank;
import org.jmol.shape.Halos;
import org.jmol.shape.Hover;
import org.jmol.shape.Labels;
import org.jmol.shape.Measures;
import org.jmol.shape.Shape;
import org.jmol.shape.Sticks;
import org.jmol.util.BSUtil;
import org.jmol.util.C;
import org.jmol.util.ColorEncoder;
import org.jmol.util.Edge;
import org.jmol.util.Escape;
import org.jmol.util.GData;
import org.jmol.util.Logger;
import org.jmol.util.Vibration;
import org.jmol.viewer.AnimationManager;
import org.jmol.viewer.ColorManager;
import org.jmol.viewer.GlobalSettings;
import org.jmol.viewer.JC;
import org.jmol.viewer.JmolStateCreator;
import org.jmol.viewer.SelectionManager;
import org.jmol.viewer.StateManager;
import org.jmol.viewer.StatusManager;
import org.jmol.viewer.TransformManager;
import org.jmol.viewer.Viewer;

public class StateCreator
extends JmolStateCreator {
    private Viewer vwr;
    private Map<String, BS> temp = new Hashtable<String, BS>();
    private Map<String, BS> temp2 = new Hashtable<String, BS>();
    private Map<String, BS> temp3 = new Hashtable<String, BS>();
    private boolean undoWorking = false;
    private static final int MAX_ACTION_UNDO = 100;

    @Override
    void setViewer(Viewer viewer) {
        this.vwr = viewer;
    }

    @Override
    String getStateScript(String string, int n, int n2) {
        SB sB;
        boolean bl = string == null || string.equalsIgnoreCase("all");
        SB sB2 = new SB();
        SB sB3 = sB = bl ? new SB().append("function _setState() {\n") : null;
        if (bl) {
            sB2.append("# Jmol state version " + Viewer.getJmolVersion() + ";\n");
            if (this.vwr.isApplet) {
                this.app(sB2, "# fullName = " + PT.esc(this.vwr.fullName));
                this.app(sB2, "# documentBase = " + PT.esc(Viewer.appletDocumentBase));
                this.app(sB2, "# codeBase = " + PT.esc(Viewer.appletCodeBase));
                sB2.append("\n");
            }
        }
        GlobalSettings globalSettings = this.vwr.g;
        if (bl || string.equalsIgnoreCase("windowState")) {
            sB2.append(this.getWindowState(sB, n, n2));
        }
        if (bl || string.equalsIgnoreCase("fileState")) {
            sB2.append(this.getFileState(sB));
        }
        if (bl || string.equalsIgnoreCase("definedState")) {
            sB2.append(this.getDefinedState(sB, true));
        }
        if (bl || string.equalsIgnoreCase("variableState")) {
            sB2.append(this.getParameterState(globalSettings, sB));
        }
        if (bl || string.equalsIgnoreCase("dataState")) {
            sB2.append(this.getDataState(sB));
        }
        if (bl || string.equalsIgnoreCase("modelState")) {
            sB2.append(this.getModelState(sB, true, this.vwr.getBooleanProperty("saveProteinStructureState")));
        }
        if (bl || string.equalsIgnoreCase("colorState")) {
            sB2.append(this.getColorState(this.vwr.cm, sB));
        }
        if (bl || string.equalsIgnoreCase("frameState")) {
            sB2.append(this.getAnimState(this.vwr.am, sB));
        }
        if (bl || string.equalsIgnoreCase("perspectiveState")) {
            sB2.append(this.getViewState(this.vwr.tm, sB));
        }
        if (bl || string.equalsIgnoreCase("selectionState")) {
            sB2.append(this.getSelectionState(this.vwr.slm, sB));
        }
        if (sB != null) {
            this.app(sB, "set refreshing true");
            this.app(sB, "set antialiasDisplay " + globalSettings.antialiasDisplay);
            this.app(sB, "set antialiasTranslucent " + globalSettings.antialiasTranslucent);
            this.app(sB, "set antialiasImages " + globalSettings.antialiasImages);
            if (this.vwr.tm.spinOn) {
                this.app(sB, "spin on");
            }
            sB.append("}\n\n_setState;\n");
        }
        if (bl) {
            sB2.appendSB(sB);
        }
        return sB2.toString();
    }

    private String getDataState(SB sB) {
        String string;
        SB sB2 = new SB();
        boolean bl = false;
        String string2 = this.getAtomicPropertyState(-1, null);
        if (string2.length() > 0) {
            bl = true;
            sB2.append(string2);
        }
        if (this.vwr.userVdws != null && (string = this.vwr.getDefaultVdwNameOrData(0, VDW.USER, this.vwr.bsUserVdws)).length() > 0) {
            bl = true;
            sB2.append(string);
        }
        if (this.vwr.nmrCalculation != null) {
            bl |= this.vwr.nmrCalculation.getState(sB2);
        }
        if (this.vwr.dm != null) {
            bl |= this.vwr.dm.getDataState(this, sB2);
        }
        if (!bl) {
            return "";
        }
        string = "";
        if (sB != null) {
            sB.append("  _setDataState;\n");
            string = "function _setDataState() {\n";
            sB2.append("}\n\n");
        }
        return String.valueOf(string) + sB2.toString();
    }

    private String getDefinedState(SB sB, boolean bl) {
        String string;
        ModelSet modelSet = this.vwr.ms;
        int n = modelSet.stateScripts.size();
        if (n == 0) {
            return "";
        }
        boolean bl2 = false;
        SB sB2 = new SB();
        int n2 = 0;
        while (n2 < n) {
            StateScript stateScript = (StateScript)modelSet.stateScripts.get(n2);
            if (stateScript.inDefinedStateBlock && (string = stateScript.toString()).length() > 0) {
                this.app(sB2, string);
                bl2 = true;
            }
            ++n2;
        }
        if (!bl2) {
            return "";
        }
        string = "";
        if (bl && sB != null) {
            sB.append("  _setDefinedState;\n");
            string = "function _setDefinedState() {\n\n";
        }
        if (sB != null) {
            sB2.append("\n}\n\n");
        }
        return String.valueOf(string) + sB2.toString();
    }

    @Override
    String getModelState(SB sB, boolean bl, boolean bl2) {
        Object object;
        int n;
        int n2;
        SB sB2 = new SB();
        if (bl && sB != null) {
            sB.append("  _setModelState;\n");
            sB2.append("function _setModelState() {\n");
        }
        ModelSet modelSet = this.vwr.ms;
        Bond[] bondArray = modelSet.bo;
        Model[] modelArray = modelSet.am;
        int n3 = modelSet.mc;
        if (bl) {
            n2 = modelSet.stateScripts.size();
            int n4 = 0;
            while (n4 < n2) {
                String string;
                StateScript stateScript = (StateScript)modelSet.stateScripts.get(n4);
                if (!stateScript.inDefinedStateBlock && (string = stateScript.toString()).length() > 0) {
                    this.app(sB2, string);
                }
                ++n4;
            }
            SB sB3 = new SB();
            n = 0;
            while (n < modelSet.bondCount) {
                if (!modelArray[bondArray[n].atom1.mi].isModelKit && (bondArray[n].isHydrogen() || (bondArray[n].order & 0x20000) != 0)) {
                    object = bondArray[n];
                    int n5 = ((Bond)object).atom1.i;
                    if (((Bond)object).atom1.group.isAdded(n5)) {
                        n5 = -1 - n5;
                    }
                    sB3.appendI(n5).appendC('\t').appendI(((Bond)object).atom2.i).appendC('\t').appendI(((Bond)object).order & 0xFFFDFFFF).appendC('\t').appendF((float)((Bond)object).mad / 1000.0f).appendC('\t').appendF(((Bond)object).getEnergy()).appendC('\t').append(Edge.getBondOrderNameFromOrder(((Bond)object).order)).append(";\n");
                }
                ++n;
            }
            if (sB3.length() > 0) {
                sB2.append("data \"connect_atoms\"\n").appendSB(sB3).append("end \"connect_atoms\";\n");
            }
            sB2.append("\n");
        }
        if (modelSet.haveHiddenBonds) {
            BondSet bondSet = new BondSet();
            int n6 = modelSet.bondCount;
            while (--n6 >= 0) {
                if (bondArray[n6].mad == 0 || (bondArray[n6].shapeVisibilityFlags & Bond.myVisibilityFlag) != 0) continue;
                bondSet.set(n6);
            }
            if (bondSet.isEmpty()) {
                modelSet.haveHiddenBonds = false;
            } else {
                sB2.append("  hide ").append(Escape.eBond(bondSet)).append(";\n");
            }
        }
        this.vwr.setModelVisibility();
        if (bl2) {
            sB2.append(modelSet.getProteinStructureState(null, bl ? 1073742327 : 1073742158));
        }
        n2 = 0;
        while (n2 < n3) {
            if (modelArray[n2].mat4 != null) {
                sB2.append("  frame orientation " + modelSet.getModelNumberDotted(n2) + Escape.matrixToScript(modelArray[n2].mat4) + ";\n");
            }
            ++n2;
        }
        this.getShapeStatePriv(sB2, bl, Integer.MAX_VALUE);
        if (bl) {
            Object object2;
            n2 = 0;
            int n7 = 0;
            while (n7 < n3) {
                if (modelArray[n7].isJmolDataFrame) {
                    n2 = 1;
                    break;
                }
                ++n7;
            }
            SB sB4 = new SB();
            n = 0;
            while (n < n3) {
                object = modelArray[n];
                sB4.setLength(0);
                String string = (String)modelSet.getInfo(n, "modelID");
                if (string != null && !string.equals(modelSet.getInfo(n, "modelID0"))) {
                    sB4.append("  frame ID ").append(PT.esc(string)).append(";\n");
                }
                if ((object2 = modelSet.frameTitles[n]) != null && ((String)object2).length() > 0) {
                    sB4.append("  frame title ").append(PT.esc((String)object2)).append(";\n");
                }
                if (n2 != 0 && ((Model)object).orientation != null && !modelSet.isTrajectorySubFrame(n)) {
                    sB4.append("  ").append(((Model)object).orientation.getMoveToText(false)).append(";\n");
                }
                if (((Model)object).frameDelay != 0L && !modelSet.isTrajectorySubFrame(n)) {
                    sB4.append("  frame delay ").appendF((float)((Model)object).frameDelay / 1000.0f).append(";\n");
                }
                if (((Model)object).simpleCage != null) {
                    sB4.append("  unitcell ").append(Escape.eAP(((Model)object).simpleCage.getUnitCellVectors())).append(";\n");
                    this.getShapeStatePriv(sB4, bl, 33);
                }
                if (sB4.length() > 0) {
                    sB2.append("  frame " + modelSet.getModelNumberDotted(n) + ";\n").appendSB(sB4);
                }
                ++n;
            }
            n = 0;
            if (modelSet.unitCells != null) {
                boolean bl3 = false;
                int n8 = 0;
                while (n8 < n3) {
                    object2 = modelSet.getUnitCell(n8);
                    if (object2 != null) {
                        sB4.setLength(0);
                        if (object2.getState(sB4)) {
                            n = 1;
                            sB2.append("  frame ").append(modelSet.getModelNumberDotted(n8)).appendSB(sB4).append(";\n");
                        }
                        bl3 |= this.vwr.ms.getLastVibrationVector(n8, 1275072532) >= 0;
                    }
                    ++n8;
                }
                if (n != 0) {
                    this.vwr.shm.loadShape(33);
                }
                this.getShapeStatePriv(sB2, bl, 33);
                if (bl3) {
                    Hashtable<String, BS> hashtable = new Hashtable<String, BS>();
                    int n9 = n3;
                    while (--n9 >= 0) {
                        int n10 = this.vwr.ms.getLastVibrationVector(n9, 1275072532);
                        if (n10 < 0) continue;
                        int n11 = modelArray[n9].firstAtomIndex;
                        while (n11 <= n10) {
                            JmolModulationSet jmolModulationSet = modelSet.getModulation(n11);
                            if (jmolModulationSet != null) {
                                BSUtil.setMapBitSet(hashtable, n11, n11, jmolModulationSet.getState());
                            }
                            ++n11;
                        }
                    }
                    sB2.append(this.getCommands(hashtable, null, "select"));
                }
            }
            sB2.append("  set fontScaling " + this.vwr.getBoolean(603979845) + ";\n");
        }
        if (sB != null) {
            sB2.append("\n}\n\n");
        }
        return sB2.toString();
    }

    private String getWindowState(SB sB, int n, int n2) {
        GlobalSettings globalSettings = this.vwr.g;
        SB sB2 = new SB();
        if (sB != null) {
            sB.append("  initialize;\n  set refreshing false;\n  _setWindowState;\n");
            sB2.append("\nfunction _setWindowState() {\n");
        }
        if (n != 0) {
            sB2.append("# preferredWidthHeight ").appendI(n).append(" ").appendI(n2).append(";\n");
        }
        sB2.append("# width ").appendI(n == 0 ? this.vwr.getScreenWidth() : n).append(";\n# height ").appendI(n2 == 0 ? this.vwr.getScreenHeight() : n2).append(";\n");
        this.app(sB2, "stateVersion = " + JC.versionInt);
        this.app(sB2, "background " + Escape.escapeColor(globalSettings.objColors[0]));
        int n3 = 1;
        while (n3 < 7) {
            if (globalSettings.objColors[n3] != 0) {
                this.app(sB2, String.valueOf(StateManager.getObjectNameFromId(n3)) + "Color = \"" + Escape.escapeColor(globalSettings.objColors[n3]) + '\"');
            }
            ++n3;
        }
        if (globalSettings.backgroundImageFileName != null) {
            this.app(sB2, "background IMAGE " + (globalSettings.backgroundImageFileName.startsWith(";base64,") ? "" : "/*file*/") + PT.esc(globalSettings.backgroundImageFileName));
        }
        sB2.append(this.getLightingState(false));
        if (sB != null) {
            sB2.append("}\n\n");
        }
        return sB2.toString();
    }

    @Override
    String getLightingState(boolean bl) {
        SB sB = new SB();
        GData gData = this.vwr.gdata;
        this.app(sB, "set ambientPercent " + gData.getAmbientPercent());
        this.app(sB, "set diffusePercent " + gData.getDiffusePercent());
        this.app(sB, "set specular " + gData.getSpecular());
        this.app(sB, "set specularPercent " + gData.getSpecularPercent());
        this.app(sB, "set specularPower " + gData.getSpecularPower());
        int n = gData.getSpecularExponent();
        int n2 = gData.getPhongExponent();
        this.app(sB, Math.pow(2.0, n) == (double)n2 ? "set specularExponent " + n : "set phongExponent " + n2);
        this.app(sB, "set celShading " + gData.getCel());
        this.app(sB, "set celShadingPower " + gData.getCelPower());
        this.app(sB, "set zShadePower " + this.vwr.g.zShadePower);
        if (bl) {
            this.getZshadeState(sB, this.vwr.tm, true);
        }
        return sB.toString();
    }

    private String getFileState(SB sB) {
        SB sB2 = new SB();
        if (sB != null) {
            sB.append("  _setFileState;\n");
            sB2.append("function _setFileState() {\n\n");
        }
        if (sB2.indexOf("append") < 0 && this.vwr.getModelSetFileName().equals("zapped")) {
            sB2.append("  zap;\n");
        }
        this.appendLoadStates(sB2);
        if (sB != null) {
            sB2.append("\n}\n\n");
        }
        return sB2.toString();
    }

    private void appendLoadStates(SB sB) {
        int n;
        Object object;
        Map<String, Boolean> map = this.vwr.ligandModelSet;
        if (map != null) {
            for (String object22 : map.keySet()) {
                object = (String)this.vwr.ligandModels.get(String.valueOf(object22) + "_data");
                if (object != null) {
                    sB.append("  ").append(Escape.encapsulateData("ligand_" + object22, String.valueOf(((String)object).trim()) + "\n", 0));
                }
                if ((object = (String)this.vwr.ligandModels.get(String.valueOf(object22) + "_file")) == null) continue;
                sB.append("  ").append(Escape.encapsulateData("file_" + object22, String.valueOf(((String)object).trim()) + "\n", 0));
            }
        }
        SB sB2 = new SB();
        ModelSet modelSet = this.vwr.ms;
        object = modelSet.am;
        int n2 = modelSet.mc;
        int string = 0;
        while (string < n2) {
            if (!modelSet.isJmolDataFrameForModel(string) && !modelSet.isTrajectorySubFrame(string)) {
                Model n4 = object[string];
                n = sB2.indexOf(n4.loadState);
                if (n < 0 || n != sB2.lastIndexOf(n4.loadState)) {
                    sB2.append(((Model)object[string]).loadState);
                }
                if (((Model)object[string]).isModelKit) {
                    BS bS = modelSet.getModelAtomBitSetIncludingDeleted(string, false);
                    if (modelSet.tainted != null) {
                        if (modelSet.tainted[2] != null) {
                            modelSet.tainted[2].andNot(bS);
                        }
                        if (modelSet.tainted[3] != null) {
                            modelSet.tainted[3].andNot(bS);
                        }
                    }
                    n4.loadScript = new SB();
                    this.getInlineData(sB2, this.vwr.getModelExtract(bS, false, true, "MOL"), string > 0, null);
                } else {
                    sB2.appendSB(n4.loadScript);
                }
            }
            ++string;
        }
        String string2 = sB2.toString();
        if (string2.indexOf("data \"append ") < 0) {
            int n3 = string2.indexOf("load /*data*/");
            n = string2.indexOf("load /*file*/");
            if (n >= 0 && n < n3) {
                n3 = n;
            }
            if ((n = string2.indexOf("load \"@")) >= 0 && n < n3) {
                n3 = n;
            }
            if (n3 >= 0) {
                string2 = String.valueOf(string2.substring(0, n3)) + "zap;" + string2.substring(n3);
            }
        }
        sB.append(string2);
    }

    @Override
    public void getInlineData(SB sB, String string, boolean bl, String string2) {
        String string3 = String.valueOf(bl ? "append" : "model") + " inline";
        sB.append("load /*data*/ data \"").append(string3).append("\"\n").append(string).append("end \"").append(string3).append(string2 == null || string2.length() == 0 ? "" : " filter" + PT.esc(string2)).append("\";");
    }

    private String getColorState(ColorManager colorManager, SB sB) {
        SB sB2 = new SB();
        int n = this.getCEState(colorManager.ce, sB2);
        if (n > 0 && sB != null) {
            sB.append("\n  _setColorState\n");
        }
        return n > 0 && sB != null ? "function _setColorState() {\n" + sB2.append("}\n\n").toString() : sB2.toString();
    }

    private int getCEState(ColorEncoder colorEncoder, SB sB) {
        int n = 0;
        for (Map.Entry<String, int[]> entry : colorEncoder.schemes.entrySet()) {
            String string = entry.getKey();
            if (!(string.length() > 0 & n++ >= 0)) continue;
            sB.append("color \"" + string + "=" + ColorEncoder.getColorSchemeList(entry.getValue()) + "\";\n");
        }
        return n;
    }

    private String getAnimState(AnimationManager animationManager, SB sB) {
        Object object;
        int n;
        int n2 = this.vwr.ms.mc;
        if (n2 < 2) {
            return "";
        }
        SB sB2 = new SB();
        if (sB != null) {
            sB.append("  _setFrameState;\n");
            sB2.append("function _setFrameState() {\n");
        }
        sB2.append("# frame state;\n");
        sB2.append("# modelCount ").appendI(n2).append(";\n# first ").append(this.vwr.getModelNumberDotted(0)).append(";\n# last ").append(this.vwr.getModelNumberDotted(n2 - 1)).append(";\n");
        if (animationManager.backgroundModelIndex >= 0) {
            this.app(sB2, "set backgroundModel " + this.vwr.getModelNumberDotted(animationManager.backgroundModelIndex));
        }
        if (this.vwr.tm.bsFrameOffsets != null) {
            this.app(sB2, "frame align " + Escape.eBS(this.vwr.tm.bsFrameOffsets));
        } else if (this.vwr.ms.translations != null) {
            n = n2;
            while (--n >= 0) {
                object = this.vwr.ms.getTranslation(n);
                if (object == null) continue;
                this.app(sB2, "frame " + this.vwr.ms.getModelNumberDotted(n) + " align " + object);
            }
        }
        this.app(sB2, "frame RANGE " + animationManager.getModelSpecial(-1) + " " + animationManager.getModelSpecial(1));
        this.app(sB2, "animation DIRECTION " + (animationManager.animationDirection == 1 ? "+1" : "-1"));
        this.app(sB2, "animation FPS " + animationManager.animationFps);
        this.app(sB2, "animation MODE " + T.nameOf(animationManager.animationReplayMode) + " " + animationManager.firstFrameDelay + " " + animationManager.lastFrameDelay);
        if (animationManager.morphCount > 0) {
            this.app(sB2, "animation MORPH " + animationManager.morphCount);
        }
        n = 1;
        if (animationManager.animationFrames != null) {
            this.app(sB2, "anim frames " + Escape.eAI(animationManager.animationFrames));
            int n3 = animationManager.caf;
            this.app(sB2, "frame " + (n3 + 1));
            int n4 = n = animationManager.cmi != animationManager.modelIndexForFrame(n3) ? 1 : 0;
        }
        if (n != 0) {
            object = animationManager.getModelSpecial(0);
            this.app(sB2, ((String)object).equals("0") ? "frame *" : "model " + (String)object);
        }
        this.app(sB2, "animation " + (!animationManager.animationOn ? "OFF" : (animationManager.currentDirection == 1 ? "PLAY" : "PLAYREV")));
        if (animationManager.animationOn && animationManager.animationPaused) {
            this.app(sB2, "animation PAUSE");
        }
        if (sB != null) {
            sB2.append("}\n\n");
        }
        return sB2.toString();
    }

    private String getParameterState(GlobalSettings globalSettings, SB sB) {
        boolean bl;
        Object[] objectArray = new String[globalSettings.htBooleanParameterFlags.size() + globalSettings.htNonbooleanParameterValues.size()];
        SB sB2 = new SB();
        boolean bl2 = bl = sB != null;
        if (bl) {
            sB.append("  _setParameterState;\n");
            sB2.append("function _setParameterState() {\n\n");
        }
        int n = 0;
        for (String string : globalSettings.htBooleanParameterFlags.keySet()) {
            if (!GlobalSettings.doReportProperty(string)) continue;
            objectArray[n++] = "set " + string + " " + globalSettings.htBooleanParameterFlags.get(string);
        }
        for (String string : globalSettings.htNonbooleanParameterValues.keySet()) {
            if (!GlobalSettings.doReportProperty(string)) continue;
            Object object = globalSettings.htNonbooleanParameterValues.get(string);
            if (string.charAt(0) == '=') {
                string = string.substring(1);
            } else {
                string = String.valueOf(string.indexOf("default") == 0 ? " " : "") + "set " + string;
                object = Escape.e(object);
            }
            objectArray[n++] = String.valueOf(string) + " " + object;
        }
        switch (globalSettings.axesMode) {
            case 0x24000020: {
                objectArray[n++] = "set axes unitcell";
                break;
            }
            case 603979804: {
                objectArray[n++] = "set axes molecular";
                break;
            }
            default: {
                objectArray[n++] = "set axes window";
            }
        }
        Arrays.sort(objectArray, 0, n);
        int n2 = 0;
        while (n2 < n) {
            if (objectArray[n2] != null) {
                this.app(sB2, (String)objectArray[n2]);
            }
            ++n2;
        }
        String string = StateManager.getVariableList(globalSettings.htUserVariables, 0, false, true);
        if (string.length() > 0) {
            sB2.append("\n#user-defined atom sets; \n");
            sB2.append(string);
        }
        if (this.vwr.shm.getShape(5) != null) {
            sB2.append(this.getDefaultLabelState((Labels)this.vwr.shm.shapes[5]));
        }
        if (globalSettings.haveSetStructureList) {
            Map<STR, float[]> map = globalSettings.structureList;
            sB2.append("struture HELIX set " + Escape.eAF((float[])map.get((Object)STR.HELIX)));
            sB2.append("struture SHEET set " + Escape.eAF((float[])map.get((Object)STR.SHEET)));
            sB2.append("struture TURN set " + Escape.eAF((float[])map.get((Object)STR.TURN)));
        }
        if (sB != null) {
            sB2.append("\n}\n\n");
        }
        return sB2.toString();
    }

    private String getDefaultLabelState(Labels labels) {
        SB sB = new SB().append("\n# label defaults;\n");
        this.app(sB, "select none");
        this.app(sB, Shape.getColorCommand("label", labels.defaultPaletteID, labels.defaultColix, labels.translucentAllowed));
        this.app(sB, "background label " + Shape.encodeColor(labels.defaultBgcolix));
        this.app(sB, "set labelOffset " + JC.getXOffset(labels.defaultOffset) + " " + JC.getYOffset(labels.defaultOffset));
        String string = JC.getHorizAlignmentName(labels.defaultAlignment);
        this.app(sB, "set labelAlignment " + (string.length() < 5 ? "left" : string));
        String string2 = JC.getPointerName(labels.defaultPointer);
        this.app(sB, "set labelPointer " + (string2.length() == 0 ? "off" : string2));
        if ((labels.defaultZPos & 0x20) != 0) {
            this.app(sB, "set labelFront");
        } else if ((labels.defaultZPos & 0x10) != 0) {
            this.app(sB, "set labelGroup");
        }
        this.app(sB, Shape.getFontCommand("label", Font.getFont3D(labels.defaultFontId)));
        return sB.toString();
    }

    private String getSelectionState(SelectionManager selectionManager, SB sB) {
        SB sB2 = new SB();
        if (sB != null) {
            sB.append("  _setSelectionState;\n");
            sB2.append("function _setSelectionState() {\n");
        }
        if (this.vwr.ms.trajectory != null) {
            this.app(sB2, this.vwr.ms.trajectory.getState());
        }
        Hashtable<String, BS> hashtable = new Hashtable<String, BS>();
        String string = null;
        this.addBs(sB2, "hide ", selectionManager.bsHidden);
        this.addBs(sB2, "subset ", selectionManager.bsSubset);
        this.addBs(sB2, "delete ", selectionManager.bsDeleted);
        this.addBs(sB2, "fix ", selectionManager.bsFixed);
        hashtable.put("-", this.vwr.slm.getSelectedAtomsNoSubset());
        string = this.getCommands(hashtable, null, "select");
        if (string == null) {
            this.app(sB2, "select none");
        } else {
            sB2.append(string);
        }
        this.app(sB2, "set hideNotSelected " + selectionManager.hideNotSelected);
        sB2.append((String)this.vwr.getShapeProperty(1, "selectionState"));
        if (this.vwr.getSelectionHalosEnabled()) {
            this.app(sB2, "SelectionHalos ON");
        }
        if (sB != null) {
            sB2.append("}\n\n");
        }
        return sB2.toString();
    }

    private String getViewState(TransformManager transformManager, SB sB) {
        boolean bl;
        boolean bl2;
        SB sB2 = new SB();
        String string = transformManager.getMoveToText(0.0f, false);
        if (sB != null) {
            sB.append("  _setPerspectiveState;\n");
            sB2.append("function _setPerspectiveState() {\n");
        }
        this.app(sB2, "set perspectiveModel " + transformManager.perspectiveModel);
        this.app(sB2, "set scaleAngstromsPerInch " + transformManager.scale3DAngstromsPerInch);
        this.app(sB2, "set perspectiveDepth " + transformManager.perspectiveDepth);
        this.app(sB2, "set visualRange " + transformManager.visualRangeAngstroms);
        if (!transformManager.isWindowCentered()) {
            this.app(sB2, "set windowCentered false");
        }
        this.app(sB2, "set cameraDepth " + transformManager.cameraDepth);
        boolean bl3 = bl2 = transformManager.mode == 1;
        if (bl2) {
            this.app(sB2, "set navigationMode true");
        }
        this.app(sB2, this.vwr.ms.getBoundBoxCommand(false));
        this.app(sB2, "center " + Escape.eP(transformManager.fixedRotationCenter));
        sB2.append(this.vwr.getOrientationText(1073742034, null, null).toString());
        this.app(sB2, string);
        if (!bl2 && !transformManager.zoomEnabled) {
            this.app(sB2, "zoom off");
        }
        sB2.append("  slab ").appendI(transformManager.slabPercentSetting).append(";depth ").appendI(transformManager.depthPercentSetting).append(transformManager.slabEnabled && !bl2 ? ";slab on" : "").append(";\n");
        sB2.append("  set slabRange ").appendF(transformManager.slabRange).append(";\n");
        if (transformManager.slabPlane != null) {
            sB2.append("  slab plane ").append(Escape.eP4(transformManager.slabPlane)).append(";\n");
        }
        if (transformManager.depthPlane != null) {
            sB2.append("  depth plane ").append(Escape.eP4(transformManager.depthPlane)).append(";\n");
        }
        this.getZshadeState(sB2, transformManager, false);
        sB2.append(this.getSpinState(true)).append("\n");
        if (this.vwr.ms.modelSetHasVibrationVectors() && transformManager.vibrationOn) {
            this.app(sB2, "set vibrationPeriod " + transformManager.vibrationPeriod + ";vibration on");
        }
        boolean bl4 = bl = transformManager.depthPlane != null || transformManager.slabPlane != null;
        if (bl2) {
            sB2.append(transformManager.getNavigationState());
        }
        if (!transformManager.slabEnabled && bl) {
            sB2.append("  slab off;\n");
        }
        if (sB != null) {
            sB2.append("}\n\n");
        }
        return sB2.toString();
    }

    private void getZshadeState(SB sB, TransformManager transformManager, boolean bl) {
        if (bl) {
            this.app(sB, "set zDepth " + transformManager.zDepthPercentSetting);
            this.app(sB, "set zSlab " + transformManager.zSlabPercentSetting);
            if (!transformManager.zShadeEnabled) {
                this.app(sB, "set zShade false");
            }
        }
        if (transformManager.zShadeEnabled) {
            this.app(sB, "set zShade true");
        }
        try {
            if (transformManager.zSlabPoint != null) {
                this.app(sB, "set zSlab " + Escape.eP(transformManager.zSlabPoint));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    String getSpinState(boolean bl) {
        String string;
        TransformManager transformManager = this.vwr.tm;
        String string2 = "  set spinX " + (int)transformManager.spinX + "; set spinY " + (int)transformManager.spinY + "; set spinZ " + (int)transformManager.spinZ + "; set spinFps " + (int)transformManager.spinFps + ";";
        if (!Float.isNaN(transformManager.navFps)) {
            string2 = String.valueOf(string2) + "  set navX " + (int)transformManager.navX + "; set navY " + (int)transformManager.navY + "; set navZ " + (int)transformManager.navZ + "; set navFps " + (int)transformManager.navFps + ";";
        }
        if (transformManager.navOn) {
            string2 = String.valueOf(string2) + " navigation on;";
        }
        if (!transformManager.spinOn) {
            return string2;
        }
        String string3 = string = transformManager.isSpinSelected ? "\n  select " + Escape.eBS(this.vwr.bsA()) + ";\n  rotateSelected" : "\n ";
        if (transformManager.isSpinInternal) {
            P3 p3 = P3.newP(transformManager.internalRotationCenter);
            p3.sub(transformManager.rotationAxis);
            string2 = String.valueOf(string2) + string + " spin " + transformManager.rotationRate + " " + Escape.eP(transformManager.internalRotationCenter) + " " + Escape.eP(p3);
        } else {
            string2 = transformManager.isSpinFixed ? String.valueOf(string2) + string + " spin axisangle " + Escape.eP(transformManager.rotationAxis) + " " + transformManager.rotationRate : String.valueOf(string2) + " spin on";
        }
        return String.valueOf(string2) + ";";
    }

    @Override
    String getCommands(Map<String, BS> map, Map<String, BS> map2, String string) {
        SB sB = new SB();
        String string2 = this.getCommands2(map, sB, null, string);
        if (map2 != null) {
            this.getCommands2(map2, sB, string2, "select");
        }
        return sB.toString();
    }

    private String getCommands2(Map<String, BS> map, SB sB, String string, String string2) {
        if (map == null) {
            return "";
        }
        for (Map.Entry<String, BS> entry : map.entrySet()) {
            String string3 = entry.getKey();
            String string4 = Escape.eBS(entry.getValue());
            if (string4.length() < 5) continue;
            string4 = String.valueOf(string2) + " " + string4;
            if (!string4.equals(string)) {
                this.app(sB, string4);
            }
            string = string4;
            if (string3.indexOf("-") == 0) continue;
            this.app(sB, string3);
        }
        return string;
    }

    private void app(SB sB, String string) {
        if (string.length() != 0) {
            sB.append("  ").append(string).append(";\n");
        }
    }

    private void addBs(SB sB, String string, BS bS) {
        if (bS == null || bS.length() == 0) {
            return;
        }
        this.app(sB, String.valueOf(string) + Escape.eBS(bS));
    }

    private String getFontState(String string, Font font) {
        int n = StateManager.getObjectIdFromName(string.equalsIgnoreCase("axes") ? "axis" : string);
        if (n < 0) {
            return "";
        }
        int n2 = this.vwr.getObjectMad10(n);
        SB sB = new SB().append("\n");
        this.app(sB, String.valueOf(string) + (n2 == 0 ? " off" : (n2 == 1 ? " on" : (n2 == -1 ? " dotted" : (n2 < 20 ? " " + n2 : " " + (float)n2 / 20000.0f)))));
        if (sB.length() < 3) {
            return "";
        }
        String string2 = Shape.getFontCommand(string, font);
        if (string2.length() > 0) {
            string2 = "  " + string2 + ";\n";
        }
        return sB + string2;
    }

    private void appendTickInfo(String string, SB sB, TickInfo tickInfo) {
        sB.append("  ");
        sB.append(string);
        StateCreator.addTickInfo(sB, tickInfo, false);
        sB.append(";\n");
    }

    private static void addTickInfo(SB sB, TickInfo tickInfo, boolean bl) {
        boolean bl2;
        sB.append(" ticks ").append(tickInfo.type).append(" ").append(Escape.eP(tickInfo.ticks));
        boolean bl3 = bl2 = tickInfo.scale != null && Float.isNaN(tickInfo.scale.x);
        if (bl2) {
            sB.append(" UNITCELL");
        }
        if (tickInfo.tickLabelFormats != null) {
            sB.append(" format ").append(Escape.eAS(tickInfo.tickLabelFormats, false));
        }
        if (!bl2 && tickInfo.scale != null) {
            sB.append(" scale ").append(Escape.eP(tickInfo.scale));
        }
        if (bl && !Float.isNaN(tickInfo.first) && tickInfo.first != 0.0f) {
            sB.append(" first ").appendF(tickInfo.first);
        }
        if (tickInfo.reference != null) {
            sB.append(" point ").append(Escape.eP(tickInfo.reference));
        }
    }

    private String getMeasurementState(Measures measures) {
        String string;
        Object object;
        Object object2;
        Lst<Measurement> lst = measures.measurements;
        int n = measures.measurementCount;
        Font font = measures.font3d;
        TickInfo tickInfo = measures.defaultTickInfo;
        SB sB = new SB();
        this.app(sB, "measures delete");
        int n2 = 0;
        while (n2 < n) {
            object2 = (Measurement)lst.get(n2);
            int n3 = ((Measurement)object2).count;
            SB sB2 = new SB().append("measure");
            if (((Measurement)object2).thisID != null) {
                sB2.append(" ID ").append(PT.esc(((Measurement)object2).thisID));
            }
            if (((Measurement)object2).mad != 0) {
                sB2.append(" radius ").appendF(((Measurement)object2).thisID == null || ((Measurement)object2).mad > 0 ? (float)((Measurement)object2).mad / 2000.0f : 0.0f);
            }
            if (((Measurement)object2).colix != 0) {
                sB2.append(" color ").append(Escape.escapeColor(C.getArgb(((Measurement)object2).colix)));
            }
            if (((Measurement)object2).text != null) {
                if (((Measurement)object2).text.font != null) {
                    sB2.append(" font ").append(((Measurement)object2).text.font.getInfo());
                }
                if (((Measurement)object2).text.align != 0) {
                    sB2.append(" align ").append(JC.getHorizAlignmentName(((Measurement)object2).text.align));
                }
                if (((Measurement)object2).text.pymolOffset != null) {
                    sB2.append(" offset ").append(Escape.eAF(((Measurement)object2).text.pymolOffset));
                }
            }
            if ((object = ((Measurement)object2).tickInfo) != null) {
                StateCreator.addTickInfo(sB2, (TickInfo)object, true);
            }
            int n4 = 1;
            while (n4 <= n3) {
                sB2.append(" ").append(((Measurement)object2).getLabel(n4, true, true));
                ++n4;
            }
            sB2.append("; # " + measures.getInfoAsString(n2));
            this.app(sB, sB2.toString());
            ++n2;
        }
        this.app(sB, "select *; set measures " + this.vwr.g.measureDistanceUnits);
        this.app(sB, Shape.getFontCommand("measures", font));
        n2 = 0;
        object2 = new Hashtable();
        BS bS = BS.newN(n);
        int n5 = 0;
        while (n5 < n) {
            object = (Measurement)lst.get(n5);
            if (((Measurement)object).isHidden) {
                ++n2;
                bS.set(n5);
            }
            if (measures.bsColixSet != null && measures.bsColixSet.get(n5)) {
                BSUtil.setMapBitSet((Map<String, BS>)object2, n5, n5, Shape.getColorCommandUnk("measure", ((Measurement)object).colix, measures.translucentAllowed));
            }
            if (((Measurement)object).strFormat != null) {
                BSUtil.setMapBitSet((Map<String, BS>)object2, n5, n5, "measure " + PT.esc(((Measurement)object).strFormat));
            }
            ++n5;
        }
        if (n2 > 0) {
            if (n2 == n) {
                this.app(sB, "measures off; # lines and numbers off");
            } else {
                n5 = 0;
                while (n5 < n) {
                    if (bS.get(n5)) {
                        BSUtil.setMapBitSet((Map<String, BS>)object2, n5, n5, "measure off");
                    }
                    ++n5;
                }
            }
        }
        if (tickInfo != null) {
            sB.append(" measure ");
            StateCreator.addTickInfo(sB, tickInfo, true);
            sB.append(";\n");
        }
        if (measures.mad >= 0) {
            sB.append(" set measurements " + (float)measures.mad / 2000.0f).append(";\n");
        }
        if ((string = this.getCommands((Map<String, BS>)object2, null, "select measures")) != null && string.length() != 0) {
            sB.append(string);
            this.app(sB, "select measures ({null})");
        }
        return sB.toString();
    }

    private void getShapeStatePriv(SB sB, boolean bl, int n) {
        int n2;
        int n3;
        Shape[] shapeArray = this.vwr.shm.shapes;
        if (shapeArray == null) {
            return;
        }
        if (n == Integer.MAX_VALUE) {
            n3 = 0;
            n2 = 37;
        } else {
            n3 = n;
            n2 = n3 + 1;
        }
        while (n3 < n2) {
            String string;
            Shape shape = shapeArray[n3];
            if (shape != null && (bl || n3 >= 9 && n3 < 16) && (string = this.getShapeState(shape)) != null && string.length() > 1) {
                sB.append(string);
            }
            ++n3;
        }
        sB.append("  select *;\n");
    }

    private String getBondState(Sticks sticks) {
        int n;
        int n2;
        BS bS = sticks.bsOrderSet;
        boolean bl = sticks.reportAll;
        this.clearTemp();
        ModelSet modelSet = this.vwr.ms;
        boolean bl2 = false;
        Bond[] bondArray = modelSet.bo;
        int n3 = modelSet.bondCount;
        if (bl || sticks.bsSizeSet != null) {
            n = n2 = bl ? n3 - 1 : sticks.bsSizeSet.nextSetBit(0);
            while (n >= 0) {
                short s = bondArray[n].mad;
                BSUtil.setMapBitSet(this.temp, n, n, "wireframe " + (s == 1 ? "on" : "" + (float)s / 2000.0f));
                int n4 = n = bl ? n - 1 : sticks.bsSizeSet.nextSetBit(n + 1);
            }
        }
        if (bl || bS != null) {
            n = n2 = bl ? n3 - 1 : bS.nextSetBit(0);
            while (n >= 0) {
                Bond bond = bondArray[n];
                if (bl || (bond.order & 0x20000) == 0) {
                    BSUtil.setMapBitSet(this.temp, n, n, "bondOrder " + Edge.getBondOrderNameFromOrder(bond.order));
                }
                int n5 = n = bl ? n - 1 : bS.nextSetBit(n + 1);
            }
        }
        if (sticks.bsColixSet != null) {
            n2 = sticks.bsColixSet.nextSetBit(0);
            while (n2 >= 0) {
                n = bondArray[n2].colix;
                if ((n & 0xFFFF87FF) == 2) {
                    BSUtil.setMapBitSet(this.temp, n2, n2, Shape.getColorCommand("bonds", PAL.CPK.id, (short)n, sticks.translucentAllowed));
                } else {
                    BSUtil.setMapBitSet(this.temp, n2, n2, Shape.getColorCommandUnk("bonds", (short)n, sticks.translucentAllowed));
                }
                n2 = sticks.bsColixSet.nextSetBit(n2 + 1);
            }
        }
        String string = String.valueOf(this.getCommands(this.temp, null, "select BONDS")) + "\n" + (bl2 ? String.valueOf(this.getCommands(this.temp2, null, "select BONDS")) + "\n" : "");
        this.clearTemp();
        return string;
    }

    private void clearTemp() {
        this.temp.clear();
        this.temp2.clear();
    }

    private String getShapeState(Shape shape) {
        String string;
        switch (shape.shapeID) {
            case 34: {
                string = this.getAxesState((Axes)shape);
                break;
            }
            case 33: {
                SymmetryInterface symmetryInterface;
                if (!this.vwr.ms.haveUnitCells) {
                    return "";
                }
                String string2 = string = this.getFontLineShapeState((FontLineShape)shape);
                int n = this.vwr.am.cai;
                if (n >= 0) {
                    string = String.valueOf(string) + "  unitcell ({" + n + "});\n";
                }
                if ((symmetryInterface = this.vwr.getCurrentUnitCell()) == null) break;
                string = String.valueOf(string) + symmetryInterface.getUnitCellState();
                string = String.valueOf(string) + string2;
                break;
            }
            case 32: {
                string = this.getFontLineShapeState((FontLineShape)shape);
                break;
            }
            case 36: {
                string = this.getFontState(shape.myType, ((Frank)shape).baseFont3d);
                break;
            }
            case 6: {
                string = this.getMeasurementState((Measures)shape);
                break;
            }
            case 7: 
            case 18: {
                string = this.getAtomShapeState((AtomShape)shape);
                break;
            }
            case 1: {
                string = this.getBondState((Sticks)shape);
                break;
            }
            case 31: {
                Echo echo = (Echo)shape;
                SB sB = new SB();
                sB.append("\n  set echo off;\n");
                for (Text text : echo.objects.values()) {
                    sB.append(this.getTextState(text));
                    if (!text.hidden) continue;
                    sB.append("  set echo ID ").append(PT.esc(text.target)).append(" hidden;\n");
                }
                string = sB.toString();
                break;
            }
            case 8: {
                Halos halos = (Halos)shape;
                string = String.valueOf(this.getAtomShapeState(halos)) + (halos.colixSelection == 2 ? "" : (halos.colixSelection == 0 ? "  color SelectionHalos NONE;\n" : String.valueOf(Shape.getColorCommandUnk("selectionHalos", halos.colixSelection, halos.translucentAllowed)) + ";\n"));
                if (halos.bsHighlight == null) break;
                string = String.valueOf(string) + "  set highlight " + Escape.eBS(halos.bsHighlight) + "; " + Shape.getColorCommandUnk("highlight", halos.colixHighlight, halos.translucentAllowed) + ";\n";
                break;
            }
            case 35: {
                this.clearTemp();
                Hover hover = (Hover)shape;
                if (hover.atomFormats != null) {
                    int n = this.vwr.ms.ac;
                    while (--n >= 0) {
                        if (hover.atomFormats[n] == null) continue;
                        BSUtil.setMapBitSet(this.temp, n, n, "set hoverLabel " + PT.esc(hover.atomFormats[n]));
                    }
                }
                string = "\n  hover " + PT.esc(hover.labelFormat == null ? "" : hover.labelFormat) + ";\n" + this.getCommands(this.temp, null, "select");
                this.clearTemp();
                break;
            }
            case 5: {
                Labels labels = (Labels)shape;
                if (!labels.isActive || labels.bsSizeSet == null) {
                    return "";
                }
                this.clearTemp();
                int n = labels.bsSizeSet.nextSetBit(0);
                while (n >= 0) {
                    Text text;
                    float f;
                    Text text2 = labels.getLabel(n);
                    String string3 = "label ";
                    if (text2 == null) {
                        string3 = String.valueOf(string3) + PT.esc(labels.formats[n]);
                    } else {
                        string3 = String.valueOf(string3) + PT.esc(text2.textUnformatted);
                        if (text2.pymolOffset != null) {
                            string3 = String.valueOf(string3) + ";set labelOffset " + Escape.eAF(text2.pymolOffset);
                        }
                    }
                    BSUtil.setMapBitSet(this.temp, n, n, string3);
                    if (labels.bsColixSet != null && labels.bsColixSet.get(n)) {
                        BSUtil.setMapBitSet(this.temp2, n, n, Shape.getColorCommand("label", labels.paletteIDs[n], labels.colixes[n], labels.translucentAllowed));
                    }
                    if (labels.bsBgColixSet != null && labels.bsBgColixSet.get(n)) {
                        BSUtil.setMapBitSet(this.temp2, n, n, "background label " + Shape.encodeColor(labels.bgcolixes[n]));
                    }
                    float f2 = f = (text = labels.getLabel(n)) != null ? text.scalePixelsPerMicron : 0.0f;
                    if (f > 0.0f) {
                        BSUtil.setMapBitSet(this.temp2, n, n, "set labelScaleReference " + 10000.0f / f);
                    }
                    if (labels.offsets != null && labels.offsets.length > n) {
                        int n2 = labels.offsets[n];
                        BSUtil.setMapBitSet(this.temp2, n, n, "set " + (JC.isOffsetAbsolute(n2) ? "labelOffsetAbsolute " : "labelOffset ") + JC.getXOffset(n2) + " " + JC.getYOffset(n2));
                        String string4 = JC.getHorizAlignmentName(n2 >> 2);
                        String string5 = JC.getPointerName(n2);
                        if (string5.length() > 0) {
                            BSUtil.setMapBitSet(this.temp2, n, n, "set labelPointer " + string5);
                        }
                        if ((n2 & 0x20) != 0) {
                            BSUtil.setMapBitSet(this.temp2, n, n, "set labelFront");
                        } else if ((n2 & 0x10) != 0) {
                            BSUtil.setMapBitSet(this.temp2, n, n, "set labelGroup");
                        }
                        if (string4.length() > 0) {
                            BSUtil.setMapBitSet(this.temp3, n, n, "set labelAlignment " + string4);
                        }
                    }
                    if (labels.mads != null && labels.mads[n] < 0) {
                        BSUtil.setMapBitSet(this.temp2, n, n, "set toggleLabel");
                    }
                    if (labels.bsFontSet != null && labels.bsFontSet.get(n)) {
                        BSUtil.setMapBitSet(this.temp2, n, n, Shape.getFontCommand("label", Font.getFont3D(labels.fids[n])));
                    }
                    n = labels.bsSizeSet.nextSetBit(n + 1);
                }
                string = String.valueOf(this.getCommands(this.temp, this.temp2, "select")) + this.getCommands(null, this.temp3, "select");
                this.temp3.clear();
                this.clearTemp();
                break;
            }
            case 0: {
                this.clearTemp();
                int n = this.vwr.ms.ac;
                Atom[] atomArray = this.vwr.ms.at;
                Balls balls = (Balls)shape;
                short[] sArray = balls.colixes;
                byte[] byArray = balls.paletteIDs;
                float f = 0.0f;
                int n3 = 0;
                while (n3 < n) {
                    if (shape.bsSizeSet != null && shape.bsSizeSet.get(n3)) {
                        float f3;
                        f = atomArray[n3].madAtom;
                        if (f3 < 0.0f) {
                            BSUtil.setMapBitSet(this.temp, n3, n3, "Spacefill on");
                        } else {
                            BSUtil.setMapBitSet(this.temp, n3, n3, "Spacefill " + PT.escF(f / 2000.0f));
                        }
                    }
                    if (shape.bsColixSet != null && shape.bsColixSet.get(n3)) {
                        byte by = atomArray[n3].paletteID;
                        if (by != PAL.CPK.id || C.isColixTranslucent(atomArray[n3].colixAtom)) {
                            BSUtil.setMapBitSet(this.temp, n3, n3, Shape.getColorCommand("atoms", by, atomArray[n3].colixAtom, shape.translucentAllowed));
                        }
                        if (sArray != null && n3 < sArray.length) {
                            BSUtil.setMapBitSet(this.temp2, n3, n3, Shape.getColorCommand("balls", byArray[n3], sArray[n3], shape.translucentAllowed));
                        }
                    }
                    ++n3;
                }
                string = this.getCommands(this.temp, this.temp2, "select");
                this.clearTemp();
                break;
            }
            default: {
                string = shape.getShapeState();
            }
        }
        return string;
    }

    private String getFontLineShapeState(FontLineShape fontLineShape) {
        String string = this.getFontState(fontLineShape.myType, fontLineShape.font3d);
        if (fontLineShape.tickInfos == null) {
            return string;
        }
        boolean bl = string.indexOf(" off") >= 0;
        SB sB = new SB();
        sB.append(string);
        int n = 0;
        while (n < 4) {
            if (fontLineShape.tickInfos[n] != null) {
                this.appendTickInfo(fontLineShape.myType, sB, fontLineShape.tickInfos[n]);
            }
            ++n;
        }
        if (bl) {
            sB.append("  " + fontLineShape.myType + " off;\n");
        }
        return sB.toString();
    }

    private String getAxesState(Axes axes) {
        String[] stringArray;
        SB sB = new SB();
        sB.append(this.getFontLineShapeState(axes));
        sB.append("  axes scale ").appendF(this.vwr.getFloat(0x22000002)).append(";\n");
        if (axes.fixedOrigin != null) {
            sB.append("  axes center ").append(Escape.eP(axes.fixedOrigin)).append(";\n");
        }
        P3 p3 = axes.axisXY;
        if (p3.z != 0.0f) {
            sB.append("  axes position [").appendI((int)p3.x).append(" ").appendI((int)p3.y).append(" ").append(p3.z < 0.0f ? " %" : "").append("];\n");
        }
        if ((stringArray = axes.labels) != null) {
            sB.append("  axes labels ");
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n] != null) {
                    sB.append(PT.esc(stringArray[n])).append(" ");
                }
                ++n;
            }
            sB.append(";\n");
        }
        if (axes.axisType != null) {
            sB.append("  axes type " + PT.esc(axes.axisType));
        }
        return sB.toString();
    }

    @Override
    public String getAtomShapeState(AtomShape atomShape) {
        int n;
        boolean bl;
        if (!atomShape.isActive) {
            return "";
        }
        this.clearTemp();
        String string = JC.shapeClassBases[atomShape.shapeID];
        boolean bl2 = bl = atomShape.shapeID == 18;
        if (atomShape.bsSizeSet != null) {
            n = atomShape.bsSizeSet.nextSetBit(0);
            while (n >= 0) {
                short s;
                BSUtil.setMapBitSet(this.temp, n, n, String.valueOf(string) + " " + ((s = atomShape.mads[n]) < 0 ? (bl && s < -1 ? "" + -s : "on") : PT.escF((float)s / 2000.0f)));
                n = atomShape.bsSizeSet.nextSetBit(n + 1);
            }
        }
        if (atomShape.bsColixSet != null) {
            n = atomShape.bsColixSet.nextSetBit(0);
            while (n >= 0) {
                BSUtil.setMapBitSet(this.temp2, n, n, Shape.getColorCommand(string, atomShape.paletteIDs[n], atomShape.colixes[n], atomShape.translucentAllowed));
                n = atomShape.bsColixSet.nextSetBit(n + 1);
            }
        }
        String string2 = this.getCommands(this.temp, this.temp2, "select");
        this.clearTemp();
        return string2;
    }

    private String getTextState(Text text) {
        SB sB = new SB();
        String string = text.text;
        if (string == null || text.isLabelOrHover || text.target.equals("error")) {
            return "";
        }
        boolean bl = text.image != null;
        String string2 = null;
        String string3 = "set echo ID " + PT.esc(text.target);
        switch (text.valign) {
            case 3: {
                string2 = text.movableXPercent == Integer.MAX_VALUE || text.movableYPercent == Integer.MAX_VALUE ? String.valueOf(text.movableXPercent == Integer.MAX_VALUE ? String.valueOf(text.movableX) + " " : String.valueOf(text.movableXPercent) + "% ") + (text.movableYPercent == Integer.MAX_VALUE ? String.valueOf(text.movableY) : String.valueOf(text.movableYPercent) + "%") : "[" + text.movableXPercent + " " + text.movableYPercent + "%]";
            }
            case 4: {
                if (string2 == null) {
                    string2 = Escape.eP(text.xyz);
                }
                sB.append("  ").append(string3).append(" ").append(string2);
                if (text.align == 4) break;
                sB.append(";  ").append(string3).append(" ").append(JC.getHorizAlignmentName(text.align));
                break;
            }
            default: {
                sB.append("  set echo ").append(JC.getEchoName(text.valign)).append(" ").append(JC.getHorizAlignmentName(text.align));
            }
        }
        if (text.movableZPercent != Integer.MAX_VALUE) {
            sB.append(";  ").append(string3).append(" depth ").appendI(text.movableZPercent);
        }
        if (bl) {
            sB.append("; ").append(string3).append(" IMAGE /*file*/");
        } else {
            sB.append("; echo ");
        }
        sB.append(PT.esc(string));
        sB.append(";\n");
        if (bl && text.imageScale != 1.0f) {
            sB.append("  ").append(string3).append(" scale ").appendF(text.imageScale).append(";\n");
        }
        if (text.script != null) {
            sB.append("  ").append(string3).append(" script ").append(PT.esc(text.script)).append(";\n");
        }
        if (text.modelIndex >= 0) {
            sB.append("  ").append(string3).append(" model ").append(this.vwr.getModelNumberDotted(text.modelIndex)).append(";\n");
        }
        if (text.pointerPt != null) {
            sB.append("  ").append(string3).append(" point ").append(text.pointerPt instanceof Atom ? "({" + ((Atom)text.pointerPt).i + "})" : Escape.eP(text.pointerPt)).append(";\n");
        }
        if (text.pymolOffset != null) {
            sB.append("  ").append(string3).append(" offset ").append(Escape.escapeFloatA(text.pymolOffset, true)).append(";\n");
        }
        text.appendFontCmd(sB);
        sB.append("; color echo");
        if (C.isColixTranslucent(text.colix)) {
            sB.append(C.getColixTranslucencyLabel(text.colix));
        }
        sB.append(" ").append(C.getHexCode(text.colix));
        if (text.bgcolix != 0) {
            sB.append("; color echo background ");
            if (C.isColixTranslucent(text.bgcolix)) {
                sB.append(C.getColixTranslucencyLabel(text.bgcolix)).append(" ");
            }
            sB.append(C.getHexCode(text.bgcolix));
        }
        sB.append(";\n");
        return sB.toString();
    }

    @Override
    String getAllSettings(String string) {
        Object object;
        GlobalSettings globalSettings = this.vwr.g;
        SB sB = new SB();
        Object[] objectArray = new String[globalSettings.htBooleanParameterFlags.size() + globalSettings.htNonbooleanParameterValues.size() + globalSettings.htUserVariables.size()];
        int n = 0;
        String string2 = "_" + string;
        for (String string3 : globalSettings.htBooleanParameterFlags.keySet()) {
            if (string != null && string3.indexOf(string) != 0 && string3.indexOf(string2) != 0) continue;
            objectArray[n++] = String.valueOf(string3.indexOf("_") == 0 ? String.valueOf(string3) + " = " : "set " + string3 + " ") + globalSettings.htBooleanParameterFlags.get(string3);
        }
        for (String string3 : globalSettings.htNonbooleanParameterValues.keySet()) {
            if (string3.charAt(0) == '@' || string != null && string3.indexOf(string) != 0 && string3.indexOf(string2) != 0) continue;
            object = globalSettings.htNonbooleanParameterValues.get(string3);
            if (object instanceof String) {
                object = StateCreator.chop(PT.esc((String)object));
            }
            objectArray[n++] = String.valueOf(string3.indexOf("_") == 0 ? String.valueOf(string3) + " = " : "set " + string3 + " ") + object;
        }
        for (String string3 : globalSettings.htUserVariables.keySet()) {
            if (string != null && string3.indexOf(string) != 0) continue;
            object = globalSettings.htUserVariables.get(string3);
            String string4 = ((SV)object).escape();
            objectArray[n++] = String.valueOf(string3) + " " + (string3.startsWith("@") ? "" : "= ") + (((SV)object).tok == 4 ? StateCreator.chop(PT.esc(string4)) : string4);
        }
        Arrays.sort(objectArray, 0, n);
        int n2 = 0;
        while (n2 < n) {
            if (objectArray[n2] != null) {
                this.app(sB, (String)objectArray[n2]);
            }
            ++n2;
        }
        sB.append("\n");
        return sB.toString();
    }

    /*
     * Unable to fully structure code
     */
    private static String chop(String var0) {
        var1_1 = var0.length();
        if (var1_1 < 512) {
            return var0;
        }
        var2_2 = new SB();
        var3_3 = "\"\\\n    + \"";
        var4_4 = 0;
        var5_5 = 72;
        ** GOTO lbl16
        {
            ++var5_5;
            do {
                if (var0.charAt(var5_5 - 1) == '\\') continue block0;
                var2_2.append(var4_4 == 0 ? "" : var3_3).append(var0.substring(var4_4, var5_5));
                var4_4 = var5_5;
                var5_5 += 72;
lbl16:
                // 2 sources

            } while (var5_5 < var1_1);
        }
        var2_2.append(var3_3).append(var0.substring(var4_4, var1_1));
        return var2_2.toString();
    }

    @Override
    String getFunctionCalls(String string) {
        boolean bl;
        if (string == null) {
            string = "";
        }
        SB sB = new SB();
        int n = string.indexOf("*");
        boolean bl2 = n >= 0;
        boolean bl3 = string.indexOf("static_") == 0;
        boolean bl4 = bl = string.equalsIgnoreCase("names") || string.equalsIgnoreCase("static_names");
        if (bl) {
            string = "";
        }
        if (bl2) {
            string = string.substring(0, n);
        }
        string = string.toLowerCase();
        if (bl3 || string.length() == 0) {
            this.addFunctions(sB, Viewer.staticFunctions, string, bl2, bl);
        }
        if (!bl3 || string.length() == 0) {
            this.addFunctions(sB, this.vwr.localFunctions, string, bl2, bl);
        }
        return sB.toString();
    }

    private void addFunctions(SB sB, Map<String, JmolScriptFunction> map, String string, boolean bl, boolean bl2) {
        Object[] objectArray = new String[map.size()];
        int n = 0;
        for (String string2 : map.keySet()) {
            if ((string.length() != 0 || string2.startsWith("_")) && !string2.equalsIgnoreCase(string) && (!bl || string2.toLowerCase().indexOf(string) != 0)) continue;
            objectArray[n++] = string2;
        }
        Arrays.sort(objectArray, 0, n);
        int n2 = 0;
        while (n2 < n) {
            JmolScriptFunction jmolScriptFunction = map.get(objectArray[n2]);
            sB.append(bl2 ? jmolScriptFunction.getSignature() : jmolScriptFunction.toString());
            sB.appendC('\n');
            ++n2;
        }
    }

    private static boolean isTainted(BS[] bSArray, int n, int n2) {
        return bSArray != null && bSArray[n2] != null && bSArray[n2].get(n);
    }

    @Override
    String getAtomicPropertyState(int n, BS bS) {
        if (!this.vwr.g.preserveState) {
            return "";
        }
        SB sB = new SB();
        int n2 = 0;
        while (n2 < 17) {
            BS bS2;
            if ((n < 0 || n2 == n) && (bS2 = bS != null ? bS : this.vwr.ms.getTaintedAtoms(n2)) != null) {
                this.getAtomicPropertyStateBuffer(sB, n2, bS2, null, null);
            }
            ++n2;
        }
        return sB.toString();
    }

    @Override
    void getAtomicPropertyStateBuffer(SB sB, int n, BS bS, String string, float[] fArray) {
        if (!this.vwr.g.preserveState) {
            return;
        }
        SB sB2 = new SB();
        String string2 = String.valueOf(string == null ? AtomCollection.userSettableValues[n] : string) + " set";
        int n2 = 0;
        boolean bl = n == 2;
        Atom[] atomArray = this.vwr.ms.at;
        BS[] bSArray = this.vwr.ms.tainted;
        if (bS != null) {
            int n3 = bS.nextSetBit(0);
            while (n3 >= 0) {
                if (!atomArray[n3].isDeleted()) {
                    sB2.appendI(n3 + 1).append(" ").append(atomArray[n3].getElementSymbol()).append(" ").append(atomArray[n3].getInfo().replace(' ', '_')).append(" ");
                    switch (n) {
                        case 17: {
                            if (n3 >= fArray.length) break;
                            sB2.appendF(fArray[n3]);
                            break;
                        }
                        case 13: {
                            sB2.appendI(atomArray[n3].getAtomNumber());
                            break;
                        }
                        case 16: {
                            sB2.append(atomArray[n3].getChainIDStr());
                            break;
                        }
                        case 15: {
                            sB2.appendI(atomArray[n3].group.getResno());
                            break;
                        }
                        case 14: {
                            sB2.appendI(atomArray[n3].getSeqID());
                            break;
                        }
                        case 0: {
                            sB2.append(atomArray[n3].getAtomName());
                            break;
                        }
                        case 1: {
                            sB2.append(atomArray[n3].getAtomType());
                            break;
                        }
                        case 2: {
                            if (StateCreator.isTainted(bSArray, n3, 2)) {
                                bl = false;
                            }
                            sB2.appendF(atomArray[n3].x).append(" ").appendF(atomArray[n3].y).append(" ").appendF(atomArray[n3].z);
                            break;
                        }
                        case 12: {
                            Vibration vibration = atomArray[n3].getVibrationVector();
                            if (vibration == null) {
                                sB2.append("0 0 0");
                                break;
                            }
                            if (Float.isNaN(vibration.modScale)) {
                                sB2.appendF(vibration.x).append(" ").appendF(vibration.y).append(" ").appendF(vibration.z);
                                break;
                            }
                            sB2.appendF(Float.MIN_VALUE).append(" ").appendF(Float.MIN_VALUE).append(" ").appendF(vibration.modScale);
                            break;
                        }
                        case 3: {
                            sB2.appendI(atomArray[n3].getAtomicAndIsotopeNumber());
                            break;
                        }
                        case 4: {
                            sB2.appendI(atomArray[n3].getFormalCharge());
                            break;
                        }
                        case 6: {
                            sB2.appendF(atomArray[n3].getBondingRadius());
                            break;
                        }
                        case 7: {
                            sB2.appendI(atomArray[n3].getOccupancy100());
                            break;
                        }
                        case 8: {
                            sB2.appendF(atomArray[n3].getPartialCharge());
                            break;
                        }
                        case 9: {
                            sB2.appendF((float)atomArray[n3].getBfactor100() / 100.0f);
                            break;
                        }
                        case 10: {
                            sB2.appendI(atomArray[n3].getValence());
                            break;
                        }
                        case 11: {
                            sB2.appendF(atomArray[n3].getVanderwaalsRadiusFloat(this.vwr, VDW.AUTO));
                        }
                    }
                    sB2.append(" ;\n");
                    ++n2;
                }
                n3 = bS.nextSetBit(n3 + 1);
            }
        }
        if (n2 == 0) {
            return;
        }
        if (bl) {
            string2 = String.valueOf(string2) + "(default)";
        }
        sB.append("\n  DATA \"" + string2 + "\"\n").appendI(n2).append(" ;\nJmol Property Data Format 1 -- Jmol ").append(Viewer.getJmolVersion()).append(";\n");
        sB.appendSB(sB2);
        sB.append("  end \"" + string2 + "\";\n");
    }

    @Override
    void undoMoveAction(int n, int n2) {
        block0 : switch (n) {
            case 4139: 
            case 4165: {
                switch (n2) {
                    case -2: {
                        this.vwr.undoClear();
                        break block0;
                    }
                    case -1: {
                        (n == 4165 ? this.vwr.actionStates : this.vwr.actionStatesRedo).clear();
                        break block0;
                    }
                    case 0: {
                        n2 = Integer.MAX_VALUE;
                    }
                }
                if (n2 > 100) {
                    n2 = (n == 4165 ? this.vwr.actionStates : this.vwr.actionStatesRedo).size();
                }
                int n3 = 0;
                while (n3 < n2) {
                    this.undoMoveActionClear(0, n, true);
                    ++n3;
                }
                break;
            }
        }
    }

    @Override
    void undoMoveActionClear(int n, int n2, boolean bl) {
        if (!this.vwr.g.preserveState) {
            return;
        }
        int n3 = n >= 0 ? (int)this.vwr.ms.at[n].mi : this.vwr.ms.mc - 1;
        switch (n2) {
            case 4139: 
            case 4165: {
                Lst<String> lst;
                Lst<String> lst2;
                this.vwr.stopMinimization();
                String string = "";
                switch (n2) {
                    default: {
                        lst2 = this.vwr.actionStates;
                        lst = this.vwr.actionStatesRedo;
                        break;
                    }
                    case 4139: {
                        lst2 = this.vwr.actionStatesRedo;
                        lst = this.vwr.actionStates;
                        if (this.vwr.actionStatesRedo.size() != 1) break;
                        return;
                    }
                }
                if (lst2.size() == 0 || this.undoWorking) {
                    return;
                }
                this.undoWorking = true;
                lst.add(0, lst2.removeItemAt(0));
                string = (String)this.vwr.actionStatesRedo.get(0);
                if (n2 == 4165 && lst.size() == 1) {
                    int[] nArray = new int[]{1};
                    n2 = PT.parseIntNext(string, nArray);
                    n = PT.parseIntNext(string, nArray);
                    this.undoMoveActionClear(n, n2, false);
                }
                if (this.vwr.ms.am[n3].isModelKit || string.indexOf("zap ") < 0) {
                    if (Logger.debugging) {
                        this.vwr.log(string);
                    }
                    this.vwr.evalStringQuiet(string);
                    break;
                }
                this.vwr.actionStates.clear();
                break;
            }
            default: {
                if (this.undoWorking && bl) {
                    return;
                }
                this.undoWorking = true;
                SB sB = new SB();
                sB.append("#" + n2 + " " + n + " " + new Date() + "\n");
                if (n >= 0) {
                    BS bS = this.vwr.getModelUndeletedAtomsBitSet(n3);
                    this.vwr.ms.taintAtoms(bS, n2);
                    sB.append(this.getAtomicPropertyState(-1, null));
                } else {
                    BS bS = this.vwr.getModelUndeletedAtomsBitSet(n3);
                    sB.append("zap ");
                    sB.append(Escape.eBS(bS)).append(";");
                    this.getInlineData(sB, this.vwr.getModelExtract(bS, false, true, "MOL"), true, null);
                    sB.append("set refreshing false;").append(this.vwr.acm.getPickingState()).append(this.vwr.tm.getMoveToText(0.0f, false)).append("set refreshing true;");
                }
                if (bl) {
                    this.vwr.actionStates.add(0, sB.toString());
                    this.vwr.actionStatesRedo.clear();
                } else {
                    this.vwr.actionStatesRedo.add(1, sB.toString());
                }
                if (this.vwr.actionStates.size() != 100) break;
                this.vwr.actionStates.removeItemAt(99);
            }
        }
        this.undoWorking = !bl;
    }

    @Override
    void syncScript(String string, String string2, int n) {
        StatusManager statusManager = this.vwr.sm;
        if ("GET_GRAPHICS".equalsIgnoreCase(string)) {
            statusManager.setSyncDriver(5);
            statusManager.syncSend(string, string2, 0);
            this.vwr.setBooleanProperty("_syncMouse", false);
            this.vwr.setBooleanProperty("_syncScript", false);
            return;
        }
        if ("=".equals(string2)) {
            string2 = "~";
            statusManager.setSyncDriver(2);
        }
        boolean bl = "~".equals(string2);
        if (n > 0 || !bl && !".".equals(string2)) {
            statusManager.syncSend(string, string2, n);
            if (!"*".equals(string2) || string.startsWith("{")) {
                return;
            }
        }
        if (string.equalsIgnoreCase("on") || string.equalsIgnoreCase("true")) {
            statusManager.setSyncDriver(1);
            return;
        }
        if (string.equalsIgnoreCase("off") || string.equalsIgnoreCase("false")) {
            statusManager.setSyncDriver(0);
            return;
        }
        if (string.equalsIgnoreCase("slave")) {
            statusManager.setSyncDriver(2);
            return;
        }
        int n2 = statusManager.getSyncMode();
        if (n2 == 0) {
            return;
        }
        if (n2 != 1) {
            bl = false;
        }
        if (Logger.debugging) {
            Logger.debug(String.valueOf(this.vwr.htmlName) + " syncing with script: " + string);
        }
        if (bl) {
            statusManager.setSyncDriver(3);
        }
        if (string.indexOf("Mouse: ") != 0) {
            int n3 = JC.getServiceCommand(string);
            switch (n3) {
                case 42: 
                case 49: 
                case 56: 
                case 63: 
                case 70: {
                    statusManager.syncSend(string, ".", n);
                    return;
                }
                case -1: {
                    break;
                }
                case 0: 
                case 28: 
                case 35: 
                case 77: {
                    if (bl) {
                        return;
                    }
                }
                case 7: 
                case 14: 
                case 21: {
                    string = this.vwr.getJSV().processSync(string, n3);
                    if (string != null) break;
                    return;
                }
            }
            this.vwr.evalStringQuietSync(string, true, false);
            return;
        }
        this.mouseScript(string);
        if (bl) {
            this.vwr.setSyncDriver(4);
        }
    }

    @Override
    void mouseScript(String string) {
        String[] stringArray = PT.getTokens(string);
        String string2 = stringArray[1];
        try {
            string2 = (String.valueOf(string2.toLowerCase()) + "...............").substring(0, 15);
            switch ("zoombyfactor...zoomby.........rotatezby......rotatexyby.....translatexyby..rotatemolecule.spinxyby.......rotatearcball..".indexOf(string2)) {
                case 0: {
                    switch (stringArray.length) {
                        case 3: {
                            this.vwr.zoomByFactor(PT.parseFloat(stringArray[2]), Integer.MAX_VALUE, Integer.MAX_VALUE);
                            return;
                        }
                        case 5: {
                            this.vwr.zoomByFactor(PT.parseFloat(stringArray[2]), PT.parseInt(stringArray[3]), PT.parseInt(stringArray[4]));
                            return;
                        }
                    }
                    break;
                }
                case 15: {
                    switch (stringArray.length) {
                        case 3: {
                            this.vwr.zoomBy(PT.parseInt(stringArray[2]));
                            return;
                        }
                    }
                    break;
                }
                case 30: {
                    switch (stringArray.length) {
                        case 3: {
                            this.vwr.rotateZBy(PT.parseInt(stringArray[2]), Integer.MAX_VALUE, Integer.MAX_VALUE);
                            return;
                        }
                        case 5: {
                            this.vwr.rotateZBy(PT.parseInt(stringArray[2]), PT.parseInt(stringArray[3]), PT.parseInt(stringArray[4]));
                        }
                    }
                    break;
                }
                case 45: {
                    this.vwr.rotateXYBy(PT.parseFloat(stringArray[2]), PT.parseFloat(stringArray[3]));
                    return;
                }
                case 60: {
                    this.vwr.translateXYBy(PT.parseInt(stringArray[2]), PT.parseInt(stringArray[3]));
                    return;
                }
                case 75: {
                    this.vwr.rotateSelected(PT.parseFloat(stringArray[2]), PT.parseFloat(stringArray[3]), null);
                    return;
                }
                case 90: {
                    this.vwr.spinXYBy(PT.parseInt(stringArray[2]), PT.parseInt(stringArray[3]), PT.parseFloat(stringArray[4]));
                    return;
                }
                case 105: {
                    this.vwr.rotateXYBy(PT.parseInt(stringArray[2]), PT.parseInt(stringArray[3]));
                    return;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.vwr.showString("error reading SYNC command: " + string, false);
    }
}

