/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.ColoringAttributesRetained;
import javax.media.j3d.CompileState;
import javax.media.j3d.GeometryAtom;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.LineAttributes;
import javax.media.j3d.LineAttributesRetained;
import javax.media.j3d.Material;
import javax.media.j3d.MaterialRetained;
import javax.media.j3d.NodeComponentRetained;
import javax.media.j3d.PointAttributes;
import javax.media.j3d.PointAttributesRetained;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.PolygonAttributesRetained;
import javax.media.j3d.RenderingAttributes;
import javax.media.j3d.RenderingAttributesRetained;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.TexCoordGeneration;
import javax.media.j3d.TexCoordGenerationRetained;
import javax.media.j3d.Texture;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.TextureAttributesRetained;
import javax.media.j3d.TextureRetained;
import javax.media.j3d.TextureUnitState;
import javax.media.j3d.TextureUnitStateRetained;
import javax.media.j3d.TransparencyAttributes;
import javax.media.j3d.TransparencyAttributesRetained;
import javax.media.j3d.VirtualUniverse;

class AppearanceRetained
extends NodeComponentRetained {
    MaterialRetained material = null;
    TextureRetained texture = null;
    TexCoordGenerationRetained texCoordGeneration = null;
    TextureAttributesRetained textureAttributes = null;
    TextureUnitStateRetained[] texUnitState = null;
    ColoringAttributesRetained coloringAttributes = null;
    TransparencyAttributesRetained transparencyAttributes = null;
    RenderingAttributesRetained renderingAttributes = null;
    PolygonAttributesRetained polygonAttributes = null;
    LineAttributesRetained lineAttributes = null;
    PointAttributesRetained pointAttributes = null;
    Object liveStateLock = new Object();
    CompileState map = null;
    AppearanceRetained mapAppearance = null;
    static final int MATERIAL = 1;
    static final int TEXTURE = 2;
    static final int TEXCOORD_GEN = 4;
    static final int TEXTURE_ATTR = 8;
    static final int COLOR = 16;
    static final int TRANSPARENCY = 32;
    static final int RENDERING = 64;
    static final int POLYGON = 128;
    static final int LINE = 256;
    static final int POINT = 512;
    static final int TEXTURE_UNIT_STATE = 1024;
    static final int ALL_SOLE_USERS = 0;
    AppearanceRetained sgApp = null;

    AppearanceRetained() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setMaterial(Material material) {
        Object object = this.liveStateLock;
        synchronized (object) {
            if (this.source.isLive()) {
                if (this.material != null) {
                    this.material.clearLive(this.refCount);
                    this.material.removeMirrorUsers(this);
                }
                if (material != null) {
                    ((MaterialRetained)material.retained).setLive(this.inBackgroundGroup, this.refCount);
                    ((MaterialRetained)material.retained).copyMirrorUsers(this);
                }
                this.sendMessage(1, material != null ? ((MaterialRetained)material.retained).mirror : null, true);
            }
            this.material = material == null ? null : (MaterialRetained)material.retained;
        }
    }

    Material getMaterial() {
        return this.material == null ? null : (Material)this.material.source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTexture(Texture texture) {
        Object object = this.liveStateLock;
        synchronized (object) {
            if (this.source.isLive()) {
                if (this.texture != null) {
                    this.texture.clearLive(this.refCount);
                    this.texture.removeMirrorUsers(this);
                }
                if (texture != null) {
                    ((TextureRetained)texture.retained).setLive(this.inBackgroundGroup, this.refCount);
                    ((TextureRetained)texture.retained).copyMirrorUsers(this);
                }
                this.sendMessage(2, texture != null ? ((TextureRetained)texture.retained).mirror : null, true);
            }
            this.texture = texture == null ? null : (TextureRetained)texture.retained;
        }
    }

    Texture getTexture() {
        return this.texture == null ? null : (Texture)this.texture.source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTextureAttributes(TextureAttributes textureAttributes) {
        Object object = this.liveStateLock;
        synchronized (object) {
            if (this.source.isLive()) {
                if (this.textureAttributes != null) {
                    this.textureAttributes.clearLive(this.refCount);
                    this.textureAttributes.removeMirrorUsers(this);
                }
                if (textureAttributes != null) {
                    ((TextureAttributesRetained)textureAttributes.retained).setLive(this.inBackgroundGroup, this.refCount);
                    ((TextureAttributesRetained)textureAttributes.retained).copyMirrorUsers(this);
                }
                this.sendMessage(8, textureAttributes != null ? ((TextureAttributesRetained)textureAttributes.retained).mirror : null, true);
            }
            this.textureAttributes = textureAttributes == null ? null : (TextureAttributesRetained)textureAttributes.retained;
        }
    }

    TextureAttributes getTextureAttributes() {
        return this.textureAttributes == null ? null : (TextureAttributes)this.textureAttributes.source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setColoringAttributes(ColoringAttributes coloringAttributes) {
        Object object = this.liveStateLock;
        synchronized (object) {
            if (this.source.isLive()) {
                if (this.coloringAttributes != null) {
                    this.coloringAttributes.clearLive(this.refCount);
                    this.coloringAttributes.removeMirrorUsers(this);
                }
                if (coloringAttributes != null) {
                    ((ColoringAttributesRetained)coloringAttributes.retained).setLive(this.inBackgroundGroup, this.refCount);
                    ((ColoringAttributesRetained)coloringAttributes.retained).copyMirrorUsers(this);
                }
                this.sendMessage(16, coloringAttributes != null ? ((ColoringAttributesRetained)coloringAttributes.retained).mirror : null, true);
            }
            this.coloringAttributes = coloringAttributes == null ? null : (ColoringAttributesRetained)coloringAttributes.retained;
        }
    }

    ColoringAttributes getColoringAttributes() {
        return this.coloringAttributes == null ? null : (ColoringAttributes)this.coloringAttributes.source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTransparencyAttributes(TransparencyAttributes transparencyAttributes) {
        Object object = this.liveStateLock;
        synchronized (object) {
            if (this.source.isLive()) {
                if (this.transparencyAttributes != null) {
                    this.transparencyAttributes.clearLive(this.refCount);
                    this.transparencyAttributes.removeMirrorUsers(this);
                }
                if (transparencyAttributes != null) {
                    ((TransparencyAttributesRetained)transparencyAttributes.retained).setLive(this.inBackgroundGroup, this.refCount);
                    ((TransparencyAttributesRetained)transparencyAttributes.retained).copyMirrorUsers(this);
                }
                this.sendMessage(32, transparencyAttributes != null ? ((TransparencyAttributesRetained)transparencyAttributes.retained).mirror : null, true);
            }
            this.transparencyAttributes = transparencyAttributes == null ? null : (TransparencyAttributesRetained)transparencyAttributes.retained;
        }
    }

    TransparencyAttributes getTransparencyAttributes() {
        return this.transparencyAttributes == null ? null : (TransparencyAttributes)this.transparencyAttributes.source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setRenderingAttributes(RenderingAttributes renderingAttributes) {
        Object object = this.liveStateLock;
        synchronized (object) {
            if (this.source.isLive()) {
                if (this.renderingAttributes != null) {
                    this.renderingAttributes.clearLive(this.refCount);
                    this.renderingAttributes.removeMirrorUsers(this);
                }
                if (renderingAttributes != null) {
                    ((RenderingAttributesRetained)renderingAttributes.retained).setLive(this.inBackgroundGroup, this.refCount);
                    ((RenderingAttributesRetained)renderingAttributes.retained).copyMirrorUsers(this);
                }
                NodeComponentRetained nodeComponentRetained = null;
                boolean bl = true;
                if (renderingAttributes != null) {
                    nodeComponentRetained = ((RenderingAttributesRetained)renderingAttributes.retained).mirror;
                    bl = ((RenderingAttributesRetained)renderingAttributes.retained).visible;
                }
                this.sendMessage(64, nodeComponentRetained, bl);
                this.sendRenderingAttributesChangedMessage(bl);
            }
            this.renderingAttributes = renderingAttributes == null ? null : (RenderingAttributesRetained)renderingAttributes.retained;
        }
    }

    RenderingAttributes getRenderingAttributes() {
        if (this.renderingAttributes == null) {
            return null;
        }
        return (RenderingAttributes)this.renderingAttributes.source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setPolygonAttributes(PolygonAttributes polygonAttributes) {
        Object object = this.liveStateLock;
        synchronized (object) {
            if (this.source.isLive()) {
                if (this.polygonAttributes != null) {
                    this.polygonAttributes.clearLive(this.refCount);
                    this.polygonAttributes.removeMirrorUsers(this);
                }
                if (polygonAttributes != null) {
                    ((PolygonAttributesRetained)polygonAttributes.retained).setLive(this.inBackgroundGroup, this.refCount);
                    ((PolygonAttributesRetained)polygonAttributes.retained).copyMirrorUsers(this);
                }
                this.sendMessage(128, polygonAttributes != null ? ((PolygonAttributesRetained)polygonAttributes.retained).mirror : null, true);
            }
            this.polygonAttributes = polygonAttributes == null ? null : (PolygonAttributesRetained)polygonAttributes.retained;
        }
    }

    PolygonAttributes getPolygonAttributes() {
        return this.polygonAttributes == null ? null : (PolygonAttributes)this.polygonAttributes.source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setLineAttributes(LineAttributes lineAttributes) {
        Object object = this.liveStateLock;
        synchronized (object) {
            if (this.source.isLive()) {
                if (this.lineAttributes != null) {
                    this.lineAttributes.clearLive(this.refCount);
                    this.lineAttributes.removeMirrorUsers(this);
                }
                if (lineAttributes != null) {
                    ((LineAttributesRetained)lineAttributes.retained).setLive(this.inBackgroundGroup, this.refCount);
                    ((LineAttributesRetained)lineAttributes.retained).copyMirrorUsers(this);
                }
                this.sendMessage(256, lineAttributes != null ? ((LineAttributesRetained)lineAttributes.retained).mirror : null, true);
            }
            this.lineAttributes = lineAttributes == null ? null : (LineAttributesRetained)lineAttributes.retained;
        }
    }

    LineAttributes getLineAttributes() {
        return this.lineAttributes == null ? null : (LineAttributes)this.lineAttributes.source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setPointAttributes(PointAttributes pointAttributes) {
        Object object = this.liveStateLock;
        synchronized (object) {
            if (this.source.isLive()) {
                if (this.pointAttributes != null) {
                    this.pointAttributes.clearLive(this.refCount);
                    this.pointAttributes.removeMirrorUsers(this);
                }
                if (pointAttributes != null) {
                    ((PointAttributesRetained)pointAttributes.retained).setLive(this.inBackgroundGroup, this.refCount);
                    ((PointAttributesRetained)pointAttributes.retained).copyMirrorUsers(this);
                }
                this.sendMessage(512, pointAttributes != null ? ((PointAttributesRetained)pointAttributes.retained).mirror : null, true);
            }
            this.pointAttributes = pointAttributes == null ? null : (PointAttributesRetained)pointAttributes.retained;
        }
    }

    PointAttributes getPointAttributes() {
        return this.pointAttributes == null ? null : (PointAttributes)this.pointAttributes.source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTexCoordGeneration(TexCoordGeneration texCoordGeneration) {
        Object object = this.liveStateLock;
        synchronized (object) {
            if (this.source.isLive()) {
                if (this.texCoordGeneration != null) {
                    this.texCoordGeneration.clearLive(this.refCount);
                    this.texCoordGeneration.removeMirrorUsers(this);
                }
                if (texCoordGeneration != null) {
                    ((TexCoordGenerationRetained)texCoordGeneration.retained).setLive(this.inBackgroundGroup, this.refCount);
                    ((TexCoordGenerationRetained)texCoordGeneration.retained).copyMirrorUsers(this);
                }
                this.sendMessage(4, texCoordGeneration != null ? ((TexCoordGenerationRetained)texCoordGeneration.retained).mirror : null, true);
            }
            this.texCoordGeneration = texCoordGeneration == null ? null : (TexCoordGenerationRetained)texCoordGeneration.retained;
        }
    }

    TexCoordGeneration getTexCoordGeneration() {
        return this.texCoordGeneration == null ? null : (TexCoordGeneration)this.texCoordGeneration.source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTextureUnitState(TextureUnitState[] textureUnitStateArray) {
        Object object = this.liveStateLock;
        synchronized (object) {
            int n;
            if (this.source.isLive()) {
                if (this.texUnitState != null) {
                    for (n = 0; n < this.texUnitState.length; ++n) {
                        if (this.texUnitState[n] == null) continue;
                        this.texUnitState[n].clearLive(this.refCount);
                        this.texUnitState[n].removeMirrorUsers(this);
                    }
                }
                if (textureUnitStateArray != null && textureUnitStateArray.length > 0) {
                    TextureUnitStateRetained[] textureUnitStateRetainedArray = new TextureUnitStateRetained[textureUnitStateArray.length];
                    Object[] objectArray = new Object[]{new Integer(-1), textureUnitStateRetainedArray};
                    for (n = 0; n < textureUnitStateArray.length; ++n) {
                        TextureUnitState textureUnitState = textureUnitStateArray[n];
                        if (textureUnitState != null) {
                            ((TextureUnitStateRetained)textureUnitState.retained).setLive(this.inBackgroundGroup, this.refCount);
                            ((TextureUnitStateRetained)textureUnitState.retained).copyMirrorUsers(this);
                            textureUnitStateRetainedArray[n] = (TextureUnitStateRetained)((TextureUnitStateRetained)textureUnitState.retained).mirror;
                            continue;
                        }
                        textureUnitStateRetainedArray[n] = null;
                    }
                    this.sendMessage(1024, objectArray, true);
                } else {
                    this.sendMessage(1024, null, true);
                }
            }
            if (textureUnitStateArray == null) {
                this.texUnitState = null;
            } else {
                if (this.texUnitState == null || this.texUnitState.length != textureUnitStateArray.length) {
                    this.texUnitState = new TextureUnitStateRetained[textureUnitStateArray.length];
                }
                for (n = 0; n < textureUnitStateArray.length; ++n) {
                    this.texUnitState[n] = textureUnitStateArray[n] != null ? (TextureUnitStateRetained)textureUnitStateArray[n].retained : null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTextureUnitState(int n, TextureUnitState textureUnitState) {
        Object object = this.liveStateLock;
        synchronized (object) {
            if (this.source.isLive()) {
                if (this.texUnitState[n] != null) {
                    this.texUnitState[n].clearLive(this.refCount);
                    this.texUnitState[n].removeMirrorUsers(this);
                }
                Object[] objectArray = new Object[2];
                objectArray[0] = new Integer(n);
                if (textureUnitState != null) {
                    ((TextureUnitStateRetained)textureUnitState.retained).setLive(this.inBackgroundGroup, this.refCount);
                    ((TextureUnitStateRetained)textureUnitState.retained).copyMirrorUsers(this);
                    objectArray[1] = ((TextureUnitStateRetained)textureUnitState.retained).mirror;
                    this.sendMessage(1024, objectArray, true);
                } else {
                    objectArray[1] = null;
                    this.sendMessage(1024, objectArray, true);
                }
            }
            this.texUnitState[n] = textureUnitState != null ? (TextureUnitStateRetained)textureUnitState.retained : null;
        }
    }

    TextureUnitState[] getTextureUnitState() {
        if (this.texUnitState == null) {
            return null;
        }
        TextureUnitState[] textureUnitStateArray = new TextureUnitState[this.texUnitState.length];
        for (int i = 0; i < this.texUnitState.length; ++i) {
            textureUnitStateArray[i] = this.texUnitState[i] != null ? (TextureUnitState)this.texUnitState[i].source : null;
        }
        return textureUnitStateArray;
    }

    TextureUnitState getTextureUnitState(int n) {
        if (this.texUnitState[n] != null) {
            return (TextureUnitState)this.texUnitState[n].source;
        }
        return null;
    }

    int getTextureUnitCount() {
        if (this.texUnitState == null) {
            return 0;
        }
        return this.texUnitState.length;
    }

    synchronized void createMirrorObject() {
        if (this.mirror == null) {
            this.mirror = new AppearanceRetained();
        }
        this.initMirrorObject();
    }

    synchronized void initMirrorObject() {
        AppearanceRetained appearanceRetained = (AppearanceRetained)this.mirror;
        appearanceRetained.source = this.source;
        appearanceRetained.sgApp = this;
        appearanceRetained.changedFrequent = this.changedFrequent;
        appearanceRetained.material = this.material != null ? (MaterialRetained)this.material.mirror : null;
        appearanceRetained.texture = this.texture != null ? (TextureRetained)this.texture.mirror : null;
        appearanceRetained.texCoordGeneration = this.texCoordGeneration != null ? (TexCoordGenerationRetained)this.texCoordGeneration.mirror : null;
        appearanceRetained.textureAttributes = this.textureAttributes != null ? (TextureAttributesRetained)this.textureAttributes.mirror : null;
        if (this.texUnitState != null && this.texUnitState.length > 0) {
            appearanceRetained.texUnitState = new TextureUnitStateRetained[this.texUnitState.length];
            for (int i = 0; i < this.texUnitState.length; ++i) {
                if (this.texUnitState[i] == null) continue;
                appearanceRetained.texUnitState[i] = (TextureUnitStateRetained)this.texUnitState[i].mirror;
            }
        } else if (appearanceRetained.texture != null || appearanceRetained.textureAttributes != null || appearanceRetained.texCoordGeneration != null) {
            appearanceRetained.texUnitState = new TextureUnitStateRetained[1];
            appearanceRetained.texUnitState[0] = new TextureUnitStateRetained();
            appearanceRetained.texUnitState[0].set(appearanceRetained.texture, appearanceRetained.textureAttributes, appearanceRetained.texCoordGeneration);
        }
        appearanceRetained.coloringAttributes = this.coloringAttributes != null ? (ColoringAttributesRetained)this.coloringAttributes.mirror : null;
        appearanceRetained.transparencyAttributes = this.transparencyAttributes != null ? (TransparencyAttributesRetained)this.transparencyAttributes.mirror : null;
        appearanceRetained.renderingAttributes = this.renderingAttributes != null ? (RenderingAttributesRetained)this.renderingAttributes.mirror : null;
        appearanceRetained.polygonAttributes = this.polygonAttributes != null ? (PolygonAttributesRetained)this.polygonAttributes.mirror : null;
        appearanceRetained.lineAttributes = this.lineAttributes != null ? (LineAttributesRetained)this.lineAttributes.mirror : null;
        appearanceRetained.pointAttributes = this.pointAttributes != null ? (PointAttributesRetained)this.pointAttributes.mirror : null;
    }

    synchronized void updateMirrorObject(int n, Object object) {
        AppearanceRetained appearanceRetained = (AppearanceRetained)this.mirror;
        if ((n & 1) != 0) {
            appearanceRetained.material = (MaterialRetained)object;
        } else if ((n & 2) != 0) {
            appearanceRetained.texture = (TextureRetained)object;
            if (appearanceRetained.texUnitState == null) {
                appearanceRetained.texUnitState = new TextureUnitStateRetained[1];
                appearanceRetained.texUnitState[0] = new TextureUnitStateRetained();
            }
            appearanceRetained.texUnitState[0].texture = (TextureRetained)object;
        } else if ((n & 4) != 0) {
            if (appearanceRetained.texUnitState == null) {
                appearanceRetained.texUnitState = new TextureUnitStateRetained[1];
                appearanceRetained.texUnitState[0] = new TextureUnitStateRetained();
            }
            appearanceRetained.texUnitState[0].texGen = (TexCoordGenerationRetained)object;
        } else if ((n & 8) != 0) {
            if (appearanceRetained.texUnitState == null) {
                appearanceRetained.texUnitState = new TextureUnitStateRetained[1];
                appearanceRetained.texUnitState[0] = new TextureUnitStateRetained();
            }
            appearanceRetained.texUnitState[0].texAttrs = (TextureAttributesRetained)object;
        } else if ((n & 0x400) != 0) {
            Object[] objectArray = (Object[])object;
            if (objectArray == null) {
                appearanceRetained.texUnitState = null;
            } else {
                int n2 = (Integer)objectArray[0];
                if (n2 == -1) {
                    appearanceRetained.texUnitState = (TextureUnitStateRetained[])objectArray[1];
                } else {
                    appearanceRetained.texUnitState[n2] = (TextureUnitStateRetained)objectArray[1];
                }
            }
        } else if ((n & 0x10) != 0) {
            appearanceRetained.coloringAttributes = (ColoringAttributesRetained)object;
        } else if ((n & 0x20) != 0) {
            appearanceRetained.transparencyAttributes = (TransparencyAttributesRetained)object;
        } else if ((n & 0x40) != 0) {
            appearanceRetained.renderingAttributes = (RenderingAttributesRetained)object;
        } else if ((n & 0x80) != 0) {
            appearanceRetained.polygonAttributes = (PolygonAttributesRetained)object;
        } else if ((n & 0x100) != 0) {
            appearanceRetained.lineAttributes = (LineAttributesRetained)object;
        } else if ((n & 0x200) != 0) {
            appearanceRetained.pointAttributes = (PointAttributesRetained)object;
        }
    }

    void setLive(boolean bl, int n) {
        this.doSetLive(bl, n);
        this.markAsLive();
    }

    void doSetLive(boolean bl, int n) {
        if (this.material != null) {
            this.material.setLive(bl, n);
        }
        if (this.texture != null) {
            this.texture.setLive(bl, n);
        }
        if (this.texCoordGeneration != null) {
            this.texCoordGeneration.setLive(bl, n);
        }
        if (this.textureAttributes != null) {
            this.textureAttributes.setLive(bl, n);
        }
        if (this.texUnitState != null) {
            for (int i = 0; i < this.texUnitState.length; ++i) {
                if (this.texUnitState[i] == null) continue;
                this.texUnitState[i].setLive(bl, n);
            }
        }
        if (this.coloringAttributes != null) {
            this.coloringAttributes.setLive(bl, n);
        }
        if (this.transparencyAttributes != null) {
            this.transparencyAttributes.setLive(bl, n);
        }
        if (this.renderingAttributes != null) {
            this.renderingAttributes.setLive(bl, n);
        }
        if (this.polygonAttributes != null) {
            this.polygonAttributes.setLive(bl, n);
        }
        if (this.lineAttributes != null) {
            this.lineAttributes.setLive(bl, n);
        }
        if (this.pointAttributes != null) {
            this.pointAttributes.setLive(bl, n);
        }
        super.doSetLive(bl, n);
    }

    void clearLive(int n) {
        super.clearLive(n);
        if (this.texture != null) {
            this.texture.clearLive(n);
        }
        if (this.texCoordGeneration != null) {
            this.texCoordGeneration.clearLive(n);
        }
        if (this.textureAttributes != null) {
            this.textureAttributes.clearLive(n);
        }
        if (this.texUnitState != null) {
            for (int i = 0; i < this.texUnitState.length; ++i) {
                if (this.texUnitState[i] == null) continue;
                this.texUnitState[i].clearLive(n);
            }
        }
        if (this.coloringAttributes != null) {
            this.coloringAttributes.clearLive(n);
        }
        if (this.transparencyAttributes != null) {
            this.transparencyAttributes.clearLive(n);
        }
        if (this.renderingAttributes != null) {
            this.renderingAttributes.clearLive(n);
        }
        if (this.polygonAttributes != null) {
            this.polygonAttributes.clearLive(n);
        }
        if (this.lineAttributes != null) {
            this.lineAttributes.clearLive(n);
        }
        if (this.pointAttributes != null) {
            this.pointAttributes.clearLive(n);
        }
        if (this.material != null) {
            this.material.clearLive(n);
        }
    }

    boolean isStatic() {
        boolean bl;
        boolean bl2 = bl = !(!this.source.capabilityBitsEmpty() || this.texture != null && !this.texture.source.capabilityBitsEmpty() || this.texCoordGeneration != null && !this.texCoordGeneration.source.capabilityBitsEmpty() || this.textureAttributes != null && !this.textureAttributes.source.capabilityBitsEmpty() || this.coloringAttributes != null && !this.coloringAttributes.source.capabilityBitsEmpty() || this.transparencyAttributes != null && !this.transparencyAttributes.source.capabilityBitsEmpty() || this.renderingAttributes != null && !this.renderingAttributes.source.capabilityBitsEmpty() || this.polygonAttributes != null && !this.polygonAttributes.source.capabilityBitsEmpty() || this.lineAttributes != null && !this.lineAttributes.source.capabilityBitsEmpty() || this.pointAttributes != null && !this.pointAttributes.source.capabilityBitsEmpty() || this.material != null && !this.material.source.capabilityBitsEmpty());
        if (!bl) {
            return bl;
        }
        if (this.texUnitState != null) {
            for (int i = 0; i < this.texUnitState.length && bl; ++i) {
                if (this.texUnitState[i] == null) continue;
                bl = bl && this.texUnitState[i].isStatic();
            }
        }
        return bl;
    }

    void compile(CompileState compileState) {
        this.setCompiled();
        if (this.texture != null) {
            this.texture.compile(compileState);
        }
        if (this.texCoordGeneration != null) {
            this.texCoordGeneration.compile(compileState);
        }
        if (this.textureAttributes != null) {
            this.textureAttributes.compile(compileState);
        }
        if (this.texUnitState != null) {
            for (int i = 0; i < this.texUnitState.length; ++i) {
                if (this.texUnitState[i] == null) continue;
                this.texUnitState[i].compile(compileState);
            }
        }
        if (this.coloringAttributes != null) {
            this.coloringAttributes.compile(compileState);
        }
        if (this.transparencyAttributes != null) {
            this.transparencyAttributes.compile(compileState);
        }
        if (this.renderingAttributes != null) {
            this.renderingAttributes.compile(compileState);
        }
        if (this.polygonAttributes != null) {
            this.polygonAttributes.compile(compileState);
        }
        if (this.lineAttributes != null) {
            this.lineAttributes.compile(compileState);
        }
        if (this.pointAttributes != null) {
            this.pointAttributes.compile(compileState);
        }
        if (this.material != null) {
            this.material.compile(compileState);
        }
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof AppearanceRetained && this.equals((AppearanceRetained)object);
    }

    boolean equals(AppearanceRetained appearanceRetained) {
        boolean bl;
        boolean bl2 = bl = appearanceRetained == this || appearanceRetained != null && (this.material == appearanceRetained.material || this.material != null && this.material.equivalent(appearanceRetained.material)) && (this.texture == appearanceRetained.texture || this.texture != null && this.texture.equals(appearanceRetained.texture)) && (this.renderingAttributes == appearanceRetained.renderingAttributes || this.renderingAttributes != null && this.renderingAttributes.equivalent(appearanceRetained.renderingAttributes)) && (this.polygonAttributes == appearanceRetained.polygonAttributes || this.polygonAttributes != null && this.polygonAttributes.equivalent(appearanceRetained.polygonAttributes)) && (this.texCoordGeneration == appearanceRetained.texCoordGeneration || this.texCoordGeneration != null && this.texCoordGeneration.equivalent(appearanceRetained.texCoordGeneration)) && (this.textureAttributes == appearanceRetained.textureAttributes || this.textureAttributes != null && this.textureAttributes.equivalent(appearanceRetained.textureAttributes)) && (this.coloringAttributes == appearanceRetained.coloringAttributes || this.coloringAttributes != null && this.coloringAttributes.equivalent(appearanceRetained.coloringAttributes)) && (this.transparencyAttributes == appearanceRetained.transparencyAttributes || this.transparencyAttributes != null && this.transparencyAttributes.equivalent(appearanceRetained.transparencyAttributes)) && (this.lineAttributes == appearanceRetained.lineAttributes || this.lineAttributes != null && this.lineAttributes.equivalent(appearanceRetained.lineAttributes)) && (this.pointAttributes == appearanceRetained.pointAttributes || this.pointAttributes != null && this.pointAttributes.equivalent(appearanceRetained.pointAttributes));
        if (!bl) {
            return bl;
        }
        if (this.texUnitState == appearanceRetained.texUnitState) {
            return bl;
        }
        if (this.texUnitState == null || appearanceRetained.texUnitState == null || this.texUnitState.length != appearanceRetained.texUnitState.length) {
            return false;
        }
        for (int i = 0; i < this.texUnitState.length; ++i) {
            if (this.texUnitState[i] == appearanceRetained.texUnitState[i] || this.texUnitState[i] != null && appearanceRetained.texUnitState[i] != null && this.texUnitState[i].equals(appearanceRetained.texUnitState[i])) continue;
            return false;
        }
        return true;
    }

    synchronized void addAMirrorUser(Shape3DRetained shape3DRetained) {
        super.addAMirrorUser(shape3DRetained);
        if (this.material != null) {
            this.material.addAMirrorUser(shape3DRetained);
        }
        if (this.texture != null) {
            this.texture.addAMirrorUser(shape3DRetained);
        }
        if (this.texCoordGeneration != null) {
            this.texCoordGeneration.addAMirrorUser(shape3DRetained);
        }
        if (this.textureAttributes != null) {
            this.textureAttributes.addAMirrorUser(shape3DRetained);
        }
        if (this.texUnitState != null) {
            for (int i = 0; i < this.texUnitState.length; ++i) {
                if (this.texUnitState[i] == null) continue;
                this.texUnitState[i].addAMirrorUser(shape3DRetained);
            }
        }
        if (this.coloringAttributes != null) {
            this.coloringAttributes.addAMirrorUser(shape3DRetained);
        }
        if (this.transparencyAttributes != null) {
            this.transparencyAttributes.addAMirrorUser(shape3DRetained);
        }
        if (this.renderingAttributes != null) {
            this.renderingAttributes.addAMirrorUser(shape3DRetained);
        }
        if (this.polygonAttributes != null) {
            this.polygonAttributes.addAMirrorUser(shape3DRetained);
        }
        if (this.lineAttributes != null) {
            this.lineAttributes.addAMirrorUser(shape3DRetained);
        }
        if (this.pointAttributes != null) {
            this.pointAttributes.addAMirrorUser(shape3DRetained);
        }
    }

    synchronized void removeAMirrorUser(Shape3DRetained shape3DRetained) {
        super.removeAMirrorUser(shape3DRetained);
        if (this.material != null) {
            this.material.removeAMirrorUser(shape3DRetained);
        }
        if (this.texture != null) {
            this.texture.removeAMirrorUser(shape3DRetained);
        }
        if (this.texCoordGeneration != null) {
            this.texCoordGeneration.removeAMirrorUser(shape3DRetained);
        }
        if (this.textureAttributes != null) {
            this.textureAttributes.removeAMirrorUser(shape3DRetained);
        }
        if (this.texUnitState != null) {
            for (int i = 0; i < this.texUnitState.length; ++i) {
                if (this.texUnitState[i] == null) continue;
                this.texUnitState[i].removeAMirrorUser(shape3DRetained);
            }
        }
        if (this.coloringAttributes != null) {
            this.coloringAttributes.removeAMirrorUser(shape3DRetained);
        }
        if (this.transparencyAttributes != null) {
            this.transparencyAttributes.removeAMirrorUser(shape3DRetained);
        }
        if (this.renderingAttributes != null) {
            this.renderingAttributes.removeAMirrorUser(shape3DRetained);
        }
        if (this.polygonAttributes != null) {
            this.polygonAttributes.removeAMirrorUser(shape3DRetained);
        }
        if (this.lineAttributes != null) {
            this.lineAttributes.removeAMirrorUser(shape3DRetained);
        }
        if (this.pointAttributes != null) {
            this.pointAttributes.removeAMirrorUser(shape3DRetained);
        }
    }

    final void sendMessage(int n, Object object, boolean bl) {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = Shape3DRetained.getGeomAtomsList(this.mirror.users, arrayList);
        J3dMessage j3dMessage = new J3dMessage();
        j3dMessage.threads = 1024;
        j3dMessage.type = 18;
        j3dMessage.universe = null;
        j3dMessage.args[0] = this;
        j3dMessage.args[1] = new Integer(n);
        j3dMessage.args[2] = object;
        j3dMessage.args[3] = new Integer(this.changedFrequent);
        VirtualUniverse.mc.processMessage(j3dMessage);
        for (int i = 0; i < arrayList.size(); ++i) {
            j3dMessage = new J3dMessage();
            j3dMessage.threads = 128;
            j3dMessage.type = 18;
            j3dMessage.universe = (VirtualUniverse)arrayList.get(i);
            j3dMessage.args[0] = this;
            j3dMessage.args[1] = new Integer(n);
            j3dMessage.args[2] = object;
            ArrayList arrayList3 = (ArrayList)arrayList2.get(i);
            GeometryAtom[] geometryAtomArray = new GeometryAtom[arrayList3.size()];
            arrayList3.toArray(geometryAtomArray);
            j3dMessage.args[3] = geometryAtomArray;
            if (n == 64) {
                j3dMessage.args[4] = object != null ? (bl ? Boolean.TRUE : Boolean.FALSE) : Boolean.TRUE;
            }
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
    }

    final void sendRenderingAttributesChangedMessage(boolean bl) {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = Shape3DRetained.getGeomAtomsList(this.mirror.users, arrayList);
        for (int i = 0; i < arrayList.size(); ++i) {
            J3dMessage j3dMessage = new J3dMessage();
            j3dMessage.threads = 64;
            j3dMessage.type = 10;
            j3dMessage.universe = (VirtualUniverse)arrayList.get(i);
            j3dMessage.args[0] = this;
            j3dMessage.args[1] = null;
            j3dMessage.args[2] = bl ? Boolean.TRUE : Boolean.FALSE;
            ArrayList arrayList3 = (ArrayList)arrayList2.get(i);
            GeometryAtom[] geometryAtomArray = new GeometryAtom[arrayList3.size()];
            arrayList3.toArray(geometryAtomArray);
            j3dMessage.args[3] = geometryAtomArray;
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
    }

    boolean isOpaque(int n) {
        TransparencyAttributesRetained transparencyAttributesRetained = this.transparencyAttributes;
        if (transparencyAttributesRetained != null && transparencyAttributesRetained.transparencyMode != 4 && (VirtualUniverse.mc.isD3D() || !VirtualUniverse.mc.isD3D() && transparencyAttributesRetained.transparencyMode != 3)) {
            return false;
        }
        switch (n) {
            case 3: 
            case 10: {
                if (this.pointAttributes == null || !this.pointAttributes.pointAntialiasing) break;
                return false;
            }
            case 4: 
            case 7: 
            case 11: 
            case 14: {
                if (this.lineAttributes == null || !this.lineAttributes.lineAntialiasing) break;
                return false;
            }
            case 15: 
            case 17: {
                break;
            }
            default: {
                if (this.polygonAttributes == null) break;
                if (this.polygonAttributes.polygonMode == 0 && this.pointAttributes != null && this.pointAttributes.pointAntialiasing) {
                    return false;
                }
                if (this.polygonAttributes.polygonMode != 1 || this.lineAttributes == null || !this.lineAttributes.lineAntialiasing) break;
                return false;
            }
        }
        return true;
    }

    void handleFrequencyChange(int n) {
        int n2 = 0;
        if (n == 9) {
            n2 = 16;
        } else if (n == 11) {
            n2 = 32;
        } else if (n == 13) {
            n2 = 64;
        } else if (n == 15) {
            n2 = 128;
        } else if (n == 17) {
            n2 = 256;
        } else if (n == 19) {
            n2 = 512;
        } else if (n == 1) {
            n2 = 1;
        } else if (n == 3) {
            n2 = 2;
        } else if (n == 7) {
            n2 = 8;
        } else if (n == 5) {
            n2 = 4;
        } else if (n == 21) {
            n2 = 1024;
        }
        if (n2 != 0) {
            this.setFrequencyChangeMask(n, n2);
        }
    }
}

