/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.server.system;

import java.lang.management.ManagementFactory;
import javax.management.JMRuntimeException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

public class Timers {
    private static MBeanServerConnection conn;
    private static final String PROCESS_CPU_TIME_ATTR = "ProcessCpuTime";
    private static final String PROCESSING_CAPACITY_ATTR = "ProcessingCapacity";
    private static ObjectName osName;
    private static long processCPUTimeMultiplier;
    private static int processorsCount;
    private static boolean processCPUTimeAttribute;
    private static boolean initialized;

    public static long getCurrentTimeInCounts() {
        return System.nanoTime();
    }

    public static long getNoOfCountsInSecond() {
        return 1000000000L;
    }

    public static native long getThreadCPUTimeInNanos();

    public static long getProcessCpuTime() {
        Timers.initializeProcessCPUTime();
        if (processCPUTimeAttribute) {
            try {
                Long l = (Long)conn.getAttribute(osName, PROCESS_CPU_TIME_ATTR);
                return l * processCPUTimeMultiplier / (long)processorsCount;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return -1L;
    }

    public static native void enableMicrostateAccounting(boolean var0);

    public static void initialize() {
        ManagementFactory.getThreadMXBean();
        Timers.getThreadCPUTimeInNanos();
        Timers.initializeProcessCPUTime();
    }

    private static void initializeProcessCPUTime() {
        if (initialized) {
            return;
        }
        initialized = true;
        try {
            conn = ManagementFactory.getPlatformMBeanServer();
            osName = new ObjectName("java.lang:type=OperatingSystem");
            MBeanAttributeInfo[] mBeanAttributeInfoArray = conn.getMBeanInfo(osName).getAttributes();
            processCPUTimeMultiplier = 1L;
            processorsCount = ManagementFactory.getOperatingSystemMXBean().getAvailableProcessors();
            for (int i = 0; i < mBeanAttributeInfoArray.length; ++i) {
                String string = mBeanAttributeInfoArray[i].getName();
                if (PROCESS_CPU_TIME_ATTR.equals(string)) {
                    processCPUTimeAttribute = true;
                }
                if (!PROCESSING_CAPACITY_ATTR.equals(string)) continue;
                Number number = (Number)conn.getAttribute(osName, PROCESSING_CAPACITY_ATTR);
                processCPUTimeMultiplier = number.longValue();
            }
        }
        catch (JMRuntimeException jMRuntimeException) {
            System.err.println(jMRuntimeException.getLocalizedMessage());
            initialized = false;
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static native void osSleep(int var0);
}

