/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.Objects;
import java.util.Set;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.lookup.PainlessLookupUtility;
import org.elasticsearch.painless.lookup.PainlessMethod;
import org.elasticsearch.painless.node.AExpression;
import org.elasticsearch.painless.node.AStoreable;

final class PSubMapShortcut
extends AStoreable {
    private final Class<?> targetClass;
    private AExpression index;
    private PainlessMethod getter;
    private PainlessMethod setter;

    PSubMapShortcut(Location location, Class<?> targetClass, AExpression index) {
        super(location);
        this.targetClass = Objects.requireNonNull(targetClass);
        this.index = Objects.requireNonNull(index);
    }

    @Override
    void extractVariables(Set<String> variables) {
        throw this.createError(new IllegalStateException("Illegal tree structure."));
    }

    @Override
    void analyze(Locals locals) {
        String canonicalClassName = PainlessLookupUtility.typeToCanonicalTypeName(this.targetClass);
        this.getter = locals.getPainlessLookup().lookupPainlessMethod(this.targetClass, false, "get", 1);
        this.setter = locals.getPainlessLookup().lookupPainlessMethod(this.targetClass, false, "put", 2);
        if (this.getter != null && (this.getter.returnType == Void.TYPE || this.getter.typeParameters.size() != 1)) {
            throw this.createError(new IllegalArgumentException("Illegal map get shortcut for type [" + canonicalClassName + "]."));
        }
        if (this.setter != null && this.setter.typeParameters.size() != 2) {
            throw this.createError(new IllegalArgumentException("Illegal map set shortcut for type [" + canonicalClassName + "]."));
        }
        if (!(this.getter == null || this.setter == null || this.getter.typeParameters.get(0).equals(this.setter.typeParameters.get(0)) && this.getter.returnType.equals(this.setter.typeParameters.get(1)))) {
            throw this.createError(new IllegalArgumentException("Shortcut argument types must match."));
        }
        if (!this.read && !this.write || this.read && this.getter == null || this.write && this.setter == null) {
            throw this.createError(new IllegalArgumentException("Illegal map shortcut for type [" + canonicalClassName + "]."));
        }
        this.index.expected = this.setter != null ? this.setter.typeParameters.get(0) : this.getter.typeParameters.get(0);
        this.index.analyze(locals);
        this.index = this.index.cast(locals);
        this.actual = this.setter != null ? this.setter.typeParameters.get(1) : this.getter.returnType;
    }

    @Override
    void write(MethodWriter writer, Globals globals) {
        this.index.write(writer, globals);
        writer.writeDebugInfo(this.location);
        writer.invokeMethodCall(this.getter);
        if (this.getter.returnType != this.getter.javaMethod.getReturnType()) {
            writer.checkCast(MethodWriter.getType(this.getter.returnType));
        }
    }

    @Override
    int accessElementCount() {
        return 2;
    }

    @Override
    boolean isDefOptimized() {
        return false;
    }

    @Override
    void updateActual(Class<?> actual) {
        throw new IllegalArgumentException("Illegal tree structure.");
    }

    @Override
    void setup(MethodWriter writer, Globals globals) {
        this.index.write(writer, globals);
    }

    @Override
    void load(MethodWriter writer, Globals globals) {
        writer.writeDebugInfo(this.location);
        writer.invokeMethodCall(this.getter);
        if (this.getter.returnType != this.getter.javaMethod.getReturnType()) {
            writer.checkCast(MethodWriter.getType(this.getter.returnType));
        }
    }

    @Override
    void store(MethodWriter writer, Globals globals) {
        writer.writeDebugInfo(this.location);
        writer.invokeMethodCall(this.setter);
        writer.writePop(MethodWriter.getType(this.setter.returnType).getSize());
    }

    @Override
    public String toString() {
        return this.singleLineToString(this.prefix, this.index);
    }
}

