/***********************************************************************
*                                                                      *
* This file is part of CARAT.                                          *
* Copyright (C) 2015  Tilman Schulz                                    *
*                                                                      *
* CARAT is free software: you can redistribute it and/or modify        *
* it under the terms of the GNU General Public License as published by *
* the Free Software Foundation, either version 3 of the License, or    *
* (at your option) any later version.                                  *
*                                                                      *
* This program is distributed in the hope that it will be useful,      *
* but WITHOUT ANY WARRANTY; without even the implied warranty of       *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
* GNU General Public License for more details.                         *
*                                                                      *
* You should have received a copy of the GNU General Public License    *
* along with this program.  If not, see <http://www.gnu.org/licenses/> *
*                                                                      *
***********************************************************************/
#include"typedef.h"


main (int argc, char *argv[])
{

	matrix_TYP **Mat, **V;
        bravais_TYP *G;
        int V_anz, Mat_anz;
        int i,j;

        extern char **FILENAMES;
        extern int FILEANZ;

	extern matrix_TYP **mget_mat();
	extern bravais_TYP *get_bravais();
        extern matrix_TYP **voronoi_vertices();
	extern void put_mat ();

        read_header(argc, argv);
        if(FILEANZ != 2)
	{
          printf("usage:  Vor_vertices 'file1' 'file2',\n");
          printf("where 'file1' containes a G-invariant positive definite, symmetric matrix and\n");
          printf("      'file2' containes a group G, given as bravais_TYP\n");
          if (is_option('h')){
             exit(0);
          }
          else{
             exit(31);
          }
	}
	Mat = mget_mat (FILENAMES[0], &Mat_anz);
        G = get_bravais(FILENAMES[1]);
        for(i=0;i<Mat_anz;i++)
        {
           V = voronoi_vertices(Mat[i], G, &V_anz, &j);
           printf("#%d\n", V_anz);
           for(j=0;j<V_anz;j++)
           {
             put_mat(V[j], NULL, "", 0);
             free_mat(V[j]);
           }
           free(V);
        }

   exit(0);
}
