/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.instantiation;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import org.gradle.api.reflect.ObjectInstantiationException;
import org.gradle.internal.instantiation.ClassGenerator;
import org.gradle.internal.instantiation.ConstructorSelector;
import org.gradle.internal.instantiation.InstanceFactory;
import org.gradle.internal.logging.text.TreeFormatter;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.reflect.JavaReflectionUtil;
import org.gradle.internal.service.DefaultServiceRegistry;
import org.gradle.internal.service.ServiceLookup;

class DependencyInjectingInstantiator
implements Instantiator {
    private static final DefaultServiceRegistry NO_SERVICES = new DefaultServiceRegistry();
    private final ServiceLookup services;
    private final ConstructorSelector constructorSelector;

    public DependencyInjectingInstantiator(ConstructorSelector constructorSelector, ServiceLookup services) {
        this.services = services;
        this.constructorSelector = constructorSelector;
    }

    public <T> T newInstance(Class<? extends T> type, Object ... parameters) {
        try {
            ClassGenerator.GeneratedConstructor<T> constructor = this.constructorSelector.forParams(type, parameters);
            Object[] resolvedParameters = this.convertParameters(type, constructor, this.services, parameters);
            try {
                return constructor.newInstance(this.services, this, resolvedParameters);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }
        catch (Throwable t) {
            throw new ObjectInstantiationException(type, t);
        }
    }

    public <T> InstanceFactory<T> factoryFor(final Class<T> type) {
        final ClassGenerator.GeneratedConstructor<T> constructor = this.constructorSelector.forType(type);
        return new InstanceFactory<T>(){

            @Override
            public boolean requiresService(Class<?> serviceType) {
                return constructor.requiresService(serviceType);
            }

            @Override
            public T newInstance(ServiceLookup services, Object ... parameters) {
                try {
                    Object[] resolvedParameters = DependencyInjectingInstantiator.this.convertParameters(type, constructor, services, parameters);
                    try {
                        return constructor.newInstance(services, DependencyInjectingInstantiator.this, resolvedParameters);
                    }
                    catch (InvocationTargetException e) {
                        throw e.getCause();
                    }
                }
                catch (Throwable t) {
                    throw new ObjectInstantiationException(type, t);
                }
            }

            @Override
            public T newInstance(Object ... params) {
                return this.newInstance((ServiceLookup)NO_SERVICES, params);
            }
        };
    }

    private Object[] convertParameters(Class<?> type, ClassGenerator.GeneratedConstructor<?> constructor, ServiceLookup services, Object[] parameters) {
        this.constructorSelector.vetoParameters(constructor, parameters);
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        if (parameterTypes.length < parameters.length) {
            TreeFormatter formatter = new TreeFormatter();
            formatter.node("Too many parameters provided for constructor for ");
            formatter.appendType(type);
            formatter.append((CharSequence)String.format(". Expected %s, received %s.", parameterTypes.length, parameters.length));
            throw new IllegalArgumentException(formatter.toString());
        }
        if (parameterTypes.length == parameters.length) {
            return this.verifyParameters(constructor, parameters);
        }
        return this.addServicesToParameters(type, constructor, services, parameters);
    }

    private Object[] verifyParameters(ClassGenerator.GeneratedConstructor<?> constructor, Object[] parameters) {
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class targetType = parameterTypes[i];
            Object currentParameter = parameters[i];
            if (targetType.isPrimitive()) {
                if (currentParameter == null) {
                    this.nullPrimitiveType(i, targetType);
                }
                targetType = JavaReflectionUtil.getWrapperTypeForPrimitiveType(targetType);
            } else if (currentParameter == null) continue;
            if (targetType.isInstance(currentParameter)) continue;
            TreeFormatter formatter = new TreeFormatter();
            formatter.node("Unable to determine constructor argument #" + (i + 1) + ": value ");
            formatter.appendValue(currentParameter);
            formatter.append((CharSequence)" not assignable to ");
            formatter.appendType(parameterTypes[i]);
            throw new IllegalArgumentException(formatter.toString());
        }
        return parameters;
    }

    private void nullPrimitiveType(int index, Class<?> paramType) {
        TreeFormatter formatter = new TreeFormatter();
        formatter.node("Unable to determine constructor argument #" + (index + 1) + ": null value is not assignable to ");
        formatter.appendType(paramType);
        throw new IllegalArgumentException(formatter.toString());
    }

    private Object[] addServicesToParameters(Class<?> type, ClassGenerator.GeneratedConstructor<?> constructor, ServiceLookup services, Object[] parameters) {
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        Type[] genericTypes = constructor.getGenericParameterTypes();
        Object[] resolvedParameters = new Object[parameterTypes.length];
        int pos = 0;
        for (int i = 0; i < resolvedParameters.length; ++i) {
            Object service;
            Class targetType = parameterTypes[i];
            Type serviceType = genericTypes[i];
            if (pos < parameters.length) {
                Object parameter = parameters[pos];
                if (targetType.isPrimitive()) {
                    if (parameter == null) {
                        this.nullPrimitiveType(i, targetType);
                    }
                    targetType = JavaReflectionUtil.getWrapperTypeForPrimitiveType(targetType);
                }
                if (parameter == null || targetType.isInstance(parameter)) {
                    resolvedParameters[i] = parameter;
                    ++pos;
                    continue;
                }
            }
            if ((service = services.find(serviceType)) != null) {
                resolvedParameters[i] = service;
                continue;
            }
            TreeFormatter formatter = new TreeFormatter();
            formatter.node("Unable to determine constructor argument #" + (i + 1) + ": ");
            if (pos < parameters.length) {
                formatter.append((CharSequence)"value ");
                formatter.appendValue(parameters[pos]);
                formatter.append((CharSequence)" is not assignable to ");
                formatter.appendType(parameterTypes[i]);
            } else {
                formatter.append((CharSequence)"missing parameter of ");
                formatter.appendType(parameterTypes[i]);
            }
            formatter.append((CharSequence)", or no service of type ");
            formatter.append((CharSequence)serviceType.toString());
            throw new IllegalArgumentException(formatter.toString());
        }
        if (pos != parameters.length) {
            TreeFormatter formatter = new TreeFormatter();
            formatter.node("Unexpected parameter provided for constructor for ");
            formatter.appendType(type);
            throw new IllegalArgumentException(formatter.toString());
        }
        return resolvedParameters;
    }
}

