/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve;

import java.util.List;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyGetterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.VariableDescriptor;
import kotlin.reflect.jvm.internal.impl.incremental.components.NoLookupLocation;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InlineClassesUtilsKt {
    @Nullable
    public static final ValueParameterDescriptor underlyingRepresentation(@NotNull ClassDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        if (!$receiver.isInline()) {
            return null;
        }
        Object object = $receiver.getUnsubstitutedPrimaryConstructor();
        return object != null && (object = object.getValueParameters()) != null ? (ValueParameterDescriptor)CollectionsKt.singleOrNull((List)object) : null;
    }

    public static final boolean isInlineClass(@NotNull DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return $receiver instanceof ClassDescriptor && ((ClassDescriptor)$receiver).isInline();
    }

    @Nullable
    public static final ValueParameterDescriptor unsubstitutedUnderlyingParameter(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        ClassifierDescriptor $receiver$iv = $receiver.getConstructor().getDeclarationDescriptor();
        ClassifierDescriptor classifierDescriptor = $receiver$iv;
        if (!(classifierDescriptor instanceof ClassDescriptor)) {
            classifierDescriptor = null;
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)classifierDescriptor;
        return classDescriptor != null ? InlineClassesUtilsKt.underlyingRepresentation(classDescriptor) : null;
    }

    public static final boolean isInlineClassType(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        ClassifierDescriptor classifierDescriptor = $receiver.getConstructor().getDeclarationDescriptor();
        return classifierDescriptor != null ? InlineClassesUtilsKt.isInlineClass(classifierDescriptor) : false;
    }

    @Nullable
    public static final KotlinType substitutedUnderlyingType(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        ValueParameterDescriptor valueParameterDescriptor = InlineClassesUtilsKt.unsubstitutedUnderlyingParameter($receiver);
        if (valueParameterDescriptor == null) {
            return null;
        }
        ValueParameterDescriptor parameter = valueParameterDescriptor;
        MemberScope memberScope2 = $receiver.getMemberScope();
        Name name = parameter.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"parameter.name");
        PropertyDescriptor propertyDescriptor = (PropertyDescriptor)CollectionsKt.singleOrNull((Iterable)memberScope2.getContributedVariables(name, NoLookupLocation.FOR_ALREADY_TRACKED));
        return propertyDescriptor != null ? propertyDescriptor.getType() : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isGetterOfUnderlyingPropertyOfInlineClass(@NotNull CallableDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        if (!($receiver instanceof PropertyGetterDescriptor)) return false;
        PropertyDescriptor propertyDescriptor = ((PropertyGetterDescriptor)$receiver).getCorrespondingProperty();
        Intrinsics.checkExpressionValueIsNotNull((Object)propertyDescriptor, (String)"correspondingProperty");
        if (!InlineClassesUtilsKt.isUnderlyingPropertyOfInlineClass(propertyDescriptor)) return false;
        return true;
    }

    public static final boolean isUnderlyingPropertyOfInlineClass(@NotNull VariableDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        DeclarationDescriptor declarationDescriptor = $receiver.getContainingDeclaration();
        Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"this.containingDeclaration");
        DeclarationDescriptor containingDeclaration = declarationDescriptor;
        if (!InlineClassesUtilsKt.isInlineClass(containingDeclaration)) {
            return false;
        }
        DeclarationDescriptor declarationDescriptor2 = containingDeclaration;
        if (declarationDescriptor2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
        }
        ValueParameterDescriptor valueParameterDescriptor = InlineClassesUtilsKt.underlyingRepresentation((ClassDescriptor)declarationDescriptor2);
        return Intrinsics.areEqual((Object)(valueParameterDescriptor != null ? valueParameterDescriptor.getName() : null), (Object)$receiver.getName());
    }
}

