/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.asJava.elements;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.asJava.elements.KtLightAbstractAnnotation;
import org.jetbrains.kotlin.asJava.elements.KtLightDeclaration;
import org.jetbrains.kotlin.asJava.elements.KtLightMethod;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotation;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameterListOwner;
import org.jetbrains.kotlin.com.intellij.psi.impl.light.AbstractLightClass;
import org.jetbrains.kotlin.com.intellij.psi.search.SearchScope;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;

public class KtLightTypeParameter
extends AbstractLightClass
implements PsiTypeParameter,
KtLightDeclaration<KtTypeParameter, PsiTypeParameter> {
    private final PsiTypeParameterListOwner owner;
    private final int index;
    private final String name;

    public KtLightTypeParameter(@NotNull PsiTypeParameterListOwner owner, int index2, @NotNull String name) {
        super(owner.getManager(), KotlinLanguage.INSTANCE);
        this.owner = owner;
        this.index = index2;
        this.name = name;
    }

    @Override
    @NotNull
    public PsiTypeParameter getClsDelegate() {
        return this.getOwnerDelegate().getTypeParameters()[this.index];
    }

    @Override
    @NotNull
    public PsiClass getDelegate() {
        return this.getClsDelegate();
    }

    @Override
    @NotNull
    public KtTypeParameter getKotlinOrigin() {
        KtTypeParameterListOwner jetOwner = (KtTypeParameterListOwner)LightClassUtilsKt.getUnwrapped(this.owner);
        assert (jetOwner != null) : "Invalid type parameter owner: " + this.owner;
        return jetOwner.getTypeParameters().get(this.index);
    }

    @NotNull
    private PsiTypeParameterListOwner getOwnerDelegate() {
        if (this.owner instanceof KtLightClass) {
            return (PsiTypeParameterListOwner)((KtLightClass)this.owner).getClsDelegate();
        }
        if (this.owner instanceof KtLightMethod) {
            return (PsiTypeParameterListOwner)((KtLightMethod)this.owner).getClsDelegate();
        }
        return this.owner;
    }

    @Override
    @NotNull
    public PsiElement copy() {
        return new KtLightTypeParameter(this.owner, this.index, this.name);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitTypeParameter(this);
        } else {
            super.accept(visitor2);
        }
    }

    @Override
    public String getText() {
        return "";
    }

    @Override
    @Nullable
    public String getName() {
        return this.name;
    }

    @Override
    public PsiTypeParameterListOwner getOwner() {
        return this.owner;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    @NotNull
    public PsiAnnotation[] getAnnotations() {
        return this.getClsDelegate().getAnnotations();
    }

    @Override
    @NotNull
    public PsiAnnotation[] getApplicableAnnotations() {
        return this.getClsDelegate().getApplicableAnnotations();
    }

    @Override
    public PsiAnnotation findAnnotation(@NotNull String qualifiedName) {
        return this.getClsDelegate().findAnnotation(qualifiedName);
    }

    @Override
    @NotNull
    public PsiAnnotation addAnnotation(@NotNull String qualifiedName) {
        return this.getClsDelegate().addAnnotation(qualifiedName);
    }

    @Override
    public String toString() {
        return "KotlinLightTypeParameter:" + this.getName();
    }

    @Override
    @NotNull
    public PsiElement getNavigationElement() {
        return this.getKotlinOrigin();
    }

    @Override
    @NotNull
    public Language getLanguage() {
        return KotlinLanguage.INSTANCE;
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        return this.getKotlinOrigin().getUseScope();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return obj instanceof KtLightTypeParameter && this.getKotlinOrigin().equals(((KtLightTypeParameter)obj).getKotlinOrigin());
    }

    @Override
    public boolean isEquivalentTo(PsiElement another) {
        if (another instanceof PsiTypeParameter) {
            PsiTypeParameter anotherTypeParameter = (PsiTypeParameter)another;
            PsiTypeParameterListOwner owner = this.getOwner();
            if (owner != null) {
                return owner.isEquivalentTo(anotherTypeParameter.getOwner()) && this.getIndex() == anotherTypeParameter.getIndex();
            }
        }
        return false;
    }

    @Override
    @Nullable
    public List<KtLightAbstractAnnotation> getGivenAnnotations() {
        return null;
    }
}

