/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.core.primitive;

import org.sunflow.SunflowAPI;
import org.sunflow.core.Instance;
import org.sunflow.core.IntersectionState;
import org.sunflow.core.ParameterList;
import org.sunflow.core.PrimitiveList;
import org.sunflow.core.Ray;
import org.sunflow.core.ShadingState;
import org.sunflow.math.BoundingBox;
import org.sunflow.math.Matrix4;
import org.sunflow.math.OrthoNormalBasis;
import org.sunflow.math.Point3;
import org.sunflow.math.Solvers;
import org.sunflow.math.Vector3;

public class JuliaFractal
implements PrimitiveList {
    private static float BOUNDING_RADIUS = (float)Math.sqrt(3.0);
    private static float BOUNDING_RADIUS2 = 3.0f;
    private static float ESCAPE_THRESHOLD = 10.0f;
    private static float DELTA = 1.0E-4f;
    private float cx = 0.2f;
    private float cy = 0.3f;
    private float cz = -0.2f;
    private float cw = -0.4f;
    private int maxIterations = 15;
    private float epsilon = 1.0E-5f;

    public int getNumPrimitives() {
        return 1;
    }

    public float getPrimitiveBound(int n, int n2) {
        return (n2 & 1) == 0 ? -BOUNDING_RADIUS : BOUNDING_RADIUS;
    }

    public BoundingBox getWorldBounds(Matrix4 matrix4) {
        BoundingBox boundingBox = new BoundingBox(BOUNDING_RADIUS);
        if (matrix4 != null) {
            boundingBox = matrix4.transform(boundingBox);
        }
        return boundingBox;
    }

    public void intersectPrimitive(Ray ray, int n, IntersectionState intersectionState) {
        float f;
        float f2;
        float f3;
        block6: {
            float f4;
            float f5 = ray.ox * ray.ox + ray.oy * ray.oy + ray.oz * ray.oz - BOUNDING_RADIUS2;
            f3 = ray.getMin();
            if (f5 > 0.0f) {
                f2 = ray.dx * ray.dx + ray.dy * ray.dy + ray.dz * ray.dz;
                f4 = 2.0f * (ray.dx * ray.ox + ray.dy * ray.oy + ray.dz * ray.oz);
                double[] dArray = Solvers.solveQuadric(f2, f4, f5);
                if (dArray == null || dArray[0] >= (double)ray.getMax() || dArray[1] <= (double)ray.getMin()) {
                    return;
                }
                f3 = (float)dArray[0];
            }
            f2 = Float.POSITIVE_INFINITY;
            f4 = ray.ox + f3 * ray.dx;
            float f6 = ray.oy + f3 * ray.dy;
            float f7 = ray.oz + f3 * ray.dz;
            f = (float)(1.0 / Math.sqrt(ray.dx * ray.dx + ray.dy * ray.dy + ray.dz * ray.dz));
            do {
                float f8 = f4;
                float f9 = f6;
                float f10 = f7;
                float f11 = 0.0f;
                float f12 = 1.0f;
                float f13 = 0.0f;
                float f14 = 0.0f;
                float f15 = 0.0f;
                float f16 = 0.0f;
                for (int i = 0; i < this.maxIterations; ++i) {
                    float f17 = f8 * f12 - f9 * f13 - f10 * f14 - f11 * f15;
                    float f18 = f8 * f13 + f9 * f12 + f10 * f15 - f11 * f14;
                    float f19 = f8 * f14 + f10 * f12 + f11 * f13 - f9 * f15;
                    f15 = 2.0f * (f8 * f15 + f11 * f12 + f9 * f14 - f10 * f13);
                    f12 = 2.0f * f17;
                    f13 = 2.0f * f18;
                    f14 = 2.0f * f19;
                    f17 = f8 * f8 - f9 * f9 - f10 * f10 - f11 * f11 + this.cw;
                    f16 = (f8 = f17) * f8 + (f9 = 2.0f * f8 * f9 + this.cx) * f9 + (f10 = 2.0f * f8 * f10 + this.cy) * f10 + (f11 = 2.0f * f8 * f11 + this.cz) * f11;
                    if (f16 > ESCAPE_THRESHOLD) break;
                }
                float f20 = (float)Math.sqrt(f16);
                f2 = 0.5f * f20 * (float)Math.log(f20) / JuliaFractal.length(f12, f13, f14, f15);
                f4 += f2 * ray.dx;
                f6 += f2 * ray.dy;
                f7 += f2 * ray.dz;
                f3 += f2;
                if (f2 * f < this.epsilon) break block6;
            } while (!(f4 * f4 + f6 * f6 + f7 * f7 > BOUNDING_RADIUS2));
            return;
        }
        if (!ray.isInside(f3)) {
            return;
        }
        if (f2 * f < this.epsilon) {
            ray.setMax(f3);
            intersectionState.setIntersection(0);
        }
    }

    public void prepareShadingState(ShadingState shadingState) {
        float f;
        shadingState.init();
        shadingState.getRay().getPoint(shadingState.getPoint());
        Instance instance = shadingState.getInstance();
        Point3 point3 = shadingState.transformWorldToObject(shadingState.getPoint());
        float f2 = point3.x - DELTA;
        float f3 = point3.y;
        float f4 = point3.z;
        float f5 = 0.0f;
        float f6 = point3.x + DELTA;
        float f7 = point3.y;
        float f8 = point3.z;
        float f9 = 0.0f;
        float f10 = point3.x;
        float f11 = point3.y - DELTA;
        float f12 = point3.z;
        float f13 = 0.0f;
        float f14 = point3.x;
        float f15 = point3.y + DELTA;
        float f16 = point3.z;
        float f17 = 0.0f;
        float f18 = point3.x;
        float f19 = point3.y;
        float f20 = point3.z - DELTA;
        float f21 = 0.0f;
        float f22 = point3.x;
        float f23 = point3.y;
        float f24 = point3.z + DELTA;
        float f25 = 0.0f;
        for (int i = 0; i < this.maxIterations; ++i) {
            f = f2 * f2 - f3 * f3 - f4 * f4 - f5 * f5 + this.cw;
            f3 = 2.0f * f2 * f3 + this.cx;
            f4 = 2.0f * f2 * f4 + this.cy;
            f5 = 2.0f * f2 * f5 + this.cz;
            f2 = f;
            f = f6 * f6 - f7 * f7 - f8 * f8 - f9 * f9 + this.cw;
            f7 = 2.0f * f6 * f7 + this.cx;
            f8 = 2.0f * f6 * f8 + this.cy;
            f9 = 2.0f * f6 * f9 + this.cz;
            f6 = f;
            f = f10 * f10 - f11 * f11 - f12 * f12 - f13 * f13 + this.cw;
            f11 = 2.0f * f10 * f11 + this.cx;
            f12 = 2.0f * f10 * f12 + this.cy;
            f13 = 2.0f * f10 * f13 + this.cz;
            f10 = f;
            f = f14 * f14 - f15 * f15 - f16 * f16 - f17 * f17 + this.cw;
            f15 = 2.0f * f14 * f15 + this.cx;
            f16 = 2.0f * f14 * f16 + this.cy;
            f17 = 2.0f * f14 * f17 + this.cz;
            f14 = f;
            f = f18 * f18 - f19 * f19 - f20 * f20 - f21 * f21 + this.cw;
            f19 = 2.0f * f18 * f19 + this.cx;
            f20 = 2.0f * f18 * f20 + this.cy;
            f21 = 2.0f * f18 * f21 + this.cz;
            f18 = f;
            f = f22 * f22 - f23 * f23 - f24 * f24 - f25 * f25 + this.cw;
            f23 = 2.0f * f22 * f23 + this.cx;
            f24 = 2.0f * f22 * f24 + this.cy;
            f25 = 2.0f * f22 * f25 + this.cz;
            f22 = f;
        }
        float f26 = JuliaFractal.length(f6, f7, f8, f9) - JuliaFractal.length(f2, f3, f4, f5);
        f = JuliaFractal.length(f14, f15, f16, f17) - JuliaFractal.length(f10, f11, f12, f13);
        float f27 = JuliaFractal.length(f22, f23, f24, f25) - JuliaFractal.length(f18, f19, f20, f21);
        Vector3 vector3 = new Vector3(f26, f, f27);
        shadingState.getNormal().set(shadingState.transformNormalObjectToWorld(vector3));
        shadingState.getNormal().normalize();
        shadingState.getGeoNormal().set(shadingState.getNormal());
        shadingState.setBasis(OrthoNormalBasis.makeFromW(shadingState.getNormal()));
        shadingState.getPoint().x += shadingState.getNormal().x * this.epsilon * 20.0f;
        shadingState.getPoint().y += shadingState.getNormal().y * this.epsilon * 20.0f;
        shadingState.getPoint().z += shadingState.getNormal().z * this.epsilon * 20.0f;
        shadingState.setShader(instance.getShader(0));
        shadingState.setModifier(instance.getModifier(0));
    }

    private static float length(float f, float f2, float f3, float f4) {
        return (float)Math.sqrt(f * f + f2 * f2 + f3 * f3 + f4 * f4);
    }

    public boolean update(ParameterList parameterList, SunflowAPI sunflowAPI) {
        this.maxIterations = parameterList.getInt("iterations", this.maxIterations);
        this.epsilon = parameterList.getFloat("epsilon", this.epsilon);
        this.cw = parameterList.getFloat("cw", this.cw);
        this.cx = parameterList.getFloat("cx", this.cx);
        this.cy = parameterList.getFloat("cy", this.cy);
        this.cz = parameterList.getFloat("cz", this.cz);
        return true;
    }

    public PrimitiveList getBakingPrimitives() {
        return null;
    }
}

