/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.model;

import java.util.Hashtable;
import java.util.Map;
import javax.swing.DefaultListModel;
import org.parosproxy.paros.model.HistoryReference;

@Deprecated
public class HistoryList
extends DefaultListModel<HistoryReference> {
    private static final long serialVersionUID = 1L;
    private Hashtable<Integer, Integer> historyIdToIndex = new Hashtable();

    @Override
    public void addElement(HistoryReference hRef) {
        int sizeBefore = super.size();
        super.addElement(hRef);
        if (sizeBefore == super.size() - 1) {
            this.historyIdToIndex.put(hRef.getHistoryId(), sizeBefore);
        } else {
            this.historyIdToIndex.put(hRef.getHistoryId(), this.indexOf(hRef));
        }
    }

    public synchronized void notifyItemChanged(Object obj) {
        int i = this.indexOf(obj);
        if (i >= 0) {
            this.fireContentsChanged(this, i, i);
        }
    }

    public synchronized void notifyItemChanged(int historyId) {
        Integer i = this.historyIdToIndex.get(historyId);
        if (i != null) {
            this.fireContentsChanged(this, i, i);
        }
    }

    public HistoryReference getHistoryReference(int historyId) {
        Integer i = this.historyIdToIndex.get(historyId);
        if (i != null) {
            return (HistoryReference)this.elementAt(i);
        }
        return null;
    }

    @Override
    public void clear() {
        super.clear();
        this.historyIdToIndex.clear();
    }

    @Override
    public void removeAllElements() {
        super.removeAllElements();
        this.historyIdToIndex.clear();
    }

    @Override
    public HistoryReference remove(int index) {
        HistoryReference hRef = (HistoryReference)super.remove(index);
        this.historyIdToIndex.remove(hRef.getHistoryId());
        this.updateIndexes(index);
        return hRef;
    }

    @Override
    public boolean removeElement(Object obj) {
        if (super.removeElement(obj)) {
            int idx = this.historyIdToIndex.remove(((HistoryReference)obj).getHistoryId());
            this.updateIndexes(idx);
            return true;
        }
        return false;
    }

    @Override
    public void removeElementAt(int index) {
        this.remove(index);
    }

    @Override
    public void removeRange(int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex must be <= toIndex");
        }
        for (int i = toIndex; i >= fromIndex; --i) {
            this.removeElementAt(i);
        }
        this.fireIntervalRemoved(this, fromIndex, toIndex);
    }

    private void updateIndexes(int fromIndex) {
        for (Map.Entry<Integer, Integer> entry : this.historyIdToIndex.entrySet()) {
            if (entry.getValue() <= fromIndex) continue;
            entry.setValue(entry.getValue() - 1);
        }
    }
}

