/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httpsessions;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.renderer.DefaultTableRenderer;
import org.jdesktop.swingx.renderer.IconValues;
import org.jdesktop.swingx.renderer.MappedValue;
import org.jdesktop.swingx.renderer.StringValue;
import org.jdesktop.swingx.renderer.StringValues;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.extension.AbstractPanel;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.httpsessions.ExtensionHttpSessions;
import org.zaproxy.zap.extension.httpsessions.HttpSession;
import org.zaproxy.zap.extension.httpsessions.HttpSessionsSite;
import org.zaproxy.zap.extension.httpsessions.HttpSessionsTableModel;
import org.zaproxy.zap.utils.DisplayUtils;
import org.zaproxy.zap.utils.SortedComboBoxModel;
import org.zaproxy.zap.utils.TableExportButton;
import org.zaproxy.zap.view.ScanPanel;
import org.zaproxy.zap.view.table.decorator.AbstractTableCellItemIconHighlighter;

public class HttpSessionsPanel
extends AbstractPanel {
    private static final long serialVersionUID = 1L;
    public static final String PANEL_NAME = "httpsessions";
    private ExtensionHttpSessions extension = null;
    private JPanel panelCommand = null;
    private JToolBar panelToolbar = null;
    private JScrollPane jScrollPane = null;
    private JComboBox<String> siteSelect = null;
    private JButton newSessionButton = null;
    private JXTable sessionsTable = null;
    private TableExportButton<JXTable> exportButton = null;
    private JButton optionsButton = null;
    private String currentSite = null;
    private SortedComboBoxModel<String> siteModel = new SortedComboBoxModel();
    private HttpSessionsTableModel sessionsModel = new HttpSessionsTableModel(null);

    public HttpSessionsPanel(ExtensionHttpSessions extensionHttpSession) {
        this.extension = extensionHttpSession;
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new CardLayout());
        this.setSize(474, 251);
        this.setName(Constant.messages.getString("httpsessions.panel.title"));
        this.setIcon(new ImageIcon(HttpSessionsPanel.class.getResource("/resource/icon/16/session.png")));
        this.setDefaultAccelerator(KeyStroke.getKeyStroke(72, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 0x200 | 0x40, false));
        this.setMnemonic(Constant.messages.getChar("httpsessions.panel.mnemonic"));
        this.add((Component)this.getPanelCommand(), this.getPanelCommand().getName());
    }

    private JPanel getPanelCommand() {
        if (this.panelCommand == null) {
            this.panelCommand = new JPanel();
            this.panelCommand.setLayout(new GridBagLayout());
            this.panelCommand.setName(Constant.messages.getString("httpsessions.panel.title"));
            GridBagConstraints toolbarGridBag = new GridBagConstraints();
            GridBagConstraints workPaneGridBag = new GridBagConstraints();
            toolbarGridBag.gridx = 0;
            toolbarGridBag.gridy = 0;
            toolbarGridBag.weightx = 1.0;
            toolbarGridBag.insets = new Insets(2, 2, 2, 2);
            toolbarGridBag.anchor = 18;
            toolbarGridBag.fill = 2;
            workPaneGridBag.gridx = 0;
            workPaneGridBag.gridy = 1;
            workPaneGridBag.weightx = 1.0;
            workPaneGridBag.weighty = 1.0;
            workPaneGridBag.insets = new Insets(0, 0, 0, 0);
            workPaneGridBag.anchor = 18;
            workPaneGridBag.fill = 1;
            this.panelCommand.add((Component)this.getPanelToolbar(), toolbarGridBag);
            this.panelCommand.add((Component)this.getWorkPane(), workPaneGridBag);
        }
        return this.panelCommand;
    }

    private TableExportButton<JXTable> getExportButton() {
        if (this.exportButton == null) {
            this.exportButton = new TableExportButton<JXTable>(this.getHttpSessionsTable());
        }
        return this.exportButton;
    }

    private JButton getOptionsButton() {
        if (this.optionsButton == null) {
            this.optionsButton = new JButton();
            this.optionsButton.setToolTipText(Constant.messages.getString("httpsessions.toolbar.options.button"));
            this.optionsButton.setIcon(DisplayUtils.getScaledIcon(new ImageIcon(ScanPanel.class.getResource("/resource/icon/16/041.png"))));
            this.optionsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Control.getSingleton().getMenuToolsControl().options(Constant.messages.getString("httpsessions.options.title"));
                }
            });
        }
        return this.optionsButton;
    }

    private JButton getNewSessionButton() {
        if (this.newSessionButton == null) {
            this.newSessionButton = new JButton();
            this.newSessionButton.setText(Constant.messages.getString("httpsessions.toolbar.newsession.label"));
            this.newSessionButton.setIcon(DisplayUtils.getScaledIcon(new ImageIcon(HttpSessionsPanel.class.getResource("/resource/icon/16/103.png"))));
            this.newSessionButton.setToolTipText(Constant.messages.getString("httpsessions.toolbar.newsession.tooltip"));
            this.newSessionButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HttpSessionsSite site = HttpSessionsPanel.this.getCurrentHttpSessionSite();
                    if (site != null) {
                        site.createEmptySession();
                    }
                }
            });
        }
        return this.newSessionButton;
    }

    private JToolBar getPanelToolbar() {
        if (this.panelToolbar == null) {
            this.panelToolbar = new JToolBar();
            this.panelToolbar.setLayout(new GridBagLayout());
            this.panelToolbar.setEnabled(true);
            this.panelToolbar.setFloatable(false);
            this.panelToolbar.setRollover(true);
            this.panelToolbar.setPreferredSize(new Dimension(800, 30));
            this.panelToolbar.setName("HttpSessionToolbar");
            GridBagConstraints labelGridBag = new GridBagConstraints();
            GridBagConstraints siteSelectGridBag = new GridBagConstraints();
            GridBagConstraints newSessionGridBag = new GridBagConstraints();
            GridBagConstraints emptyGridBag = new GridBagConstraints();
            GridBagConstraints optionsGridBag = new GridBagConstraints();
            GridBagConstraints exportButtonGbc = new GridBagConstraints();
            labelGridBag.gridx = 0;
            labelGridBag.gridy = 0;
            labelGridBag.insets = new Insets(0, 0, 0, 0);
            labelGridBag.anchor = 17;
            siteSelectGridBag.gridx = 1;
            siteSelectGridBag.gridy = 0;
            siteSelectGridBag.insets = new Insets(0, 0, 0, 0);
            siteSelectGridBag.anchor = 17;
            newSessionGridBag.gridx = 2;
            newSessionGridBag.gridy = 0;
            newSessionGridBag.insets = new Insets(0, 0, 0, 0);
            newSessionGridBag.anchor = 17;
            exportButtonGbc.gridx = 3;
            exportButtonGbc.gridy = 0;
            exportButtonGbc.insets = new Insets(0, 0, 0, 0);
            exportButtonGbc.anchor = 17;
            emptyGridBag.gridx = 4;
            emptyGridBag.gridy = 0;
            emptyGridBag.weightx = 1.0;
            emptyGridBag.weighty = 1.0;
            emptyGridBag.insets = new Insets(0, 0, 0, 0);
            emptyGridBag.anchor = 17;
            emptyGridBag.fill = 2;
            optionsGridBag.gridx = 5;
            optionsGridBag.gridy = 0;
            optionsGridBag.insets = new Insets(0, 0, 0, 0);
            optionsGridBag.anchor = 13;
            JLabel label = new JLabel(Constant.messages.getString("httpsessions.toolbar.site.label"));
            this.panelToolbar.add((Component)label, labelGridBag);
            this.panelToolbar.add(this.getSiteSelect(), siteSelectGridBag);
            this.panelToolbar.add((Component)this.getNewSessionButton(), newSessionGridBag);
            this.panelToolbar.add(this.getExportButton(), exportButtonGbc);
            this.panelToolbar.add((Component)this.getOptionsButton(), optionsGridBag);
            this.panelToolbar.add((Component)new JLabel(), emptyGridBag);
        }
        return this.panelToolbar;
    }

    private JScrollPane getWorkPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView((Component)this.getHttpSessionsTable());
        }
        return this.jScrollPane;
    }

    private void setSessionsTableColumnSizes() {
        this.sessionsTable.getColumnModel().getColumn(0).setMinWidth(60);
        this.sessionsTable.getColumnModel().getColumn(0).setPreferredWidth(60);
        this.sessionsTable.getColumnModel().getColumn(1).setMinWidth(120);
        this.sessionsTable.getColumnModel().getColumn(1).setPreferredWidth(200);
        this.sessionsTable.getColumnModel().getColumn(3).setMinWidth(100);
        this.sessionsTable.getColumnModel().getColumn(3).setPreferredWidth(150);
    }

    private JXTable getHttpSessionsTable() {
        if (this.sessionsTable == null) {
            this.sessionsTable = new JXTable((TableModel)this.sessionsModel);
            this.sessionsTable.setColumnSelectionAllowed(false);
            this.sessionsTable.setCellSelectionEnabled(false);
            this.sessionsTable.setRowSelectionAllowed(true);
            this.sessionsTable.setAutoCreateRowSorter(true);
            this.sessionsTable.setColumnControlVisible(true);
            this.sessionsTable.setAutoCreateColumnsFromModel(false);
            this.sessionsTable.getColumnExt(0).setCellRenderer((TableCellRenderer)new DefaultTableRenderer((StringValue)new MappedValue(StringValues.EMPTY, IconValues.NONE), 0));
            this.sessionsTable.getColumnExt(0).setHighlighters(new Highlighter[]{new ActiveSessionIconHighlighter(0)});
            this.setSessionsTableColumnSizes();
            this.sessionsTable.setName(PANEL_NAME);
            this.sessionsTable.setDoubleBuffered(true);
            this.sessionsTable.setSelectionMode(0);
            this.sessionsTable.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    this.showPopupMenuIfTriggered(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    this.showPopupMenuIfTriggered(e);
                }

                private void showPopupMenuIfTriggered(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        int row = HttpSessionsPanel.this.sessionsTable.rowAtPoint(e.getPoint());
                        if (row < 0 || !HttpSessionsPanel.this.sessionsTable.getSelectionModel().isSelectedIndex(row)) {
                            HttpSessionsPanel.this.sessionsTable.getSelectionModel().clearSelection();
                            if (row >= 0) {
                                HttpSessionsPanel.this.sessionsTable.getSelectionModel().setSelectionInterval(row, row);
                            }
                        }
                        View.getSingleton().getPopupMenu().show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            });
        }
        return this.sessionsTable;
    }

    private JComboBox<String> getSiteSelect() {
        if (this.siteSelect == null) {
            this.siteSelect = new JComboBox<String>(this.siteModel);
            this.siteSelect.addItem(Constant.messages.getString("httpsessions.toolbar.site.select"));
            this.siteSelect.setSelectedIndex(0);
            this.siteSelect.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (1 == e.getStateChange()) {
                        if (HttpSessionsPanel.this.siteSelect.getSelectedIndex() > 0) {
                            HttpSessionsPanel.this.siteSelected((String)e.getItem());
                        } else if (HttpSessionsPanel.this.siteModel.getSize() > 1) {
                            HttpSessionsPanel.this.siteModel.setSelectedItem(HttpSessionsPanel.this.siteModel.getElementAt(1));
                        }
                    }
                }
            });
        }
        return this.siteSelect;
    }

    public void addSite(String site) {
        if (this.siteModel.getIndexOf(site) < 0) {
            this.siteModel.addElement(site);
            if (this.currentSite == null) {
                this.siteModel.setSelectedItem(site);
            }
        }
    }

    public void addSiteAsynchronously(final String site) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                HttpSessionsPanel.this.addSite(site);
            }
        });
    }

    private void siteSelected(String site) {
        if (!site.equals(this.currentSite)) {
            this.sessionsModel = this.extension.getHttpSessionsSite(site).getModel();
            this.getHttpSessionsTable().setModel((TableModel)this.sessionsModel);
            this.setSessionsTableColumnSizes();
            this.currentSite = site;
        }
    }

    public void nodeSelected(SiteNode node) {
        if (node != null) {
            this.siteModel.setSelectedItem(ScanPanel.cleanSiteName(node, true));
        }
    }

    public void reset() {
        this.currentSite = null;
        this.siteModel.removeAllElements();
        this.siteModel.addElement(Constant.messages.getString("httpsessions.toolbar.site.select"));
        this.sessionsModel = new HttpSessionsTableModel(null);
        this.getHttpSessionsTable().setModel((TableModel)this.sessionsModel);
    }

    public HttpSessionsSite getCurrentHttpSessionSite() {
        if (this.currentSite == null) {
            return null;
        }
        return this.extension.getHttpSessionsSite(this.currentSite);
    }

    public String getCurrentSite() {
        return this.currentSite;
    }

    public HttpSession getSelectedSession() {
        int selectedRow = this.sessionsTable.getSelectedRow();
        if (selectedRow == -1) {
            return null;
        }
        int rowIndex = this.sessionsTable.convertRowIndexToModel(selectedRow);
        return this.sessionsModel.getHttpSessionAt(rowIndex);
    }

    private static class ActiveSessionIconHighlighter
    extends AbstractTableCellItemIconHighlighter {
        private static final ImageIcon ACTIVE_ICON = new ImageIcon(HttpSessionsPanel.class.getResource("/resource/icon/16/102.png"));

        public ActiveSessionIconHighlighter(int columnIndex) {
            super(columnIndex);
        }

        @Override
        protected Icon getIcon(Object cellItem) {
            return ACTIVE_ICON;
        }

        @Override
        protected boolean isHighlighted(Object cellItem) {
            return (Boolean)cellItem;
        }
    }
}

