/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.security.InvalidParameterException;
import java.util.regex.PatternSyntaxException;
import sun.security.action.GetPropertyAction;
import sun.security.util.Debug;

public final class SecurityProviderConstants {
    private static final Debug debug;
    public static final int DEF_DSA_KEY_SIZE;
    public static final int DEF_RSA_KEY_SIZE;
    public static final int DEF_DH_KEY_SIZE;
    public static final int DEF_EC_KEY_SIZE;
    private static final String KEY_LENGTH_PROP = "jdk.security.defaultKeySize";

    private SecurityProviderConstants() {
    }

    public static final int getDefDSASubprimeSize(int primeSize) {
        if (primeSize <= 1024) {
            return 160;
        }
        if (primeSize == 2048) {
            return 224;
        }
        if (primeSize == 3072) {
            return 256;
        }
        throw new InvalidParameterException("Invalid DSA Prime Size: " + primeSize);
    }

    static {
        int ecKeySize;
        int dhKeySize;
        int rsaKeySize;
        int dsaKeySize;
        block15: {
            debug = Debug.getInstance("jca", "ProviderConfig");
            String keyLengthStr = GetPropertyAction.privilegedGetProperty(KEY_LENGTH_PROP);
            dsaKeySize = 2048;
            rsaKeySize = 2048;
            dhKeySize = 2048;
            ecKeySize = 256;
            if (keyLengthStr != null) {
                try {
                    String[] pairs;
                    for (String p : pairs = keyLengthStr.split(",")) {
                        String[] algoAndValue = p.split(":");
                        if (algoAndValue.length != 2) {
                            if (debug == null) continue;
                            debug.println("Ignoring invalid pair in jdk.security.defaultKeySize property: " + p);
                            continue;
                        }
                        String algoName = algoAndValue[0].trim().toUpperCase();
                        int value = -1;
                        try {
                            value = Integer.parseInt(algoAndValue[1].trim());
                        }
                        catch (NumberFormatException nfe) {
                            if (debug == null) continue;
                            debug.println("Ignoring invalid value in jdk.security.defaultKeySize property: " + p);
                            continue;
                        }
                        if (algoName.equals("DSA")) {
                            dsaKeySize = value;
                        } else if (algoName.equals("RSA")) {
                            rsaKeySize = value;
                        } else if (algoName.equals("DH")) {
                            dhKeySize = value;
                        } else if (algoName.equals("EC")) {
                            ecKeySize = value;
                        } else {
                            if (debug == null) continue;
                            debug.println("Ignoring unsupported algo in jdk.security.defaultKeySize property: " + p);
                            continue;
                        }
                        if (debug == null) continue;
                        debug.println("Overriding default " + algoName + " keysize with value from " + KEY_LENGTH_PROP + " property: " + value);
                    }
                }
                catch (PatternSyntaxException pse) {
                    if (debug == null) break block15;
                    debug.println("Unexpected exception while parsing jdk.security.defaultKeySize property: " + pse);
                }
            }
        }
        DEF_DSA_KEY_SIZE = dsaKeySize;
        DEF_RSA_KEY_SIZE = rsaKeySize;
        DEF_DH_KEY_SIZE = dhKeySize;
        DEF_EC_KEY_SIZE = ecKeySize;
    }
}

