/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.structure.impl;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotationMemberValue;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotationMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.load.java.structure.JavaAnnotationArgument;
import org.jetbrains.kotlin.load.java.structure.JavaMethod;
import org.jetbrains.kotlin.load.java.structure.JavaType;
import org.jetbrains.kotlin.load.java.structure.JavaTypeParameter;
import org.jetbrains.kotlin.load.java.structure.JavaValueParameter;
import org.jetbrains.kotlin.load.java.structure.impl.JavaAnnotationArgumentImpl;
import org.jetbrains.kotlin.load.java.structure.impl.JavaElementCollectionFromPsiArrayUtil;
import org.jetbrains.kotlin.load.java.structure.impl.JavaMemberImpl;
import org.jetbrains.kotlin.load.java.structure.impl.JavaTypeImpl;
import org.jetbrains.kotlin.name.Name;

public class JavaMethodImpl
extends JavaMemberImpl<PsiMethod>
implements JavaMethod {
    public JavaMethodImpl(@NotNull PsiMethod psiMethod) {
        super(psiMethod);
        assert (!psiMethod.isConstructor()) : "PsiMethod which is a constructor should be wrapped in JavaConstructorImpl: " + psiMethod.getName();
    }

    @Override
    @NotNull
    public Name getName() {
        return Name.identifier(((PsiMethod)this.getPsi()).getName());
    }

    @Override
    @NotNull
    public List<JavaTypeParameter> getTypeParameters() {
        return JavaElementCollectionFromPsiArrayUtil.typeParameters(((PsiMethod)this.getPsi()).getTypeParameters());
    }

    @Override
    @NotNull
    public List<JavaValueParameter> getValueParameters() {
        return JavaElementCollectionFromPsiArrayUtil.valueParameters(((PsiMethod)this.getPsi()).getParameterList().getParameters());
    }

    @Override
    @Nullable
    public JavaAnnotationArgument getAnnotationParameterDefaultValue() {
        PsiAnnotationMemberValue defaultValue;
        PsiMethod psiMethod = (PsiMethod)this.getPsi();
        if (psiMethod instanceof PsiAnnotationMethod && (defaultValue = ((PsiAnnotationMethod)psiMethod).getDefaultValue()) != null) {
            return JavaAnnotationArgumentImpl.Factory.create(defaultValue, null);
        }
        return null;
    }

    @Override
    @NotNull
    public JavaType getReturnType() {
        PsiType psiType = ((PsiMethod)this.getPsi()).getReturnType();
        assert (psiType != null) : "Method is not a constructor and has no return type: " + this.getName();
        return JavaTypeImpl.create(psiType);
    }
}

