/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.context;

import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.StatementFilter;
import org.jetbrains.kotlin.resolve.calls.components.InferenceSession;
import org.jetbrains.kotlin.resolve.calls.context.CallPosition;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionResultsCache;
import org.jetbrains.kotlin.resolve.calls.context.TemporaryTraceAndCache;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;

public abstract class ResolutionContext<Context extends ResolutionContext<Context>> {
    @NotNull
    public final BindingTrace trace;
    @NotNull
    public final LexicalScope scope;
    @NotNull
    public final KotlinType expectedType;
    @NotNull
    public final DataFlowInfo dataFlowInfo;
    @NotNull
    public final ContextDependency contextDependency;
    @NotNull
    public final ResolutionResultsCache resolutionResultsCache;
    @NotNull
    public final StatementFilter statementFilter;
    public final boolean isAnnotationContext;
    public final boolean isDebuggerContext;
    public final boolean collectAllCandidates;
    @NotNull
    public final CallPosition callPosition;
    @NotNull
    public final LanguageVersionSettings languageVersionSettings;
    @NotNull
    public final DataFlowValueFactory dataFlowValueFactory;
    @NotNull
    public final InferenceSession inferenceSession;
    @NotNull
    public final Function1<KtExpression, KtExpression> expressionContextProvider;
    public static final Function1<KtExpression, KtExpression> DEFAULT_EXPRESSION_CONTEXT_PROVIDER = expression2 -> null;

    protected ResolutionContext(@NotNull BindingTrace trace, @NotNull LexicalScope scope, @NotNull KotlinType expectedType, @NotNull DataFlowInfo dataFlowInfo, @NotNull ContextDependency contextDependency, @NotNull ResolutionResultsCache resolutionResultsCache, @NotNull StatementFilter statementFilter, boolean isAnnotationContext, boolean isDebuggerContext, boolean collectAllCandidates, @NotNull CallPosition callPosition, @NotNull Function1<KtExpression, KtExpression> expressionContextProvider, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull DataFlowValueFactory factory2, @NotNull InferenceSession inferenceSession) {
        this.trace = trace;
        this.scope = scope;
        this.expectedType = expectedType;
        this.dataFlowInfo = dataFlowInfo;
        this.contextDependency = contextDependency;
        this.resolutionResultsCache = resolutionResultsCache;
        this.statementFilter = statementFilter;
        this.isAnnotationContext = isAnnotationContext;
        this.isDebuggerContext = isDebuggerContext;
        this.collectAllCandidates = collectAllCandidates;
        this.callPosition = callPosition;
        this.expressionContextProvider = expressionContextProvider;
        this.languageVersionSettings = languageVersionSettings;
        this.dataFlowValueFactory = factory2;
        this.inferenceSession = inferenceSession;
    }

    protected abstract Context create(@NotNull BindingTrace var1, @NotNull LexicalScope var2, @NotNull DataFlowInfo var3, @NotNull KotlinType var4, @NotNull ContextDependency var5, @NotNull ResolutionResultsCache var6, @NotNull StatementFilter var7, boolean var8, @NotNull CallPosition var9, @NotNull Function1<KtExpression, KtExpression> var10, @NotNull LanguageVersionSettings var11, @NotNull DataFlowValueFactory var12, @NotNull InferenceSession var13);

    @NotNull
    private Context self() {
        return (Context)this;
    }

    @NotNull
    public Context replaceBindingTrace(@NotNull BindingTrace trace) {
        if (this.trace == trace) {
            return this.self();
        }
        return this.create(trace, this.scope, this.dataFlowInfo, this.expectedType, this.contextDependency, this.resolutionResultsCache, this.statementFilter, this.collectAllCandidates, this.callPosition, this.expressionContextProvider, this.languageVersionSettings, this.dataFlowValueFactory, this.inferenceSession);
    }

    @NotNull
    public Context replaceDataFlowInfo(@NotNull DataFlowInfo newDataFlowInfo) {
        if (newDataFlowInfo == this.dataFlowInfo) {
            return this.self();
        }
        return this.create(this.trace, this.scope, newDataFlowInfo, this.expectedType, this.contextDependency, this.resolutionResultsCache, this.statementFilter, this.collectAllCandidates, this.callPosition, this.expressionContextProvider, this.languageVersionSettings, this.dataFlowValueFactory, this.inferenceSession);
    }

    @NotNull
    public Context replaceInferenceSession(@NotNull InferenceSession newInferenceSession) {
        if (newInferenceSession == this.inferenceSession) {
            return this.self();
        }
        return this.create(this.trace, this.scope, this.dataFlowInfo, this.expectedType, this.contextDependency, this.resolutionResultsCache, this.statementFilter, this.collectAllCandidates, this.callPosition, this.expressionContextProvider, this.languageVersionSettings, this.dataFlowValueFactory, newInferenceSession);
    }

    @NotNull
    public Context replaceExpectedType(@Nullable KotlinType newExpectedType) {
        if (newExpectedType == null) {
            return this.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
        }
        if (this.expectedType == newExpectedType) {
            return this.self();
        }
        return this.create(this.trace, this.scope, this.dataFlowInfo, newExpectedType, this.contextDependency, this.resolutionResultsCache, this.statementFilter, this.collectAllCandidates, this.callPosition, this.expressionContextProvider, this.languageVersionSettings, this.dataFlowValueFactory, this.inferenceSession);
    }

    @NotNull
    public Context replaceScope(@NotNull LexicalScope newScope) {
        if (newScope == this.scope) {
            return this.self();
        }
        return this.create(this.trace, newScope, this.dataFlowInfo, this.expectedType, this.contextDependency, this.resolutionResultsCache, this.statementFilter, this.collectAllCandidates, this.callPosition, this.expressionContextProvider, this.languageVersionSettings, this.dataFlowValueFactory, this.inferenceSession);
    }

    @NotNull
    public Context replaceContextDependency(@NotNull ContextDependency newContextDependency) {
        if (newContextDependency == this.contextDependency) {
            return this.self();
        }
        return this.create(this.trace, this.scope, this.dataFlowInfo, this.expectedType, newContextDependency, this.resolutionResultsCache, this.statementFilter, this.collectAllCandidates, this.callPosition, this.expressionContextProvider, this.languageVersionSettings, this.dataFlowValueFactory, this.inferenceSession);
    }

    @NotNull
    public Context replaceResolutionResultsCache(@NotNull ResolutionResultsCache newResolutionResultsCache) {
        if (newResolutionResultsCache == this.resolutionResultsCache) {
            return this.self();
        }
        return this.create(this.trace, this.scope, this.dataFlowInfo, this.expectedType, this.contextDependency, newResolutionResultsCache, this.statementFilter, this.collectAllCandidates, this.callPosition, this.expressionContextProvider, this.languageVersionSettings, this.dataFlowValueFactory, this.inferenceSession);
    }

    @NotNull
    public Context replaceTraceAndCache(@NotNull TemporaryTraceAndCache traceAndCache) {
        return ((ResolutionContext)this.replaceBindingTrace(traceAndCache.trace)).replaceResolutionResultsCache(traceAndCache.cache);
    }

    @NotNull
    public Context replaceCollectAllCandidates(boolean newCollectAllCandidates) {
        return this.create(this.trace, this.scope, this.dataFlowInfo, this.expectedType, this.contextDependency, this.resolutionResultsCache, this.statementFilter, newCollectAllCandidates, this.callPosition, this.expressionContextProvider, this.languageVersionSettings, this.dataFlowValueFactory, this.inferenceSession);
    }

    @NotNull
    public Context replaceStatementFilter(@NotNull StatementFilter statementFilter) {
        return this.create(this.trace, this.scope, this.dataFlowInfo, this.expectedType, this.contextDependency, this.resolutionResultsCache, statementFilter, this.collectAllCandidates, this.callPosition, this.expressionContextProvider, this.languageVersionSettings, this.dataFlowValueFactory, this.inferenceSession);
    }

    @NotNull
    public Context replaceCallPosition(@NotNull CallPosition callPosition) {
        return this.create(this.trace, this.scope, this.dataFlowInfo, this.expectedType, this.contextDependency, this.resolutionResultsCache, this.statementFilter, this.collectAllCandidates, callPosition, this.expressionContextProvider, this.languageVersionSettings, this.dataFlowValueFactory, this.inferenceSession);
    }

    @NotNull
    public Context replaceExpressionContextProvider(@NotNull Function1<KtExpression, KtExpression> expressionContextProvider) {
        return this.create(this.trace, this.scope, this.dataFlowInfo, this.expectedType, this.contextDependency, this.resolutionResultsCache, this.statementFilter, this.collectAllCandidates, this.callPosition, expressionContextProvider, this.languageVersionSettings, this.dataFlowValueFactory, this.inferenceSession);
    }

    @SafeVarargs
    @Nullable
    public final <T extends PsiElement> T getContextParentOfType(@NotNull KtExpression expression2, Class<? extends T> ... classes2) {
        PsiElement current;
        KtExpression context = (KtExpression)this.expressionContextProvider.invoke((Object)expression2);
        PsiElement psiElement = current = context != null ? context : expression2.getParent();
        while (current != null) {
            for (Class<T> clazz : classes2) {
                if (!clazz.isInstance(current)) continue;
                return (T)current;
            }
            if (current instanceof PsiFile) {
                return null;
            }
            if (current instanceof KtExpression && (context = (KtExpression)this.expressionContextProvider.invoke((Object)((KtExpression)current))) != null) {
                current = context;
                continue;
            }
            current = current.getParent();
        }
        return null;
    }
}

