/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.packaging.impl;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.gradle.internal.file.TreeType;

public class PackerDirectoryUtil {
    public static void ensureDirectoryForTree(TreeType type, File root) throws IOException {
        switch (type) {
            case DIRECTORY: {
                if (PackerDirectoryUtil.makeDirectory(root)) break;
                FileUtils.cleanDirectory((File)root);
                break;
            }
            case FILE: {
                if (PackerDirectoryUtil.makeDirectory(root.getParentFile()) || !root.exists()) break;
                FileUtils.forceDelete((File)root);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    public static boolean makeDirectory(File target) throws IOException {
        if (target.isDirectory()) {
            return false;
        }
        if (target.isFile()) {
            FileUtils.forceDelete((File)target);
        }
        FileUtils.forceMkdir((File)target);
        return true;
    }
}

